DROP TABLE IF EXISTS `kolhoz_ban`;

CREATE TABLE `kolhoz_ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_who` int(11) DEFAULT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `izg` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_blacklist`;

CREATE TABLE `kolhoz_blacklist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_ank` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_chat`;

CREATE TABLE `kolhoz_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `mother` int(11) DEFAULT '0',
  `pos` int(11) DEFAULT '0',
  `admod` set('0','1') DEFAULT '0',
  `type` enum('room','komm') DEFAULT 'room',
  `msg` varchar(10000) DEFAULT NULL,
  `opis` varchar(10000) DEFAULT NULL,
  `name` varchar(1024) DEFAULT NULL,
  `otvet` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective`;

CREATE TABLE `kolhoz_collective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(24) DEFAULT NULL,
  `rating` bigint(255) DEFAULT '0',
  `money` bigint(255) DEFAULT '0',
  `rubies` bigint(255) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `tehnika` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `time_obmen` int(11) DEFAULT '0',
  `station` enum('0','1') DEFAULT '0',
  `flowerbed` enum('0','1') DEFAULT '0',
  `rating_gos` bigint(255) DEFAULT '0',
  `titleText` varchar(64) DEFAULT NULL,
  `titleText_user` int(11) DEFAULT NULL,
  `titleText_time` int(11) DEFAULT NULL,
  `soil` int(11) DEFAULT '0',
  `irrigate` int(11) DEFAULT '0',
  `scholl` int(11) DEFAULT '0',
  `vet` int(11) DEFAULT '0',
  `bank` int(11) DEFAULT '0',
  `lib` enum('0','1') DEFAULT '0',
  `greenhouse` int(11) DEFAULT '0',
  `school` int(11) DEFAULT '0',
  `nalog` int(11) DEFAULT '0',
  `time_nalog` int(11) DEFAULT NULL,
  `users_add` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_ahlist`;

CREATE TABLE `kolhoz_collective_ahlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `heli` enum('1','2','3','4') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_cash`;

CREATE TABLE `kolhoz_collective_cash` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `type` enum('rubies','money') DEFAULT 'rubies',
  `time` int(11) DEFAULT '0',
  `count` bigint(255) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_chat`;

CREATE TABLE `kolhoz_collective_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `msg` varchar(10000) DEFAULT NULL,
  `otvet` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_club`;

CREATE TABLE `kolhoz_collective_club` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_collective` int(11) DEFAULT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `mother` int(11) DEFAULT '0',
  `guest` set('0','1') DEFAULT '0',
  `type` enum('razdel','tema','komm') DEFAULT 'razdel',
  `msg` varchar(10000) DEFAULT NULL,
  `name` varchar(1024) DEFAULT NULL,
  `locked` enum('0','1') DEFAULT '0',
  `otvet` int(11) DEFAULT '0',
  `pined` enum('0','1') DEFAULT '0',
  `pos` int(11) DEFAULT '0',
  `time_obnov` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_comp`;

CREATE TABLE `kolhoz_collective_comp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT '0',
  `id_gos` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_collective_comp VALUES("1","1356175320","1");



DROP TABLE IF EXISTS `kolhoz_collective_comp_user`;

CREATE TABLE `kolhoz_collective_comp_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT '0',
  `id_comp` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_gos`;

CREATE TABLE `kolhoz_collective_gos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT '0',
  `id_plant` int(11) DEFAULT '0',
  `type` enum('rating','harvest') DEFAULT 'rating',
  `active` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_collective_gos VALUES("1","1356435060","45","harvest","1");



DROP TABLE IF EXISTS `kolhoz_collective_gos_ct`;

CREATE TABLE `kolhoz_collective_gos_ct` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_collective` int(11) DEFAULT '0',
  `id_gos` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_hangar`;

CREATE TABLE `kolhoz_collective_hangar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `gaz` int(11) DEFAULT '0',
  `heli` enum('1','2','3','4') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_heli`;

CREATE TABLE `kolhoz_collective_heli` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `gaz` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `heli` enum('0','1','2','3','4') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_history`;

CREATE TABLE `kolhoz_collective_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `id_who` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `type` enum('in','out','st_up','st_down') DEFAULT 'in',
  `status` enum('1','2','3','4','5','6','7') DEFAULT '1',
  `dei` enum('who','user') DEFAULT 'user',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_invite`;

CREATE TABLE `kolhoz_collective_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `id_who` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_rating`;

CREATE TABLE `kolhoz_collective_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `count` bigint(255) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_rating_gos`;

CREATE TABLE `kolhoz_collective_rating_gos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_collective_user`;

CREATE TABLE `kolhoz_collective_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_collective` int(11) DEFAULT NULL,
  `rating` bigint(255) DEFAULT '0',
  `money` bigint(255) DEFAULT '0',
  `rubies` bigint(255) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `status` enum('1','2','3','4','5','6','7') DEFAULT '1',
  `rubies_week` bigint(255) DEFAULT '0',
  `rating_week` bigint(255) DEFAULT '0',
  `rating_gos` bigint(255) DEFAULT '0',
  `tehnika` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_fish`;

CREATE TABLE `kolhoz_fish` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `money` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_fish VALUES("1","Верховодка","75","8","4","3600","136","60","2");
INSERT INTO kolhoz_fish VALUES("2","Бычок","100","40","4","10800","180","180","4");
INSERT INTO kolhoz_fish VALUES("3","Красноперка","125","60","4","18000","220","240","6");
INSERT INTO kolhoz_fish VALUES("4","Карась","175","120","5","28800","650","600","8");
INSERT INTO kolhoz_fish VALUES("5","Плотва","225","650","5","43200","650","780","12");
INSERT INTO kolhoz_fish VALUES("6","Линь","350","176","5","64800","800","840","15");
INSERT INTO kolhoz_fish VALUES("7","Карп","450","224","5","79200","925","900","18");
INSERT INTO kolhoz_fish VALUES("8","Окунь","550","264","4","93600","1050","1080","19");
INSERT INTO kolhoz_fish VALUES("9","Толстолобик","600","300","6","115200","1530","1200","22");
INSERT INTO kolhoz_fish VALUES("10","Щука","760","352","4","144000","1700","1320","24");
INSERT INTO kolhoz_fish VALUES("11","Угорь","900","384","8","172800","1856","1440","26");
INSERT INTO kolhoz_fish VALUES("12","Сом","1000","400","5","208800","2466","1560","28");
INSERT INTO kolhoz_fish VALUES("13","Белый Амур","1200","420","6","237600","2676","1680","30");
INSERT INTO kolhoz_fish VALUES("14","Осетр","1750","460","6","259200","3234","1800","34");
INSERT INTO kolhoz_fish VALUES("15","Белуга","2500","500","6","302400","3234","2040","36");
INSERT INTO kolhoz_fish VALUES("16","Семга","2750","625","6","345600","4260","2160","38");
INSERT INTO kolhoz_fish VALUES("17","Лосось","3000","700","6","388800","4700","2400","42");
INSERT INTO kolhoz_fish VALUES("18","Форель","3250","800","6","432000","4800","2640","46");
INSERT INTO kolhoz_fish VALUES("19","Стерлядь","3500","900","6","504000","5070","2760","48");
INSERT INTO kolhoz_fish VALUES("20","Морской еж","4000","1000","8","648000","5610","2700","50");



DROP TABLE IF EXISTS `kolhoz_food`;

CREATE TABLE `kolhoz_food` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `arena` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_forum`;

CREATE TABLE `kolhoz_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `mother` int(11) DEFAULT '0',
  `admod` set('0','1') DEFAULT '0',
  `type` enum('razdel','tema','komm') DEFAULT 'razdel',
  `msg` varchar(10000) DEFAULT NULL,
  `name` varchar(1024) DEFAULT NULL,
  `locked` enum('0','1') DEFAULT '0',
  `otvet` int(11) DEFAULT '0',
  `pined` enum('0','1') DEFAULT '0',
  `pos` int(11) DEFAULT '0',
  `time_obnov` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_friends`;

CREATE TABLE `kolhoz_friends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_ank` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_gift`;

CREATE TABLE `kolhoz_gift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `id_cat` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_gift VALUES("3","Маргарита","1000","2");
INSERT INTO kolhoz_gift VALUES("4","Легкость","500","2");
INSERT INTO kolhoz_gift VALUES("5","Аромат","500","2");
INSERT INTO kolhoz_gift VALUES("6","Свежесть","500","2");
INSERT INTO kolhoz_gift VALUES("7","Бодрость","500","2");
INSERT INTO kolhoz_gift VALUES("8","Дижестив","500","2");
INSERT INTO kolhoz_gift VALUES("9","Клубника","1000","3");
INSERT INTO kolhoz_gift VALUES("10","Ассорти","500","3");
INSERT INTO kolhoz_gift VALUES("11","Десерт","500","3");
INSERT INTO kolhoz_gift VALUES("12","Малина","500","3");
INSERT INTO kolhoz_gift VALUES("13","Мороженое","500","3");
INSERT INTO kolhoz_gift VALUES("14","Пирожное","500","3");
INSERT INTO kolhoz_gift VALUES("15","Торт","500","3");
INSERT INTO kolhoz_gift VALUES("16","Утёнок","1000","4");
INSERT INTO kolhoz_gift VALUES("17","Слоник","500","4");
INSERT INTO kolhoz_gift VALUES("18","Зайка","500","4");
INSERT INTO kolhoz_gift VALUES("19","Лапа","500","4");
INSERT INTO kolhoz_gift VALUES("20","Милашка","500","4");
INSERT INTO kolhoz_gift VALUES("21","Озорник","500","4");
INSERT INTO kolhoz_gift VALUES("22","Золотое сердце","1000","5");
INSERT INTO kolhoz_gift VALUES("23","Медальон \"Любящее сердце\"","500","5");
INSERT INTO kolhoz_gift VALUES("24","Медальон \"Энергия жизни\"","500","5");
INSERT INTO kolhoz_gift VALUES("25","Кольцо с сапфиром","500","5");
INSERT INTO kolhoz_gift VALUES("26","Кольцо с рубином","500","5");
INSERT INTO kolhoz_gift VALUES("27","Обручальное кольцо","500","5");
INSERT INTO kolhoz_gift VALUES("28","С любовью","1000","6");
INSERT INTO kolhoz_gift VALUES("29","Букет","500","6");
INSERT INTO kolhoz_gift VALUES("30","Тебе с нежностью","500","6");
INSERT INTO kolhoz_gift VALUES("31","Волшебство","500","6");
INSERT INTO kolhoz_gift VALUES("32","Легкого настроения","500","6");
INSERT INTO kolhoz_gift VALUES("33","Ромашки","500","6");
INSERT INTO kolhoz_gift VALUES("34","Роза","500","6");
INSERT INTO kolhoz_gift VALUES("35","Подснежники","500","6");
INSERT INTO kolhoz_gift VALUES("36","Букет невесты","500","6");
INSERT INTO kolhoz_gift VALUES("37","Джип","10000","7");
INSERT INTO kolhoz_gift VALUES("38","Парфюм","10000","7");
INSERT INTO kolhoz_gift VALUES("39","Ноутбук","10000","7");
INSERT INTO kolhoz_gift VALUES("40","Пистолет","10000","7");
INSERT INTO kolhoz_gift VALUES("41","Гламурные тапочки","50000","7");
INSERT INTO kolhoz_gift VALUES("42","Сувенир","50000","7");
INSERT INTO kolhoz_gift VALUES("43","Rolex","100000","7");
INSERT INTO kolhoz_gift VALUES("44","Для Королевы...","100000","7");
INSERT INTO kolhoz_gift VALUES("45","Финансовых успехов!","50000","7");
INSERT INTO kolhoz_gift VALUES("46","Лови жука","500","8");
INSERT INTO kolhoz_gift VALUES("47","Сковорода","500","8");
INSERT INTO kolhoz_gift VALUES("48","В добрый путь!","500","8");
INSERT INTO kolhoz_gift VALUES("49","Ученье - свет!","500","8");
INSERT INTO kolhoz_gift VALUES("50","Вредина","500","8");
INSERT INTO kolhoz_gift VALUES("53","Елочные игрушки ","500","9");
INSERT INTO kolhoz_gift VALUES("54","Змейка ","500","9");
INSERT INTO kolhoz_gift VALUES("55","Мешок подарков ","500","9");
INSERT INTO kolhoz_gift VALUES("56","Снеговик","20000","9");
INSERT INTO kolhoz_gift VALUES("57","Сноуборд","50000","9");
INSERT INTO kolhoz_gift VALUES("58","Дед Мороз","100000","9");



DROP TABLE IF EXISTS `kolhoz_gift_cat`;

CREATE TABLE `kolhoz_gift_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_gift_cat VALUES("2","Напитки");
INSERT INTO kolhoz_gift_cat VALUES("3","Вкусности");
INSERT INTO kolhoz_gift_cat VALUES("4","Игрушки");
INSERT INTO kolhoz_gift_cat VALUES("5","Украшения");
INSERT INTO kolhoz_gift_cat VALUES("6","Цветы");
INSERT INTO kolhoz_gift_cat VALUES("7","Премиум");
INSERT INTO kolhoz_gift_cat VALUES("8","Повседневные");
INSERT INTO kolhoz_gift_cat VALUES("9","Новогодние");



DROP TABLE IF EXISTS `kolhoz_gifts`;

CREATE TABLE `kolhoz_gifts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_kont` int(11) DEFAULT NULL,
  `id_gift` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `read` set('0','1') DEFAULT '0',
  `msg` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_ground`;

CREATE TABLE `kolhoz_ground` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT '0',
  `soil` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_water` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `cultivator` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16491 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_ground VALUES("11354","1004","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11355","1004","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11356","1004","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11357","1004","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11358","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("11359","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("11360","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("11361","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("11362","1006","53","0","1353653489","1353333209","1353333329","1","0");
INSERT INTO kolhoz_ground VALUES("11363","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11364","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11365","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11366","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11367","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11368","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11369","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11370","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11371","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11372","1008","0","0","1353331075","1353304895","1353264175","1","0");
INSERT INTO kolhoz_ground VALUES("11373","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11374","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11375","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11376","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11377","1009","9","0","1353272332","1353263092","1353263092","1","0");
INSERT INTO kolhoz_ground VALUES("11378","1009","9","0","1353272366","1353263126","1353263126","1","0");
INSERT INTO kolhoz_ground VALUES("11379","1009","9","0","1353272388","1353263148","1353263148","1","0");
INSERT INTO kolhoz_ground VALUES("11380","1009","0","1","1353262797","1353264482","1353262361","1","0");
INSERT INTO kolhoz_ground VALUES("11381","1010","7","0","1353344385","1353338025","1353338025","1","0");
INSERT INTO kolhoz_ground VALUES("11382","1010","7","0","1353344385","1353338025","1353338025","1","0");
INSERT INTO kolhoz_ground VALUES("11383","1010","7","0","1353344385","1353338025","1353338025","1","0");
INSERT INTO kolhoz_ground VALUES("11384","1010","7","0","1353344385","1353338025","1353338025","1","0");
INSERT INTO kolhoz_ground VALUES("11385","1011","22","1","1353319091","1353322753","1353253391","1","0");
INSERT INTO kolhoz_ground VALUES("11386","1011","22","1","1353324494","1353298808","1353253394","1","0");
INSERT INTO kolhoz_ground VALUES("11387","1011","22","1","1353324495","1353298808","1353253395","1","0");
INSERT INTO kolhoz_ground VALUES("11388","1011","22","1","1353324495","1353298808","1353253395","1","0");
INSERT INTO kolhoz_ground VALUES("11389","1012","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11390","1012","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11391","1012","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11392","1012","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11393","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("11394","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("11395","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("11396","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("11397","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11398","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11399","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11400","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11401","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11402","1006","53","0","1353653515","1353333235","1353333355","1","0");
INSERT INTO kolhoz_ground VALUES("11403","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11404","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11405","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11406","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11407","1016","6","0","1355584727","1355582147","1355582147","1","0");
INSERT INTO kolhoz_ground VALUES("11408","1016","6","0","1355584734","1355582154","1355582154","1","0");
INSERT INTO kolhoz_ground VALUES("11409","1016","6","0","1355584737","1355582157","1355582157","1","0");
INSERT INTO kolhoz_ground VALUES("11410","1016","6","0","1355584739","1355582159","1355582159","1","0");
INSERT INTO kolhoz_ground VALUES("11411","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11412","1017","0","0","1353222173","1353332093","1353332153","1","0");
INSERT INTO kolhoz_ground VALUES("11413","1017","0","0","1353222173","1353332093","1353332153","1","0");
INSERT INTO kolhoz_ground VALUES("11414","1017","0","0","1353222173","1353332093","1353332153","1","0");
INSERT INTO kolhoz_ground VALUES("11415","1017","0","0","1353222173","1353332093","1353332153","1","0");
INSERT INTO kolhoz_ground VALUES("11416","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("11417","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("11418","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("11419","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("11420","1019","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11421","1019","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11422","1019","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11423","1019","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11424","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11425","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11426","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11427","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11428","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11429","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11430","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11431","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11432","1008","0","0","1353227270","1353304430","1353304550","1","0");
INSERT INTO kolhoz_ground VALUES("11433","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11434","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11435","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11436","1020","33","0","1353493164","1353331284","1353331344","1","0");
INSERT INTO kolhoz_ground VALUES("11437","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("11438","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("11439","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("11440","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("11441","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11442","1022","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11443","1022","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11444","1022","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11445","1022","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11446","1023","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11447","1023","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11448","1023","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11449","1023","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11450","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11451","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11452","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11453","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11454","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11455","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11456","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11457","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11458","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11459","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11460","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11461","1026","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11462","1026","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11463","1026","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11464","1026","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11465","1027","26","1","1353332913","1353331658","1353244233","1","0");
INSERT INTO kolhoz_ground VALUES("11466","1027","26","1","1353332921","1353331658","1353244241","1","0");
INSERT INTO kolhoz_ground VALUES("11467","1027","28","1","1353344281","1353331658","1353244801","1","0");
INSERT INTO kolhoz_ground VALUES("11468","1027","28","1","1353344296","1353331658","1353244816","1","0");
INSERT INTO kolhoz_ground VALUES("11469","1007","6","0","1353281402","1353278822","1353278822","1","0");
INSERT INTO kolhoz_ground VALUES("11470","1028","8","0","1353265456","1353242056","1353241996","1","0");
INSERT INTO kolhoz_ground VALUES("11471","1028","8","0","1353265464","1353242064","1353242004","1","0");
INSERT INTO kolhoz_ground VALUES("11472","1028","8","0","1353265469","1353242069","1353242009","1","0");
INSERT INTO kolhoz_ground VALUES("11473","1028","8","0","1353265473","1353242073","1353242013","1","0");
INSERT INTO kolhoz_ground VALUES("11474","1015","7","0","1353327187","1353320827","1353320827","1","0");
INSERT INTO kolhoz_ground VALUES("11475","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11476","1028","8","0","1353265483","1353242083","1353242023","1","0");
INSERT INTO kolhoz_ground VALUES("11477","1028","8","0","1353265490","1353242090","1353242030","1","0");
INSERT INTO kolhoz_ground VALUES("11478","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11479","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11480","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11481","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11482","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11483","1030","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11484","1030","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11485","1030","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11486","1030","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11487","1028","8","0","1353265496","1353242096","1353242036","1","0");
INSERT INTO kolhoz_ground VALUES("11488","1028","8","0","1353265499","1353242099","1353242039","1","0");
INSERT INTO kolhoz_ground VALUES("11489","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11490","1028","8","0","1353265503","1353242103","1353242043","1","0");
INSERT INTO kolhoz_ground VALUES("11491","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11492","1027","28","1","1353344309","1353331658","1353244829","1","0");
INSERT INTO kolhoz_ground VALUES("11493","1027","28","1","1353344319","1353331658","1353244839","1","0");
INSERT INTO kolhoz_ground VALUES("11494","1027","31","1","1353355155","1353331658","1353244935","1","0");
INSERT INTO kolhoz_ground VALUES("11495","1027","31","1","1353355161","1353331658","1353244941","1","0");
INSERT INTO kolhoz_ground VALUES("11496","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11497","1031","0","0","1353379725","1353326711","1353320565","0","0");
INSERT INTO kolhoz_ground VALUES("11498","1031","0","0","1353379729","1353326711","1353320569","0","0");
INSERT INTO kolhoz_ground VALUES("11499","1031","0","0","1353379729","1353326711","1353320569","0","0");
INSERT INTO kolhoz_ground VALUES("11500","1031","0","0","1353379729","1353326711","1353320569","0","0");
INSERT INTO kolhoz_ground VALUES("11501","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11502","1014","7","0","1353335720","1353329360","1353329360","1","0");
INSERT INTO kolhoz_ground VALUES("11503","1032","8","1","1353344167","1353325021","1353323227","1","0");
INSERT INTO kolhoz_ground VALUES("11504","1032","8","1","1353344167","1353325021","1353323227","1","0");
INSERT INTO kolhoz_ground VALUES("11505","1032","8","1","1353344167","1353325021","1353323227","1","0");
INSERT INTO kolhoz_ground VALUES("11506","1032","8","1","1353344167","1353325021","1353323227","1","0");
INSERT INTO kolhoz_ground VALUES("11507","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11508","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11509","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11510","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11511","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11512","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("11513","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("11514","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("11515","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("11516","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11517","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11518","1025","49","1","1353464859","1353247034","1353243939","1","0");
INSERT INTO kolhoz_ground VALUES("11519","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11520","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11521","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("11522","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("11523","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("11524","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("11525","1036","32","1","1353319763","1353314879","1353312563","1","0");
INSERT INTO kolhoz_ground VALUES("11526","1036","32","1","1353319768","1353314880","1353312568","1","0");
INSERT INTO kolhoz_ground VALUES("11527","1036","32","1","1353319770","1353314881","1353312570","1","0");
INSERT INTO kolhoz_ground VALUES("11528","1036","32","1","1353319771","1353314883","1353312571","1","0");
INSERT INTO kolhoz_ground VALUES("11529","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11530","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11531","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11532","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11533","1031","0","0","1353379729","1353326711","1353320569","0","0");
INSERT INTO kolhoz_ground VALUES("11534","1031","0","0","1353379729","1353326711","1353320569","0","0");
INSERT INTO kolhoz_ground VALUES("11535","1031","0","0","1353379729","1353326711","1353320569","0","0");
INSERT INTO kolhoz_ground VALUES("11536","1017","0","0","1353222173","1353332093","1353332153","1","0");
INSERT INTO kolhoz_ground VALUES("11537","1036","32","1","1353319773","1353315986","1353312573","1","0");
INSERT INTO kolhoz_ground VALUES("11538","1036","32","1","1353319789","1353314887","1353312589","1","0");
INSERT INTO kolhoz_ground VALUES("11539","1036","32","1","1353319776","1353314889","1353312576","1","0");
INSERT INTO kolhoz_ground VALUES("11540","1036","32","1","1353319777","1353314891","1353312577","1","0");
INSERT INTO kolhoz_ground VALUES("11541","1036","32","1","1353319787","1353314892","1353312587","1","0");
INSERT INTO kolhoz_ground VALUES("11542","1036","32","1","1353319786","1353314894","1353312586","1","0");
INSERT INTO kolhoz_ground VALUES("11543","1027","31","1","1353355167","1353331658","1353244947","1","0");
INSERT INTO kolhoz_ground VALUES("11544","1027","31","1","1353355169","1353331658","1353244949","1","0");
INSERT INTO kolhoz_ground VALUES("11545","1027","31","1","1353355180","1353331658","1353244960","1","0");
INSERT INTO kolhoz_ground VALUES("11546","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("11547","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("11548","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("11549","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("11550","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11551","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11552","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11553","1039","0","0","1353253419","1353329859","1353329859","1","0");
INSERT INTO kolhoz_ground VALUES("11554","1039","0","0","1353253419","1353329859","1353329859","1","0");
INSERT INTO kolhoz_ground VALUES("11555","1039","0","0","1353253419","1353329859","1353329859","1","0");
INSERT INTO kolhoz_ground VALUES("11556","1039","0","0","1353253419","1353329859","1353329859","1","0");
INSERT INTO kolhoz_ground VALUES("11557","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11558","1040","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11559","1040","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11560","1040","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11561","1040","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11562","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11563","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11564","1041","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11565","1041","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11566","1041","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11567","1041","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11568","1042","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11569","1042","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11570","1042","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11571","1042","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11572","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("11573","1032","8","1","1353344167","1353325021","1353323227","1","0");
INSERT INTO kolhoz_ground VALUES("11574","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("11575","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("11576","1043","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11577","1043","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11578","1043","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11579","1043","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11580","1044","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11581","1044","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11582","1044","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11583","1044","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11584","1043","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11585","1045","6","1","1353252449","1353253621","1353251609","1","0");
INSERT INTO kolhoz_ground VALUES("11586","1045","8","1","1353269937","1353253206","1353248277","1","0");
INSERT INTO kolhoz_ground VALUES("11587","1045","6","1","1353252457","1353253637","1353251617","1","0");
INSERT INTO kolhoz_ground VALUES("11588","1045","6","1","1353252460","1353253620","1353251620","1","0");
INSERT INTO kolhoz_ground VALUES("11589","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("11590","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("11591","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("11592","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("11593","1047","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11594","1047","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11595","1047","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11596","1047","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11597","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11598","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("11599","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("11600","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("11601","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("11602","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("11603","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("11604","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("11605","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("11606","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("11607","1050","0","0","1353261700","1353260894","1353257260","0","0");
INSERT INTO kolhoz_ground VALUES("11608","1050","0","0","1353261717","1353260894","1353257277","0","0");
INSERT INTO kolhoz_ground VALUES("11609","1050","7","1","1353261717","1353260894","1353257277","1","0");
INSERT INTO kolhoz_ground VALUES("11610","1050","0","0","1353261720","1353260894","1353257280","0","0");
INSERT INTO kolhoz_ground VALUES("11611","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11612","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11613","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11614","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11615","1052","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11616","1052","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11617","1052","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11618","1052","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11619","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11620","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11621","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11622","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11623","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11624","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11625","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11626","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11627","1055","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11628","1055","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11629","1055","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11630","1055","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11631","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11632","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11633","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11634","1056","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11635","1056","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11636","1056","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11637","1056","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11638","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11639","1051","0","0","1353382224","1353276744","1353276744","0","0");
INSERT INTO kolhoz_ground VALUES("11640","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11641","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11642","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11643","1053","55","0","1356099668","1355763331","1355762048","1","0");
INSERT INTO kolhoz_ground VALUES("11644","1050","7","1","1353261720","1353260894","1353257280","1","0");
INSERT INTO kolhoz_ground VALUES("11645","1057","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11646","1057","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11647","1057","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11648","1057","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11649","1029","31","0","1353445985","1353298505","1353298565","1","0");
INSERT INTO kolhoz_ground VALUES("11650","1058","53","1","1355873188","1355705190","1355585428","1","0");
INSERT INTO kolhoz_ground VALUES("11651","1058","53","1","1355873190","1355705191","1355585430","1","0");
INSERT INTO kolhoz_ground VALUES("11652","1058","53","1","1355873339","1355705192","1355585579","1","0");
INSERT INTO kolhoz_ground VALUES("11653","1058","53","1","1355873193","1355705194","1355585433","1","0");
INSERT INTO kolhoz_ground VALUES("11654","1059","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11655","1059","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11656","1059","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11657","1059","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11658","1060","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11659","1060","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11660","1060","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11661","1060","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11662","1058","53","1","1355873308","1355705194","1355585548","1","0");
INSERT INTO kolhoz_ground VALUES("11663","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11664","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11665","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("11666","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("11667","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("11668","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("11669","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("11670","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11671","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11672","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11673","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11674","1063","20","0","1353339762","1353246282","1353246402","1","0");
INSERT INTO kolhoz_ground VALUES("11675","1063","20","0","1353339764","1353246284","1353246404","1","0");
INSERT INTO kolhoz_ground VALUES("11676","1063","22","0","1353351771","1353246291","1353246471","1","0");
INSERT INTO kolhoz_ground VALUES("11677","1063","22","0","1353351773","1353246293","1353246473","1","0");
INSERT INTO kolhoz_ground VALUES("11678","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11679","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11680","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11681","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11682","1065","12","1","1353312871","1353270538","1353268831","1","0");
INSERT INTO kolhoz_ground VALUES("11683","1065","12","1","1353312871","1353270538","1353268831","1","0");
INSERT INTO kolhoz_ground VALUES("11684","1065","12","1","1353312871","1353270538","1353268831","1","0");
INSERT INTO kolhoz_ground VALUES("11685","1065","12","1","1353312871","1353270538","1353268831","1","0");
INSERT INTO kolhoz_ground VALUES("11686","1066","20","0","1353404568","1353311088","1353311088","1","0");
INSERT INTO kolhoz_ground VALUES("11687","1066","20","0","1353404578","1353311098","1353311098","1","0");
INSERT INTO kolhoz_ground VALUES("11688","1066","22","0","1353416650","1353311170","1353311170","1","0");
INSERT INTO kolhoz_ground VALUES("11689","1066","22","0","1353416828","1353311348","1353311348","1","0");
INSERT INTO kolhoz_ground VALUES("11690","1067","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11691","1067","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11692","1067","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11693","1067","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11694","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11695","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11696","1062","6","0","1353260142","1353257562","1353257502","1","0");
INSERT INTO kolhoz_ground VALUES("11697","1068","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11698","1068","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11699","1068","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11700","1068","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11701","1069","22","0","1353351392","1353245912","1353246092","1","0");
INSERT INTO kolhoz_ground VALUES("11702","1069","22","0","1353351392","1353245912","1353246092","1","0");
INSERT INTO kolhoz_ground VALUES("11703","1069","22","0","1353351392","1353245912","1353246092","1","0");
INSERT INTO kolhoz_ground VALUES("11704","1069","22","0","1353351392","1353245912","1353246092","1","0");
INSERT INTO kolhoz_ground VALUES("11705","1065","12","1","1353312871","1353270538","1353268831","1","0");
INSERT INTO kolhoz_ground VALUES("11706","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11707","1065","12","1","1353312871","1353270538","1353268831","1","0");
INSERT INTO kolhoz_ground VALUES("11708","1070","14","1","1353280326","1353264598","1353256986","1","0");
INSERT INTO kolhoz_ground VALUES("11709","1070","14","1","1353280332","1353264598","1353256992","1","0");
INSERT INTO kolhoz_ground VALUES("11710","1070","14","1","1353280332","1353264599","1353256992","1","0");
INSERT INTO kolhoz_ground VALUES("11711","1070","14","1","1353280349","1353264601","1353257009","1","0");
INSERT INTO kolhoz_ground VALUES("11712","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11713","1064","53","0","1353613759","1353298033","1353296359","1","0");
INSERT INTO kolhoz_ground VALUES("11714","1069","22","0","1353351392","1353245912","1353246092","1","0");
INSERT INTO kolhoz_ground VALUES("11715","1063","22","0","1353351776","1353246296","1353246476","1","0");
INSERT INTO kolhoz_ground VALUES("11716","1063","22","0","1353351778","1353246298","1353246478","1","0");
INSERT INTO kolhoz_ground VALUES("11717","1063","0","0","1353245806","1353245766","1353245886","1","0");
INSERT INTO kolhoz_ground VALUES("11718","1063","0","0","1353245806","1353245771","1353245891","1","0");
INSERT INTO kolhoz_ground VALUES("11719","1063","0","0","1353245806","1353245777","1353245897","1","0");
INSERT INTO kolhoz_ground VALUES("11720","1063","0","0","1353245806","1353245918","1353246038","1","0");
INSERT INTO kolhoz_ground VALUES("11721","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11722","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11723","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11724","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11725","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11726","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11727","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11728","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11729","1070","14","1","1353280336","1353264601","1353256996","1","0");
INSERT INTO kolhoz_ground VALUES("11730","1073","6","0","1353250261","1353247681","1353247621","1","0");
INSERT INTO kolhoz_ground VALUES("11731","1073","6","0","1353250262","1353247682","1353247622","1","0");
INSERT INTO kolhoz_ground VALUES("11732","1073","6","0","1353250266","1353247686","1353247626","1","0");
INSERT INTO kolhoz_ground VALUES("11733","1073","6","0","1353250269","1353247689","1353247629","1","0");
INSERT INTO kolhoz_ground VALUES("11734","1070","14","1","1353280336","1353264602","1353256996","1","0");
INSERT INTO kolhoz_ground VALUES("11735","1070","14","1","1353280352","1353264603","1353257012","1","0");
INSERT INTO kolhoz_ground VALUES("11736","1070","14","1","1353280341","1353264604","1353257001","1","0");
INSERT INTO kolhoz_ground VALUES("11737","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11738","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11739","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11740","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("11741","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("11742","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("11743","1074","17","0","1353271124","1353254881","1353253184","1","0");
INSERT INTO kolhoz_ground VALUES("11744","1074","17","1","1353257858","1353253621","1353249818","1","0");
INSERT INTO kolhoz_ground VALUES("11745","1074","17","0","1353273951","1353253191","1353253311","1","0");
INSERT INTO kolhoz_ground VALUES("11746","1074","17","1","1353242222","1353254769","1353253082","1","0");
INSERT INTO kolhoz_ground VALUES("11747","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("11748","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("11749","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("11750","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("11751","1076","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11752","1076","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11753","1076","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11754","1076","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11755","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11756","1058","53","1","1355873307","1355705195","1355585547","1","0");
INSERT INTO kolhoz_ground VALUES("11757","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11758","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("11759","1058","53","1","1355873013","1355705197","1355585253","1","0");
INSERT INTO kolhoz_ground VALUES("11760","1077","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11761","1077","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11762","1077","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11763","1077","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11764","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("11765","1078","51","1","1353411561","1353300864","1353251241","1","0");
INSERT INTO kolhoz_ground VALUES("11766","1078","51","1","1353411554","1353300869","1353251234","1","0");
INSERT INTO kolhoz_ground VALUES("11767","1078","51","1","1353411586","1353300873","1353251266","1","0");
INSERT INTO kolhoz_ground VALUES("11768","1078","51","1","1353411530","1353300878","1353251210","1","0");
INSERT INTO kolhoz_ground VALUES("11769","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("11770","1079","20","0","1353354716","1353261236","1353261356","1","0");
INSERT INTO kolhoz_ground VALUES("11771","1079","20","0","1353354719","1353261239","1353261359","1","0");
INSERT INTO kolhoz_ground VALUES("11772","1079","20","0","1353354724","1353261244","1353261364","1","0");
INSERT INTO kolhoz_ground VALUES("11773","1079","20","0","1353354728","1353261248","1353261368","1","0");
INSERT INTO kolhoz_ground VALUES("11774","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11775","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11776","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11777","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11778","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11779","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11780","1080","31","1","1353339383","1353331464","1353327563","1","0");
INSERT INTO kolhoz_ground VALUES("11781","1081","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11782","1081","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11783","1081","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11784","1081","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11785","1082","6","0","1353249965","1353247385","1353247325","1","0");
INSERT INTO kolhoz_ground VALUES("11786","1082","6","0","1353249970","1353247390","1353247330","1","0");
INSERT INTO kolhoz_ground VALUES("11787","1082","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11788","1082","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11789","1083","6","0","1353334701","1353332121","1353332121","1","0");
INSERT INTO kolhoz_ground VALUES("11790","1083","6","0","1353334704","1353332124","1353332124","1","0");
INSERT INTO kolhoz_ground VALUES("11791","1083","0","0","1353248517","1353249549","1353247677","1","0");
INSERT INTO kolhoz_ground VALUES("11792","1083","6","0","1353334706","1353332126","1353332126","1","0");
INSERT INTO kolhoz_ground VALUES("11793","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("11794","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("11795","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("11796","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("11797","1083","0","0","1353248553","1353249584","1353247713","0","0");
INSERT INTO kolhoz_ground VALUES("11798","1085","6","0","1353317377","1353314797","1353314797","1","0");
INSERT INTO kolhoz_ground VALUES("11799","1085","6","0","1353317377","1353314797","1353314797","1","0");
INSERT INTO kolhoz_ground VALUES("11800","1085","6","0","1353317377","1353314797","1353314797","1","0");
INSERT INTO kolhoz_ground VALUES("11801","1085","6","0","1353317377","1353314797","1353314797","1","0");
INSERT INTO kolhoz_ground VALUES("11802","1086","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11803","1086","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11804","1086","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11805","1086","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11806","1087","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11807","1087","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11808","1087","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11809","1087","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11810","1088","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11811","1088","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11812","1088","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11813","1088","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11814","1024","23","0","1353367550","1353338150","1353338210","1","0");
INSERT INTO kolhoz_ground VALUES("11815","1089","0","0","1353192944","1353258651","1353257324","0","0");
INSERT INTO kolhoz_ground VALUES("11816","1089","0","0","1353192949","1353258873","1353257329","1","0");
INSERT INTO kolhoz_ground VALUES("11817","1089","0","0","1353192949","1353258653","1353257329","0","0");
INSERT INTO kolhoz_ground VALUES("11818","1089","0","0","1353192950","1353258654","1353257330","1","0");
INSERT INTO kolhoz_ground VALUES("11819","1090","6","1","1353249173","1353248393","1353248333","1","0");
INSERT INTO kolhoz_ground VALUES("11820","1090","6","1","1353249173","1353248393","1353248333","1","0");
INSERT INTO kolhoz_ground VALUES("11821","1090","6","1","1353249174","1353248394","1353248334","1","0");
INSERT INTO kolhoz_ground VALUES("11822","1090","6","1","1353249170","1353248390","1353248330","1","0");
INSERT INTO kolhoz_ground VALUES("11823","1074","17","0","1353273893","1353253133","1353253253","1","0");
INSERT INTO kolhoz_ground VALUES("11824","1074","17","0","1353273988","1353253228","1353253348","1","0");
INSERT INTO kolhoz_ground VALUES("11825","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11826","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11827","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11828","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11829","1089","0","0","1353192951","1353258655","1353257331","1","0");
INSERT INTO kolhoz_ground VALUES("11830","1092","18","1","1353306636","1353259322","1353250296","1","0");
INSERT INTO kolhoz_ground VALUES("11831","1092","18","1","1353306636","1353259322","1353250296","1","0");
INSERT INTO kolhoz_ground VALUES("11832","1092","18","1","1353306636","1353259322","1353250296","1","0");
INSERT INTO kolhoz_ground VALUES("11833","1092","18","1","1353306636","1353259322","1353250296","1","0");
INSERT INTO kolhoz_ground VALUES("11834","1093","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11835","1093","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11836","1093","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11837","1093","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11838","1092","18","1","1353306636","1353259322","1353250296","1","0");
INSERT INTO kolhoz_ground VALUES("11839","1092","18","1","1353306636","1353259322","1353250296","1","0");
INSERT INTO kolhoz_ground VALUES("11840","1094","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11841","1094","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11842","1094","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11843","1094","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11844","1095","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11845","1095","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11846","1095","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11847","1095","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11848","1096","12","1","1353282710","1353278054","1353249410","1","0");
INSERT INTO kolhoz_ground VALUES("11849","1096","12","1","1353282710","1353278054","1353249410","1","0");
INSERT INTO kolhoz_ground VALUES("11850","1096","12","1","1353282710","1353278054","1353249410","1","0");
INSERT INTO kolhoz_ground VALUES("11851","1096","12","1","1353282710","1353278054","1353249410","1","0");
INSERT INTO kolhoz_ground VALUES("11852","1097","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11853","1097","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11854","1097","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11855","1097","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11856","1098","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11857","1098","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11858","1098","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11859","1098","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11860","1099","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11861","1099","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11862","1099","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11863","1099","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11864","1100","6","1","1353315048","1353316292","1353314508","1","0");
INSERT INTO kolhoz_ground VALUES("11865","1100","6","1","1353315048","1353316292","1353314508","1","0");
INSERT INTO kolhoz_ground VALUES("11866","1100","6","1","1353315048","1353316292","1353314508","1","0");
INSERT INTO kolhoz_ground VALUES("11867","1100","6","1","1353315048","1353316292","1353314508","1","0");
INSERT INTO kolhoz_ground VALUES("11868","1101","31","0","1353478720","1353331240","1353331300","1","0");
INSERT INTO kolhoz_ground VALUES("11869","1101","31","0","1353478720","1353331240","1353331300","1","0");
INSERT INTO kolhoz_ground VALUES("11870","1101","31","0","1353478720","1353331240","1353331300","1","0");
INSERT INTO kolhoz_ground VALUES("11871","1101","31","0","1353478720","1353331240","1353331300","1","0");
INSERT INTO kolhoz_ground VALUES("11872","1102","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11873","1102","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11874","1102","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11875","1102","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11876","1103","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11877","1103","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11878","1103","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11879","1103","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11880","1096","12","1","1353282710","1353278054","1353249410","1","0");
INSERT INTO kolhoz_ground VALUES("11881","1096","12","1","1353282710","1353278054","1353249410","1","0");
INSERT INTO kolhoz_ground VALUES("11882","1104","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11883","1104","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11884","1104","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11885","1104","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11886","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11887","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11888","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11889","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11890","1106","0","0","1353264716","1353269336","1353269336","1","0");
INSERT INTO kolhoz_ground VALUES("11891","1106","0","0","1353264717","1353269337","1353269337","1","0");
INSERT INTO kolhoz_ground VALUES("11892","1106","0","0","1353264719","1353269339","1353269339","1","0");
INSERT INTO kolhoz_ground VALUES("11893","1106","0","0","1353264721","1353269341","1353269341","1","0");
INSERT INTO kolhoz_ground VALUES("11894","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11895","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11896","1107","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11897","1107","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11898","1107","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11899","1107","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11900","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11901","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11902","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11903","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11904","1109","20","0","1353344172","1353250692","1353250812","1","0");
INSERT INTO kolhoz_ground VALUES("11905","1109","22","0","1353356219","1353250739","1353250919","1","0");
INSERT INTO kolhoz_ground VALUES("11906","1109","22","0","1353356225","1353250745","1353250925","1","0");
INSERT INTO kolhoz_ground VALUES("11907","1109","22","0","1353356233","1353250753","1353250933","1","0");
INSERT INTO kolhoz_ground VALUES("11908","1110","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11909","1110","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11910","1110","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11911","1110","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11912","1106","0","0","1353264722","1353269342","1353269342","1","0");
INSERT INTO kolhoz_ground VALUES("11913","1106","0","0","1353264724","1353269344","1353269344","1","0");
INSERT INTO kolhoz_ground VALUES("11914","1106","0","0","1353264726","1353269346","1353269346","0","0");
INSERT INTO kolhoz_ground VALUES("11915","1111","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11916","1111","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11917","1111","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11918","1111","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11919","1109","22","0","1353356231","1353250751","1353250931","1","0");
INSERT INTO kolhoz_ground VALUES("11920","1112","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11921","1112","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11922","1112","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11923","1112","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11924","1113","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11925","1113","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11926","1113","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11927","1113","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11928","1039","0","0","1353253419","1353329859","1353329859","1","0");
INSERT INTO kolhoz_ground VALUES("11929","1039","0","0","1353253419","1353329859","1353329859","1","0");
INSERT INTO kolhoz_ground VALUES("11930","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11931","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11932","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11933","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11934","1089","0","0","1353192952","1353258656","1353257332","1","0");
INSERT INTO kolhoz_ground VALUES("11935","1115","0","0","1353257915","1353250835","1353250955","0","0");
INSERT INTO kolhoz_ground VALUES("11936","1115","20","0","1353344342","1353250862","1353250982","1","0");
INSERT INTO kolhoz_ground VALUES("11937","1115","20","0","1353344349","1353250869","1353250989","1","0");
INSERT INTO kolhoz_ground VALUES("11938","1115","22","0","1353356372","1353250892","1353251072","1","0");
INSERT INTO kolhoz_ground VALUES("11939","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11940","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11941","1114","22","1","1353324355","1353308133","1353252055","1","0");
INSERT INTO kolhoz_ground VALUES("11942","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("11943","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("11944","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("11945","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("11946","1117","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11947","1117","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11948","1117","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11949","1117","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11950","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("11951","1115","22","0","1353356377","1353250897","1353251077","1","0");
INSERT INTO kolhoz_ground VALUES("11952","1115","22","0","1353356382","1353250902","1353251082","1","0");
INSERT INTO kolhoz_ground VALUES("11953","1115","0","0","1353253035","1353253155","1353253035","1","0");
INSERT INTO kolhoz_ground VALUES("11954","1115","0","0","1353253035","1353253155","1353253035","1","0");
INSERT INTO kolhoz_ground VALUES("11955","1115","0","0","1353253035","1353253155","1353253035","1","0");
INSERT INTO kolhoz_ground VALUES("11956","1118","22","0","1353356282","1353250802","1353250982","1","0");
INSERT INTO kolhoz_ground VALUES("11957","1118","22","0","1353356288","1353250808","1353250988","1","0");
INSERT INTO kolhoz_ground VALUES("11958","1118","22","0","1353356289","1353250809","1353250989","1","0");
INSERT INTO kolhoz_ground VALUES("11959","1118","22","0","1353356293","1353250813","1353250993","1","0");
INSERT INTO kolhoz_ground VALUES("11960","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("11961","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("11962","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("11963","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("11964","1118","22","0","1353356294","1353250814","1353250994","1","0");
INSERT INTO kolhoz_ground VALUES("11965","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11966","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("11967","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("11968","1120","6","0","1353253247","1353250667","1353250607","1","0");
INSERT INTO kolhoz_ground VALUES("11969","1120","6","0","1353253252","1353250672","1353250612","1","0");
INSERT INTO kolhoz_ground VALUES("11970","1120","6","0","1353253254","1353250674","1353250614","1","0");
INSERT INTO kolhoz_ground VALUES("11971","1120","6","0","1353253254","1353250674","1353250614","1","0");
INSERT INTO kolhoz_ground VALUES("11972","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11973","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11974","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11975","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11976","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11977","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("11978","1122","9","1","1353254990","1353253695","1353251840","1","0");
INSERT INTO kolhoz_ground VALUES("11979","1122","9","1","1353254990","1353253695","1353251840","1","0");
INSERT INTO kolhoz_ground VALUES("11980","1122","9","1","1353254990","1353253695","1353251840","1","0");
INSERT INTO kolhoz_ground VALUES("11981","1122","9","1","1353254990","1353253695","1353251840","1","0");
INSERT INTO kolhoz_ground VALUES("11982","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11983","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11984","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11985","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("11986","1105","23","0","1353348608","1353319208","1353319268","1","0");
INSERT INTO kolhoz_ground VALUES("11987","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11988","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11989","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("11990","1123","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11991","1123","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11992","1123","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11993","1123","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11994","1124","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11995","1124","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11996","1124","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11997","1124","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11998","1125","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("11999","1125","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12000","1125","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12001","1125","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12002","1126","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12003","1126","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12004","1126","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12005","1126","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12006","1127","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12007","1127","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12008","1127","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12009","1127","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12010","1128","6","0","1353256075","1353253495","1353253435","1","0");
INSERT INTO kolhoz_ground VALUES("12011","1128","6","0","1353256075","1353253495","1353253435","1","0");
INSERT INTO kolhoz_ground VALUES("12012","1128","6","0","1353256075","1353253495","1353253435","1","0");
INSERT INTO kolhoz_ground VALUES("12013","1128","6","0","1353256075","1353253495","1353253435","1","0");
INSERT INTO kolhoz_ground VALUES("12014","1129","6","1","1353295634","1353296709","1353294854","1","0");
INSERT INTO kolhoz_ground VALUES("12015","1129","6","1","1353295636","1353296711","1353294856","1","0");
INSERT INTO kolhoz_ground VALUES("12016","1129","6","1","1353295638","1353296715","1353294858","1","0");
INSERT INTO kolhoz_ground VALUES("12017","1129","6","1","1353295639","1353296714","1353294859","1","0");
INSERT INTO kolhoz_ground VALUES("12018","1130","37","0","1353438830","1353255350","1353255710","1","0");
INSERT INTO kolhoz_ground VALUES("12019","1130","37","0","1353438830","1353255350","1353255710","1","0");
INSERT INTO kolhoz_ground VALUES("12020","1130","37","0","1353438830","1353255350","1353255710","1","0");
INSERT INTO kolhoz_ground VALUES("12021","1130","37","0","1353438830","1353255350","1353255710","1","0");
INSERT INTO kolhoz_ground VALUES("12022","1131","17","0","1353298028","1353277268","1353277268","1","0");
INSERT INTO kolhoz_ground VALUES("12023","1131","17","0","1353298028","1353277268","1353277268","1","0");
INSERT INTO kolhoz_ground VALUES("12024","1131","17","0","1353298028","1353277268","1353277268","1","0");
INSERT INTO kolhoz_ground VALUES("12025","1131","17","0","1353298028","1353277268","1353277268","1","0");
INSERT INTO kolhoz_ground VALUES("12026","1045","6","1","1353252748","1353251968","1353251908","1","0");
INSERT INTO kolhoz_ground VALUES("12027","1132","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12028","1132","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12029","1132","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12030","1132","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12031","1131","17","0","1353298028","1353277268","1353277268","1","0");
INSERT INTO kolhoz_ground VALUES("12032","1131","17","0","1353298028","1353277268","1353277268","1","0");
INSERT INTO kolhoz_ground VALUES("12033","1133","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12034","1133","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12035","1133","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12036","1133","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12037","1045","6","0","1353254579","1353251999","1353251939","1","0");
INSERT INTO kolhoz_ground VALUES("12038","1045","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12039","1122","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12040","1130","37","0","1353438830","1353255350","1353255710","1","0");
INSERT INTO kolhoz_ground VALUES("12041","1130","37","0","1353438830","1353255350","1353255710","1","0");
INSERT INTO kolhoz_ground VALUES("12042","1134","22","0","1353358401","1353252921","1353253101","1","0");
INSERT INTO kolhoz_ground VALUES("12043","1134","22","0","1353358408","1353252928","1353253108","1","0");
INSERT INTO kolhoz_ground VALUES("12044","1134","22","0","1353358411","1353252931","1353253111","1","0");
INSERT INTO kolhoz_ground VALUES("12045","1134","22","0","1353358420","1353252940","1353253120","1","0");
INSERT INTO kolhoz_ground VALUES("12046","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("12047","1134","22","0","1353358420","1353252940","1353253120","1","0");
INSERT INTO kolhoz_ground VALUES("12048","1134","22","0","1353358423","1353252943","1353253123","1","0");
INSERT INTO kolhoz_ground VALUES("12049","1134","22","0","1353358426","1353252946","1353253126","1","0");
INSERT INTO kolhoz_ground VALUES("12050","1134","22","0","1353358432","1353252952","1353253132","1","0");
INSERT INTO kolhoz_ground VALUES("12051","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("12052","1135","6","1","1353265912","1353267108","1353265132","1","0");
INSERT INTO kolhoz_ground VALUES("12053","1135","6","1","1353265921","1353267120","1353265141","1","0");
INSERT INTO kolhoz_ground VALUES("12054","1135","6","1","1353265937","1353267151","1353265157","1","0");
INSERT INTO kolhoz_ground VALUES("12055","1135","8","1","1353286787","1353267162","1353265187","1","0");
INSERT INTO kolhoz_ground VALUES("12056","1119","13","0","1353275049","1353260049","1353260109","1","0");
INSERT INTO kolhoz_ground VALUES("12057","1134","22","0","1353358434","1353252954","1353253134","1","0");
INSERT INTO kolhoz_ground VALUES("12058","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("12059","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("12060","1116","31","1","1353342934","1353332873","1353331114","1","0");
INSERT INTO kolhoz_ground VALUES("12061","1101","31","0","1353478720","1353331240","1353331300","1","0");
INSERT INTO kolhoz_ground VALUES("12062","1101","31","0","1353478720","1353331240","1353331300","1","0");
INSERT INTO kolhoz_ground VALUES("12063","1136","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12064","1136","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12065","1136","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12066","1136","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12067","1137","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12068","1137","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12069","1137","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12070","1137","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12071","1138","6","0","1353258289","1353255709","1353255649","1","0");
INSERT INTO kolhoz_ground VALUES("12072","1138","6","0","1353258296","1353255716","1353255656","1","0");
INSERT INTO kolhoz_ground VALUES("12073","1138","6","0","1353258302","1353255722","1353255662","1","0");
INSERT INTO kolhoz_ground VALUES("12074","1138","6","0","1353258315","1353255735","1353255675","1","0");
INSERT INTO kolhoz_ground VALUES("12075","1139","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12076","1139","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12077","1139","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12078","1139","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12079","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("12080","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("12081","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("12082","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("12083","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("12084","1140","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12085","1140","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12086","1140","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12087","1140","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12088","1141","57","0","1355875028","1355507948","1355508128","1","0");
INSERT INTO kolhoz_ground VALUES("12089","1141","57","0","1355875047","1355507967","1355508147","1","0");
INSERT INTO kolhoz_ground VALUES("12090","1141","57","0","1355875047","1355507967","1355508147","1","0");
INSERT INTO kolhoz_ground VALUES("12091","1141","57","0","1355875047","1355507967","1355508147","1","0");
INSERT INTO kolhoz_ground VALUES("12092","1142","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12093","1142","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12094","1142","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12095","1142","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12096","1013","0","0","1353331750","1353331870","1353331750","1","0");
INSERT INTO kolhoz_ground VALUES("12097","1143","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12098","1143","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12099","1143","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12100","1143","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12101","1144","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12102","1144","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12103","1144","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12104","1144","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12105","1145","24","1","1353335124","1353255684","1353255864","1","0");
INSERT INTO kolhoz_ground VALUES("12106","1145","24","1","1353335124","1353255684","1353255864","1","0");
INSERT INTO kolhoz_ground VALUES("12107","1145","24","1","1353335124","1353255684","1353255864","1","0");
INSERT INTO kolhoz_ground VALUES("12108","1145","24","1","1353335124","1353255684","1353255864","1","0");
INSERT INTO kolhoz_ground VALUES("12109","1145","24","1","1353335124","1353255684","1353255864","1","0");
INSERT INTO kolhoz_ground VALUES("12110","1145","24","1","1353335124","1353255684","1353255864","1","0");
INSERT INTO kolhoz_ground VALUES("12111","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("12112","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("12113","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("12114","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("12115","1147","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12116","1147","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12117","1147","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12118","1147","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12119","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12120","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12121","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12122","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12123","1149","0","0","1353256000","1353257030","1353255160","0","0");
INSERT INTO kolhoz_ground VALUES("12124","1149","0","0","1353256012","1353257054","1353255172","0","0");
INSERT INTO kolhoz_ground VALUES("12125","1149","0","0","1353256019","1353257063","1353255179","0","0");
INSERT INTO kolhoz_ground VALUES("12126","1149","0","0","1353256024","1353257075","1353255184","0","0");
INSERT INTO kolhoz_ground VALUES("12127","1150","6","1","1353291216","1353290436","1353290436","1","0");
INSERT INTO kolhoz_ground VALUES("12128","1150","6","0","1353293030","1353290450","1353290450","1","0");
INSERT INTO kolhoz_ground VALUES("12129","1150","6","0","1353293034","1353290454","1353290454","1","0");
INSERT INTO kolhoz_ground VALUES("12130","1150","6","0","1353293040","1353290460","1353290460","1","0");
INSERT INTO kolhoz_ground VALUES("12131","1149","6","1","1353256123","1353257157","1353255283","1","0");
INSERT INTO kolhoz_ground VALUES("12132","1151","6","0","1353308666","1353306086","1353306086","1","0");
INSERT INTO kolhoz_ground VALUES("12133","1151","6","0","1353308666","1353306086","1353306086","1","0");
INSERT INTO kolhoz_ground VALUES("12134","1151","6","0","1353308666","1353306086","1353306086","1","0");
INSERT INTO kolhoz_ground VALUES("12135","1151","6","0","1353308666","1353306086","1353306086","1","0");
INSERT INTO kolhoz_ground VALUES("12136","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12137","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12138","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12139","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12140","1153","6","0","1353307024","1353304444","1353304444","1","0");
INSERT INTO kolhoz_ground VALUES("12141","1153","6","0","1353307034","1353304454","1353304454","1","0");
INSERT INTO kolhoz_ground VALUES("12142","1153","6","0","1353307039","1353304459","1353304459","1","0");
INSERT INTO kolhoz_ground VALUES("12143","1153","6","0","1353307041","1353304461","1353304461","1","0");
INSERT INTO kolhoz_ground VALUES("12144","1149","10","1","1353286742","1353256082","1353256082","1","0");
INSERT INTO kolhoz_ground VALUES("12145","1149","10","1","1353286742","1353256082","1353256082","1","0");
INSERT INTO kolhoz_ground VALUES("12146","1154","8","1","1353341002","1353332485","1353319402","1","0");
INSERT INTO kolhoz_ground VALUES("12147","1154","8","1","1353340979","1353332484","1353319379","1","0");
INSERT INTO kolhoz_ground VALUES("12148","1154","8","1","1353340980","1353332484","1353319380","1","0");
INSERT INTO kolhoz_ground VALUES("12149","1154","8","1","1353352441","1353333079","1353330841","1","0");
INSERT INTO kolhoz_ground VALUES("12150","1155","6","1","1353256667","1353257725","1353255827","1","0");
INSERT INTO kolhoz_ground VALUES("12151","1155","6","1","1353256699","1353257727","1353255859","1","0");
INSERT INTO kolhoz_ground VALUES("12152","1155","6","1","1353256705","1353257729","1353255865","1","0");
INSERT INTO kolhoz_ground VALUES("12153","1155","6","1","1353256706","1353257728","1353255866","1","0");
INSERT INTO kolhoz_ground VALUES("12154","1156","8","0","1353290328","1353266928","1353266928","1","0");
INSERT INTO kolhoz_ground VALUES("12155","1156","8","0","1353290330","1353266930","1353266930","1","0");
INSERT INTO kolhoz_ground VALUES("12156","1156","8","0","1353290332","1353266932","1353266932","1","0");
INSERT INTO kolhoz_ground VALUES("12157","1156","8","0","1353290345","1353266945","1353266945","1","0");
INSERT INTO kolhoz_ground VALUES("12158","1155","6","1","1353256709","1353257730","1353255869","1","0");
INSERT INTO kolhoz_ground VALUES("12159","1155","6","1","1353256714","1353257764","1353255874","1","0");
INSERT INTO kolhoz_ground VALUES("12160","1155","6","1","1353256716","1353257766","1353255876","1","0");
INSERT INTO kolhoz_ground VALUES("12161","1149","10","1","1353286742","1353256082","1353256082","1","0");
INSERT INTO kolhoz_ground VALUES("12162","1157","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12163","1157","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12164","1157","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12165","1157","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12166","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12167","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12168","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12169","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12170","1141","57","0","1355875047","1355507967","1355508147","1","0");
INSERT INTO kolhoz_ground VALUES("12171","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12172","1159","0","0","1353252857","1353257657","1353257597","1","0");
INSERT INTO kolhoz_ground VALUES("12173","1159","0","0","1353252857","1353257657","1353257597","1","0");
INSERT INTO kolhoz_ground VALUES("12174","1159","0","0","1353252857","1353257657","1353257597","1","0");
INSERT INTO kolhoz_ground VALUES("12175","1159","0","0","1353252857","1353257657","1353257597","1","0");
INSERT INTO kolhoz_ground VALUES("12176","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12177","1158","6","0","1353259246","1353256666","1353256606","1","0");
INSERT INTO kolhoz_ground VALUES("12178","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("12179","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("12180","1160","21","0","1353289541","1353263021","1353263201","1","0");
INSERT INTO kolhoz_ground VALUES("12181","1160","21","0","1353289547","1353263027","1353263207","1","0");
INSERT INTO kolhoz_ground VALUES("12182","1160","21","0","1353289552","1353263032","1353263212","1","0");
INSERT INTO kolhoz_ground VALUES("12183","1160","21","0","1353289568","1353263048","1353263228","1","0");
INSERT INTO kolhoz_ground VALUES("12184","1161","6","1","1353258267","1353257487","1353257427","1","0");
INSERT INTO kolhoz_ground VALUES("12185","1161","6","0","1353260071","1353257491","1353257431","1","0");
INSERT INTO kolhoz_ground VALUES("12186","1161","6","0","1353260071","1353257491","1353257431","1","0");
INSERT INTO kolhoz_ground VALUES("12187","1161","6","0","1353260072","1353257492","1353257432","1","0");
INSERT INTO kolhoz_ground VALUES("12188","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12189","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12190","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12191","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12192","1050","6","0","1353262483","1353259903","1353259843","1","0");
INSERT INTO kolhoz_ground VALUES("12193","1054","23","0","1353362687","1353333287","1353333347","1","0");
INSERT INTO kolhoz_ground VALUES("12194","1071","12","0","1355158696","1355112496","1355112496","1","0");
INSERT INTO kolhoz_ground VALUES("12195","1160","21","0","1353289578","1353263058","1353263238","1","0");
INSERT INTO kolhoz_ground VALUES("12196","1160","0","0","1353253241","1353264367","1353262781","1","0");
INSERT INTO kolhoz_ground VALUES("12197","1160","21","0","1353289592","1353263072","1353263252","1","0");
INSERT INTO kolhoz_ground VALUES("12198","1163","6","0","1353266304","1353263724","1353263724","1","0");
INSERT INTO kolhoz_ground VALUES("12199","1163","6","0","1353266304","1353263724","1353263724","1","0");
INSERT INTO kolhoz_ground VALUES("12200","1163","6","0","1353266305","1353263725","1353263725","1","0");
INSERT INTO kolhoz_ground VALUES("12201","1163","6","0","1353266318","1353263738","1353263738","1","0");
INSERT INTO kolhoz_ground VALUES("12202","1164","5","1","1353264691","1353265906","1353264151","1","0");
INSERT INTO kolhoz_ground VALUES("12203","1164","5","1","1353264691","1353265906","1353264151","1","0");
INSERT INTO kolhoz_ground VALUES("12204","1164","5","1","1353264691","1353265906","1353264151","1","0");
INSERT INTO kolhoz_ground VALUES("12205","1164","5","1","1353264691","1353265906","1353264151","1","0");
INSERT INTO kolhoz_ground VALUES("12206","1165","8","0","1353283744","1353260344","1353260284","1","0");
INSERT INTO kolhoz_ground VALUES("12207","1165","8","0","1353283746","1353260346","1353260286","1","0");
INSERT INTO kolhoz_ground VALUES("12208","1165","8","0","1353283748","1353260348","1353260288","1","0");
INSERT INTO kolhoz_ground VALUES("12209","1165","8","0","1353283749","1353260349","1353260289","1","0");
INSERT INTO kolhoz_ground VALUES("12210","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12211","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12212","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12213","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12214","1165","8","0","1353283751","1353260351","1353260291","1","0");
INSERT INTO kolhoz_ground VALUES("12215","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("12216","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("12217","1048","12","1","1353268536","1353263077","1353261096","1","0");
INSERT INTO kolhoz_ground VALUES("12218","1167","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12219","1167","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12220","1167","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12221","1167","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12222","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12223","1168","6","1","1353260041","1353261101","1353259201","1","0");
INSERT INTO kolhoz_ground VALUES("12224","1168","6","1","1353260045","1353261101","1353259205","1","0");
INSERT INTO kolhoz_ground VALUES("12225","1168","6","1","1353260049","1353261103","1353259209","1","0");
INSERT INTO kolhoz_ground VALUES("12226","1168","6","1","1353260053","1353261103","1353259213","1","0");
INSERT INTO kolhoz_ground VALUES("12227","1050","6","0","1353262483","1353259903","1353259843","1","0");
INSERT INTO kolhoz_ground VALUES("12228","1169","12","1","1353354219","1353329852","1353311139","1","0");
INSERT INTO kolhoz_ground VALUES("12229","1169","12","1","1353354234","1353329852","1353311154","1","0");
INSERT INTO kolhoz_ground VALUES("12230","1169","12","1","1353354238","1353329852","1353311158","1","0");
INSERT INTO kolhoz_ground VALUES("12231","1169","12","1","1353354226","1353329852","1353311146","1","0");
INSERT INTO kolhoz_ground VALUES("12232","1170","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12233","1170","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12234","1170","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12235","1170","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12236","1168","6","1","1353260064","1353261104","1353259224","1","0");
INSERT INTO kolhoz_ground VALUES("12237","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12238","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12239","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12240","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12241","1166","6","0","1353262642","1353260062","1353260002","1","0");
INSERT INTO kolhoz_ground VALUES("12242","1171","6","0","1353262159","1353259579","1353259519","1","0");
INSERT INTO kolhoz_ground VALUES("12243","1171","6","0","1353262172","1353259592","1353259532","1","0");
INSERT INTO kolhoz_ground VALUES("12244","1171","6","0","1353262172","1353259592","1353259532","1","0");
INSERT INTO kolhoz_ground VALUES("12245","1171","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12246","1172","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12247","1172","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12248","1172","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12249","1172","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12250","1173","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12251","1173","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12252","1173","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12253","1173","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12254","1174","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12255","1174","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12256","1174","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12257","1174","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12258","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12259","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12260","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12261","1175","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12262","1175","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12263","1175","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12264","1175","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12265","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12266","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12267","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12268","1176","6","0","1353318309","1353315729","1353315729","1","0");
INSERT INTO kolhoz_ground VALUES("12269","1176","6","0","1353318317","1353315737","1353315737","1","0");
INSERT INTO kolhoz_ground VALUES("12270","1176","6","0","1353318330","1353315750","1353315750","1","0");
INSERT INTO kolhoz_ground VALUES("12271","1176","6","0","1353318336","1353315756","1353315756","1","0");
INSERT INTO kolhoz_ground VALUES("12272","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12273","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12274","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12275","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12276","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12277","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12278","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12279","1176","6","0","1353318343","1353315763","1353315763","1","0");
INSERT INTO kolhoz_ground VALUES("12280","1176","6","0","1353318351","1353315771","1353315771","1","0");
INSERT INTO kolhoz_ground VALUES("12281","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12282","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12283","1178","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12284","1178","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12285","1178","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12286","1178","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12287","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("12288","1061","35","1","1353350260","1353326246","1353319240","1","0");
INSERT INTO kolhoz_ground VALUES("12289","1179","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12290","1179","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12291","1179","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12292","1179","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12293","1180","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12294","1180","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12295","1180","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12296","1180","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12297","1181","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12298","1181","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12299","1181","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12300","1181","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12301","1141","57","0","1355875047","1355507967","1355508147","1","0");
INSERT INTO kolhoz_ground VALUES("12302","1141","57","0","1355875047","1355507967","1355508147","1","0");
INSERT INTO kolhoz_ground VALUES("12303","1108","23","0","1353361040","1353331640","1353331700","1","0");
INSERT INTO kolhoz_ground VALUES("12304","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12305","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12306","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12307","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12308","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("12309","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("12310","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("12311","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("12312","1005","53","1","1353494326","1353282780","1353280606","1","0");
INSERT INTO kolhoz_ground VALUES("12313","1183","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12314","1183","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12315","1183","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12316","1183","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12317","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12318","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12319","1046","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12320","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12321","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12322","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12323","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12324","1185","6","0","1353276803","1353274223","1353274223","1","0");
INSERT INTO kolhoz_ground VALUES("12325","1185","6","0","1353276806","1353274226","1353274226","1","0");
INSERT INTO kolhoz_ground VALUES("12326","1185","8","0","1353297635","1353274235","1353274235","1","0");
INSERT INTO kolhoz_ground VALUES("12327","1185","8","0","1353297638","1353274238","1353274238","1","0");
INSERT INTO kolhoz_ground VALUES("12328","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12329","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12330","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12331","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12332","1187","12","0","1353354145","1353307945","1353307945","1","0");
INSERT INTO kolhoz_ground VALUES("12333","1187","12","0","1353354145","1353307945","1353307945","1","0");
INSERT INTO kolhoz_ground VALUES("12334","1187","12","0","1353354145","1353307945","1353307945","1","0");
INSERT INTO kolhoz_ground VALUES("12335","1187","12","0","1353354145","1353307945","1353307945","1","0");
INSERT INTO kolhoz_ground VALUES("12336","1164","10","1","1353297031","1353266023","1353264271","1","0");
INSERT INTO kolhoz_ground VALUES("12337","1187","12","0","1353354145","1353307945","1353307945","1","0");
INSERT INTO kolhoz_ground VALUES("12338","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12339","1188","5","0","1353270061","1353267481","1353267481","1","0");
INSERT INTO kolhoz_ground VALUES("12340","1188","5","0","1353270059","1353267479","1353267479","1","0");
INSERT INTO kolhoz_ground VALUES("12341","1188","5","0","1353270064","1353267484","1353267484","1","0");
INSERT INTO kolhoz_ground VALUES("12342","1188","5","0","1353270067","1353267487","1353267487","1","0");
INSERT INTO kolhoz_ground VALUES("12343","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12344","1156","8","0","1353290334","1353266934","1353266934","1","0");
INSERT INTO kolhoz_ground VALUES("12345","1188","5","0","1353270090","1353267510","1353267510","1","0");
INSERT INTO kolhoz_ground VALUES("12346","1188","5","0","1353270075","1353267495","1353267495","1","0");
INSERT INTO kolhoz_ground VALUES("12347","1188","5","0","1353270079","1353267499","1353267499","1","0");
INSERT INTO kolhoz_ground VALUES("12348","1188","5","0","1353270079","1353267499","1353267499","1","0");
INSERT INTO kolhoz_ground VALUES("12349","1188","5","0","1353270080","1353267500","1353267500","1","0");
INSERT INTO kolhoz_ground VALUES("12350","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12351","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12352","1186","22","1","1353275801","1353267502","1353265421","1","0");
INSERT INTO kolhoz_ground VALUES("12353","1189","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12354","1189","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12355","1189","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12356","1189","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12357","1184","8","1","1353329749","1353327210","1353308929","1","0");
INSERT INTO kolhoz_ground VALUES("12358","1190","6","0","1353269456","1353266876","1353266876","1","0");
INSERT INTO kolhoz_ground VALUES("12359","1190","0","0","1353261571","1353266191","1353266191","1","0");
INSERT INTO kolhoz_ground VALUES("12360","1190","0","0","1353261585","1353266205","1353266205","0","0");
INSERT INTO kolhoz_ground VALUES("12361","1190","0","0","1353261594","1353266214","1353266214","0","0");
INSERT INTO kolhoz_ground VALUES("12362","1191","22","1","1353366204","1353270717","1353268704","1","0");
INSERT INTO kolhoz_ground VALUES("12363","1191","22","1","1353366241","1353270717","1353268741","1","0");
INSERT INTO kolhoz_ground VALUES("12364","1191","22","1","1353366279","1353270717","1353268779","1","0");
INSERT INTO kolhoz_ground VALUES("12365","1191","22","1","1353366606","1353271063","1353269106","1","0");
INSERT INTO kolhoz_ground VALUES("12366","1191","22","1","1353366628","1353271063","1353269128","1","0");
INSERT INTO kolhoz_ground VALUES("12367","1191","22","1","1353366636","1353271063","1353269136","1","0");
INSERT INTO kolhoz_ground VALUES("12368","1191","22","1","1353366618","1353271063","1353269118","1","0");
INSERT INTO kolhoz_ground VALUES("12369","1192","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12370","1192","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12371","1192","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12372","1192","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12373","1192","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12374","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12375","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12376","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12377","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12378","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12379","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12380","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12381","1193","6","0","1353269716","1353267136","1353267136","1","0");
INSERT INTO kolhoz_ground VALUES("12382","1194","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12383","1194","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12384","1194","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12385","1194","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12386","1195","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12387","1195","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12388","1195","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12389","1195","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12390","1196","6","1","1353268469","1353269698","1353267689","1","0");
INSERT INTO kolhoz_ground VALUES("12391","1196","6","1","1353268499","1353269707","1353267719","1","0");
INSERT INTO kolhoz_ground VALUES("12392","1196","8","1","1353289328","1353269707","1353267728","1","0");
INSERT INTO kolhoz_ground VALUES("12393","1196","10","1","1353301035","1353269855","1353268035","1","0");
INSERT INTO kolhoz_ground VALUES("12394","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("12395","1197","10","1","1353301541","1353270468","1353268541","1","0");
INSERT INTO kolhoz_ground VALUES("12396","1197","10","1","1353301545","1353270474","1353268545","1","0");
INSERT INTO kolhoz_ground VALUES("12397","1197","10","1","1353301552","1353270478","1353268552","1","0");
INSERT INTO kolhoz_ground VALUES("12398","1197","10","1","1353301557","1353270482","1353268557","1","0");
INSERT INTO kolhoz_ground VALUES("12399","1075","23","0","1353358276","1353328876","1353328936","1","0");
INSERT INTO kolhoz_ground VALUES("12400","1198","18","1","1353343186","1353273466","1353271546","1","0");
INSERT INTO kolhoz_ground VALUES("12401","1198","18","1","1353343324","1353273466","1353271684","1","0");
INSERT INTO kolhoz_ground VALUES("12402","1198","18","1","1353335454","1353273643","1353271914","1","0");
INSERT INTO kolhoz_ground VALUES("12403","1198","20","1","1353348563","1353273657","1353271943","1","0");
INSERT INTO kolhoz_ground VALUES("12404","1199","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12405","1199","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12406","1199","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12407","1199","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12408","1196","10","1","1353301083","1353269920","1353268083","1","0");
INSERT INTO kolhoz_ground VALUES("12409","1196","12","1","1353312526","1353269939","1353268126","1","0");
INSERT INTO kolhoz_ground VALUES("12410","1196","12","1","1353312567","1353270055","1353268167","1","0");
INSERT INTO kolhoz_ground VALUES("12411","1200","20","1","1353355053","1353333745","1353270453","1","0");
INSERT INTO kolhoz_ground VALUES("12412","1200","22","1","1353367059","1353333745","1353270459","1","0");
INSERT INTO kolhoz_ground VALUES("12413","1200","22","1","1353367061","1353333745","1353270461","1","0");
INSERT INTO kolhoz_ground VALUES("12414","1200","22","1","1353367062","1353333745","1353270462","1","0");
INSERT INTO kolhoz_ground VALUES("12415","1201","6","0","1353271210","1353268630","1353268630","1","0");
INSERT INTO kolhoz_ground VALUES("12416","1201","6","0","1353271215","1353268635","1353268635","1","0");
INSERT INTO kolhoz_ground VALUES("12417","1201","6","0","1353271217","1353268637","1353268637","1","0");
INSERT INTO kolhoz_ground VALUES("12418","1201","6","0","1353271220","1353268640","1353268640","1","0");
INSERT INTO kolhoz_ground VALUES("12419","1202","8","0","1353355309","1353331909","1353331909","1","0");
INSERT INTO kolhoz_ground VALUES("12420","1202","8","0","1353355310","1353331910","1353331910","1","0");
INSERT INTO kolhoz_ground VALUES("12421","1202","8","0","1353355311","1353331911","1353331911","1","0");
INSERT INTO kolhoz_ground VALUES("12422","1202","8","0","1353355311","1353331911","1353331911","1","0");
INSERT INTO kolhoz_ground VALUES("12423","1201","6","0","1353271244","1353268664","1353268664","1","0");
INSERT INTO kolhoz_ground VALUES("12424","1201","6","0","1353271247","1353268667","1353268667","1","0");
INSERT INTO kolhoz_ground VALUES("12425","1201","6","0","1353271249","1353268669","1353268669","1","0");
INSERT INTO kolhoz_ground VALUES("12426","1201","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12427","1201","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12428","1201","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12429","1200","22","1","1353367065","1353333745","1353270465","1","0");
INSERT INTO kolhoz_ground VALUES("12430","1202","8","0","1353355312","1353331912","1353331912","1","0");
INSERT INTO kolhoz_ground VALUES("12431","1202","8","0","1353355313","1353331913","1353331913","1","0");
INSERT INTO kolhoz_ground VALUES("12432","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12433","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12434","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12435","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12436","1204","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12437","1204","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12438","1204","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12439","1204","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12440","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12441","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12442","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12443","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12444","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12445","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12446","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12447","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12448","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("12449","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("12450","1084","8","1","1353351597","1353333064","1353330237","1","0");
INSERT INTO kolhoz_ground VALUES("12451","1198","20","1","1353348644","1353273754","1353272024","1","0");
INSERT INTO kolhoz_ground VALUES("12452","1205","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12453","1205","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12454","1205","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12455","1205","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12456","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12457","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12458","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12459","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12460","1202","8","0","1353355313","1353331913","1353331913","1","0");
INSERT INTO kolhoz_ground VALUES("12461","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12462","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12463","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12464","1207","6","0","1353274624","1353272044","1353272044","1","0");
INSERT INTO kolhoz_ground VALUES("12465","1207","6","0","1353274626","1353272046","1353272046","1","0");
INSERT INTO kolhoz_ground VALUES("12466","1207","6","0","1353274630","1353272050","1353272050","1","0");
INSERT INTO kolhoz_ground VALUES("12467","1207","6","0","1353274632","1353272052","1353272052","1","0");
INSERT INTO kolhoz_ground VALUES("12468","1207","6","0","1353274639","1353272059","1353272059","1","0");
INSERT INTO kolhoz_ground VALUES("12469","1208","22","0","1353378588","1353273108","1353273108","1","0");
INSERT INTO kolhoz_ground VALUES("12470","1208","22","0","1353378593","1353273113","1353273113","1","0");
INSERT INTO kolhoz_ground VALUES("12471","1208","22","0","1353378598","1353273118","1353273118","1","0");
INSERT INTO kolhoz_ground VALUES("12472","1208","24","0","1353388225","1353273145","1353273205","1","0");
INSERT INTO kolhoz_ground VALUES("12473","1209","51","1","1353460147","1353320165","1353306187","1","0");
INSERT INTO kolhoz_ground VALUES("12474","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12475","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12476","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12477","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12478","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12479","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12480","1209","51","1","1353460156","1353320165","1353306196","1","0");
INSERT INTO kolhoz_ground VALUES("12481","1210","20","0","1353366504","1353273024","1353273024","1","0");
INSERT INTO kolhoz_ground VALUES("12482","1210","22","0","1353378515","1353273035","1353273035","1","0");
INSERT INTO kolhoz_ground VALUES("12483","1210","22","0","1353378518","1353273038","1353273038","1","0");
INSERT INTO kolhoz_ground VALUES("12484","1210","22","0","1353378522","1353273042","1353273042","1","0");
INSERT INTO kolhoz_ground VALUES("12485","1210","22","0","1353378525","1353273045","1353273045","1","0");
INSERT INTO kolhoz_ground VALUES("12486","1210","22","0","1353378573","1353273093","1353273093","1","0");
INSERT INTO kolhoz_ground VALUES("12487","1210","22","0","1353378576","1353273096","1353273096","1","0");
INSERT INTO kolhoz_ground VALUES("12488","1208","24","0","1353388229","1353273149","1353273209","1","0");
INSERT INTO kolhoz_ground VALUES("12489","1208","24","0","1353388239","1353273159","1353273219","1","0");
INSERT INTO kolhoz_ground VALUES("12490","1211","22","0","1353379474","1353273994","1353273994","1","0");
INSERT INTO kolhoz_ground VALUES("12491","1211","22","0","1353379493","1353274013","1353274013","1","0");
INSERT INTO kolhoz_ground VALUES("12492","1211","0","0","1353273847","1353273928","1353273928","1","0");
INSERT INTO kolhoz_ground VALUES("12493","1211","0","0","1353273847","1353273933","1353273933","0","0");
INSERT INTO kolhoz_ground VALUES("12494","1211","0","0","1353273847","1353273940","1353273940","1","0");
INSERT INTO kolhoz_ground VALUES("12495","1211","0","0","1353273847","1353273948","1353273948","0","0");
INSERT INTO kolhoz_ground VALUES("12496","1211","0","0","1353273847","1353273813","1353273813","0","0");
INSERT INTO kolhoz_ground VALUES("12497","1211","0","0","1353273847","1353273954","1353273954","0","0");
INSERT INTO kolhoz_ground VALUES("12498","1212","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12499","1212","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12500","1212","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12501","1212","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12502","1213","0","0","1353276987","1353274407","1353274407","1","0");
INSERT INTO kolhoz_ground VALUES("12503","1213","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12504","1213","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12505","1213","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12506","1214","6","0","1353277199","1353274619","1353274619","1","0");
INSERT INTO kolhoz_ground VALUES("12507","1214","6","0","1353277204","1353274624","1353274624","1","0");
INSERT INTO kolhoz_ground VALUES("12508","1214","6","0","1353277207","1353274627","1353274627","1","0");
INSERT INTO kolhoz_ground VALUES("12509","1214","6","0","1353277211","1353274631","1353274631","1","0");
INSERT INTO kolhoz_ground VALUES("12510","1214","7","0","1353281003","1353274643","1353274643","1","0");
INSERT INTO kolhoz_ground VALUES("12511","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12512","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12513","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12514","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12515","1216","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12516","1216","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12517","1216","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12518","1216","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12519","1214","7","0","1353281034","1353274674","1353274674","1","0");
INSERT INTO kolhoz_ground VALUES("12520","1214","7","0","1353281039","1353274679","1353274679","1","0");
INSERT INTO kolhoz_ground VALUES("12521","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12522","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12523","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12524","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12525","1214","7","0","1353281043","1353274683","1353274683","1","0");
INSERT INTO kolhoz_ground VALUES("12526","1214","7","0","1353281049","1353274689","1353274689","1","0");
INSERT INTO kolhoz_ground VALUES("12527","1218","10","1","1353355281","1353325937","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12528","1218","10","1","1353355281","1353325940","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12529","1218","10","1","1353355281","1353325943","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12530","1218","10","1","1353355281","1353325946","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12531","1218","10","1","1353355281","1353325952","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12532","1219","6","1","1353275138","1353276606","1353274598","1","0");
INSERT INTO kolhoz_ground VALUES("12533","1219","6","1","1353275143","1353276606","1353274603","1","0");
INSERT INTO kolhoz_ground VALUES("12534","1219","6","1","1353275147","1353276606","1353274607","1","0");
INSERT INTO kolhoz_ground VALUES("12535","1219","6","1","1353275153","1353276606","1353274613","1","0");
INSERT INTO kolhoz_ground VALUES("12536","1220","6","0","1353308312","1353305732","1353305732","1","0");
INSERT INTO kolhoz_ground VALUES("12537","1220","6","0","1353308319","1353305739","1353305739","1","0");
INSERT INTO kolhoz_ground VALUES("12538","1220","8","0","1353329169","1353305769","1353305769","1","0");
INSERT INTO kolhoz_ground VALUES("12539","1220","8","0","1353329185","1353305785","1353305785","1","0");
INSERT INTO kolhoz_ground VALUES("12540","1218","10","1","1353355281","1353325956","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12541","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12542","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12543","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12544","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12545","1219","6","1","1353275175","1353276606","1353274635","1","0");
INSERT INTO kolhoz_ground VALUES("12546","1222","5","1","1353276547","1353277947","1353276187","1","0");
INSERT INTO kolhoz_ground VALUES("12547","1222","5","1","1353276547","1353277947","1353276187","1","0");
INSERT INTO kolhoz_ground VALUES("12548","1222","5","1","1353276547","1353277947","1353276187","1","0");
INSERT INTO kolhoz_ground VALUES("12549","1222","5","1","1353276547","1353277947","1353276187","1","0");
INSERT INTO kolhoz_ground VALUES("12550","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12551","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12552","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12553","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12554","1220","8","0","1353329193","1353305793","1353305793","1","0");
INSERT INTO kolhoz_ground VALUES("12555","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12556","1223","10","0","1353365457","1353330657","1353330657","1","0");
INSERT INTO kolhoz_ground VALUES("12557","1223","6","0","1353333280","1353330700","1353330700","1","0");
INSERT INTO kolhoz_ground VALUES("12558","1223","6","0","1353333282","1353330702","1353330702","1","0");
INSERT INTO kolhoz_ground VALUES("12559","1223","6","0","1353333283","1353330703","1353330703","1","0");
INSERT INTO kolhoz_ground VALUES("12560","1218","10","1","1353355281","1353325959","1353322761","1","0");
INSERT INTO kolhoz_ground VALUES("12561","1224","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12562","1224","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12563","1224","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12564","1224","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12565","1225","6","0","1353277850","1353275270","1353275270","1","0");
INSERT INTO kolhoz_ground VALUES("12566","1225","6","0","1353277905","1353275325","1353275325","1","0");
INSERT INTO kolhoz_ground VALUES("12567","1225","6","0","1353277910","1353275330","1353275330","1","0");
INSERT INTO kolhoz_ground VALUES("12568","1225","6","0","1353277916","1353275336","1353275336","1","0");
INSERT INTO kolhoz_ground VALUES("12569","1223","6","0","1353333284","1353330704","1353330704","1","0");
INSERT INTO kolhoz_ground VALUES("12570","1223","6","0","1353333286","1353330706","1353330706","1","0");
INSERT INTO kolhoz_ground VALUES("12571","1220","8","0","1353329200","1353305800","1353305800","1","0");
INSERT INTO kolhoz_ground VALUES("12572","1220","8","0","1353329208","1353305808","1353305808","1","0");
INSERT INTO kolhoz_ground VALUES("12573","1226","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12574","1226","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12575","1226","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12576","1226","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12577","1227","0","0","1353294825","1353285976","1353275745","0","0");
INSERT INTO kolhoz_ground VALUES("12578","1227","22","1","1353294827","1353285978","1353275747","1","0");
INSERT INTO kolhoz_ground VALUES("12579","1227","22","1","1353294828","1353285986","1353275748","1","0");
INSERT INTO kolhoz_ground VALUES("12580","1227","22","1","1353294830","1353285988","1353275750","1","0");
INSERT INTO kolhoz_ground VALUES("12581","1227","22","1","1353294831","1353285989","1353275751","1","0");
INSERT INTO kolhoz_ground VALUES("12582","1227","22","1","1353294832","1353285991","1353275752","1","0");
INSERT INTO kolhoz_ground VALUES("12583","1227","22","1","1353294833","1353285992","1353275753","1","0");
INSERT INTO kolhoz_ground VALUES("12584","1228","12","1","1353370646","1353334717","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12585","1228","12","1","1353370646","1353334725","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12586","1228","12","1","1353370646","1353334725","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12587","1228","12","1","1353370646","1353334725","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12588","1223","6","0","1353333287","1353330707","1353330707","1","0");
INSERT INTO kolhoz_ground VALUES("12589","1229","20","1","1353362401","1353334251","1353276121","1","0");
INSERT INTO kolhoz_ground VALUES("12590","1229","22","1","1353374407","1353334257","1353276127","1","0");
INSERT INTO kolhoz_ground VALUES("12591","1229","22","1","1353374412","1353334259","1353276132","1","0");
INSERT INTO kolhoz_ground VALUES("12592","1229","22","1","1353374413","1353334261","1353276133","1","0");
INSERT INTO kolhoz_ground VALUES("12593","1229","22","1","1353374414","1353334268","1353276134","1","0");
INSERT INTO kolhoz_ground VALUES("12594","1229","22","1","1353374414","1353334269","1353276134","1","0");
INSERT INTO kolhoz_ground VALUES("12595","1229","22","1","1353374414","1353334269","1353276134","1","0");
INSERT INTO kolhoz_ground VALUES("12596","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12597","1228","12","1","1353370646","1353334725","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12598","1228","12","1","1353370646","1353334725","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12599","1228","12","1","1353370646","1353334725","1353328046","1","0");
INSERT INTO kolhoz_ground VALUES("12600","1121","23","0","1353358607","1353329207","1353329267","1","0");
INSERT INTO kolhoz_ground VALUES("12601","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12602","1217","8","1","1355596731","1355578186","1355576511","1","0");
INSERT INTO kolhoz_ground VALUES("12603","1222","5","1","1353276634","1353278046","1353276274","1","0");
INSERT INTO kolhoz_ground VALUES("12604","1222","5","1","1353276634","1353278046","1353276274","1","0");
INSERT INTO kolhoz_ground VALUES("12605","1230","22","1","1353350631","1353280340","1353277551","1","0");
INSERT INTO kolhoz_ground VALUES("12606","1230","22","1","1353350636","1353280350","1353277556","1","0");
INSERT INTO kolhoz_ground VALUES("12607","1230","24","1","1353360626","1353277946","1353278006","1","0");
INSERT INTO kolhoz_ground VALUES("12608","1230","24","1","1353360630","1353277950","1353278010","1","0");
INSERT INTO kolhoz_ground VALUES("12609","1231","5","1","1353277641","1353278677","1353276861","1","0");
INSERT INTO kolhoz_ground VALUES("12610","1231","5","1","1353277645","1353278687","1353276865","1","0");
INSERT INTO kolhoz_ground VALUES("12611","1231","5","1","1353277648","1353278690","1353276868","1","0");
INSERT INTO kolhoz_ground VALUES("12612","1231","5","1","1353277650","1353278692","1353276870","1","0");
INSERT INTO kolhoz_ground VALUES("12613","1230","24","1","1353360634","1353277954","1353278014","1","0");
INSERT INTO kolhoz_ground VALUES("12614","1230","24","0","1353393041","1353277961","1353278021","1","0");
INSERT INTO kolhoz_ground VALUES("12615","1231","5","1","1353277938","1353278975","1353277158","1","0");
INSERT INTO kolhoz_ground VALUES("12616","1231","5","1","1353277942","1353278988","1353277162","1","0");
INSERT INTO kolhoz_ground VALUES("12617","1231","5","1","1353277963","1353278996","1353277183","1","0");
INSERT INTO kolhoz_ground VALUES("12618","1231","5","1","1353277971","1353279003","1353277191","1","0");
INSERT INTO kolhoz_ground VALUES("12619","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12620","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12621","1221","23","0","1353367898","1353338498","1353338558","1","0");
INSERT INTO kolhoz_ground VALUES("12622","1232","5","0","1353280147","1353277567","1353277567","1","0");
INSERT INTO kolhoz_ground VALUES("12623","1232","6","0","1353280165","1353277585","1353277585","1","0");
INSERT INTO kolhoz_ground VALUES("12624","1232","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12625","1232","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12626","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12627","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12628","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12629","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12630","1234","5","0","1353280513","1353277933","1353277933","1","0");
INSERT INTO kolhoz_ground VALUES("12631","1234","5","0","1353280518","1353277938","1353277938","1","0");
INSERT INTO kolhoz_ground VALUES("12632","1234","5","0","1353280533","1353277953","1353277953","1","0");
INSERT INTO kolhoz_ground VALUES("12633","1234","5","0","1353280528","1353277948","1353277948","1","0");
INSERT INTO kolhoz_ground VALUES("12634","1235","6","0","1353280677","1353278097","1353278097","1","0");
INSERT INTO kolhoz_ground VALUES("12635","1235","6","0","1353280691","1353278111","1353278111","1","0");
INSERT INTO kolhoz_ground VALUES("12636","1235","6","0","1353280703","1353278123","1353278123","1","0");
INSERT INTO kolhoz_ground VALUES("12637","1235","6","0","1353280715","1353278135","1353278135","1","0");
INSERT INTO kolhoz_ground VALUES("12638","1215","11","0","1353343818","1353331698","1353331698","1","0");
INSERT INTO kolhoz_ground VALUES("12639","1236","6","0","1353280653","1353278073","1353278073","1","0");
INSERT INTO kolhoz_ground VALUES("12640","1236","6","0","1353280657","1353278077","1353278077","1","0");
INSERT INTO kolhoz_ground VALUES("12641","1236","6","0","1353280660","1353278080","1353278080","1","0");
INSERT INTO kolhoz_ground VALUES("12642","1236","6","0","1353280669","1353278089","1353278089","1","0");
INSERT INTO kolhoz_ground VALUES("12643","1237","0","0","1353310223","1353332663","1353332723","1","0");
INSERT INTO kolhoz_ground VALUES("12644","1237","0","0","1353310222","1353332662","1353332722","0","0");
INSERT INTO kolhoz_ground VALUES("12645","1237","0","0","1353310223","1353332663","1353332723","0","0");
INSERT INTO kolhoz_ground VALUES("12646","1237","0","0","1353310223","1353332663","1353332723","0","0");
INSERT INTO kolhoz_ground VALUES("12647","1238","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12648","1238","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12649","1238","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12650","1238","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12651","1239","22","1","1353416505","1353324057","1353318225","1","0");
INSERT INTO kolhoz_ground VALUES("12652","1239","22","1","1353416507","1353324058","1353318227","1","0");
INSERT INTO kolhoz_ground VALUES("12653","1239","22","1","1353416508","1353324059","1353318228","1","0");
INSERT INTO kolhoz_ground VALUES("12654","1239","22","1","1353416514","1353324059","1353318234","1","0");
INSERT INTO kolhoz_ground VALUES("12655","1240","20","1","1353371135","1353284494","1353279455","1","0");
INSERT INTO kolhoz_ground VALUES("12656","1240","22","1","1353383140","1353284496","1353279460","1","0");
INSERT INTO kolhoz_ground VALUES("12657","1240","22","1","1353383141","1353281524","1353279461","1","0");
INSERT INTO kolhoz_ground VALUES("12658","1240","22","1","1353383143","1353281523","1353279463","1","0");
INSERT INTO kolhoz_ground VALUES("12659","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12660","1240","22","1","1353383144","1353281522","1353279464","1","0");
INSERT INTO kolhoz_ground VALUES("12661","1240","22","1","1353383146","1353281521","1353279466","1","0");
INSERT INTO kolhoz_ground VALUES("12662","1240","22","1","1353383148","1353281520","1353279468","1","0");
INSERT INTO kolhoz_ground VALUES("12663","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12664","1241","39","1","1353337452","1353318756","1353285852","1","0");
INSERT INTO kolhoz_ground VALUES("12665","1241","39","1","1353337462","1353318756","1353285862","1","0");
INSERT INTO kolhoz_ground VALUES("12666","1241","39","1","1353337468","1353318756","1353285868","1","0");
INSERT INTO kolhoz_ground VALUES("12667","1241","39","1","1353337473","1353318756","1353285873","1","0");
INSERT INTO kolhoz_ground VALUES("12668","1239","22","1","1353416509","1353324039","1353318229","1","0");
INSERT INTO kolhoz_ground VALUES("12669","1239","22","1","1353416509","1353324060","1353318229","1","0");
INSERT INTO kolhoz_ground VALUES("12670","1239","22","1","1353416510","1353324061","1353318230","1","0");
INSERT INTO kolhoz_ground VALUES("12671","1242","20","0","1353373602","1353280122","1353280122","1","0");
INSERT INTO kolhoz_ground VALUES("12672","1242","22","0","1353385610","1353280130","1353280130","1","0");
INSERT INTO kolhoz_ground VALUES("12673","1242","22","0","1353385612","1353280132","1353280132","1","0");
INSERT INTO kolhoz_ground VALUES("12674","1242","22","0","1353385617","1353280137","1353280137","1","0");
INSERT INTO kolhoz_ground VALUES("12675","1241","39","1","1353337489","1353318756","1353285889","1","0");
INSERT INTO kolhoz_ground VALUES("12676","1241","39","1","1353337494","1353318756","1353285894","1","0");
INSERT INTO kolhoz_ground VALUES("12677","1242","22","0","1353385616","1353280136","1353280136","1","0");
INSERT INTO kolhoz_ground VALUES("12678","1242","22","0","1353385621","1353280141","1353280141","1","0");
INSERT INTO kolhoz_ground VALUES("12679","1242","22","0","1353385624","1353280144","1353280144","1","0");
INSERT INTO kolhoz_ground VALUES("12680","1241","39","1","1353340561","1353318756","1353285901","1","0");
INSERT INTO kolhoz_ground VALUES("12681","1239","22","1","1353416510","1353324061","1353318230","1","0");
INSERT INTO kolhoz_ground VALUES("12682","1239","22","1","1353416511","1353324061","1353318231","1","0");
INSERT INTO kolhoz_ground VALUES("12683","1243","5","1","1353281261","1353282339","1353280481","1","0");
INSERT INTO kolhoz_ground VALUES("12684","1243","5","1","1353281253","1353282329","1353280473","1","0");
INSERT INTO kolhoz_ground VALUES("12685","1243","5","1","1353281245","1353282356","1353280465","1","0");
INSERT INTO kolhoz_ground VALUES("12686","1243","5","1","1353281968","1353281188","1353281188","1","0");
INSERT INTO kolhoz_ground VALUES("12687","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12688","1244","18","1","1353328852","1353283230","1353280852","1","0");
INSERT INTO kolhoz_ground VALUES("12689","1244","18","1","1353328853","1353283231","1353280853","1","0");
INSERT INTO kolhoz_ground VALUES("12690","1244","20","1","1353341940","1353283234","1353280860","1","0");
INSERT INTO kolhoz_ground VALUES("12691","1244","22","1","1353353946","1353283232","1353280866","1","0");
INSERT INTO kolhoz_ground VALUES("12692","1244","22","1","1353353956","1353283233","1353280876","1","0");
INSERT INTO kolhoz_ground VALUES("12693","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12694","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12695","1243","8","1","1353302877","1353283584","1353281277","1","0");
INSERT INTO kolhoz_ground VALUES("12696","1237","0","0","1353310223","1353332663","1353332723","0","0");
INSERT INTO kolhoz_ground VALUES("12697","1177","23","0","1353362171","1353332771","1353332831","1","0");
INSERT INTO kolhoz_ground VALUES("12698","1035","23","0","1353353548","1353324148","1353324208","1","0");
INSERT INTO kolhoz_ground VALUES("12699","1245","5","1","1353283584","1353284754","1353282804","1","0");
INSERT INTO kolhoz_ground VALUES("12700","1245","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12701","1245","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12702","1245","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12703","1246","10","1","1353316769","1353285594","1353283769","1","0");
INSERT INTO kolhoz_ground VALUES("12704","1246","12","1","1353328193","1353285609","1353283793","1","0");
INSERT INTO kolhoz_ground VALUES("12705","1246","12","1","1353328198","1353285612","1353283798","1","0");
INSERT INTO kolhoz_ground VALUES("12706","1246","8","1","1353304463","1353284700","1353282863","1","0");
INSERT INTO kolhoz_ground VALUES("12707","1246","7","1","1353287506","1353284874","1353282946","1","0");
INSERT INTO kolhoz_ground VALUES("12708","1245","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12709","1246","8","1","1353304823","1353285098","1353283223","1","0");
INSERT INTO kolhoz_ground VALUES("12710","1246","8","1","1353304847","1353285108","1353283247","1","0");
INSERT INTO kolhoz_ground VALUES("12711","1246","8","1","1353304873","1353285117","1353283273","1","0");
INSERT INTO kolhoz_ground VALUES("12712","1246","10","1","1353316300","1353285128","1353283300","1","0");
INSERT INTO kolhoz_ground VALUES("12713","1247","8","0","1353308468","1353285068","1353285068","1","0");
INSERT INTO kolhoz_ground VALUES("12714","1247","8","0","1353308473","1353285073","1353285073","1","0");
INSERT INTO kolhoz_ground VALUES("12715","1247","8","0","1353308473","1353285073","1353285073","1","0");
INSERT INTO kolhoz_ground VALUES("12716","1247","8","0","1353308473","1353285073","1353285073","1","0");
INSERT INTO kolhoz_ground VALUES("12717","1246","10","1","1353316330","1353285148","1353283330","1","0");
INSERT INTO kolhoz_ground VALUES("12718","1237","0","0","1353310223","1353332663","1353332723","1","0");
INSERT INTO kolhoz_ground VALUES("12719","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("12720","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("12721","1018","0","0","1353356562","1353327162","1353327222","0","0");
INSERT INTO kolhoz_ground VALUES("12722","1248","5","1","1353286699","1353287758","1353285919","1","0");
INSERT INTO kolhoz_ground VALUES("12723","1248","6","1","1353286715","1353287786","1353285935","1","0");
INSERT INTO kolhoz_ground VALUES("12724","1248","6","1","1353286729","1353287797","1353285949","1","0");
INSERT INTO kolhoz_ground VALUES("12725","1248","8","1","1353307567","1353287819","1353285967","1","0");
INSERT INTO kolhoz_ground VALUES("12726","1248","7","1","1353290575","1353287864","1353286015","1","0");
INSERT INTO kolhoz_ground VALUES("12727","1248","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("12728","1249","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12729","1249","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12730","1249","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12731","1249","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12732","1250","22","0","1353392975","1353287495","1353287495","1","0");
INSERT INTO kolhoz_ground VALUES("12733","1250","22","0","1353392979","1353287499","1353287499","1","0");
INSERT INTO kolhoz_ground VALUES("12734","1250","22","0","1353392980","1353287500","1353287500","1","0");
INSERT INTO kolhoz_ground VALUES("12735","1250","22","0","1353392982","1353287502","1353287502","1","0");
INSERT INTO kolhoz_ground VALUES("12736","1250","22","0","1353392983","1353287503","1353287503","1","0");
INSERT INTO kolhoz_ground VALUES("12737","1250","22","0","1353392989","1353287509","1353287509","1","0");
INSERT INTO kolhoz_ground VALUES("12738","1251","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12739","1251","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12740","1251","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12741","1251","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12742","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("12743","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("12744","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("12745","1021","47","1","1353427673","1353327092","1353314273","1","0");
INSERT INTO kolhoz_ground VALUES("12746","1252","8","1","1353321279","1353319998","1353299919","1","0");
INSERT INTO kolhoz_ground VALUES("12747","1252","8","1","1353321279","1353319998","1353299919","1","0");
INSERT INTO kolhoz_ground VALUES("12748","1252","8","1","1353321279","1353319998","1353299919","1","0");
INSERT INTO kolhoz_ground VALUES("12749","1252","8","1","1353321279","1353319998","1353299919","1","0");
INSERT INTO kolhoz_ground VALUES("12750","1253","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12751","1253","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12752","1253","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12753","1253","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12754","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12755","1254","12","0","1353364158","1353317958","1353317958","1","0");
INSERT INTO kolhoz_ground VALUES("12756","1254","12","0","1353364165","1353317965","1353317965","1","0");
INSERT INTO kolhoz_ground VALUES("12757","1254","12","0","1353364165","1353317965","1353317965","1","0");
INSERT INTO kolhoz_ground VALUES("12758","1254","12","0","1353364165","1353317965","1353317965","1","0");
INSERT INTO kolhoz_ground VALUES("12759","1255","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12760","1255","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12761","1255","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12762","1255","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12763","1256","10","0","1353345073","1353310273","1353310273","1","0");
INSERT INTO kolhoz_ground VALUES("12764","1256","10","0","1353345063","1353310263","1353310263","1","0");
INSERT INTO kolhoz_ground VALUES("12765","1256","8","1","1353330922","1353311449","1353309322","1","0");
INSERT INTO kolhoz_ground VALUES("12766","1256","7","1","1353313919","1353311493","1353309359","1","0");
INSERT INTO kolhoz_ground VALUES("12767","1254","12","0","1353364165","1353317965","1353317965","1","0");
INSERT INTO kolhoz_ground VALUES("12768","1254","12","0","1353364165","1353317965","1353317965","1","0");
INSERT INTO kolhoz_ground VALUES("12769","1254","12","0","1353364165","1353317965","1353317965","1","0");
INSERT INTO kolhoz_ground VALUES("12770","1129","6","1","1353295640","1353296720","1353294860","1","0");
INSERT INTO kolhoz_ground VALUES("12771","1162","7","0","1353311125","1353304765","1353304765","1","0");
INSERT INTO kolhoz_ground VALUES("12772","1257","7","0","1353319454","1353313094","1353313094","1","0");
INSERT INTO kolhoz_ground VALUES("12773","1257","7","0","1353319454","1353313094","1353313094","1","0");
INSERT INTO kolhoz_ground VALUES("12774","1257","7","0","1353319454","1353313094","1353313094","1","0");
INSERT INTO kolhoz_ground VALUES("12775","1257","7","0","1353319454","1353313094","1353313094","1","0");
INSERT INTO kolhoz_ground VALUES("12776","1257","7","0","1353319454","1353313094","1353313094","1","0");
INSERT INTO kolhoz_ground VALUES("12777","1258","10","1","1353353365","1353322280","1353320365","1","0");
INSERT INTO kolhoz_ground VALUES("12778","1258","10","1","1353353369","1353322285","1353320369","1","0");
INSERT INTO kolhoz_ground VALUES("12779","1258","10","1","1353353374","1353322291","1353320374","1","0");
INSERT INTO kolhoz_ground VALUES("12780","1258","12","1","1353364807","1353322262","1353320407","1","0");
INSERT INTO kolhoz_ground VALUES("12781","1259","6","0","1353335064","1353332484","1353332484","1","0");
INSERT INTO kolhoz_ground VALUES("12782","1259","6","0","1353335064","1353332484","1353332484","1","0");
INSERT INTO kolhoz_ground VALUES("12783","1259","6","0","1353335064","1353332484","1353332484","1","0");
INSERT INTO kolhoz_ground VALUES("12784","1259","6","0","1353335064","1353332484","1353332484","1","0");
INSERT INTO kolhoz_ground VALUES("12785","1260","16","1","1353336793","1353301188","1353299293","1","0");
INSERT INTO kolhoz_ground VALUES("12786","1260","16","1","1353336798","1353301193","1353299298","1","0");
INSERT INTO kolhoz_ground VALUES("12787","1260","16","1","1353336801","1353301197","1353299301","1","0");
INSERT INTO kolhoz_ground VALUES("12788","1260","16","1","1353336805","1353301199","1353299305","1","0");
INSERT INTO kolhoz_ground VALUES("12789","1260","16","1","1353336810","1353301204","1353299310","1","0");
INSERT INTO kolhoz_ground VALUES("12790","1260","16","1","1353336814","1353301209","1353299314","1","0");
INSERT INTO kolhoz_ground VALUES("12791","1260","16","1","1353336820","1353301212","1353299320","1","0");
INSERT INTO kolhoz_ground VALUES("12792","1260","16","1","1353336829","1353301218","1353299329","1","0");
INSERT INTO kolhoz_ground VALUES("12793","1261","6","1","1353299539","1353300909","1353298999","1","0");
INSERT INTO kolhoz_ground VALUES("12794","1261","6","1","1353299542","1353300909","1353299002","1","0");
INSERT INTO kolhoz_ground VALUES("12795","1261","6","1","1353299545","1353300909","1353299005","1","0");
INSERT INTO kolhoz_ground VALUES("12796","1261","8","1","1353320377","1353300909","1353299017","1","0");
INSERT INTO kolhoz_ground VALUES("12797","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12798","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12799","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12800","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12801","1263","10","1","1353363987","1353332944","1353330987","1","0");
INSERT INTO kolhoz_ground VALUES("12802","1263","10","1","1353364001","1353332975","1353331001","1","0");
INSERT INTO kolhoz_ground VALUES("12803","1263","10","1","1353364017","1353333006","1353331017","1","0");
INSERT INTO kolhoz_ground VALUES("12804","1263","10","1","1353364037","1353333041","1353331037","1","0");
INSERT INTO kolhoz_ground VALUES("12805","1264","6","0","1353312780","1353310200","1353310200","1","0");
INSERT INTO kolhoz_ground VALUES("12806","1264","6","0","1353312780","1353310200","1353310200","1","0");
INSERT INTO kolhoz_ground VALUES("12807","1264","6","0","1353312780","1353310200","1353310200","1","0");
INSERT INTO kolhoz_ground VALUES("12808","1264","6","0","1353312780","1353310200","1353310200","1","0");
INSERT INTO kolhoz_ground VALUES("12809","1265","18","0","1355660974","1355580574","1355580574","1","0");
INSERT INTO kolhoz_ground VALUES("12810","1265","20","0","1355674087","1355580607","1355580607","1","0");
INSERT INTO kolhoz_ground VALUES("12811","1265","20","0","1355674112","1355580632","1355580632","1","0");
INSERT INTO kolhoz_ground VALUES("12812","1265","20","0","1355674132","1355580652","1355580652","1","0");
INSERT INTO kolhoz_ground VALUES("12813","1266","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12814","1266","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12815","1266","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12816","1266","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12817","1085","6","0","1353317377","1353314797","1353314797","1","0");
INSERT INTO kolhoz_ground VALUES("12818","1085","6","0","1353317377","1353314797","1353314797","1","0");
INSERT INTO kolhoz_ground VALUES("12819","1267","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12820","1267","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12821","1267","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12822","1267","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12823","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12824","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12825","1148","33","0","1353500423","1353338543","1353338603","1","0");
INSERT INTO kolhoz_ground VALUES("12826","1268","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12827","1268","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12828","1268","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12829","1268","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12830","1269","6","0","1353306686","1353304106","1353304106","1","0");
INSERT INTO kolhoz_ground VALUES("12831","1269","6","0","1353306686","1353304106","1353304106","1","0");
INSERT INTO kolhoz_ground VALUES("12832","1269","6","0","1353306686","1353304106","1353304106","1","0");
INSERT INTO kolhoz_ground VALUES("12833","1269","6","0","1353306686","1353304106","1353304106","1","0");
INSERT INTO kolhoz_ground VALUES("12834","1270","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12835","1270","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12836","1270","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12837","1270","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12838","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("12839","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12840","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("12841","1034","7","0","1353310649","1353304289","1353304289","1","0");
INSERT INTO kolhoz_ground VALUES("12842","1271","12","1","1353320132","1353308052","1353306212","1","0");
INSERT INTO kolhoz_ground VALUES("12843","1271","12","1","1353320145","1353308052","1353306225","1","0");
INSERT INTO kolhoz_ground VALUES("12844","1271","12","1","1353320145","1353308052","1353306225","1","0");
INSERT INTO kolhoz_ground VALUES("12845","1271","12","1","1353320145","1353308052","1353306225","1","0");
INSERT INTO kolhoz_ground VALUES("12846","1272","14","1","1353349481","1353333320","1353327701","1","0");
INSERT INTO kolhoz_ground VALUES("12847","1272","14","1","1353349484","1353333320","1353327704","1","0");
INSERT INTO kolhoz_ground VALUES("12848","1272","14","1","1353349484","1353333320","1353327704","1","0");
INSERT INTO kolhoz_ground VALUES("12849","1272","14","1","1353349484","1353333320","1353327704","1","0");
INSERT INTO kolhoz_ground VALUES("12850","1272","14","1","1353349484","1353333320","1353327704","1","0");
INSERT INTO kolhoz_ground VALUES("12851","1272","14","1","1353349484","1353333320","1353327704","1","0");
INSERT INTO kolhoz_ground VALUES("12852","1151","6","0","1353308666","1353306086","1353306086","1","0");
INSERT INTO kolhoz_ground VALUES("12853","1272","14","1","1353349484","1353333320","1353327704","1","0");
INSERT INTO kolhoz_ground VALUES("12854","1152","0","0","1353326368","1353332968","1353333028","0","0");
INSERT INTO kolhoz_ground VALUES("12855","1271","12","1","1353320145","1353308052","1353306225","1","0");
INSERT INTO kolhoz_ground VALUES("12856","1273","6","0","1353308828","1353306248","1353306248","1","0");
INSERT INTO kolhoz_ground VALUES("12857","1273","6","0","1353308832","1353306252","1353306252","1","0");
INSERT INTO kolhoz_ground VALUES("12858","1273","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12859","1273","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12860","1274","5","1","1353307955","1353309042","1353307175","1","0");
INSERT INTO kolhoz_ground VALUES("12861","1274","5","1","1353307955","1353307175","1353307175","1","0");
INSERT INTO kolhoz_ground VALUES("12862","1274","5","1","1353307955","1353307175","1353307175","1","0");
INSERT INTO kolhoz_ground VALUES("12863","1274","5","1","1353307955","1353307175","1353307175","1","0");
INSERT INTO kolhoz_ground VALUES("12864","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12865","1275","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12866","1275","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12867","1275","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12868","1275","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12869","1276","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12870","1276","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12871","1276","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12872","1276","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12873","1277","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12874","1277","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12875","1277","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12876","1277","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12877","1033","24","0","1353448489","1353333409","1353333469","1","0");
INSERT INTO kolhoz_ground VALUES("12878","1278","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12879","1278","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12880","1278","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12881","1278","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12882","1187","12","0","1353354145","1353307945","1353307945","1","0");
INSERT INTO kolhoz_ground VALUES("12883","1279","16","1","1353372113","1353311033","1353311033","1","0");
INSERT INTO kolhoz_ground VALUES("12884","1279","16","1","1353372113","1353311033","1353311033","1","0");
INSERT INTO kolhoz_ground VALUES("12885","1279","16","1","1353372113","1353311033","1353311033","1","0");
INSERT INTO kolhoz_ground VALUES("12886","1279","16","1","1353372113","1353311033","1353311033","1","0");
INSERT INTO kolhoz_ground VALUES("12887","1066","22","0","1353416837","1353311357","1353311357","1","0");
INSERT INTO kolhoz_ground VALUES("12888","1066","22","0","1353416838","1353311358","1353311358","1","0");
INSERT INTO kolhoz_ground VALUES("12889","1066","0","0","1353310877","1353310904","1353310904","1","0");
INSERT INTO kolhoz_ground VALUES("12890","1066","0","0","1353310877","1353310957","1353310957","1","0");
INSERT INTO kolhoz_ground VALUES("12891","1279","16","1","1353372113","1353311033","1353311033","1","0");
INSERT INTO kolhoz_ground VALUES("12892","1279","16","1","1353372100","1353311020","1353311020","1","0");
INSERT INTO kolhoz_ground VALUES("12893","1280","10","1","1353351476","1353322799","1353320276","1","0");
INSERT INTO kolhoz_ground VALUES("12894","1280","10","1","1353351489","1353322829","1353320289","1","0");
INSERT INTO kolhoz_ground VALUES("12895","1280","10","1","1353351489","1353322839","1353320289","1","0");
INSERT INTO kolhoz_ground VALUES("12896","1280","10","1","1353351489","1353322863","1353320289","1","0");
INSERT INTO kolhoz_ground VALUES("12897","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12898","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12899","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12900","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12901","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12902","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12903","1281","6","0","1353314574","1353311994","1353311994","1","0");
INSERT INTO kolhoz_ground VALUES("12904","1265","20","0","1355674151","1355580671","1355580671","1","0");
INSERT INTO kolhoz_ground VALUES("12905","1282","6","0","1353314645","1353312065","1353312065","1","0");
INSERT INTO kolhoz_ground VALUES("12906","1282","6","0","1353314669","1353312089","1353312089","1","0");
INSERT INTO kolhoz_ground VALUES("12907","1282","6","0","1353314675","1353312095","1353312095","1","0");
INSERT INTO kolhoz_ground VALUES("12908","1282","6","0","1353314682","1353312102","1353312102","1","0");
INSERT INTO kolhoz_ground VALUES("12909","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12910","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12911","1182","9","0","1353324877","1353315637","1353315637","1","0");
INSERT INTO kolhoz_ground VALUES("12912","1283","6","1","1353329177","1353329837","1353329837","1","0");
INSERT INTO kolhoz_ground VALUES("12913","1283","6","1","1353329186","1353329846","1353329846","1","0");
INSERT INTO kolhoz_ground VALUES("12914","1283","6","1","1353329200","1353329860","1353329860","1","0");
INSERT INTO kolhoz_ground VALUES("12915","1283","6","1","1353329235","1353329895","1353329895","1","0");
INSERT INTO kolhoz_ground VALUES("12916","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12917","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12918","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12919","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12920","1285","14","0","1353372582","1353314982","1353314982","1","0");
INSERT INTO kolhoz_ground VALUES("12921","1285","16","0","1353383997","1353314997","1353314997","1","0");
INSERT INTO kolhoz_ground VALUES("12922","1285","18","0","1353395411","1353315011","1353315011","1","0");
INSERT INTO kolhoz_ground VALUES("12923","1285","18","0","1353395415","1353315015","1353315015","1","0");
INSERT INTO kolhoz_ground VALUES("12924","1283","6","1","1353329243","1353329903","1353329903","1","0");
INSERT INTO kolhoz_ground VALUES("12925","1286","23","0","1353360957","1353331557","1353331617","1","0");
INSERT INTO kolhoz_ground VALUES("12926","1286","23","0","1353360957","1353331557","1353331617","1","0");
INSERT INTO kolhoz_ground VALUES("12927","1286","23","0","1353360957","1353331557","1353331617","1","0");
INSERT INTO kolhoz_ground VALUES("12928","1286","23","0","1353360957","1353331557","1353331617","1","0");
INSERT INTO kolhoz_ground VALUES("12929","1286","23","0","1353360957","1353331557","1353331617","1","0");
INSERT INTO kolhoz_ground VALUES("12930","1010","7","0","1353344385","1353338025","1353338025","1","0");
INSERT INTO kolhoz_ground VALUES("12931","1010","7","0","1353344385","1353338025","1353338025","1","0");
INSERT INTO kolhoz_ground VALUES("12932","1287","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12933","1287","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12934","1287","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12935","1287","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12936","1285","20","0","1353408517","1353315037","1353315037","1","0");
INSERT INTO kolhoz_ground VALUES("12937","1285","20","0","1353408521","1353315041","1353315041","1","0");
INSERT INTO kolhoz_ground VALUES("12938","1285","22","0","1353420543","1353315063","1353315063","1","0");
INSERT INTO kolhoz_ground VALUES("12939","1280","10","1","1353351489","1353322901","1353320289","1","0");
INSERT INTO kolhoz_ground VALUES("12940","1280","10","1","1353351489","1353322926","1353320289","1","0");
INSERT INTO kolhoz_ground VALUES("12941","1280","10","1","1353351489","1353322945","1353320289","1","0");
INSERT INTO kolhoz_ground VALUES("12942","1285","22","0","1353420566","1353315086","1353315086","1","0");
INSERT INTO kolhoz_ground VALUES("12943","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12944","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12945","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12946","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12947","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12948","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12949","1289","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12950","1289","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12951","1289","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12952","1289","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12953","1202","8","0","1353355314","1353331914","1353331914","1","0");
INSERT INTO kolhoz_ground VALUES("12954","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12955","1262","25","0","1353350849","1353318569","1353318629","1","0");
INSERT INTO kolhoz_ground VALUES("12956","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12957","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12958","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12959","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12960","1288","16","0","1353402268","1353333268","1353333268","1","0");
INSERT INTO kolhoz_ground VALUES("12961","1233","23","0","1353361762","1353332362","1353332422","1","0");
INSERT INTO kolhoz_ground VALUES("12962","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12963","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12964","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12965","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12966","1291","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12967","1291","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12968","1291","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12969","1291","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12970","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12971","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12972","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12973","1290","11","0","1353343544","1353331424","1353331424","1","0");
INSERT INTO kolhoz_ground VALUES("12974","1292","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12975","1292","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12976","1292","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12977","1292","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12978","1293","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12979","1293","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12980","1293","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12981","1293","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12982","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("12983","1294","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12984","1294","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12985","1294","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12986","1294","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12987","1295","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12988","1295","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12989","1295","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12990","1295","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12991","1218","10","1","1353355869","1353325000","1353323109","1","0");
INSERT INTO kolhoz_ground VALUES("12992","1206","35","1","1353332015","1353331055","1353331115","1","0");
INSERT INTO kolhoz_ground VALUES("12993","1284","34","1","1353334875","1353331839","1353330255","1","0");
INSERT INTO kolhoz_ground VALUES("12994","1072","14","0","1353396111","1353338511","1353338511","1","0");
INSERT INTO kolhoz_ground VALUES("12995","1203","0","0","1353212423","1353325223","1353325343","0","0");
INSERT INTO kolhoz_ground VALUES("12996","1296","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12997","1296","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12998","1296","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("12999","1296","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13000","1297","8","1","1353339006","1353325146","1353325146","1","0");
INSERT INTO kolhoz_ground VALUES("13001","1297","10","1","1353350419","1353325159","1353325159","1","0");
INSERT INTO kolhoz_ground VALUES("13002","1297","10","1","1353350420","1353325160","1353325160","1","0");
INSERT INTO kolhoz_ground VALUES("13003","1297","12","1","1353361829","1353325169","1353325169","1","0");
INSERT INTO kolhoz_ground VALUES("13004","1298","6","0","1353331308","1353328728","1353328728","1","0");
INSERT INTO kolhoz_ground VALUES("13005","1298","6","0","1353331308","1353328728","1353328728","1","0");
INSERT INTO kolhoz_ground VALUES("13006","1298","6","0","1353331308","1353328728","1353328728","1","0");
INSERT INTO kolhoz_ground VALUES("13007","1298","6","0","1353331308","1353328728","1353328728","1","0");
INSERT INTO kolhoz_ground VALUES("13008","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13009","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13010","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13011","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13012","1300","10","1","1353360020","1353329186","1353327020","1","0");
INSERT INTO kolhoz_ground VALUES("13013","1300","10","1","1353360022","1353329187","1353327022","1","0");
INSERT INTO kolhoz_ground VALUES("13014","1300","10","1","1353360267","1353329189","1353327267","1","0");
INSERT INTO kolhoz_ground VALUES("13015","1300","10","1","1353360370","1353327370","1353327370","1","0");
INSERT INTO kolhoz_ground VALUES("13016","1300","10","1","1353360349","1353327349","1353327349","1","0");
INSERT INTO kolhoz_ground VALUES("13017","1300","10","1","1353360269","1353327269","1353327269","1","0");
INSERT INTO kolhoz_ground VALUES("13018","1300","10","1","1353360270","1353327270","1353327270","1","0");
INSERT INTO kolhoz_ground VALUES("13019","1300","10","1","1353360272","1353327272","1353327272","1","0");
INSERT INTO kolhoz_ground VALUES("13020","1300","10","1","1353360249","1353327249","1353327249","1","0");
INSERT INTO kolhoz_ground VALUES("13021","1300","10","1","1353360008","1353327008","1353327008","1","0");
INSERT INTO kolhoz_ground VALUES("13022","1301","6","1","1353327733","1353329105","1353326953","1","0");
INSERT INTO kolhoz_ground VALUES("13023","1301","6","1","1353327742","1353329106","1353326962","1","0");
INSERT INTO kolhoz_ground VALUES("13024","1301","6","1","1353327743","1353329106","1353326963","1","0");
INSERT INTO kolhoz_ground VALUES("13025","1301","6","1","1353327744","1353329107","1353326964","1","0");
INSERT INTO kolhoz_ground VALUES("13026","1302","6","1","1353327943","1353329513","1353327163","1","0");
INSERT INTO kolhoz_ground VALUES("13027","1302","6","1","1353327965","1353329516","1353327185","1","0");
INSERT INTO kolhoz_ground VALUES("13028","1302","6","1","1353327970","1353329522","1353327190","1","0");
INSERT INTO kolhoz_ground VALUES("13029","1302","6","1","1353327974","1353329525","1353327194","1","0");
INSERT INTO kolhoz_ground VALUES("13030","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13031","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13032","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13033","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13034","1304","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13035","1304","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13036","1304","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13037","1304","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13038","1305","20","0","1353424371","1353330891","1353330891","1","0");
INSERT INTO kolhoz_ground VALUES("13039","1305","20","0","1353424379","1353330899","1353330899","1","0");
INSERT INTO kolhoz_ground VALUES("13040","1305","20","0","1353425237","1353331757","1353331757","1","0");
INSERT INTO kolhoz_ground VALUES("13041","1305","20","0","1353425246","1353331766","1353331766","1","0");
INSERT INTO kolhoz_ground VALUES("13042","1306","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13043","1306","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13044","1306","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13045","1306","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13046","1307","6","0","1353341059","1353338479","1353338479","1","0");
INSERT INTO kolhoz_ground VALUES("13047","1307","6","0","1353341059","1353338479","1353338479","1","0");
INSERT INTO kolhoz_ground VALUES("13048","1307","6","0","1353341059","1353338479","1353338479","1","0");
INSERT INTO kolhoz_ground VALUES("13049","1307","6","0","1353341059","1353338479","1353338479","1","0");
INSERT INTO kolhoz_ground VALUES("13050","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13051","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13052","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13053","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13054","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13055","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13056","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13057","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13058","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13059","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13060","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13061","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13062","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13063","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13064","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13065","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13066","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13067","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13068","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13069","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13070","1303","22","0","1353435952","1353330472","1353330472","1","0");
INSERT INTO kolhoz_ground VALUES("13071","1307","6","0","1353341059","1353338479","1353338479","1","0");
INSERT INTO kolhoz_ground VALUES("13072","1307","6","0","1353341059","1353338479","1353338479","1","0");
INSERT INTO kolhoz_ground VALUES("13073","1308","20","0","1353423841","1353330361","1353330361","1","0");
INSERT INTO kolhoz_ground VALUES("13074","1308","20","0","1353423844","1353330364","1353330364","1","0");
INSERT INTO kolhoz_ground VALUES("13075","1308","20","0","1353423856","1353330376","1353330376","1","0");
INSERT INTO kolhoz_ground VALUES("13076","1308","20","0","1353423856","1353330376","1353330376","1","0");
INSERT INTO kolhoz_ground VALUES("13077","1309","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13078","1309","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13079","1309","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13080","1309","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13081","1308","20","0","1353423864","1353330384","1353330384","1","0");
INSERT INTO kolhoz_ground VALUES("13082","1308","20","0","1353423865","1353330385","1353330385","1","0");
INSERT INTO kolhoz_ground VALUES("13083","1308","20","0","1353423865","1353330385","1353330385","1","0");
INSERT INTO kolhoz_ground VALUES("13084","1310","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13085","1310","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13086","1310","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13087","1310","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13088","1308","20","0","1353423866","1353330386","1353330386","1","0");
INSERT INTO kolhoz_ground VALUES("13089","1311","6","1","1353330992","1353332030","1353330212","1","0");
INSERT INTO kolhoz_ground VALUES("13090","1311","6","1","1353330998","1353332032","1353330218","1","0");
INSERT INTO kolhoz_ground VALUES("13091","1311","6","1","1353331004","1353332036","1353330224","1","0");
INSERT INTO kolhoz_ground VALUES("13092","1311","6","1","1353331016","1353332046","1353330236","1","0");
INSERT INTO kolhoz_ground VALUES("13093","1305","20","0","1353425253","1353331773","1353331773","1","0");
INSERT INTO kolhoz_ground VALUES("13094","1311","6","0","1353332868","1353330288","1353330288","1","0");
INSERT INTO kolhoz_ground VALUES("13095","1305","20","0","1353425266","1353331786","1353331786","1","0");
INSERT INTO kolhoz_ground VALUES("13096","1305","20","0","1353425830","1353332350","1353332350","1","0");
INSERT INTO kolhoz_ground VALUES("13097","1305","20","0","1353425831","1353332351","1353332351","1","0");
INSERT INTO kolhoz_ground VALUES("13098","1305","20","0","1353425833","1353332353","1353332353","1","0");
INSERT INTO kolhoz_ground VALUES("13099","1305","20","0","1353425834","1353332354","1353332354","1","0");
INSERT INTO kolhoz_ground VALUES("13100","1311","6","0","1353332889","1353330309","1353330309","1","0");
INSERT INTO kolhoz_ground VALUES("13101","1308","20","0","1353423867","1353330387","1353330387","1","0");
INSERT INTO kolhoz_ground VALUES("13102","1311","6","0","1353332914","1353330334","1353330334","1","0");
INSERT INTO kolhoz_ground VALUES("13103","1310","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13104","1","79","1","1355874738","1355755854","1355553858","1","0");
INSERT INTO kolhoz_ground VALUES("13105","1","79","1","1355874738","1355755854","1355553858","1","0");
INSERT INTO kolhoz_ground VALUES("13106","1","79","1","1355874738","1355755854","1355553858","1","0");
INSERT INTO kolhoz_ground VALUES("13107","1","79","1","1355874738","1355755854","1355553858","1","0");
INSERT INTO kolhoz_ground VALUES("13108","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13109","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13110","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13111","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13112","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13113","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13114","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13115","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13116","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13117","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13118","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13119","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13120","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13121","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13122","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13123","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13124","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13125","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13126","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13127","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13128","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13129","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13130","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13131","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13132","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13133","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13134","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13135","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13136","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13137","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13138","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13139","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13140","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13141","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13142","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13143","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13144","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13145","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13146","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13147","1299","24","0","1353448528","1353333448","1353333508","1","0");
INSERT INTO kolhoz_ground VALUES("13148","1313","6","0","1353335950","1353333370","1353333370","1","0");
INSERT INTO kolhoz_ground VALUES("13149","1313","0","0","1353332896","1353334103","1353332116","1","0");
INSERT INTO kolhoz_ground VALUES("13150","1313","0","0","1353332918","1353334154","1353332138","1","0");
INSERT INTO kolhoz_ground VALUES("13151","1313","0","0","1353332951","1353334189","1353332171","0","0");
INSERT INTO kolhoz_ground VALUES("13152","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13153","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13154","1312","11","1","1353333305","1353334423","1353333005","1","0");
INSERT INTO kolhoz_ground VALUES("13155","1310","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13156","1314","0","0","1353333112","1353333159","1353333159","0","0");
INSERT INTO kolhoz_ground VALUES("13157","1314","0","0","1353333112","1353333165","1353333165","0","0");
INSERT INTO kolhoz_ground VALUES("13158","1314","0","0","1353333112","1353333171","1353333171","0","0");
INSERT INTO kolhoz_ground VALUES("13159","1314","0","0","1353333112","1353333202","1353333202","0","0");
INSERT INTO kolhoz_ground VALUES("13160","1315","6","0","1353336046","1353333466","1353333466","1","0");
INSERT INTO kolhoz_ground VALUES("13161","1315","6","0","1353336046","1353333466","1353333466","1","0");
INSERT INTO kolhoz_ground VALUES("13162","1315","6","0","1353336046","1353333466","1353333466","1","0");
INSERT INTO kolhoz_ground VALUES("13163","1315","6","0","1353336046","1353333466","1353333466","1","0");
INSERT INTO kolhoz_ground VALUES("13164","1315","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13165","1315","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13166","1316","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13167","1316","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13168","1316","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13169","1316","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13170","1317","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13171","1317","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13172","1317","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13173","1317","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13174","1318","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13175","1318","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13176","1318","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13177","1318","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13178","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13179","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13180","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13181","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13182","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13183","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13184","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13185","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13186","1320","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13187","1320","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13188","1320","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13189","1320","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13206","1324","6","0","1354624940","1354622360","1354622360","1","0");
INSERT INTO kolhoz_ground VALUES("13191","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13192","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13193","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13194","1322","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13195","1322","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13196","1322","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13197","1322","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13198","1323","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13199","1323","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13200","1323","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13201","1323","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13202","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13203","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13204","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13205","1321","86","1","1355180958","1354520063","1354439538","1","0");
INSERT INTO kolhoz_ground VALUES("13207","1324","6","0","1354624930","1354622350","1354622350","1","0");
INSERT INTO kolhoz_ground VALUES("13208","1324","6","0","1354624931","1354622351","1354622351","1","0");
INSERT INTO kolhoz_ground VALUES("13209","1324","6","0","1354624933","1354622353","1354622353","1","0");
INSERT INTO kolhoz_ground VALUES("13210","1325","6","1","1354621485","1354622674","1354620705","1","0");
INSERT INTO kolhoz_ground VALUES("13211","1325","6","1","1354621487","1354622673","1354620707","1","0");
INSERT INTO kolhoz_ground VALUES("13212","1325","6","1","1354621489","1354622677","1354620709","1","0");
INSERT INTO kolhoz_ground VALUES("13213","1325","6","1","1354621768","1354622976","1354620988","1","0");
INSERT INTO kolhoz_ground VALUES("13214","1325","6","1","1354621785","1354622979","1354621005","1","0");
INSERT INTO kolhoz_ground VALUES("13215","1325","6","1","1354621792","1354622982","1354621012","1","0");
INSERT INTO kolhoz_ground VALUES("13216","1325","6","1","1354621799","1354622985","1354621019","1","0");
INSERT INTO kolhoz_ground VALUES("13217","1325","6","1","1354621806","1354622987","1354621026","1","0");
INSERT INTO kolhoz_ground VALUES("13218","1325","6","1","1354621815","1354622990","1354621035","1","0");
INSERT INTO kolhoz_ground VALUES("13219","1325","6","1","1354621825","1354622992","1354621045","1","0");
INSERT INTO kolhoz_ground VALUES("13220","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13221","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13222","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13223","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13224","1325","6","0","1354623912","1354621332","1354621332","1","0");
INSERT INTO kolhoz_ground VALUES("13225","1325","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("13226","1327","15","0","1354655716","1354637836","1354637836","1","0");
INSERT INTO kolhoz_ground VALUES("13227","1327","15","0","1354655716","1354637836","1354637836","1","0");
INSERT INTO kolhoz_ground VALUES("13228","1327","15","0","1354655716","1354637836","1354637836","1","0");
INSERT INTO kolhoz_ground VALUES("13229","1327","15","0","1354655716","1354637836","1354637836","1","0");
INSERT INTO kolhoz_ground VALUES("13230","1327","15","0","1354655716","1354637836","1354637836","1","0");
INSERT INTO kolhoz_ground VALUES("13231","1327","15","0","1354655716","1354637836","1354637836","1","0");
INSERT INTO kolhoz_ground VALUES("13232","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13233","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13234","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13235","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13236","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13237","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13238","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13239","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13240","1329","5","0","1354627465","1354624885","1354624885","1","0");
INSERT INTO kolhoz_ground VALUES("13241","1329","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13242","1329","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13243","1329","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13244","1330","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13245","1330","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13246","1330","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13247","1330","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13248","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13249","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13250","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13251","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13252","1332","7","0","1354966074","1354959714","1354959714","1","0");
INSERT INTO kolhoz_ground VALUES("13253","1332","7","0","1354966074","1354959714","1354959714","1","0");
INSERT INTO kolhoz_ground VALUES("13254","1332","7","0","1354966074","1354959714","1354959714","1","0");
INSERT INTO kolhoz_ground VALUES("13255","1332","7","0","1354966074","1354959714","1354959714","1","0");
INSERT INTO kolhoz_ground VALUES("13256","1332","7","0","1354966074","1354959714","1354959714","1","0");
INSERT INTO kolhoz_ground VALUES("13257","1332","7","0","1354966074","1354959714","1354959714","1","0");
INSERT INTO kolhoz_ground VALUES("13258","1333","8","0","1355002792","1354979392","1354979392","1","0");
INSERT INTO kolhoz_ground VALUES("13259","1333","8","0","1355002792","1354979392","1354979392","1","0");
INSERT INTO kolhoz_ground VALUES("13260","1333","8","0","1355002792","1354979392","1354979392","1","0");
INSERT INTO kolhoz_ground VALUES("13261","1333","8","0","1355002792","1354979392","1354979392","1","0");
INSERT INTO kolhoz_ground VALUES("13262","1334","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13263","1334","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13264","1334","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13265","1334","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13266","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13267","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13268","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13269","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13270","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13271","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13272","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13273","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13274","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13275","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13276","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13277","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13278","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13279","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13280","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13281","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13282","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13283","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13284","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13285","1326","22","1","1354732542","1354632240","1354630452","1","0");
INSERT INTO kolhoz_ground VALUES("13286","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13287","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13288","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13289","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13290","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13291","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13292","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13293","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13294","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13295","1339","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13296","1339","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13297","1339","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13298","1339","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13299","1340","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13300","1340","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13301","1340","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13302","1340","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13303","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13304","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13305","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13306","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13307","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13308","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13309","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13310","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13311","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13312","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13313","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13314","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13315","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13316","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13317","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13318","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13319","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13320","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13321","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13322","1342","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13323","1342","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13324","1342","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13325","1342","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13326","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13327","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13328","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13329","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13330","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13331","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13332","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13333","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13334","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13335","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13336","1336","77","0","1356178652","1355752496","1355753492","1","0");
INSERT INTO kolhoz_ground VALUES("13337","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13338","1343","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13339","1343","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13340","1343","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13341","1343","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13342","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13343","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13344","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13345","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13346","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13347","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13348","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13349","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13350","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13351","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13352","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13353","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13354","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13355","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13356","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13357","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("13358","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("14130","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14131","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14132","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13362","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13363","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13364","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13365","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13366","1345","0","0","1354698684","1354698804","1354698684","1","0");
INSERT INTO kolhoz_ground VALUES("13367","1345","0","0","1354698684","1354698804","1354698684","1","0");
INSERT INTO kolhoz_ground VALUES("13368","1345","0","0","1354698684","1354698804","1354698684","1","0");
INSERT INTO kolhoz_ground VALUES("13369","1345","0","0","1354698684","1354698804","1354698684","1","0");
INSERT INTO kolhoz_ground VALUES("13370","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13371","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13372","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13373","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13374","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13375","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13376","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13377","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13378","1348","31","0","1354783590","1354636110","1354636170","1","0");
INSERT INTO kolhoz_ground VALUES("13379","1348","31","0","1354783600","1354636120","1354636180","1","0");
INSERT INTO kolhoz_ground VALUES("13380","1348","31","0","1354783606","1354636126","1354636186","1","0");
INSERT INTO kolhoz_ground VALUES("13381","1348","33","0","1354798016","1354636136","1354636196","1","0");
INSERT INTO kolhoz_ground VALUES("13382","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13383","1349","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13384","1349","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13385","1349","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13386","1349","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13387","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13388","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13389","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13390","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13391","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("13392","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13393","1344","0","0","1355564730","1355555490","1355555490","0","0");
INSERT INTO kolhoz_ground VALUES("13394","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13395","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13396","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13397","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13398","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13399","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13400","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13401","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13402","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13403","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13404","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13405","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13406","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13407","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13408","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13409","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13410","1348","33","0","1354798034","1354636154","1354636214","1","0");
INSERT INTO kolhoz_ground VALUES("13411","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13412","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13413","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13414","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13415","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13416","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13417","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13418","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13419","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13420","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13421","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13422","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13423","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13424","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13425","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13426","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13427","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13428","1348","35","0","1354808848","1354636168","1354636228","1","0");
INSERT INTO kolhoz_ground VALUES("13429","1356","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13430","1356","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13431","1356","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13432","1356","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13433","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13434","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13435","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("13436","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13437","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13438","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13439","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13440","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13441","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13442","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13443","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13444","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13445","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13446","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13447","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13448","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13449","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13450","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13451","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13452","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13453","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13454","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13455","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13456","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13457","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("13458","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("13459","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("13460","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("13461","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13462","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13463","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13464","1354","56","0","1355410949","1355325098","1355324969","1","0");
INSERT INTO kolhoz_ground VALUES("13465","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("13466","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("13467","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("13468","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("13469","1363","55","1","1355563212","1355445145","1355425896","1","0");
INSERT INTO kolhoz_ground VALUES("13470","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("13471","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("13472","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("13473","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13474","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13475","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13476","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13477","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13478","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13479","1365","6","0","1354804880","1354802300","1354802300","1","0");
INSERT INTO kolhoz_ground VALUES("13480","1365","6","0","1354804880","1354802300","1354802300","1","0");
INSERT INTO kolhoz_ground VALUES("13481","1365","6","0","1354804880","1354802300","1354802300","1","0");
INSERT INTO kolhoz_ground VALUES("13482","1365","6","0","1354804880","1354802300","1354802300","1","0");
INSERT INTO kolhoz_ground VALUES("13483","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13484","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13485","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13486","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13487","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13488","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13489","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13490","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13491","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13492","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13493","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13494","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13495","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13496","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13497","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13498","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13499","1351","86","0","1356810243","1355586363","1355587743","1","0");
INSERT INTO kolhoz_ground VALUES("13500","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13501","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13502","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13503","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13504","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13505","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13506","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13507","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13508","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13509","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13510","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13511","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13512","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13513","1368","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13514","1368","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13515","1368","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13516","1368","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13517","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13518","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13519","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13520","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13521","1367","26","0","1354764713","1354638833","1354638893","1","0");
INSERT INTO kolhoz_ground VALUES("13522","1364","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13523","1364","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13524","1364","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13525","1364","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13526","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13527","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13528","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13529","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("13530","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13531","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13532","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13533","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13534","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13535","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13536","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13537","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13538","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13539","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13540","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13541","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13542","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13543","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13544","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13545","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13546","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13547","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13548","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13549","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13550","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13551","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13552","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13553","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13554","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13555","1037","10","0","1355794577","1355759777","1355759777","1","0");
INSERT INTO kolhoz_ground VALUES("13556","1370","8","0","1354663729","1354640329","1354640329","1","0");
INSERT INTO kolhoz_ground VALUES("13557","1370","8","0","1354663734","1354640334","1354640334","1","0");
INSERT INTO kolhoz_ground VALUES("13558","1370","8","0","1354663737","1354640337","1354640337","1","0");
INSERT INTO kolhoz_ground VALUES("13559","1370","10","0","1354675147","1354640347","1354640347","1","0");
INSERT INTO kolhoz_ground VALUES("13560","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13561","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13562","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13563","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13564","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13565","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13566","1372","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13567","1372","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13568","1372","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13569","1372","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13570","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13571","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13572","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("13573","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13574","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13575","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13576","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13577","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13578","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13579","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13580","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("13581","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("13582","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("13583","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("13584","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13585","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13586","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13587","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13588","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("13589","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("13590","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13591","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13592","1375","6","0","1354646562","1354643982","1354643982","1","0");
INSERT INTO kolhoz_ground VALUES("13593","1376","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13594","1376","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13595","1376","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13596","1376","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13597","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13598","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13599","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("13600","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13601","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13602","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13603","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13604","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13605","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13606","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13607","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13608","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13609","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13610","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13611","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13612","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13613","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13614","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13615","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13616","1337","67","0","1356301877","1355747597","1355747777","1","0");
INSERT INTO kolhoz_ground VALUES("13617","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13618","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13619","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13620","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13621","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13622","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13623","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13624","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13625","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13626","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13627","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13628","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13629","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13630","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13631","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13632","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13633","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13634","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13635","1346","65","0","1356269277","1355761797","1355761977","1","0");
INSERT INTO kolhoz_ground VALUES("13636","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13637","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13638","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13639","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13640","1328","62","0","1355910118","1355744638","1355744818","1","0");
INSERT INTO kolhoz_ground VALUES("13641","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13642","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13643","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13644","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13645","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13646","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13647","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13648","1377","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13649","1377","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13650","1377","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13651","1377","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13652","1378","5","1","1354707468","1354706688","1354706688","1","0");
INSERT INTO kolhoz_ground VALUES("13653","1378","5","1","1354707471","1354706691","1354706691","1","0");
INSERT INTO kolhoz_ground VALUES("13654","1378","5","1","1354707474","1354706694","1354706694","1","0");
INSERT INTO kolhoz_ground VALUES("13655","1378","5","1","1354707477","1354706697","1354706697","1","0");
INSERT INTO kolhoz_ground VALUES("13656","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13657","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13658","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13659","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13660","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13661","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("13662","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13663","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13664","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13665","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13666","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13667","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13668","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13669","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13670","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13671","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13672","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13673","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13674","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13675","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13676","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13677","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13678","1341","67","0","1355688132","1355133852","1355134032","1","0");
INSERT INTO kolhoz_ground VALUES("13679","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13680","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13681","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13682","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13683","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13684","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13685","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13686","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13687","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13688","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13689","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13690","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13691","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13692","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13693","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13694","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13695","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13696","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13697","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13698","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13699","1319","86","0","1356972619","1355748739","1355750119","1","0");
INSERT INTO kolhoz_ground VALUES("13700","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13701","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13702","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13703","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13704","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13705","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13706","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13707","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13708","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13709","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13710","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13711","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13712","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13713","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13714","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13715","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13716","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13717","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13718","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13719","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13720","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13721","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13722","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13723","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13724","1379","86","1","1355555983","1355486407","1355487787","1","0");
INSERT INTO kolhoz_ground VALUES("13725","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13726","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13727","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13728","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13729","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13730","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13731","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("13732","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("13733","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("13734","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("13735","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("13736","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("13737","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("13738","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("13739","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("13740","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("13741","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("13742","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("13743","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("13744","1382","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13745","1382","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13746","1382","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13747","1382","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13748","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13749","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13750","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13751","1335","6","0","1354676861","1354674281","1354674281","1","0");
INSERT INTO kolhoz_ground VALUES("13752","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13753","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13754","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13755","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13756","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13757","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13758","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13759","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13760","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13761","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13762","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13763","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13764","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13765","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13766","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13767","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13768","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13769","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13770","1366","63","0","1355512857","1355048577","1355048757","1","0");
INSERT INTO kolhoz_ground VALUES("13771","1383","10","1","1355162996","1355153072","1355129996","1","0");
INSERT INTO kolhoz_ground VALUES("13772","1383","12","1","1355174490","1355153073","1355130090","1","0");
INSERT INTO kolhoz_ground VALUES("13773","1383","12","1","1355174538","1355153102","1355130138","1","0");
INSERT INTO kolhoz_ground VALUES("13774","1383","12","1","1355174627","1355153103","1355130227","1","0");
INSERT INTO kolhoz_ground VALUES("13775","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13776","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13777","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13778","1357","59","0","1356146344","1355757664","1355757844","1","0");
INSERT INTO kolhoz_ground VALUES("13779","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("13780","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("13781","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("13782","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("13783","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("13784","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("13785","1385","22","1","1354823557","1354733917","1354733917","1","0");
INSERT INTO kolhoz_ground VALUES("13786","1385","22","1","1354823560","1354733920","1354733920","1","0");
INSERT INTO kolhoz_ground VALUES("13787","1385","24","1","1354833170","1354733930","1354733990","1","0");
INSERT INTO kolhoz_ground VALUES("13788","1385","24","1","1354833171","1354733931","1354733991","1","0");
INSERT INTO kolhoz_ground VALUES("13789","1386","6","1","1354695138","1354699758","1354699758","1","0");
INSERT INTO kolhoz_ground VALUES("13790","1386","6","1","1354695139","1354699759","1354699759","1","0");
INSERT INTO kolhoz_ground VALUES("13791","1386","6","1","1354695141","1354699761","1354699761","1","0");
INSERT INTO kolhoz_ground VALUES("13792","1386","6","0","1354702342","1354699762","1354699762","1","0");
INSERT INTO kolhoz_ground VALUES("13793","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13794","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13795","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13796","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13797","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13798","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13799","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13800","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13801","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13802","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13803","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13804","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13805","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("13806","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("13807","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("13808","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("13809","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("13810","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("13811","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("13812","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("13813","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("13814","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("13815","0","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13816","0","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13817","0","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13818","0","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13819","1391","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13820","1391","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13821","1391","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13822","1391","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13823","1392","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13824","1392","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13825","1392","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13826","1392","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13827","1393","0","0","1354600189","1354737829","1354737889","1","0");
INSERT INTO kolhoz_ground VALUES("13828","1393","0","0","1354600201","1354737841","1354737901","1","0");
INSERT INTO kolhoz_ground VALUES("13829","1393","0","0","1354789230","1354739725","1354737930","1","0");
INSERT INTO kolhoz_ground VALUES("13830","1393","0","0","1354789256","1354739734","1354737956","1","0");
INSERT INTO kolhoz_ground VALUES("13831","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("13832","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("13833","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("13834","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("13835","1393","5","0","1354816639","1354814059","1354814059","1","0");
INSERT INTO kolhoz_ground VALUES("13836","1395","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13837","1395","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13838","1395","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13839","1395","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13840","1396","12","0","1354754840","1354708640","1354708640","1","0");
INSERT INTO kolhoz_ground VALUES("13841","1396","12","0","1354754854","1354708654","1354708654","1","0");
INSERT INTO kolhoz_ground VALUES("13842","1396","8","1","1354727852","1354710344","1354706252","1","0");
INSERT INTO kolhoz_ground VALUES("13843","1396","8","1","1354727866","1354710352","1354706266","1","0");
INSERT INTO kolhoz_ground VALUES("13844","1397","8","0","1355162361","1355138961","1355138961","1","0");
INSERT INTO kolhoz_ground VALUES("13845","1397","8","0","1355162368","1355138968","1355138968","1","0");
INSERT INTO kolhoz_ground VALUES("13846","1397","8","0","1355162380","1355138980","1355138980","1","0");
INSERT INTO kolhoz_ground VALUES("13847","1397","8","0","1355162403","1355139003","1355139003","1","0");
INSERT INTO kolhoz_ground VALUES("13848","1398","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13849","1398","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13850","1398","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13851","1398","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13852","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13853","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13854","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13855","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13856","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13857","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13858","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13859","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13860","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13861","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13862","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13863","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13864","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13865","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13866","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13867","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13868","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13869","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13870","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13871","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("13872","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13873","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("13874","1396","10","1","1354739311","1354710360","1354706311","1","0");
INSERT INTO kolhoz_ground VALUES("13875","1396","10","1","1354739372","1354710367","1354706372","1","0");
INSERT INTO kolhoz_ground VALUES("13876","1396","12","1","1354750800","1354710374","1354706400","1","0");
INSERT INTO kolhoz_ground VALUES("13877","1399","6","0","1355000213","1354997633","1354997633","1","0");
INSERT INTO kolhoz_ground VALUES("13878","1399","6","0","1355000214","1354997634","1354997634","1","0");
INSERT INTO kolhoz_ground VALUES("13879","1399","6","0","1355000215","1354997635","1354997635","1","0");
INSERT INTO kolhoz_ground VALUES("13880","1399","6","0","1355000219","1354997639","1354997639","1","0");
INSERT INTO kolhoz_ground VALUES("13881","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("13882","1400","6","1","1354708094","1354709172","1354707314","1","0");
INSERT INTO kolhoz_ground VALUES("13883","1400","6","1","1354708098","1354707318","1354707318","1","0");
INSERT INTO kolhoz_ground VALUES("13884","1400","6","1","1354707203","1354707323","1354707323","1","0");
INSERT INTO kolhoz_ground VALUES("13885","1400","6","0","1354709909","1354707329","1354707329","1","0");
INSERT INTO kolhoz_ground VALUES("13886","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("13887","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13888","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13889","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13890","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13891","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13892","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13893","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13894","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13895","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13896","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13897","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13898","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13899","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("13900","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13901","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13902","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("13903","1403","22","0","1354820523","1354715043","1354715043","1","0");
INSERT INTO kolhoz_ground VALUES("13904","1403","22","0","1354820563","1354715083","1354715083","1","0");
INSERT INTO kolhoz_ground VALUES("13905","1403","22","0","1354820608","1354715128","1354715128","1","0");
INSERT INTO kolhoz_ground VALUES("13906","1403","22","0","1354820667","1354715187","1354715187","1","0");
INSERT INTO kolhoz_ground VALUES("13907","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("13908","1404","8","0","1354736752","1354713352","1354713352","1","0");
INSERT INTO kolhoz_ground VALUES("13909","1404","8","0","1354736762","1354713362","1354713362","1","0");
INSERT INTO kolhoz_ground VALUES("13910","1404","8","0","1354736770","1354713370","1354713370","1","0");
INSERT INTO kolhoz_ground VALUES("13911","1404","8","0","1354736575","1354713175","1354713175","1","0");
INSERT INTO kolhoz_ground VALUES("13912","1399","6","0","1355000221","1354997641","1354997641","1","0");
INSERT INTO kolhoz_ground VALUES("13913","1399","6","0","1355000224","1354997644","1354997644","1","0");
INSERT INTO kolhoz_ground VALUES("13914","1405","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13915","1405","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13916","1405","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13917","1405","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13918","1404","8","0","1354736590","1354713190","1354713190","1","0");
INSERT INTO kolhoz_ground VALUES("13919","1406","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13920","1406","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13921","1406","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13922","1406","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13923","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("13924","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("13925","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("13926","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13927","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13928","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13929","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13930","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13931","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13932","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13933","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13934","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13935","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13936","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13937","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13938","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13939","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13940","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13941","1352","62","0","1355275007","1355109527","1355109707","1","0");
INSERT INTO kolhoz_ground VALUES("13942","1407","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13943","1407","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13944","1407","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13945","1407","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("13946","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13947","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13948","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13949","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13950","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13951","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13952","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13953","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13954","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13955","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13956","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13957","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13958","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13959","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13960","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13961","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13962","1360","86","0","1356971834","1355759600","1355760254","1","0");
INSERT INTO kolhoz_ground VALUES("13963","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13964","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13965","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13966","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13967","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13968","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13969","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13970","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13971","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13972","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13973","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13974","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13975","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13976","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13977","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13978","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13979","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13980","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13981","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13982","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13983","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13984","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13985","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13986","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13987","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13988","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13989","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13990","1401","67","0","1356312292","1355758012","1355758192","1","0");
INSERT INTO kolhoz_ground VALUES("13991","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13992","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13993","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13994","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13995","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13996","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13997","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("13998","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("13999","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("14000","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("14001","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("14002","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("14003","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("14004","1359","86","0","1356982078","1355758198","1355759578","1","0");
INSERT INTO kolhoz_ground VALUES("14005","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14006","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14007","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14008","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14009","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14010","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14011","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14012","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14013","1388","86","0","1356980803","1355756923","1355758303","1","0");
INSERT INTO kolhoz_ground VALUES("14014","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14015","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14016","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14017","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14018","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14019","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14020","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14021","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14022","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14023","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14024","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14025","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14026","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14027","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14028","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14029","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14030","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14031","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14032","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14033","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14034","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14035","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14036","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14037","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14038","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14039","1373","86","0","1356922350","1355698470","1355699850","1","0");
INSERT INTO kolhoz_ground VALUES("14040","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14041","1408","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14042","1408","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14043","1408","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14044","1408","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14045","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14046","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14047","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14048","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14049","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14050","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14051","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14052","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14053","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14054","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14055","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14056","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14057","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14058","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14059","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14060","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14061","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14062","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14063","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14064","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14065","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14066","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14067","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14068","1331","59","0","1355194083","1354805403","1354805583","1","0");
INSERT INTO kolhoz_ground VALUES("14069","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("14070","1387","49","0","1355780403","1355506923","1355507043","1","0");
INSERT INTO kolhoz_ground VALUES("14071","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14072","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14073","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14074","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14075","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14076","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14077","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14078","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14079","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14080","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14081","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14082","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14083","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14084","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14085","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14086","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14087","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14088","1355","65","0","1356033799","1355526319","1355526499","1","0");
INSERT INTO kolhoz_ground VALUES("14089","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14090","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14091","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14092","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14093","1410","22","0","1354831488","1354726008","1354726008","1","0");
INSERT INTO kolhoz_ground VALUES("14094","1410","22","0","1354831505","1354726025","1354726025","1","0");
INSERT INTO kolhoz_ground VALUES("14095","1410","22","0","1354831518","1354726038","1354726038","1","0");
INSERT INTO kolhoz_ground VALUES("14096","1410","22","0","1354831519","1354726039","1354726039","1","0");
INSERT INTO kolhoz_ground VALUES("14097","1410","22","0","1354831530","1354726050","1354726050","1","0");
INSERT INTO kolhoz_ground VALUES("14098","1410","22","0","1354831531","1354726051","1354726051","1","0");
INSERT INTO kolhoz_ground VALUES("14099","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14100","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14101","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14102","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14103","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14104","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14105","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14106","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14107","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14108","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14109","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14110","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14111","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14112","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14113","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14114","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14115","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14116","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14117","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14118","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14119","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14120","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14121","1390","59","0","1355889177","1355500497","1355500677","1","0");
INSERT INTO kolhoz_ground VALUES("14122","1393","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14123","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14124","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14125","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14126","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14127","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14128","1385","24","1","1354833173","1354733933","1354733993","1","0");
INSERT INTO kolhoz_ground VALUES("14129","1385","24","1","1354833174","1354733934","1354733994","1","0");
INSERT INTO kolhoz_ground VALUES("14133","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14134","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("14135","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("14136","1338","47","0","1356009588","1355757708","1355757828","1","0");
INSERT INTO kolhoz_ground VALUES("14137","1413","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14138","1413","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14139","1413","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14140","1413","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14141","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14142","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14143","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14144","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14145","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14146","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14147","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14148","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14149","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("14150","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14151","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14152","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14153","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14154","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14155","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14156","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14157","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14158","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14159","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14160","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14161","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14162","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14163","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14164","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14165","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14166","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14167","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14168","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14169","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14423","1435","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14171","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14172","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14173","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14174","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14175","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14176","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14177","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14178","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14179","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14180","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14181","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14182","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14183","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14184","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14185","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14186","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14187","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14188","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14189","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14190","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14191","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14192","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14193","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14194","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14195","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("14196","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14197","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14198","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14199","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14200","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14201","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14202","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14203","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14204","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14205","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14206","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14207","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14208","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14209","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14210","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14211","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14212","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14213","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14214","1380","8","0","1354900694","1354877294","1354877294","1","0");
INSERT INTO kolhoz_ground VALUES("14215","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("14216","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14217","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14218","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14219","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14220","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14221","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14222","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14223","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14224","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14225","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14226","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14227","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14228","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14229","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14230","1350","51","0","1355770073","1355471393","1355471513","1","0");
INSERT INTO kolhoz_ground VALUES("14231","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14232","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14233","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14234","1409","65","0","1355380930","1354879099","1354879090","1","0");
INSERT INTO kolhoz_ground VALUES("14235","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14236","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14237","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14238","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14239","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14240","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14241","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14242","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14243","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14244","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14245","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14246","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14247","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14248","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14249","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14250","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14251","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14252","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14253","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14254","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14255","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14256","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14257","1402","47","0","1355806303","1355554423","1355554543","1","0");
INSERT INTO kolhoz_ground VALUES("14258","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14259","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14260","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14261","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14262","1418","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14263","1418","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14264","1418","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14265","1418","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14266","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14267","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14268","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("14269","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("14270","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("14271","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("14272","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14273","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14274","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14275","1365","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("14276","1419","0","0","1354802153","1354807553","1354807553","1","0");
INSERT INTO kolhoz_ground VALUES("14277","1419","0","0","1354802153","1354807553","1354807553","1","0");
INSERT INTO kolhoz_ground VALUES("14278","1419","0","0","1354802154","1354807554","1354807554","1","0");
INSERT INTO kolhoz_ground VALUES("14279","1419","0","0","1354802154","1354807554","1354807554","1","0");
INSERT INTO kolhoz_ground VALUES("14280","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14281","1420","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14282","1420","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14283","1420","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14284","1420","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14285","1422","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14286","1422","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14287","1422","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14288","1422","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14289","1421","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14290","1421","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14291","1421","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14292","1421","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14293","1423","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14294","1423","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14295","1423","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14296","1423","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14297","1424","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14298","1424","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14299","1424","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14300","1424","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14301","1425","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14302","1425","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14303","1425","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14304","1425","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14305","1419","0","0","1354802155","1354807555","1354807555","1","0");
INSERT INTO kolhoz_ground VALUES("14306","1419","0","0","1354802155","1354807555","1354807555","1","0");
INSERT INTO kolhoz_ground VALUES("14307","1419","0","0","1354802156","1354807556","1354807556","1","0");
INSERT INTO kolhoz_ground VALUES("14308","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("14309","1384","48","0","1355785014","1355718174","1355718294","1","0");
INSERT INTO kolhoz_ground VALUES("14310","1393","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14311","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14312","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14313","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14314","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14315","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14316","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14317","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14318","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14319","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14320","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14321","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14322","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14323","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14324","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14325","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14326","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14327","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14328","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14329","1374","47","0","1355999168","1355747288","1355747408","1","0");
INSERT INTO kolhoz_ground VALUES("14330","1426","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14331","1426","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14332","1426","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14333","1426","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14334","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("14335","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("14336","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("14337","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("14338","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14339","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14340","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14341","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14342","1429","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14343","1429","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14344","1429","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14345","1429","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14346","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14347","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14348","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14349","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14350","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14351","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14352","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14353","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14354","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14355","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14356","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14357","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14358","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14359","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14360","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14361","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14362","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14363","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14364","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14365","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14366","1428","73","0","1355902574","1355564294","1355565434","1","0");
INSERT INTO kolhoz_ground VALUES("14367","1430","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14368","1430","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14369","1430","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14370","1430","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14371","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14372","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14373","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14374","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14375","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14376","1431","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14377","1431","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14378","1431","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14379","1431","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14380","1432","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14381","1432","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14382","1432","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14383","1432","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14384","1433","20","0","1354927674","1354834194","1354834194","1","0");
INSERT INTO kolhoz_ground VALUES("14385","1433","22","0","1354939704","1354834224","1354834224","1","0");
INSERT INTO kolhoz_ground VALUES("14386","1433","22","0","1354939726","1354834246","1354834246","1","0");
INSERT INTO kolhoz_ground VALUES("14387","1433","22","0","1354939736","1354834256","1354834256","1","0");
INSERT INTO kolhoz_ground VALUES("14388","1434","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14389","1434","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14390","1434","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14391","1434","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14392","1433","22","0","1354939748","1354834268","1354834268","1","0");
INSERT INTO kolhoz_ground VALUES("14393","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14394","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14395","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14396","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14397","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14398","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14399","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14400","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14401","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14402","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14403","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14404","1347","63","0","1355907556","1355443276","1355443456","1","0");
INSERT INTO kolhoz_ground VALUES("14405","1433","0","0","1354834003","1354833980","1354833980","1","0");
INSERT INTO kolhoz_ground VALUES("14406","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14407","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14408","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14409","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14410","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14411","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14412","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14413","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14414","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14415","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14416","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14417","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14418","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14419","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14420","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14421","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14422","1381","63","0","1355950869","1355486589","1355486769","1","0");
INSERT INTO kolhoz_ground VALUES("14424","1435","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14425","1435","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14426","1435","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14427","1436","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14428","1436","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14429","1436","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14430","1436","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14431","1437","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14432","1437","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14433","1437","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14434","1437","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14435","1438","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14436","1438","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14437","1438","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14438","1438","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14439","1414","56","0","1355837337","1355747457","1355747637","1","0");
INSERT INTO kolhoz_ground VALUES("14440","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14441","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14442","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14443","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14444","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14445","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14446","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14447","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14448","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14449","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14450","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14451","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14452","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14453","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14454","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14455","1371","51","0","1355721575","1355422895","1355423015","1","0");
INSERT INTO kolhoz_ground VALUES("14456","1439","16","0","1355119552","1355050552","1355050552","1","0");
INSERT INTO kolhoz_ground VALUES("14457","1439","18","0","1355130987","1355050587","1355050587","1","0");
INSERT INTO kolhoz_ground VALUES("14458","1439","18","0","1355130998","1355050598","1355050598","1","0");
INSERT INTO kolhoz_ground VALUES("14459","1439","18","0","1355131003","1355050603","1355050603","1","0");
INSERT INTO kolhoz_ground VALUES("14460","1439","18","0","1355131009","1355050609","1355050609","1","0");
INSERT INTO kolhoz_ground VALUES("14461","1439","18","0","1355131017","1355050617","1355050617","1","0");
INSERT INTO kolhoz_ground VALUES("14462","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14463","1440","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14464","1440","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14465","1440","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14466","1440","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14467","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14468","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14469","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14470","1441","5","0","1354889621","1354887041","1354887041","1","0");
INSERT INTO kolhoz_ground VALUES("14471","1441","5","0","1354889621","1354887041","1354887041","1","0");
INSERT INTO kolhoz_ground VALUES("14472","1441","5","0","1354889621","1354887041","1354887041","1","0");
INSERT INTO kolhoz_ground VALUES("14473","1441","5","0","1354889621","1354887041","1354887041","1","0");
INSERT INTO kolhoz_ground VALUES("14474","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14475","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14476","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14477","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14478","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14479","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14480","1441","5","0","1354889621","1354887041","1354887041","1","0");
INSERT INTO kolhoz_ground VALUES("14481","1441","5","0","1354889621","1354887041","1354887041","1","0");
INSERT INTO kolhoz_ground VALUES("14482","1443","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14483","1443","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14484","1443","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14485","1443","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14486","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14487","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14488","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14489","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14490","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14491","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14492","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14493","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14494","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14495","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14496","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14497","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14498","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14499","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14500","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14501","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14502","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14503","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14504","1442","56","0","1355847995","1355758115","1355758295","1","0");
INSERT INTO kolhoz_ground VALUES("14505","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14506","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14507","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14508","1415","63","0","1355703344","1355239064","1355239244","1","0");
INSERT INTO kolhoz_ground VALUES("14509","1444","6","0","1355576268","1355573688","1355573688","1","0");
INSERT INTO kolhoz_ground VALUES("14510","1444","6","0","1355576275","1355573695","1355573695","1","0");
INSERT INTO kolhoz_ground VALUES("14511","1444","6","0","1355576279","1355573699","1355573699","1","0");
INSERT INTO kolhoz_ground VALUES("14512","1444","6","0","1355576286","1355573706","1355573706","1","0");
INSERT INTO kolhoz_ground VALUES("14513","1445","6","1","1355571922","1355571142","1355571142","1","0");
INSERT INTO kolhoz_ground VALUES("14514","1445","6","0","1355573932","1355571352","1355571352","1","0");
INSERT INTO kolhoz_ground VALUES("14515","1445","6","0","1355573941","1355571361","1355571361","1","0");
INSERT INTO kolhoz_ground VALUES("14516","1445","6","0","1355573951","1355571371","1355571371","1","0");
INSERT INTO kolhoz_ground VALUES("14517","1445","6","0","1355573953","1355571373","1355571373","1","0");
INSERT INTO kolhoz_ground VALUES("14518","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14519","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14520","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14521","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14522","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14523","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14524","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("14525","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("14526","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("14527","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("14528","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("14529","1444","6","0","1355576296","1355573716","1355573716","1","0");
INSERT INTO kolhoz_ground VALUES("14530","1445","8","0","1355594788","1355571388","1355571388","1","0");
INSERT INTO kolhoz_ground VALUES("14531","1445","8","0","1355594807","1355571407","1355571407","1","0");
INSERT INTO kolhoz_ground VALUES("14532","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14533","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14534","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14535","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14536","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14537","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14538","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14539","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14540","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14541","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14542","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14543","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14544","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14545","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14546","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14547","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14548","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14549","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14550","1446","59","0","1356141635","1355752955","1355753135","1","0");
INSERT INTO kolhoz_ground VALUES("14551","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14552","1447","38","1","1355328695","1355326540","1355324615","1","0");
INSERT INTO kolhoz_ground VALUES("14553","1447","38","1","1355328695","1355326540","1355324615","1","0");
INSERT INTO kolhoz_ground VALUES("14554","1447","38","1","1355328695","1355326540","1355324615","1","0");
INSERT INTO kolhoz_ground VALUES("14555","1447","38","1","1355328695","1355326540","1355324615","1","0");
INSERT INTO kolhoz_ground VALUES("14556","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("14557","1447","38","1","1355328695","1355326540","1355324615","1","0");
INSERT INTO kolhoz_ground VALUES("14558","1448","67","1","1355828694","1355751403","1355543862","1","0");
INSERT INTO kolhoz_ground VALUES("14559","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14560","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14561","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14562","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14563","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14564","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14565","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("14566","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("14567","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("14568","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("14569","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14570","1450","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14571","1450","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14572","1450","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14573","1450","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14574","1451","5","0","1354909233","1354906653","1354906653","1","0");
INSERT INTO kolhoz_ground VALUES("14575","1451","5","0","1354909322","1354906742","1354906742","1","0");
INSERT INTO kolhoz_ground VALUES("14576","1451","5","0","1354909329","1354906749","1354906749","1","0");
INSERT INTO kolhoz_ground VALUES("14577","1451","5","0","1354909336","1354906756","1354906756","1","0");
INSERT INTO kolhoz_ground VALUES("14578","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14579","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14580","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("14581","1452","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14582","1452","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14583","1452","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14584","1452","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14585","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14586","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14587","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14588","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14589","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14590","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14591","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14592","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14593","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14594","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14595","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14596","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14597","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14598","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14599","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14600","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14601","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14602","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14603","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14604","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14605","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14606","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14607","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14608","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14609","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14610","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14611","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14612","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14613","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14614","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14615","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14616","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14617","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14618","1453","63","0","1356187929","1355723649","1355723829","1","0");
INSERT INTO kolhoz_ground VALUES("14619","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14620","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14621","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14622","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14623","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14624","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14625","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14626","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14627","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14628","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14629","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14630","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("14631","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14632","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14633","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14634","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14635","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14636","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14637","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14638","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14639","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14640","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14641","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14642","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14643","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14644","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14645","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14646","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14647","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14648","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14649","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14650","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14651","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14652","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14653","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("14654","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14655","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14656","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14657","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14658","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("14659","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("14660","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("14661","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("14662","1459","6","0","1354962765","1354960185","1354960185","1","0");
INSERT INTO kolhoz_ground VALUES("14663","1459","6","0","1354962766","1354960186","1354960186","1","0");
INSERT INTO kolhoz_ground VALUES("14664","1459","6","0","1354962767","1354960187","1354960187","1","0");
INSERT INTO kolhoz_ground VALUES("14665","1459","6","0","1354962768","1354960188","1354960188","1","0");
INSERT INTO kolhoz_ground VALUES("14666","1460","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14667","1460","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14668","1460","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14669","1460","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14670","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14671","1461","6","1","1354963031","1354966822","1354964951","1","0");
INSERT INTO kolhoz_ground VALUES("14672","1461","6","1","1354965743","1354964963","1354964963","1","0");
INSERT INTO kolhoz_ground VALUES("14673","1461","6","1","1354965756","1354964976","1354964976","1","0");
INSERT INTO kolhoz_ground VALUES("14674","1461","6","1","1354965760","1354964980","1354964980","1","0");
INSERT INTO kolhoz_ground VALUES("14675","1461","6","0","1354967645","1354965065","1354965065","1","0");
INSERT INTO kolhoz_ground VALUES("14676","1461","10","0","1354999882","1354965082","1354965082","1","0");
INSERT INTO kolhoz_ground VALUES("14677","1462","8","1","1354988568","1354968955","1354966968","1","0");
INSERT INTO kolhoz_ground VALUES("14678","1462","8","1","1354988595","1354968972","1354966995","1","0");
INSERT INTO kolhoz_ground VALUES("14679","1462","8","1","1354988611","1354968989","1354967011","1","0");
INSERT INTO kolhoz_ground VALUES("14680","1462","8","1","1354988604","1354968995","1354967004","1","0");
INSERT INTO kolhoz_ground VALUES("14681","1462","8","1","1354988580","1354969006","1354966980","1","0");
INSERT INTO kolhoz_ground VALUES("14682","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14683","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14684","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14685","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14686","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14687","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14688","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14689","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14690","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14691","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14692","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14693","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14694","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14695","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14696","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14697","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14698","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14699","1457","69","0","1356344675","1355732270","1355733035","1","0");
INSERT INTO kolhoz_ground VALUES("14700","1463","6","0","1355027095","1355024515","1355024515","1","0");
INSERT INTO kolhoz_ground VALUES("14701","1463","6","0","1355027095","1355024515","1355024515","1","0");
INSERT INTO kolhoz_ground VALUES("14702","1463","6","0","1355027096","1355024516","1355024516","1","0");
INSERT INTO kolhoz_ground VALUES("14703","1463","6","0","1355027097","1355024517","1355024517","1","0");
INSERT INTO kolhoz_ground VALUES("14704","1464","16","1","1355040463","1354978704","1354973263","1","0");
INSERT INTO kolhoz_ground VALUES("14705","1464","14","1","1355029051","1354978706","1354973251","1","0");
INSERT INTO kolhoz_ground VALUES("14706","1464","14","1","1355029048","1354978708","1354973248","1","0");
INSERT INTO kolhoz_ground VALUES("14707","1464","14","1","1355029045","1354978708","1354973245","1","0");
INSERT INTO kolhoz_ground VALUES("14708","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14709","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14710","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14711","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14712","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14713","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14714","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14715","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14716","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14717","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14718","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14719","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14720","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14721","1448","67","1","1355828698","1355751403","1355543866","1","0");
INSERT INTO kolhoz_ground VALUES("14722","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14723","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14724","1465","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14725","1465","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14726","1465","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14727","1465","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14728","1466","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14729","1466","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14730","1466","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14731","1466","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14732","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14733","1467","8","1","1355211836","1355290820","1355290820","1","0");
INSERT INTO kolhoz_ground VALUES("14734","1467","8","1","1355211836","1355290820","1355290820","1","0");
INSERT INTO kolhoz_ground VALUES("14735","1467","8","1","1355211835","1355290819","1355290819","1","0");
INSERT INTO kolhoz_ground VALUES("14736","1467","8","1","1355211835","1355290819","1355290819","1","0");
INSERT INTO kolhoz_ground VALUES("14737","1467","8","1","1355211834","1355290818","1355290818","1","0");
INSERT INTO kolhoz_ground VALUES("14738","1468","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14739","1468","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14740","1468","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14741","1468","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14742","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14743","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14744","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14745","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14746","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14747","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14748","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14749","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14750","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14751","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14752","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14753","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14754","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14755","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14756","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14757","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14758","1417","47","0","1356003670","1355757492","1355757370","1","0");
INSERT INTO kolhoz_ground VALUES("14759","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14760","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14761","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14762","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14763","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14764","1469","10","0","1355087647","1355052847","1355052847","1","0");
INSERT INTO kolhoz_ground VALUES("14765","1469","10","0","1355087666","1355052866","1355052866","1","0");
INSERT INTO kolhoz_ground VALUES("14766","1469","10","0","1355087683","1355052883","1355052883","1","0");
INSERT INTO kolhoz_ground VALUES("14767","1469","10","0","1355087690","1355052890","1355052890","1","0");
INSERT INTO kolhoz_ground VALUES("14768","1470","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14769","1470","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14770","1470","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14771","1470","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14772","1471","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14773","1471","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14774","1471","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14775","1471","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14776","1472","6","0","1355009294","1355006714","1355006714","1","0");
INSERT INTO kolhoz_ground VALUES("14777","1472","6","0","1355009301","1355006721","1355006721","1","0");
INSERT INTO kolhoz_ground VALUES("14778","1472","6","0","1355009306","1355006726","1355006726","1","0");
INSERT INTO kolhoz_ground VALUES("14779","1472","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14780","1473","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14781","1473","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14782","1473","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14783","1473","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14784","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14785","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14786","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14787","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14788","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14789","1475","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14790","1475","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14791","1475","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14792","1475","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14793","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14794","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14795","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14796","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14797","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14798","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14799","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("14800","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("14801","1476","6","1","1355028448","1355029629","1355027668","1","0");
INSERT INTO kolhoz_ground VALUES("14802","1476","6","1","1355028464","1355029648","1355027684","1","0");
INSERT INTO kolhoz_ground VALUES("14803","1476","6","1","1355028474","1355027694","1355027694","1","0");
INSERT INTO kolhoz_ground VALUES("14804","1476","6","1","1355028495","1355027715","1355027715","1","0");
INSERT INTO kolhoz_ground VALUES("14805","1476","6","0","1355030329","1355027749","1355027749","1","0");
INSERT INTO kolhoz_ground VALUES("14806","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14807","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14808","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14809","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14810","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14811","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14812","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14813","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14814","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14815","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14816","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14817","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14818","1411","47","1","1355460262","1355731102","1355731222","1","0");
INSERT INTO kolhoz_ground VALUES("14819","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("14820","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("14821","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14822","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14823","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14824","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14825","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14826","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14827","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14828","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14829","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14830","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14831","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14832","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14833","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14834","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14835","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14836","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14837","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14838","1416","47","0","1356009392","1355760467","1355760392","1","0");
INSERT INTO kolhoz_ground VALUES("14839","1478","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14840","1478","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14841","1478","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14842","1478","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14843","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14844","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14845","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("14846","1479","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14847","1479","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14848","1479","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14849","1479","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14850","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("14851","1480","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14852","1480","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14853","1480","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14854","1480","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14855","1481","18","1","1355111763","1355061982","1355039463","1","0");
INSERT INTO kolhoz_ground VALUES("14856","1481","18","1","1355111765","1355050690","1355039465","1","0");
INSERT INTO kolhoz_ground VALUES("14857","1481","18","1","1355111766","1355050691","1355039466","1","0");
INSERT INTO kolhoz_ground VALUES("14858","1481","18","1","1355111768","1355050693","1355039468","1","0");
INSERT INTO kolhoz_ground VALUES("14859","1482","51","1","1355856421","1355760825","1355746885","1","0");
INSERT INTO kolhoz_ground VALUES("14860","1482","51","1","1355856421","1355760825","1355746885","1","0");
INSERT INTO kolhoz_ground VALUES("14861","1482","51","1","1355856421","1355760825","1355746885","1","0");
INSERT INTO kolhoz_ground VALUES("14862","1482","51","1","1355856421","1355760825","1355746885","1","0");
INSERT INTO kolhoz_ground VALUES("14863","1481","18","1","1355107917","1355050795","1355039667","1","0");
INSERT INTO kolhoz_ground VALUES("14864","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("14865","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("14866","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("14867","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("14868","1484","18","1","1355116115","1355042915","1355042915","1","0");
INSERT INTO kolhoz_ground VALUES("14869","1484","18","1","1355116120","1355042920","1355042920","1","0");
INSERT INTO kolhoz_ground VALUES("14870","1484","18","1","1355116118","1355042918","1355042918","1","0");
INSERT INTO kolhoz_ground VALUES("14871","1484","18","1","1355116110","1355042910","1355042910","1","0");
INSERT INTO kolhoz_ground VALUES("14872","1484","20","1","1355129245","1355042965","1355042965","1","0");
INSERT INTO kolhoz_ground VALUES("14873","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("14874","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("14875","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("14876","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("14877","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("14878","1486","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14879","1486","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14880","1486","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14881","1486","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14882","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("14883","1487","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14884","1487","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14885","1487","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14886","1487","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14887","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("14888","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("14889","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("14890","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("14891","1489","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14892","1489","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14893","1489","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14894","1489","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14895","1490","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14896","1490","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14897","1490","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14898","1490","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14899","1491","0","0","1355070165","1355069385","1355069385","0","0");
INSERT INTO kolhoz_ground VALUES("14900","1491","0","0","1355070174","1355069394","1355069394","0","0");
INSERT INTO kolhoz_ground VALUES("14901","1491","6","1","1355070179","1355069399","1355069399","1","0");
INSERT INTO kolhoz_ground VALUES("14902","1491","6","1","1355070184","1355069404","1355069404","1","0");
INSERT INTO kolhoz_ground VALUES("14903","1492","16","0","1355122175","1355053175","1355053175","1","0");
INSERT INTO kolhoz_ground VALUES("14904","1492","18","0","1355133614","1355053214","1355053214","1","0");
INSERT INTO kolhoz_ground VALUES("14905","1492","18","0","1355133621","1355053221","1355053221","1","0");
INSERT INTO kolhoz_ground VALUES("14906","1492","20","0","1355146709","1355053229","1355053229","1","0");
INSERT INTO kolhoz_ground VALUES("14907","1492","20","0","1355146714","1355053234","1355053234","1","0");
INSERT INTO kolhoz_ground VALUES("14908","1492","20","0","1355146717","1355053237","1355053237","1","0");
INSERT INTO kolhoz_ground VALUES("14909","1492","20","0","1355146718","1355053238","1355053238","1","0");
INSERT INTO kolhoz_ground VALUES("14910","1493","5","1","1355054014","1355055189","1355053294","1","0");
INSERT INTO kolhoz_ground VALUES("14911","1493","5","1","1355054015","1355055189","1355053295","1","0");
INSERT INTO kolhoz_ground VALUES("14912","1493","5","1","1355054018","1355055189","1355053298","1","0");
INSERT INTO kolhoz_ground VALUES("14913","1493","5","1","1355054011","1355055173","1355053291","1","0");
INSERT INTO kolhoz_ground VALUES("14914","1494","22","0","1355272989","1355167509","1355167509","1","0");
INSERT INTO kolhoz_ground VALUES("14915","1494","6","0","1355170115","1355167535","1355167535","1","0");
INSERT INTO kolhoz_ground VALUES("14916","1494","6","0","1355170128","1355167548","1355167548","1","0");
INSERT INTO kolhoz_ground VALUES("14917","1494","6","0","1355170140","1355167560","1355167560","1","0");
INSERT INTO kolhoz_ground VALUES("14918","1495","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14919","1495","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14920","1495","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14921","1495","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14922","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("14923","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("14924","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("14925","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("14926","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14927","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14928","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14929","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14930","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("14931","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("14932","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("14933","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("14934","1499","6","1","1355753533","1355754684","1355752753","1","0");
INSERT INTO kolhoz_ground VALUES("14935","1499","6","1","1355753536","1355754689","1355752756","1","0");
INSERT INTO kolhoz_ground VALUES("14936","1499","6","1","1355753538","1355754691","1355752758","1","0");
INSERT INTO kolhoz_ground VALUES("14937","1499","6","1","1355753541","1355754692","1355752761","1","0");
INSERT INTO kolhoz_ground VALUES("14938","1500","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14939","1500","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14940","1500","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14941","1500","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14942","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("14943","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("14944","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("14945","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("14946","1499","6","1","1355753543","1355754704","1355752763","1","0");
INSERT INTO kolhoz_ground VALUES("14947","1502","6","0","1355057062","1355054482","1355054482","1","0");
INSERT INTO kolhoz_ground VALUES("14948","1502","6","0","1355057091","1355054511","1355054511","1","0");
INSERT INTO kolhoz_ground VALUES("14949","1502","8","0","1355077951","1355054551","1355054551","1","0");
INSERT INTO kolhoz_ground VALUES("14950","1502","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14951","1503","56","0","1355820935","1355731055","1355731235","1","0");
INSERT INTO kolhoz_ground VALUES("14952","1503","56","0","1355820935","1355731055","1355731235","1","0");
INSERT INTO kolhoz_ground VALUES("14953","1503","56","0","1355820935","1355731055","1355731235","1","0");
INSERT INTO kolhoz_ground VALUES("14954","1503","56","0","1355820935","1355731055","1355731235","1","0");
INSERT INTO kolhoz_ground VALUES("14955","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14956","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14957","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("14958","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14959","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14960","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14961","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14962","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14963","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14964","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("14965","1503","56","0","1355820935","1355731055","1355731235","1","0");
INSERT INTO kolhoz_ground VALUES("14966","1505","20","0","1355147953","1355054473","1355054473","1","0");
INSERT INTO kolhoz_ground VALUES("14967","1505","22","0","1355159984","1355054504","1355054504","1","0");
INSERT INTO kolhoz_ground VALUES("14968","1505","22","0","1355159996","1355054516","1355054516","1","0");
INSERT INTO kolhoz_ground VALUES("14969","1505","22","0","1355159997","1355054517","1355054517","1","0");
INSERT INTO kolhoz_ground VALUES("14970","1505","0","0","1355054262","1355054246","1355054246","1","0");
INSERT INTO kolhoz_ground VALUES("14971","1505","22","0","1355160026","1355054546","1355054546","1","0");
INSERT INTO kolhoz_ground VALUES("14972","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("14973","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("14974","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("14975","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("14976","1505","22","0","1355160028","1355054548","1355054548","1","0");
INSERT INTO kolhoz_ground VALUES("14977","1507","76","1","1356024701","1355741101","1355060825","1","0");
INSERT INTO kolhoz_ground VALUES("14978","1507","76","1","1356024710","1355741101","1355060834","1","0");
INSERT INTO kolhoz_ground VALUES("14979","1507","76","1","1356024710","1355741101","1355060834","1","0");
INSERT INTO kolhoz_ground VALUES("14980","1507","76","1","1356024710","1355741101","1355060834","1","0");
INSERT INTO kolhoz_ground VALUES("14981","1508","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14982","1508","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14983","1508","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14984","1508","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("14985","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("14986","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("14987","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("14988","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("14989","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("14990","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("14991","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("14992","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("14993","1511","6","1","1355054464","1355055484","1355055484","1","0");
INSERT INTO kolhoz_ground VALUES("14994","1511","6","1","1355054466","1355055486","1355055486","1","0");
INSERT INTO kolhoz_ground VALUES("14995","1511","6","1","1355054468","1355055488","1355055488","1","0");
INSERT INTO kolhoz_ground VALUES("14996","1511","6","1","1355054471","1355055491","1355055491","1","0");
INSERT INTO kolhoz_ground VALUES("14997","1511","6","0","1355058076","1355055496","1355055496","1","0");
INSERT INTO kolhoz_ground VALUES("14998","1511","6","1","1355054488","1355055508","1355055508","1","0");
INSERT INTO kolhoz_ground VALUES("14999","1511","6","1","1355054506","1355055526","1355055526","1","0");
INSERT INTO kolhoz_ground VALUES("15000","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15001","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15002","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15003","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15004","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15005","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15006","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15007","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15008","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15009","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15010","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15011","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15012","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15013","1512","16","1","1355800212","1355753159","1355738412","1","0");
INSERT INTO kolhoz_ground VALUES("15014","1512","16","1","1355800216","1355753162","1355738416","1","0");
INSERT INTO kolhoz_ground VALUES("15015","1512","18","1","1355811731","1355753165","1355738531","1","0");
INSERT INTO kolhoz_ground VALUES("15016","1512","18","1","1355811741","1355753169","1355738541","1","0");
INSERT INTO kolhoz_ground VALUES("15017","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15018","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15019","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15020","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15021","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15022","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15023","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15024","1513","6","1","1355060517","1355059737","1355059737","1","0");
INSERT INTO kolhoz_ground VALUES("15025","1513","6","0","1355062323","1355059743","1355059743","1","0");
INSERT INTO kolhoz_ground VALUES("15026","1513","6","0","1355062331","1355059751","1355059751","1","0");
INSERT INTO kolhoz_ground VALUES("15027","1513","6","0","1355062343","1355059763","1355059763","1","0");
INSERT INTO kolhoz_ground VALUES("15028","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15029","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15030","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15031","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15032","1504","49","1","1355232221","1355181101","1355180813","1","0");
INSERT INTO kolhoz_ground VALUES("15033","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15034","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15035","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15036","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15037","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15038","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15039","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15040","1514","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15041","1514","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15042","1514","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15043","1514","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15044","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15045","1515","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15046","1515","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15047","1515","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15048","1515","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15049","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15050","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15051","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15052","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15053","1517","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15054","1517","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15055","1517","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15056","1517","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15057","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15058","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15059","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15060","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15061","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15062","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15063","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15064","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15065","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15066","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15067","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15068","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15069","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15070","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15071","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15072","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15073","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15074","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15075","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15076","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15077","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15078","1497","47","0","1355978992","1355730062","1355729992","1","0");
INSERT INTO kolhoz_ground VALUES("15079","1507","76","1","1356024710","1355741101","1355060834","1","0");
INSERT INTO kolhoz_ground VALUES("15080","1507","76","1","1356024710","1355741101","1355060834","1","0");
INSERT INTO kolhoz_ground VALUES("15081","1518","31","1","1355626236","1355585715","1355583678","1","0");
INSERT INTO kolhoz_ground VALUES("15082","1518","31","1","1355626236","1355585715","1355583678","1","0");
INSERT INTO kolhoz_ground VALUES("15083","1518","31","1","1355626236","1355585715","1355583678","1","0");
INSERT INTO kolhoz_ground VALUES("15084","1518","31","1","1355626236","1355585715","1355583678","1","0");
INSERT INTO kolhoz_ground VALUES("15085","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15086","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15087","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15088","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("15089","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15090","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("15091","1519","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15092","1519","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15093","1519","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15094","1519","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15095","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15096","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15097","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15098","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15099","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15100","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15101","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15102","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15103","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15104","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15105","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15106","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15107","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15108","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15109","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15110","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15111","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15112","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15113","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15114","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15115","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15116","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15117","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15118","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15119","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15120","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15121","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15122","1501","48","0","1355631959","1355565119","1355565239","1","0");
INSERT INTO kolhoz_ground VALUES("15123","1518","31","1","1355626236","1355585715","1355583678","1","0");
INSERT INTO kolhoz_ground VALUES("15124","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15125","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15126","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15127","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15128","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15129","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15130","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15131","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15132","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15133","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15134","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15135","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15136","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15137","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15138","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15139","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15140","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15141","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15142","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15143","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15144","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15145","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15146","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15147","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15148","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15149","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15150","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15151","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15152","1520","57","0","1356112513","1355745433","1355745613","1","0");
INSERT INTO kolhoz_ground VALUES("15153","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15154","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15155","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15156","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15157","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15158","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15159","1522","51","1","1355615290","1355476923","1355411950","1","0");
INSERT INTO kolhoz_ground VALUES("15160","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15161","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15162","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15163","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15164","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15165","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15166","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15167","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15168","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15169","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15170","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15171","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15172","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15173","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15174","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15175","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15176","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15177","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15178","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15179","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15180","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15181","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15182","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15183","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15184","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15185","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15186","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15187","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15188","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15189","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15190","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15191","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15192","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15193","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15194","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15195","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15196","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15197","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15198","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15199","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15200","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15201","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15202","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15203","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15204","1496","53","0","1355827576","1355507296","1355507416","1","0");
INSERT INTO kolhoz_ground VALUES("15205","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15206","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15207","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15208","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15209","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15210","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15211","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15212","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15213","1510","69","0","1356377725","1355762245","1355763325","1","0");
INSERT INTO kolhoz_ground VALUES("15214","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15215","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15216","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15217","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15218","1524","6","0","1355083760","1355081180","1355081180","1","0");
INSERT INTO kolhoz_ground VALUES("15219","1524","6","0","1355083769","1355081189","1355081189","1","0");
INSERT INTO kolhoz_ground VALUES("15220","1524","6","0","1355083779","1355081199","1355081199","1","0");
INSERT INTO kolhoz_ground VALUES("15221","1524","6","0","1355083794","1355081214","1355081214","1","0");
INSERT INTO kolhoz_ground VALUES("15222","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15223","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15224","1525","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15225","1525","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15226","1525","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15227","1525","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15228","1518","31","1","1355626236","1355585715","1355583678","1","0");
INSERT INTO kolhoz_ground VALUES("15229","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("15230","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("15231","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("15232","1526","0","0","1355749552","1355749646","1355749766","1","0");
INSERT INTO kolhoz_ground VALUES("15233","1526","0","0","1355749552","1355555831","1355555831","1","0");
INSERT INTO kolhoz_ground VALUES("15234","1526","0","0","1355749552","1355555833","1355555833","1","0");
INSERT INTO kolhoz_ground VALUES("15235","1526","0","0","1355749552","1355555834","1355555834","1","0");
INSERT INTO kolhoz_ground VALUES("15236","1527","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15237","1527","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15238","1527","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15239","1527","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15240","1528","0","0","1355332867","1355332087","1355332087","0","0");
INSERT INTO kolhoz_ground VALUES("15241","1528","0","0","1355332008","1355329428","1355329428","1","0");
INSERT INTO kolhoz_ground VALUES("15242","1528","0","0","1355331998","1355329418","1355329418","0","0");
INSERT INTO kolhoz_ground VALUES("15243","1528","6","0","1355332011","1355329431","1355329431","1","0");
INSERT INTO kolhoz_ground VALUES("15244","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15245","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15246","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15247","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15248","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15249","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15250","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15251","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15252","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15253","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15254","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15255","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15256","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15257","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15258","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15259","1049","63","0","1356226421","1355762141","1355762321","1","0");
INSERT INTO kolhoz_ground VALUES("15260","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15261","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15262","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15263","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15264","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15265","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15266","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15267","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15268","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15269","1531","8","0","1355096377","1355072977","1355072977","1","0");
INSERT INTO kolhoz_ground VALUES("15270","1531","8","0","1355096390","1355072990","1355072990","1","0");
INSERT INTO kolhoz_ground VALUES("15271","1531","8","0","1355096394","1355072994","1355072994","1","0");
INSERT INTO kolhoz_ground VALUES("15272","1531","8","0","1355096399","1355072999","1355072999","1","0");
INSERT INTO kolhoz_ground VALUES("15273","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15274","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15275","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15276","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15277","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15278","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15279","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15280","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15281","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15282","1532","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15283","1532","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15284","1532","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15285","1532","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15286","1531","8","0","1355096406","1355073006","1355073006","1","0");
INSERT INTO kolhoz_ground VALUES("15287","1499","6","1","1355753546","1355754698","1355752766","1","0");
INSERT INTO kolhoz_ground VALUES("15288","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15289","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15290","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15291","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15292","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15293","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15294","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15295","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15296","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15297","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15298","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15299","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15300","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15301","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15302","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15303","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15304","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15305","1534","6","1","1355080920","1355082002","1355080140","1","0");
INSERT INTO kolhoz_ground VALUES("15306","1534","6","1","1355080932","1355082009","1355080152","1","0");
INSERT INTO kolhoz_ground VALUES("15307","1534","6","1","1355080944","1355082021","1355080164","1","0");
INSERT INTO kolhoz_ground VALUES("15308","1534","6","1","1355080955","1355082023","1355080175","1","0");
INSERT INTO kolhoz_ground VALUES("15309","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("15310","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15311","1534","6","0","1355082969","1355080389","1355080389","1","0");
INSERT INTO kolhoz_ground VALUES("15312","1535","6","0","1355083847","1355081267","1355081267","1","0");
INSERT INTO kolhoz_ground VALUES("15313","1535","6","0","1355083852","1355081272","1355081272","1","0");
INSERT INTO kolhoz_ground VALUES("15314","1535","6","0","1355083859","1355081279","1355081279","1","0");
INSERT INTO kolhoz_ground VALUES("15315","1535","0","0","1355075900","1355080880","1355080880","1","0");
INSERT INTO kolhoz_ground VALUES("15316","1534","6","0","1355083009","1355080429","1355080429","1","0");
INSERT INTO kolhoz_ground VALUES("15317","1535","0","0","1355075913","1355080893","1355080893","1","0");
INSERT INTO kolhoz_ground VALUES("15318","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15319","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15320","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15321","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15322","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15323","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15324","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15325","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15326","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15327","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15328","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15329","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15330","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15331","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15332","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15333","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15334","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15335","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15336","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15337","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15338","1038","76","0","1356794448","1355750568","1355751828","1","0");
INSERT INTO kolhoz_ground VALUES("15339","1536","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15340","1536","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15341","1536","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15342","1536","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15343","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15344","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15345","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15346","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15347","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15348","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15349","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15350","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15351","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15352","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15353","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15354","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15355","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15356","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15357","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15358","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15359","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15360","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15361","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15362","1509","59","0","1356121549","1355732869","1355733049","1","0");
INSERT INTO kolhoz_ground VALUES("15363","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("15364","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("15365","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15366","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15367","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15368","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15369","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15370","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15371","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15372","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15373","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15374","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15375","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15376","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15377","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15378","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15379","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15380","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15381","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15382","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15383","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15384","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15385","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15386","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15387","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15388","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15389","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15390","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15391","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15392","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15393","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15394","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15395","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15396","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15397","1537","70","0","1355406530","1355158250","1355159330","1","0");
INSERT INTO kolhoz_ground VALUES("15398","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15399","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15400","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15401","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15402","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15403","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15404","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15405","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15406","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15407","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15408","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15409","1529","86","0","1356979236","1355761139","1355762196","1","0");
INSERT INTO kolhoz_ground VALUES("15410","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15411","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15412","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15413","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15414","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15415","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15416","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15417","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15418","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15419","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15420","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15421","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15422","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15423","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15424","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15425","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15426","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15427","1539","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15428","1539","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15429","1539","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15430","1539","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15431","1540","6","0","1355122359","1355119779","1355119779","1","0");
INSERT INTO kolhoz_ground VALUES("15432","1540","6","0","1355122379","1355119799","1355119799","1","0");
INSERT INTO kolhoz_ground VALUES("15433","1540","6","0","1355122385","1355119805","1355119805","1","0");
INSERT INTO kolhoz_ground VALUES("15434","1540","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15435","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15436","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15437","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15438","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15439","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15440","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15441","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15442","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15443","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15444","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("15445","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("15446","1362","65","0","1356264565","1355757085","1355757265","1","0");
INSERT INTO kolhoz_ground VALUES("15447","1541","6","0","1355130947","1355128367","1355128367","1","0");
INSERT INTO kolhoz_ground VALUES("15448","1541","6","0","1355130955","1355128375","1355128375","1","0");
INSERT INTO kolhoz_ground VALUES("15449","1541","6","0","1355130965","1355128385","1355128385","1","0");
INSERT INTO kolhoz_ground VALUES("15450","1541","6","0","1355130974","1355128394","1355128394","1","0");
INSERT INTO kolhoz_ground VALUES("15451","1542","6","0","1355130467","1355127887","1355127887","1","0");
INSERT INTO kolhoz_ground VALUES("15452","1542","0","0","1355127761","1355129557","1355126981","0","0");
INSERT INTO kolhoz_ground VALUES("15453","1542","0","0","1355127774","1355126994","1355126994","0","0");
INSERT INTO kolhoz_ground VALUES("15454","1542","0","0","1355127792","1355129578","1355127012","0","0");
INSERT INTO kolhoz_ground VALUES("15455","1542","6","1","1355127833","1355127053","1355127053","1","0");
INSERT INTO kolhoz_ground VALUES("15456","1541","6","0","1355131000","1355128420","1355128420","1","0");
INSERT INTO kolhoz_ground VALUES("15457","1543","6","1","1355129020","1355128240","1355128240","1","0");
INSERT INTO kolhoz_ground VALUES("15458","1543","6","0","1355130822","1355128242","1355128242","1","0");
INSERT INTO kolhoz_ground VALUES("15459","1543","6","0","1355130822","1355128242","1355128242","1","0");
INSERT INTO kolhoz_ground VALUES("15460","1543","6","0","1355130835","1355128255","1355128255","1","0");
INSERT INTO kolhoz_ground VALUES("15461","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15462","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15463","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15464","1544","6","1","1355131696","1355132736","1355130916","1","0");
INSERT INTO kolhoz_ground VALUES("15465","1544","6","1","1355131718","1355132748","1355130938","1","0");
INSERT INTO kolhoz_ground VALUES("15466","1544","6","1","1355131723","1355132754","1355130943","1","0");
INSERT INTO kolhoz_ground VALUES("15467","1544","6","1","1355131730","1355132764","1355130950","1","0");
INSERT INTO kolhoz_ground VALUES("15468","1544","8","0","1355154545","1355131145","1355131145","1","0");
INSERT INTO kolhoz_ground VALUES("15469","1544","8","0","1355154582","1355131182","1355131182","1","0");
INSERT INTO kolhoz_ground VALUES("15470","1544","8","0","1355154630","1355131230","1355131230","1","0");
INSERT INTO kolhoz_ground VALUES("15471","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15472","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15473","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15474","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15475","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15476","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15477","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15478","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15479","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15480","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15481","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15482","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15483","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15484","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15485","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15486","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15487","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15488","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15489","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15490","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15491","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15492","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15493","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15494","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15495","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15496","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15497","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15498","1545","86","0","1356933083","1355720516","1355721503","1","0");
INSERT INTO kolhoz_ground VALUES("15499","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15500","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15501","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15502","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15503","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15504","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15505","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15506","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15507","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15508","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15509","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("15510","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15511","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15512","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15513","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15514","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15515","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15516","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15517","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15518","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15519","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15520","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15521","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15522","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15523","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("15524","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15525","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15526","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15527","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15528","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15529","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15530","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15531","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15532","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15533","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15534","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15535","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15536","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15537","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15538","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15539","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15540","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15541","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15542","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15543","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15544","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15545","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15546","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15547","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15548","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15549","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15550","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15551","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15552","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15553","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15554","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15555","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15556","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15557","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15558","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15559","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15560","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15561","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15562","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15563","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15564","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15565","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15566","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15567","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("15568","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("15569","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15570","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15571","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15572","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15573","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15574","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15575","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15576","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15577","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15578","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15579","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15580","1546","65","0","1356269489","1355762009","1355762189","1","0");
INSERT INTO kolhoz_ground VALUES("15581","1551","8","0","1355212353","1355188953","1355188953","1","0");
INSERT INTO kolhoz_ground VALUES("15582","1551","10","0","1355223763","1355188963","1355188963","1","0");
INSERT INTO kolhoz_ground VALUES("15583","1551","10","0","1355223769","1355188969","1355188969","1","0");
INSERT INTO kolhoz_ground VALUES("15584","1551","10","0","1355223774","1355188974","1355188974","1","0");
INSERT INTO kolhoz_ground VALUES("15585","1551","10","0","1355223779","1355188979","1355188979","1","0");
INSERT INTO kolhoz_ground VALUES("15586","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15587","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("15588","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15589","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15590","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15591","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15592","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15593","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15594","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15595","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15596","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15597","1474","63","0","1356185665","1355727051","1355727025","1","0");
INSERT INTO kolhoz_ground VALUES("15598","1552","6","0","1355214993","1355212413","1355212413","1","0");
INSERT INTO kolhoz_ground VALUES("15599","1552","6","0","1355214997","1355212417","1355212417","1","0");
INSERT INTO kolhoz_ground VALUES("15600","1552","6","0","1355215001","1355212421","1355212421","1","0");
INSERT INTO kolhoz_ground VALUES("15601","1552","6","0","1355215006","1355212426","1355212426","1","0");
INSERT INTO kolhoz_ground VALUES("15602","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15603","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15604","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15605","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15606","1552","6","0","1355215012","1355212432","1355212432","1","0");
INSERT INTO kolhoz_ground VALUES("15607","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15608","1552","6","0","1355215019","1355212439","1355212439","1","0");
INSERT INTO kolhoz_ground VALUES("15609","1552","6","0","1355215028","1355212448","1355212448","1","0");
INSERT INTO kolhoz_ground VALUES("15610","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15611","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15612","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15613","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15614","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("15615","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15616","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15617","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15618","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15619","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15620","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15621","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15622","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15623","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15624","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15625","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15626","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15627","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15628","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15629","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15630","1550","47","0","1355987597","1355741407","1355741297","1","0");
INSERT INTO kolhoz_ground VALUES("15631","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("15632","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15633","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15634","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15635","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15636","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15637","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15638","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15639","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15640","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15641","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15642","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15643","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15644","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15645","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15646","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15647","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15648","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15649","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15650","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15651","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15652","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15653","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15654","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15655","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15656","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15657","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15658","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15659","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15660","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15661","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15662","1548","69","0","1356164354","1355548874","1355549954","1","0");
INSERT INTO kolhoz_ground VALUES("15663","1555","6","1","1355399801","1355401117","1355399021","1","0");
INSERT INTO kolhoz_ground VALUES("15664","1555","6","1","1355399804","1355401119","1355399024","1","0");
INSERT INTO kolhoz_ground VALUES("15665","1555","6","1","1355399806","1355399026","1355399026","1","0");
INSERT INTO kolhoz_ground VALUES("15666","1555","6","1","1355399808","1355399028","1355399028","1","0");
INSERT INTO kolhoz_ground VALUES("15667","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("15668","1394","57","1","1355660366","1355441546","1355422166","1","0");
INSERT INTO kolhoz_ground VALUES("15669","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15670","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15671","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15672","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15673","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15674","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15675","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15676","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15677","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15678","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15679","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15680","1557","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15681","1557","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15682","1557","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15683","1557","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15684","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15685","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15686","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15687","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15688","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15689","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15690","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15691","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15692","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15693","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15694","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15695","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15696","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15697","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15698","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15699","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15700","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15701","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15702","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15703","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15704","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15705","1556","59","0","1356137190","1355754219","1355754150","1","0");
INSERT INTO kolhoz_ground VALUES("15706","1506","59","0","1356134398","1355745718","1355745898","1","0");
INSERT INTO kolhoz_ground VALUES("15707","1554","35","1","1355397195","1355324904","1355322915","1","0");
INSERT INTO kolhoz_ground VALUES("15708","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15709","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15710","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15711","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15712","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15713","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15714","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15715","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15716","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15717","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15718","1361","59","0","1355769911","1355381231","1355381411","1","0");
INSERT INTO kolhoz_ground VALUES("15719","1558","37","1","1355829050","1355702018","1355696390","1","0");
INSERT INTO kolhoz_ground VALUES("15720","1558","39","1","1355839878","1355702018","1355696418","1","0");
INSERT INTO kolhoz_ground VALUES("15721","1558","39","1","1355839884","1355702019","1355696424","1","0");
INSERT INTO kolhoz_ground VALUES("15722","1558","39","1","1355839889","1355702020","1355696429","1","0");
INSERT INTO kolhoz_ground VALUES("15723","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15724","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15725","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15726","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15727","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15728","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15729","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15730","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15731","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15732","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15733","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15734","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15735","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15736","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15737","1369","59","0","1356150914","1355762234","1355762414","1","0");
INSERT INTO kolhoz_ground VALUES("15738","1538","8","0","1355277598","1355254198","1355254198","1","0");
INSERT INTO kolhoz_ground VALUES("15739","1559","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15740","1559","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15741","1559","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15742","1559","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15743","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("15744","1389","61","0","1355943209","1355507729","1355507909","1","0");
INSERT INTO kolhoz_ground VALUES("15745","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15746","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15747","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15748","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15749","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15750","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15751","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15752","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15753","1483","65","0","1356251407","1355749695","1355749567","1","0");
INSERT INTO kolhoz_ground VALUES("15754","1394","57","1","1355501277","1355441546","1355264517","1","0");
INSERT INTO kolhoz_ground VALUES("15755","1394","57","1","1355501277","1355441546","1355264517","1","0");
INSERT INTO kolhoz_ground VALUES("15756","1560","6","0","1355267603","1355265023","1355265023","1","0");
INSERT INTO kolhoz_ground VALUES("15757","1560","6","0","1355267648","1355265068","1355265068","1","0");
INSERT INTO kolhoz_ground VALUES("15758","1560","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15759","1560","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15760","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15761","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15762","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15763","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15764","1458","61","0","1356163990","1355728510","1355728690","1","0");
INSERT INTO kolhoz_ground VALUES("15765","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15766","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15767","1488","47","0","1356007050","1355755170","1355755290","1","0");
INSERT INTO kolhoz_ground VALUES("15768","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("15769","1533","47","0","1355833102","1355581222","1355581342","1","0");
INSERT INTO kolhoz_ground VALUES("15770","1456","57","1","1355761802","1355761278","1355729630","1","0");
INSERT INTO kolhoz_ground VALUES("15771","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15772","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15773","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15774","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15775","1561","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15776","1561","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15777","1561","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15778","1561","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15779","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15780","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15781","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15782","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15783","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15784","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15785","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15786","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15787","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15788","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15789","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15790","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15791","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15792","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15793","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15794","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15795","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15796","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15797","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15798","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15799","1516","86","0","1356961437","1355737557","1355738937","1","0");
INSERT INTO kolhoz_ground VALUES("15800","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15801","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15802","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15803","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15804","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15805","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("15806","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15807","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15808","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15809","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15810","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15811","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15812","1563","0","0","1355323590","1355325381","1355322810","0","0");
INSERT INTO kolhoz_ground VALUES("15813","1563","0","0","1355323601","1355322821","1355322821","0","0");
INSERT INTO kolhoz_ground VALUES("15814","1563","5","1","1355323611","1355325409","1355322831","1","0");
INSERT INTO kolhoz_ground VALUES("15815","1563","5","1","1355323621","1355325418","1355322841","1","0");
INSERT INTO kolhoz_ground VALUES("15816","1563","5","1","1355323676","1355325430","1355322896","1","0");
INSERT INTO kolhoz_ground VALUES("15817","1563","5","1","1355323701","1355325446","1355322921","1","0");
INSERT INTO kolhoz_ground VALUES("15818","1485","59","1","1355800325","1355760141","1355752757","1","0");
INSERT INTO kolhoz_ground VALUES("15819","1564","53","1","1355782397","1355761992","1355721917","1","0");
INSERT INTO kolhoz_ground VALUES("15820","1564","53","1","1355782400","1355761992","1355721920","1","0");
INSERT INTO kolhoz_ground VALUES("15821","1564","53","1","1355782400","1355761992","1355721920","1","0");
INSERT INTO kolhoz_ground VALUES("15822","1564","53","1","1355782400","1355761992","1355721920","1","0");
INSERT INTO kolhoz_ground VALUES("15823","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15824","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15825","1565","39","1","1355831670","1355692459","1355687130","1","0");
INSERT INTO kolhoz_ground VALUES("15826","1565","39","1","1355831686","1355692467","1355687146","1","0");
INSERT INTO kolhoz_ground VALUES("15827","1565","39","1","1355831646","1355692462","1355687166","1","0");
INSERT INTO kolhoz_ground VALUES("15828","1565","39","1","1355831672","1355692462","1355687192","1","0");
INSERT INTO kolhoz_ground VALUES("15829","1565","39","1","1355831696","1355692462","1355687216","1","0");
INSERT INTO kolhoz_ground VALUES("15830","1565","39","1","1355831720","1355692462","1355687240","1","0");
INSERT INTO kolhoz_ground VALUES("15831","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15832","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15833","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15834","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15835","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15836","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15837","1567","12","1","1355414145","1355379726","1355377845","1","0");
INSERT INTO kolhoz_ground VALUES("15838","1567","14","0","1355435663","1355378063","1355378063","1","0");
INSERT INTO kolhoz_ground VALUES("15839","1567","14","0","1355435668","1355378068","1355378068","1","0");
INSERT INTO kolhoz_ground VALUES("15840","1567","14","0","1355435672","1355378072","1355378072","1","0");
INSERT INTO kolhoz_ground VALUES("15841","1526","0","0","1355749552","1355555836","1355555836","1","0");
INSERT INTO kolhoz_ground VALUES("15842","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15843","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15844","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15845","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15846","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("15847","1562","37","1","1355828578","1355763750","1355734510","1","0");
INSERT INTO kolhoz_ground VALUES("15848","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15849","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15850","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15851","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15852","1523","63","1","1355871855","1355753137","1355743227","1","0");
INSERT INTO kolhoz_ground VALUES("15853","1564","53","1","1355782400","1355761992","1355721920","1","0");
INSERT INTO kolhoz_ground VALUES("15854","1567","16","0","1355447101","1355378101","1355378101","1","0");
INSERT INTO kolhoz_ground VALUES("15855","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15856","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15857","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15858","1477","61","0","1356021684","1355586204","1355586384","1","0");
INSERT INTO kolhoz_ground VALUES("15859","1361","59","0","1355769947","1355381267","1355381447","1","0");
INSERT INTO kolhoz_ground VALUES("15860","1361","59","0","1355769947","1355381267","1355381447","1","0");
INSERT INTO kolhoz_ground VALUES("15861","1568","0","0","1355388730","1355388760","1355388760","1","0");
INSERT INTO kolhoz_ground VALUES("15862","1568","0","0","1355388730","1355388783","1355388783","1","0");
INSERT INTO kolhoz_ground VALUES("15863","1568","0","0","1355388730","1355388788","1355388788","1","0");
INSERT INTO kolhoz_ground VALUES("15864","1568","0","0","1355388730","1355388812","1355388812","1","0");
INSERT INTO kolhoz_ground VALUES("15865","1568","0","0","1355388730","1355388817","1355388817","1","0");
INSERT INTO kolhoz_ground VALUES("15866","1568","0","0","1355388730","1355388840","1355388900","1","0");
INSERT INTO kolhoz_ground VALUES("15867","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15868","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15869","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15870","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15871","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15872","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15873","1512","18","1","1355811749","1355753173","1355738549","1","0");
INSERT INTO kolhoz_ground VALUES("15874","1512","18","1","1355811757","1355753178","1355738557","1","0");
INSERT INTO kolhoz_ground VALUES("15875","1512","18","1","1355811783","1355753186","1355738583","1","0");
INSERT INTO kolhoz_ground VALUES("15876","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15877","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15878","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15879","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("15880","1353","61","0","1356193151","1355757671","1355757851","1","0");
INSERT INTO kolhoz_ground VALUES("15881","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("15882","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15883","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15884","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15885","1549","55","1","1355823592","1355692604","1355688076","1","0");
INSERT INTO kolhoz_ground VALUES("15886","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("15887","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("15888","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("15889","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("15890","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("15891","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("15892","1564","53","1","1355782400","1355761992","1355721920","1","0");
INSERT INTO kolhoz_ground VALUES("15893","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("15894","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("15895","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("15896","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("15897","1571","12","0","1355785594","1355739394","1355739394","1","0");
INSERT INTO kolhoz_ground VALUES("15898","1571","12","0","1355785594","1355739394","1355739394","1","0");
INSERT INTO kolhoz_ground VALUES("15899","1571","12","0","1355785594","1355739394","1355739394","1","0");
INSERT INTO kolhoz_ground VALUES("15900","1571","12","0","1355785594","1355739394","1355739394","1","0");
INSERT INTO kolhoz_ground VALUES("15901","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("15902","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("15903","1571","12","0","1355785594","1355739394","1355739394","1","0");
INSERT INTO kolhoz_ground VALUES("15904","1572","22","1","1355511536","1355431317","1355414336","1","0");
INSERT INTO kolhoz_ground VALUES("15905","1572","22","1","1355511540","1355431320","1355414340","1","0");
INSERT INTO kolhoz_ground VALUES("15906","1572","22","1","1355511543","1355431321","1355414343","1","0");
INSERT INTO kolhoz_ground VALUES("15907","1572","24","1","1355521152","1355431322","1355414412","1","0");
INSERT INTO kolhoz_ground VALUES("15908","1572","24","1","1355521157","1355431323","1355414417","1","0");
INSERT INTO kolhoz_ground VALUES("15909","1572","24","1","1355521161","1355431324","1355414421","1","0");
INSERT INTO kolhoz_ground VALUES("15910","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15911","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15912","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15913","1547","61","0","1356016663","1355586878","1355586823","1","0");
INSERT INTO kolhoz_ground VALUES("15914","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("15915","1573","6","0","1355418634","1355416054","1355416054","1","0");
INSERT INTO kolhoz_ground VALUES("15916","1573","6","0","1355418643","1355416063","1355416063","1","0");
INSERT INTO kolhoz_ground VALUES("15917","1573","6","0","1355418640","1355416060","1355416060","1","0");
INSERT INTO kolhoz_ground VALUES("15918","1573","6","0","1355418643","1355416063","1355416063","1","0");
INSERT INTO kolhoz_ground VALUES("15919","1574","20","1","1355800311","1355760406","1355714031","1","0");
INSERT INTO kolhoz_ground VALUES("15920","1574","20","1","1355800316","1355760412","1355714036","1","0");
INSERT INTO kolhoz_ground VALUES("15921","1574","20","1","1355800319","1355760415","1355714039","1","0");
INSERT INTO kolhoz_ground VALUES("15922","1574","20","1","1355800323","1355760418","1355714043","1","0");
INSERT INTO kolhoz_ground VALUES("15923","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15924","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15925","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15926","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15927","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15928","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15929","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15930","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15931","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15932","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15933","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15934","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15935","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15936","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15937","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15938","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15939","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15940","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15941","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15942","1553","67","0","1356291790","1355737510","1355737690","1","0");
INSERT INTO kolhoz_ground VALUES("15943","1575","22","1","1355515868","1355512705","1355468708","1","0");
INSERT INTO kolhoz_ground VALUES("15944","1575","22","1","1355515869","1355512705","1355468709","1","0");
INSERT INTO kolhoz_ground VALUES("15945","1575","22","1","1355515869","1355512705","1355468709","1","0");
INSERT INTO kolhoz_ground VALUES("15946","1575","22","1","1355515870","1355512705","1355468710","1","0");
INSERT INTO kolhoz_ground VALUES("15947","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("15948","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("15949","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("15950","1363","55","1","1355563224","1355445145","1355425908","1","0");
INSERT INTO kolhoz_ground VALUES("15951","1576","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15952","1576","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15953","1576","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15954","1576","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("15955","1574","20","1","1355800326","1355760421","1355714046","1","0");
INSERT INTO kolhoz_ground VALUES("15956","1574","20","1","1355800331","1355760424","1355714051","1","0");
INSERT INTO kolhoz_ground VALUES("15957","1574","22","1","1355812360","1355760427","1355714080","1","0");
INSERT INTO kolhoz_ground VALUES("15958","1577","24","0","1355586834","1355471754","1355471814","1","0");
INSERT INTO kolhoz_ground VALUES("15959","1577","24","0","1355586834","1355471754","1355471814","1","0");
INSERT INTO kolhoz_ground VALUES("15960","1577","24","0","1355586834","1355471754","1355471814","1","0");
INSERT INTO kolhoz_ground VALUES("15961","1577","24","0","1355586834","1355471754","1355471814","1","0");
INSERT INTO kolhoz_ground VALUES("15962","1578","22","0","1355544804","1355439324","1355439324","1","0");
INSERT INTO kolhoz_ground VALUES("15963","1578","22","0","1355544810","1355439330","1355439330","1","0");
INSERT INTO kolhoz_ground VALUES("15964","1578","22","0","1355544813","1355439333","1355439333","1","0");
INSERT INTO kolhoz_ground VALUES("15965","1578","22","0","1355544815","1355439335","1355439335","1","0");
INSERT INTO kolhoz_ground VALUES("15966","1578","22","0","1355544819","1355439339","1355439339","1","0");
INSERT INTO kolhoz_ground VALUES("15967","1578","22","0","1355544822","1355439342","1355439342","1","0");
INSERT INTO kolhoz_ground VALUES("15968","1578","22","0","1355544826","1355439346","1355439346","1","0");
INSERT INTO kolhoz_ground VALUES("15969","1579","22","0","1355547562","1355442082","1355442082","1","0");
INSERT INTO kolhoz_ground VALUES("15970","1579","22","0","1355547580","1355442100","1355442100","1","0");
INSERT INTO kolhoz_ground VALUES("15971","1579","0","0","1355441916","1355441937","1355441937","0","0");
INSERT INTO kolhoz_ground VALUES("15972","1579","22","0","1355547598","1355442118","1355442118","1","0");
INSERT INTO kolhoz_ground VALUES("15973","1579","0","0","1355441916","1355441969","1355441969","0","0");
INSERT INTO kolhoz_ground VALUES("15974","1579","0","0","1355441916","1355441987","1355441987","0","0");
INSERT INTO kolhoz_ground VALUES("15975","1579","0","0","1355441916","1355442007","1355442007","0","0");
INSERT INTO kolhoz_ground VALUES("15976","1580","20","0","1355556141","1355462661","1355462661","1","0");
INSERT INTO kolhoz_ground VALUES("15977","1580","20","0","1355556155","1355462675","1355462675","1","0");
INSERT INTO kolhoz_ground VALUES("15978","1580","20","0","1355556176","1355462696","1355462696","1","0");
INSERT INTO kolhoz_ground VALUES("15979","1580","20","0","1355556198","1355462718","1355462718","1","0");
INSERT INTO kolhoz_ground VALUES("15980","1580","20","0","1355556214","1355462734","1355462734","1","0");
INSERT INTO kolhoz_ground VALUES("15981","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15982","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15983","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15984","1580","20","0","1355556249","1355462769","1355462769","1","0");
INSERT INTO kolhoz_ground VALUES("15985","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15986","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15987","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15988","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15989","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15990","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15991","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15992","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("15993","1577","24","0","1355586834","1355471754","1355471814","1","0");
INSERT INTO kolhoz_ground VALUES("15994","1581","5","0","1355479949","1355477369","1355477369","1","0");
INSERT INTO kolhoz_ground VALUES("15995","1581","5","0","1355479951","1355477371","1355477371","1","0");
INSERT INTO kolhoz_ground VALUES("15996","1581","5","0","1355479953","1355477373","1355477373","1","0");
INSERT INTO kolhoz_ground VALUES("15997","1581","5","0","1355479960","1355477380","1355477380","1","0");
INSERT INTO kolhoz_ground VALUES("15998","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("15999","1449","45","1","1355738880","1355728323","1355727912","1","0");
INSERT INTO kolhoz_ground VALUES("16000","1581","5","1","1355477493","1355478559","1355476713","1","0");
INSERT INTO kolhoz_ground VALUES("16001","1581","5","1","1355477497","1355478564","1355476717","1","0");
INSERT INTO kolhoz_ground VALUES("16002","1581","5","1","1355477500","1355478566","1355476720","1","0");
INSERT INTO kolhoz_ground VALUES("16003","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("16004","1530","56","0","1355661636","1355571756","1355571936","1","0");
INSERT INTO kolhoz_ground VALUES("16005","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("16006","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("16007","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("16008","1454","59","0","1356141949","1355758991","1355758909","1","0");
INSERT INTO kolhoz_ground VALUES("16009","1582","18","1","1355594975","1355562580","1355530265","1","0");
INSERT INTO kolhoz_ground VALUES("16010","1582","20","1","1355608094","1355562580","1355530304","1","0");
INSERT INTO kolhoz_ground VALUES("16011","1582","20","1","1355608102","1355562580","1355530312","1","0");
INSERT INTO kolhoz_ground VALUES("16012","1582","20","1","1355608109","1355562580","1355530319","1","0");
INSERT INTO kolhoz_ground VALUES("16013","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16014","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16015","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16016","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16017","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16018","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16019","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16020","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16021","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16022","1358","56","0","1355631832","1355541952","1355542132","1","0");
INSERT INTO kolhoz_ground VALUES("16023","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16024","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16025","1583","6","0","1355493623","1355491043","1355491043","1","0");
INSERT INTO kolhoz_ground VALUES("16026","1583","22","0","1355596555","1355491075","1355491075","1","0");
INSERT INTO kolhoz_ground VALUES("16027","1583","22","0","1355596562","1355491082","1355491082","1","0");
INSERT INTO kolhoz_ground VALUES("16028","1583","22","0","1355596565","1355491085","1355491085","1","0");
INSERT INTO kolhoz_ground VALUES("16029","1583","22","0","1355596572","1355491092","1355491092","1","0");
INSERT INTO kolhoz_ground VALUES("16030","1583","22","0","1355596581","1355491101","1355491101","1","0");
INSERT INTO kolhoz_ground VALUES("16031","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("16032","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("16033","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16034","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16035","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16036","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16037","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16038","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16039","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16040","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16041","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16042","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16043","1521","59","1","1355669080","1355564404","1355499772","1","0");
INSERT INTO kolhoz_ground VALUES("16044","1584","22","1","1355595214","1355500534","1355500534","1","0");
INSERT INTO kolhoz_ground VALUES("16045","1584","22","0","1355606021","1355500541","1355500541","1","0");
INSERT INTO kolhoz_ground VALUES("16046","1584","22","0","1355606030","1355500550","1355500550","1","0");
INSERT INTO kolhoz_ground VALUES("16047","1584","22","0","1355606037","1355500557","1355500557","1","0");
INSERT INTO kolhoz_ground VALUES("16048","1584","0","0","1355500397","1355500486","1355500486","0","0");
INSERT INTO kolhoz_ground VALUES("16049","1584","0","0","1355500397","1355500495","1355500495","0","0");
INSERT INTO kolhoz_ground VALUES("16050","1584","0","0","1355500397","1355500507","1355500507","0","0");
INSERT INTO kolhoz_ground VALUES("16051","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16052","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16053","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16054","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16055","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16056","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16057","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16058","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16059","1498","59","0","1356103195","1355714515","1355714695","1","0");
INSERT INTO kolhoz_ground VALUES("16060","1585","22","0","1355613402","1355507922","1355507922","1","0");
INSERT INTO kolhoz_ground VALUES("16061","1585","0","0","1355507754","1355507814","1355507814","1","0");
INSERT INTO kolhoz_ground VALUES("16062","1585","0","0","1355507754","1355507821","1355507821","1","0");
INSERT INTO kolhoz_ground VALUES("16063","1585","0","0","1355507754","1355507828","1355507828","1","0");
INSERT INTO kolhoz_ground VALUES("16064","1585","0","0","1355507754","1355507838","1355507838","1","0");
INSERT INTO kolhoz_ground VALUES("16065","1585","0","0","1355507754","1355507847","1355507847","1","0");
INSERT INTO kolhoz_ground VALUES("16066","1585","0","0","1355507754","1355507856","1355507856","1","0");
INSERT INTO kolhoz_ground VALUES("16067","1586","22","0","1355625696","1355520216","1355520216","1","0");
INSERT INTO kolhoz_ground VALUES("16068","1586","22","0","1355625700","1355520220","1355520220","1","0");
INSERT INTO kolhoz_ground VALUES("16069","1586","22","0","1355625703","1355520223","1355520223","1","0");
INSERT INTO kolhoz_ground VALUES("16070","1586","22","0","1355625707","1355520227","1355520227","1","0");
INSERT INTO kolhoz_ground VALUES("16071","1586","22","0","1355625710","1355520230","1355520230","1","0");
INSERT INTO kolhoz_ground VALUES("16072","1586","22","0","1355625713","1355520233","1355520233","1","0");
INSERT INTO kolhoz_ground VALUES("16073","1586","22","0","1355625720","1355520240","1355520240","1","0");
INSERT INTO kolhoz_ground VALUES("16074","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16075","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16076","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16077","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16078","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16079","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16080","1146","31","0","1355904911","1355757431","1355757491","1","0");
INSERT INTO kolhoz_ground VALUES("16081","1582","20","1","1355612464","1355562580","1355530564","1","0");
INSERT INTO kolhoz_ground VALUES("16082","1587","7","0","1355553677","1355547317","1355547317","1","0");
INSERT INTO kolhoz_ground VALUES("16083","1587","7","0","1355553681","1355547321","1355547321","1","0");
INSERT INTO kolhoz_ground VALUES("16084","1587","7","0","1355553685","1355547325","1355547325","1","0");
INSERT INTO kolhoz_ground VALUES("16085","1587","7","0","1355553689","1355547329","1355547329","1","0");
INSERT INTO kolhoz_ground VALUES("16086","1526","0","0","1355749552","1355555838","1355555838","1","0");
INSERT INTO kolhoz_ground VALUES("16087","1588","47","1","1355893923","1355752610","1355745807","1","0");
INSERT INTO kolhoz_ground VALUES("16088","1588","47","1","1355893923","1355752610","1355745807","1","0");
INSERT INTO kolhoz_ground VALUES("16089","1588","47","1","1355893923","1355752610","1355745807","1","0");
INSERT INTO kolhoz_ground VALUES("16090","1588","47","1","1355893923","1355752610","1355745807","1","0");
INSERT INTO kolhoz_ground VALUES("16091","1589","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16092","1589","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16093","1589","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16094","1589","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16095","1590","5","1","1355553658","1355554727","1355552878","1","0");
INSERT INTO kolhoz_ground VALUES("16096","1590","5","1","1355553666","1355554729","1355552886","1","0");
INSERT INTO kolhoz_ground VALUES("16097","1590","5","1","1355553645","1355554729","1355552865","1","0");
INSERT INTO kolhoz_ground VALUES("16098","1590","5","1","1355553632","1355554723","1355552852","1","0");
INSERT INTO kolhoz_ground VALUES("16099","1590","8","1","1355574598","1355554836","1355552998","1","0");
INSERT INTO kolhoz_ground VALUES("16100","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("16101","1427","47","0","1355937931","1355686051","1355686171","1","0");
INSERT INTO kolhoz_ground VALUES("16102","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("16103","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("16104","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("16105","1591","6","0","1355559265","1355556685","1355556685","1","0");
INSERT INTO kolhoz_ground VALUES("16106","1591","6","0","1355559305","1355556725","1355556725","1","0");
INSERT INTO kolhoz_ground VALUES("16107","1591","0","0","1355551788","1355556408","1355556408","0","0");
INSERT INTO kolhoz_ground VALUES("16108","1591","6","0","1355558998","1355556418","1355556418","1","0");
INSERT INTO kolhoz_ground VALUES("16109","1592","6","0","1355561363","1355558783","1355558783","1","0");
INSERT INTO kolhoz_ground VALUES("16110","1592","6","0","1355561369","1355558789","1355558789","1","0");
INSERT INTO kolhoz_ground VALUES("16111","1592","6","0","1355561373","1355558793","1355558793","1","0");
INSERT INTO kolhoz_ground VALUES("16112","1592","6","0","1355561374","1355558794","1355558794","1","0");
INSERT INTO kolhoz_ground VALUES("16113","1455","40","0","1355773695","1355721255","1355721315","1","0");
INSERT INTO kolhoz_ground VALUES("16114","1593","6","0","1355566647","1355564067","1355564067","1","0");
INSERT INTO kolhoz_ground VALUES("16115","1593","6","0","1355566655","1355564075","1355564075","1","0");
INSERT INTO kolhoz_ground VALUES("16116","1593","6","0","1355566779","1355564199","1355564199","1","0");
INSERT INTO kolhoz_ground VALUES("16117","1593","6","0","1355566781","1355564201","1355564201","1","0");
INSERT INTO kolhoz_ground VALUES("16118","1594","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16119","1594","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16120","1594","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16121","1594","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16122","1595","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16123","1595","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16124","1595","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16125","1595","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16126","1596","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16127","1596","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16128","1596","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16129","1596","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16130","1597","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16131","1597","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16132","1597","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16133","1597","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16134","1598","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16135","1598","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16136","1598","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16137","1598","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16138","1599","6","0","1355565643","1355563063","1355563063","1","0");
INSERT INTO kolhoz_ground VALUES("16139","1599","6","0","1355565648","1355563068","1355563068","1","0");
INSERT INTO kolhoz_ground VALUES("16140","1599","6","0","1355565653","1355563073","1355563073","1","0");
INSERT INTO kolhoz_ground VALUES("16141","1599","6","0","1355565653","1355563073","1355563073","1","0");
INSERT INTO kolhoz_ground VALUES("16142","1600","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16143","1600","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16144","1600","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16145","1600","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16146","1601","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16147","1601","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16148","1601","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16149","1601","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16150","1602","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16151","1602","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16152","1602","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16153","1602","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16154","1603","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16155","1603","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16156","1603","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16157","1603","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16158","1604","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16159","1604","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16160","1604","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16161","1604","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16162","1605","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16163","1605","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16164","1605","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16165","1605","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16166","1606","6","1","1355561373","1355562532","1355560593","1","0");
INSERT INTO kolhoz_ground VALUES("16167","1606","6","1","1355561377","1355562537","1355560597","1","0");
INSERT INTO kolhoz_ground VALUES("16168","1606","6","1","1355561381","1355560601","1355560601","1","0");
INSERT INTO kolhoz_ground VALUES("16169","1606","6","1","1355561386","1355560606","1355560606","1","0");
INSERT INTO kolhoz_ground VALUES("16170","1606","6","1","1355561394","1355560614","1355560614","1","0");
INSERT INTO kolhoz_ground VALUES("16171","1599","6","0","1355565656","1355563076","1355563076","1","0");
INSERT INTO kolhoz_ground VALUES("16172","1599","6","0","1355565659","1355563079","1355563079","1","0");
INSERT INTO kolhoz_ground VALUES("16173","1607","0","0","1355563545","1355568945","1355568945","0","0");
INSERT INTO kolhoz_ground VALUES("16174","1607","0","0","1355563545","1355568945","1355568945","0","0");
INSERT INTO kolhoz_ground VALUES("16175","1607","8","0","1355592357","1355568957","1355568957","1","0");
INSERT INTO kolhoz_ground VALUES("16176","1607","8","0","1355592357","1355568957","1355568957","1","0");
INSERT INTO kolhoz_ground VALUES("16177","1608","6","0","1355566504","1355563924","1355563924","1","0");
INSERT INTO kolhoz_ground VALUES("16178","1608","6","0","1355566511","1355563931","1355563931","1","0");
INSERT INTO kolhoz_ground VALUES("16179","1608","6","0","1355566519","1355563939","1355563939","1","0");
INSERT INTO kolhoz_ground VALUES("16180","1608","6","0","1355566527","1355563947","1355563947","1","0");
INSERT INTO kolhoz_ground VALUES("16181","1607","8","0","1355592364","1355568964","1355568964","1","0");
INSERT INTO kolhoz_ground VALUES("16182","1607","8","0","1355592378","1355568978","1355568978","1","0");
INSERT INTO kolhoz_ground VALUES("16183","1609","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16184","1609","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16185","1609","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16186","1609","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16187","1610","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16188","1610","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16189","1610","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16190","1610","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16191","1588","47","1","1355893923","1355752610","1355745807","1","0");
INSERT INTO kolhoz_ground VALUES("16192","1611","6","0","1355574644","1355572064","1355572064","1","0");
INSERT INTO kolhoz_ground VALUES("16193","1611","6","0","1355574639","1355572059","1355572059","1","0");
INSERT INTO kolhoz_ground VALUES("16194","1611","6","0","1355574639","1355572059","1355572059","1","0");
INSERT INTO kolhoz_ground VALUES("16195","1611","6","0","1355574658","1355572078","1355572078","1","0");
INSERT INTO kolhoz_ground VALUES("16196","1611","6","0","1355574658","1355572078","1355572078","1","0");
INSERT INTO kolhoz_ground VALUES("16197","1611","6","0","1355574658","1355572078","1355572078","1","0");
INSERT INTO kolhoz_ground VALUES("16198","1612","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16199","1612","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16200","1612","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16201","1612","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16202","1613","0","0","1355573444","1355578844","1355578844","1","0");
INSERT INTO kolhoz_ground VALUES("16203","1613","0","0","1355573444","1355578844","1355578844","1","0");
INSERT INTO kolhoz_ground VALUES("16204","1613","8","1","1355573444","1355578844","1355578844","1","0");
INSERT INTO kolhoz_ground VALUES("16205","1613","0","0","1355572556","1355577956","1355577956","0","0");
INSERT INTO kolhoz_ground VALUES("16206","1613","0","0","1355572591","1355577991","1355577991","1","0");
INSERT INTO kolhoz_ground VALUES("16207","1614","18","0","1355653373","1355572973","1355572973","1","0");
INSERT INTO kolhoz_ground VALUES("16208","1614","20","0","1355666479","1355572999","1355572999","1","0");
INSERT INTO kolhoz_ground VALUES("16209","1614","20","0","1355666484","1355573004","1355573004","1","0");
INSERT INTO kolhoz_ground VALUES("16210","1614","22","0","1355678507","1355573027","1355573027","1","0");
INSERT INTO kolhoz_ground VALUES("16211","1613","0","0","1355572608","1355578008","1355578008","1","0");
INSERT INTO kolhoz_ground VALUES("16212","1614","22","0","1355678514","1355573034","1355573034","1","0");
INSERT INTO kolhoz_ground VALUES("16213","1614","22","0","1355678521","1355573041","1355573041","1","0");
INSERT INTO kolhoz_ground VALUES("16214","1615","6","0","1355575886","1355573306","1355573306","1","0");
INSERT INTO kolhoz_ground VALUES("16215","1615","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16216","1615","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16217","1615","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16218","1616","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16219","1616","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16220","1616","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16221","1616","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16222","1617","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16223","1617","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16224","1617","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16225","1617","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16226","1613","0","0","1355572608","1355578008","1355578008","1","0");
INSERT INTO kolhoz_ground VALUES("16227","1618","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16228","1618","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16229","1618","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16230","1618","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16231","1619","6","0","1355580484","1355577904","1355577904","1","0");
INSERT INTO kolhoz_ground VALUES("16232","1619","6","0","1355580484","1355577904","1355577904","1","0");
INSERT INTO kolhoz_ground VALUES("16233","1619","6","0","1355580485","1355577905","1355577905","1","0");
INSERT INTO kolhoz_ground VALUES("16234","1619","6","0","1355580485","1355577905","1355577905","1","0");
INSERT INTO kolhoz_ground VALUES("16235","1619","6","0","1355580486","1355577906","1355577906","1","0");
INSERT INTO kolhoz_ground VALUES("16236","1620","22","1","1355674253","1355577912","1355575973","1","0");
INSERT INTO kolhoz_ground VALUES("16237","1620","22","1","1355674257","1355577916","1355575977","1","0");
INSERT INTO kolhoz_ground VALUES("16238","1620","22","1","1355674262","1355577919","1355575982","1","0");
INSERT INTO kolhoz_ground VALUES("16239","1620","22","1","1355674268","1355577923","1355575988","1","0");
INSERT INTO kolhoz_ground VALUES("16240","1621","18","0","1355842659","1355762259","1355762259","1","0");
INSERT INTO kolhoz_ground VALUES("16241","1621","18","0","1355842659","1355762259","1355762259","1","0");
INSERT INTO kolhoz_ground VALUES("16242","1621","18","0","1355842659","1355762259","1355762259","1","0");
INSERT INTO kolhoz_ground VALUES("16243","1621","18","0","1355842659","1355762259","1355762259","1","0");
INSERT INTO kolhoz_ground VALUES("16244","1620","22","1","1355674280","1355577926","1355576000","1","0");
INSERT INTO kolhoz_ground VALUES("16245","1622","48","0","1355650265","1355583425","1355583545","1","0");
INSERT INTO kolhoz_ground VALUES("16246","1622","48","0","1355650266","1355583426","1355583546","1","0");
INSERT INTO kolhoz_ground VALUES("16247","1622","48","0","1355650268","1355583428","1355583548","1","0");
INSERT INTO kolhoz_ground VALUES("16248","1622","48","0","1355650270","1355583430","1355583550","1","0");
INSERT INTO kolhoz_ground VALUES("16249","1623","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16250","1623","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16251","1623","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16252","1623","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16253","1624","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16254","1624","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16255","1624","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16256","1624","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16257","1625","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16258","1625","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16259","1625","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16260","1625","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16261","1626","6","0","1355579316","1355576736","1355576736","1","0");
INSERT INTO kolhoz_ground VALUES("16262","1626","6","0","1355579321","1355576741","1355576741","1","0");
INSERT INTO kolhoz_ground VALUES("16263","1626","6","0","1355579326","1355576746","1355576746","1","0");
INSERT INTO kolhoz_ground VALUES("16264","1626","6","0","1355579330","1355576750","1355576750","1","0");
INSERT INTO kolhoz_ground VALUES("16265","1622","48","0","1355650272","1355583432","1355583552","1","0");
INSERT INTO kolhoz_ground VALUES("16266","1622","48","0","1355650274","1355583434","1355583554","1","0");
INSERT INTO kolhoz_ground VALUES("16267","1626","6","0","1355579336","1355576756","1355576756","1","0");
INSERT INTO kolhoz_ground VALUES("16268","1627","7","0","1355585295","1355578935","1355578935","1","0");
INSERT INTO kolhoz_ground VALUES("16269","1627","7","0","1355585306","1355578946","1355578946","1","0");
INSERT INTO kolhoz_ground VALUES("16270","1627","0","0","1355578115","1355578415","1355578415","1","0");
INSERT INTO kolhoz_ground VALUES("16271","1627","0","0","1355578001","1355578301","1355578301","1","0");
INSERT INTO kolhoz_ground VALUES("16272","1628","6","0","1355579759","1355577179","1355577179","1","0");
INSERT INTO kolhoz_ground VALUES("16273","1628","6","0","1355579769","1355577189","1355577189","1","0");
INSERT INTO kolhoz_ground VALUES("16274","1628","6","0","1355579781","1355577201","1355577201","1","0");
INSERT INTO kolhoz_ground VALUES("16275","1628","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16276","1629","10","1","1355610470","1355579343","1355577470","1","0");
INSERT INTO kolhoz_ground VALUES("16277","1629","10","1","1355610470","1355579343","1355577470","1","0");
INSERT INTO kolhoz_ground VALUES("16278","1629","10","1","1355610470","1355579344","1355577470","1","0");
INSERT INTO kolhoz_ground VALUES("16279","1629","10","1","1355610470","1355579344","1355577470","1","0");
INSERT INTO kolhoz_ground VALUES("16280","1630","23","0","1355616192","1355586792","1355586852","1","0");
INSERT INTO kolhoz_ground VALUES("16281","1630","23","0","1355616200","1355586800","1355586860","1","0");
INSERT INTO kolhoz_ground VALUES("16282","1630","23","0","1355616207","1355586807","1355586867","1","0");
INSERT INTO kolhoz_ground VALUES("16283","1630","23","0","1355616228","1355586828","1355586888","1","0");
INSERT INTO kolhoz_ground VALUES("16284","1629","10","0","1355612518","1355577718","1355577718","1","0");
INSERT INTO kolhoz_ground VALUES("16285","1631","6","1","1355587004","1355588249","1355586224","1","0");
INSERT INTO kolhoz_ground VALUES("16286","1631","6","1","1355586992","1355588251","1355586212","1","0");
INSERT INTO kolhoz_ground VALUES("16287","1631","6","1","1355586990","1355588252","1355586210","1","0");
INSERT INTO kolhoz_ground VALUES("16288","1631","6","1","1355586990","1355588254","1355586210","1","0");
INSERT INTO kolhoz_ground VALUES("16289","1632","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16290","1632","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16291","1632","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16292","1632","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16293","1633","6","0","1355589213","1355586633","1355586633","1","0");
INSERT INTO kolhoz_ground VALUES("16294","1633","6","0","1355589212","1355586632","1355586632","1","0");
INSERT INTO kolhoz_ground VALUES("16295","1633","6","0","1355589210","1355586630","1355586630","1","0");
INSERT INTO kolhoz_ground VALUES("16296","1633","6","0","1355589209","1355586629","1355586629","1","0");
INSERT INTO kolhoz_ground VALUES("16297","1634","0","0","1355579718","1355580978","1355578938","0","0");
INSERT INTO kolhoz_ground VALUES("16298","1634","0","0","1355579752","1355580979","1355578972","1","0");
INSERT INTO kolhoz_ground VALUES("16299","1634","0","0","1355579722","1355581007","1355578942","0","0");
INSERT INTO kolhoz_ground VALUES("16300","1634","0","0","1355579706","1355580981","1355578926","1","0");
INSERT INTO kolhoz_ground VALUES("16301","1635","6","0","1355764575","1355761995","1355761995","1","0");
INSERT INTO kolhoz_ground VALUES("16302","1635","6","0","1355764583","1355762003","1355762003","1","0");
INSERT INTO kolhoz_ground VALUES("16303","1635","6","0","1355764584","1355762004","1355762004","1","0");
INSERT INTO kolhoz_ground VALUES("16304","1635","6","0","1355764585","1355762005","1355762005","1","0");
INSERT INTO kolhoz_ground VALUES("16305","1636","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16306","1636","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16307","1636","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16308","1636","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16309","1637","6","1","1355580146","1355581286","1355579366","1","0");
INSERT INTO kolhoz_ground VALUES("16310","1637","6","1","1355580163","1355581313","1355579383","1","0");
INSERT INTO kolhoz_ground VALUES("16311","1637","6","1","1355580203","1355581334","1355579423","1","0");
INSERT INTO kolhoz_ground VALUES("16312","1637","6","1","1355580256","1355581442","1355579476","1","0");
INSERT INTO kolhoz_ground VALUES("16313","1638","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16314","1638","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16315","1638","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16316","1638","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16317","1639","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16318","1639","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16319","1639","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16320","1639","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16321","1265","22","0","1355686214","1355580734","1355580734","1","0");
INSERT INTO kolhoz_ground VALUES("16322","1635","6","0","1355764586","1355762006","1355762006","1","0");
INSERT INTO kolhoz_ground VALUES("16323","1640","6","1","1355580792","1355581980","1355580012","1","0");
INSERT INTO kolhoz_ground VALUES("16324","1640","6","1","1355580804","1355582005","1355580024","1","0");
INSERT INTO kolhoz_ground VALUES("16325","1640","8","1","1355601640","1355582055","1355580040","1","0");
INSERT INTO kolhoz_ground VALUES("16326","1640","8","1","1355601649","1355582006","1355580049","1","0");
INSERT INTO kolhoz_ground VALUES("16327","1641","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16328","1641","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16329","1641","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16330","1641","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16331","1642","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16332","1642","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16333","1642","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16334","1642","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16335","1640","10","1","1355613102","1355582007","1355580102","1","0");
INSERT INTO kolhoz_ground VALUES("16336","1640","10","1","1355613112","1355582008","1355580112","1","0");
INSERT INTO kolhoz_ground VALUES("16337","1643","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16338","1643","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16339","1643","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16340","1643","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16341","1265","22","0","1355686231","1355580751","1355580751","1","0");
INSERT INTO kolhoz_ground VALUES("16342","1265","22","0","1355686345","1355580865","1355580865","1","0");
INSERT INTO kolhoz_ground VALUES("16343","1265","22","0","1355686383","1355580903","1355580903","1","0");
INSERT INTO kolhoz_ground VALUES("16344","1644","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16345","1644","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16346","1644","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16347","1644","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16348","1645","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16349","1645","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16350","1645","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16351","1645","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16352","1646","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16353","1646","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16354","1646","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16355","1646","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16356","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("16357","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("16358","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("16359","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("16360","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("16361","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_ground VALUES("16362","1647","22","0","1355688508","1355583028","1355583028","1","0");
INSERT INTO kolhoz_ground VALUES("16363","1647","22","0","1355688526","1355583046","1355583046","1","0");
INSERT INTO kolhoz_ground VALUES("16364","1647","22","0","1355688526","1355583046","1355583046","1","0");
INSERT INTO kolhoz_ground VALUES("16365","1647","22","0","1355688526","1355583046","1355583046","1","0");
INSERT INTO kolhoz_ground VALUES("16366","1647","22","0","1355688527","1355583047","1355583047","1","0");
INSERT INTO kolhoz_ground VALUES("16367","1647","22","0","1355688527","1355583047","1355583047","1","0");
INSERT INTO kolhoz_ground VALUES("16368","1648","8","1","1355594984","1355587923","1355584184","1","0");
INSERT INTO kolhoz_ground VALUES("16369","1648","8","1","1355595013","1355587924","1355584213","1","0");
INSERT INTO kolhoz_ground VALUES("16370","1648","8","1","1355595024","1355587925","1355584224","1","0");
INSERT INTO kolhoz_ground VALUES("16371","1648","8","1","1355595033","1355587926","1355584233","1","0");
INSERT INTO kolhoz_ground VALUES("16372","1649","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16373","1649","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16374","1649","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16375","1649","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16376","1650","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16377","1650","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16378","1650","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16379","1650","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16380","1651","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16381","1651","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16382","1651","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16383","1651","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16384","1648","8","1","1355595046","1355587928","1355584246","1","0");
INSERT INTO kolhoz_ground VALUES("16385","1652","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16386","1652","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16387","1652","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16388","1652","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16389","1653","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16390","1653","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16391","1653","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16392","1653","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16393","1648","8","1","1355595048","1355587928","1355584248","1","0");
INSERT INTO kolhoz_ground VALUES("16394","1482","51","1","1355856421","1355760825","1355746885","1","0");
INSERT INTO kolhoz_ground VALUES("16395","1482","51","1","1355856421","1355760825","1355746885","1","0");
INSERT INTO kolhoz_ground VALUES("16396","1654","0","0","1355580628","1355585248","1355585248","0","0");
INSERT INTO kolhoz_ground VALUES("16397","1654","6","1","1355580636","1355585256","1355585256","1","0");
INSERT INTO kolhoz_ground VALUES("16398","1654","6","1","1355580644","1355585264","1355585264","1","0");
INSERT INTO kolhoz_ground VALUES("16399","1654","6","1","1355580647","1355585267","1355585267","1","0");
INSERT INTO kolhoz_ground VALUES("16400","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16401","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16402","1655","0","0","1355581633","1355586253","1355586253","0","0");
INSERT INTO kolhoz_ground VALUES("16403","1655","0","0","1355581634","1355586254","1355586254","0","0");
INSERT INTO kolhoz_ground VALUES("16404","1655","0","0","1355581659","1355586279","1355586279","0","0");
INSERT INTO kolhoz_ground VALUES("16405","1655","0","0","1355581639","1355586259","1355586259","0","0");
INSERT INTO kolhoz_ground VALUES("16406","1654","6","1","1355580738","1355585358","1355585358","1","0");
INSERT INTO kolhoz_ground VALUES("16407","1654","6","1","1355580716","1355585336","1355585336","1","0");
INSERT INTO kolhoz_ground VALUES("16408","1656","6","1","1355586254","1355587535","1355585474","1","0");
INSERT INTO kolhoz_ground VALUES("16409","1656","6","1","1355586272","1355587558","1355585492","1","0");
INSERT INTO kolhoz_ground VALUES("16410","1656","6","1","1355586292","1355587566","1355585512","1","0");
INSERT INTO kolhoz_ground VALUES("16411","1656","6","1","1355586302","1355587584","1355585522","1","0");
INSERT INTO kolhoz_ground VALUES("16412","1656","6","1","1355586339","1355587599","1355585559","1","0");
INSERT INTO kolhoz_ground VALUES("16413","1656","6","1","1355586342","1355587627","1355585562","1","0");
INSERT INTO kolhoz_ground VALUES("16414","1657","6","0","1355588425","1355585845","1355585845","1","0");
INSERT INTO kolhoz_ground VALUES("16415","1657","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16416","1657","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16417","1657","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16418","1658","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16419","1658","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16420","1658","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16421","1658","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16422","1659","22","0","1355692012","1355586532","1355586532","1","0");
INSERT INTO kolhoz_ground VALUES("16423","1659","22","0","1355692018","1355586538","1355586538","1","0");
INSERT INTO kolhoz_ground VALUES("16424","1659","22","0","1355692024","1355586544","1355586544","1","0");
INSERT INTO kolhoz_ground VALUES("16425","1659","22","0","1355692032","1355586552","1355586552","1","0");
INSERT INTO kolhoz_ground VALUES("16426","1659","22","0","1355692040","1355586560","1355586560","1","0");
INSERT INTO kolhoz_ground VALUES("16427","1659","22","0","1355692041","1355586561","1355586561","1","0");
INSERT INTO kolhoz_ground VALUES("16428","1660","6","0","1355694137","1355691557","1355691557","1","0");
INSERT INTO kolhoz_ground VALUES("16429","1660","6","0","1355694142","1355691562","1355691562","1","0");
INSERT INTO kolhoz_ground VALUES("16430","1660","6","0","1355694145","1355691565","1355691565","1","0");
INSERT INTO kolhoz_ground VALUES("16431","1660","6","0","1355694159","1355691579","1355691579","1","0");
INSERT INTO kolhoz_ground VALUES("16432","1660","0","0","1355589318","1355586738","1355586738","0","0");
INSERT INTO kolhoz_ground VALUES("16433","1661","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16434","1661","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16435","1661","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16436","1661","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16437","1662","6","1","1355692515","1355693568","1355691735","1","0");
INSERT INTO kolhoz_ground VALUES("16438","1662","6","1","1355692525","1355693574","1355691745","1","0");
INSERT INTO kolhoz_ground VALUES("16439","1662","6","0","1355694333","1355691753","1355691753","1","0");
INSERT INTO kolhoz_ground VALUES("16440","1662","6","0","1355694343","1355691763","1355691763","1","0");
INSERT INTO kolhoz_ground VALUES("16441","1663","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16442","1663","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16443","1663","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16444","1663","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16445","1664","5","1","1355695269","1355696427","1355694489","1","0");
INSERT INTO kolhoz_ground VALUES("16446","1664","5","1","1355695271","1355696429","1355694491","1","0");
INSERT INTO kolhoz_ground VALUES("16447","1664","5","1","1355695272","1355696430","1355694492","1","0");
INSERT INTO kolhoz_ground VALUES("16448","1664","5","1","1355695274","1355696432","1355694494","1","0");
INSERT INTO kolhoz_ground VALUES("16449","1664","5","1","1355695313","1355696433","1355694533","1","0");
INSERT INTO kolhoz_ground VALUES("16450","1665","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16451","1665","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16452","1665","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16453","1665","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16454","1666","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16455","1666","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16456","1666","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16457","1666","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16458","1621","18","0","1355842659","1355762259","1355762259","1","0");
INSERT INTO kolhoz_ground VALUES("16459","1412","37","0","1355944941","1355761461","1355761521","1","0");
INSERT INTO kolhoz_ground VALUES("16460","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16461","1566","14","0","1355810479","1355752879","1355752879","1","0");
INSERT INTO kolhoz_ground VALUES("16462","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16463","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16464","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16465","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16466","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16467","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16468","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16469","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16470","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16471","1569","47","0","1355989764","1355737884","1355738004","1","0");
INSERT INTO kolhoz_ground VALUES("16472","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16473","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16474","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16475","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16476","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16477","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16478","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16479","1621","18","0","1355842659","1355762259","1355762259","1","0");
INSERT INTO kolhoz_ground VALUES("16480","1482","52","0","1355837662","1355759302","1355759422","1","0");
INSERT INTO kolhoz_ground VALUES("16481","1667","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16482","1667","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16483","1667","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16484","1667","0","0","0","0","0","1","0");
INSERT INTO kolhoz_ground VALUES("16485","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16486","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16487","1570","47","0","1356009641","1355757761","1355757881","1","0");
INSERT INTO kolhoz_ground VALUES("16488","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("16489","1091","55","1","1355889597","1355759046","1355755161","1","0");
INSERT INTO kolhoz_ground VALUES("16490","1091","55","1","1355889597","1355759046","1355755161","1","0");



DROP TABLE IF EXISTS `kolhoz_korm`;

CREATE TABLE `kolhoz_korm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_korm VALUES("1","Зерно","50","10","3600","1");
INSERT INTO kolhoz_korm VALUES("2","Комбикорм","100","50","7200","10");
INSERT INTO kolhoz_korm VALUES("3","Муха","350","100","14400","20");
INSERT INTO kolhoz_korm VALUES("4","Рачки","750","400","19440","30");
INSERT INTO kolhoz_korm VALUES("5","Крилевые хлопья","1250","800","129600","40");



DROP TABLE IF EXISTS `kolhoz_level`;

CREATE TABLE `kolhoz_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(1000) DEFAULT '0',
  `rating` varchar(1000) DEFAULT '0',
  `rubies` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_level VALUES("1","2","100","2");
INSERT INTO kolhoz_level VALUES("2","3","250","3");
INSERT INTO kolhoz_level VALUES("3","4","495","4");
INSERT INTO kolhoz_level VALUES("4","5","798","5");
INSERT INTO kolhoz_level VALUES("5","6","1100","6");
INSERT INTO kolhoz_level VALUES("6","7","1500","7");
INSERT INTO kolhoz_level VALUES("7","8","1900","8");
INSERT INTO kolhoz_level VALUES("8","9","2300","9");
INSERT INTO kolhoz_level VALUES("9","10","2800","10");
INSERT INTO kolhoz_level VALUES("10","11","3300","11");
INSERT INTO kolhoz_level VALUES("11","12","3800","12");
INSERT INTO kolhoz_level VALUES("12","13","4400","13");
INSERT INTO kolhoz_level VALUES("13","14","4900","14");
INSERT INTO kolhoz_level VALUES("14","15","5500","15");
INSERT INTO kolhoz_level VALUES("15","16","6100","16");
INSERT INTO kolhoz_level VALUES("16","17","11700","17");
INSERT INTO kolhoz_level VALUES("17","18","21200","18");
INSERT INTO kolhoz_level VALUES("18","19","37100","19");
INSERT INTO kolhoz_level VALUES("19","20","63700","20");
INSERT INTO kolhoz_level VALUES("20","21","107600","21");
INSERT INTO kolhoz_level VALUES("21","22","163300","22");
INSERT INTO kolhoz_level VALUES("22","23","237000","23");
INSERT INTO kolhoz_level VALUES("23","24","398900","24");
INSERT INTO kolhoz_level VALUES("24","25","750100","25");
INSERT INTO kolhoz_level VALUES("25","26","1510000","26");
INSERT INTO kolhoz_level VALUES("26","27","3170000","27");
INSERT INTO kolhoz_level VALUES("27","28","6780000","28");
INSERT INTO kolhoz_level VALUES("28","29","14630000","29");
INSERT INTO kolhoz_level VALUES("29","30","31710000","30");
INSERT INTO kolhoz_level VALUES("30","31","50000000","31");
INSERT INTO kolhoz_level VALUES("31","32","75000000","32");
INSERT INTO kolhoz_level VALUES("32","33","100000000","33");
INSERT INTO kolhoz_level VALUES("33","34","125000000","34");
INSERT INTO kolhoz_level VALUES("34","35","150000000","35");
INSERT INTO kolhoz_level VALUES("35","36","300000000","36");
INSERT INTO kolhoz_level VALUES("36","37","600000000","37");
INSERT INTO kolhoz_level VALUES("37","38","1200000000","38");
INSERT INTO kolhoz_level VALUES("38","39","2400000000","39");
INSERT INTO kolhoz_level VALUES("39","40","4800000000","40");
INSERT INTO kolhoz_level VALUES("40","41","7000000000","41");
INSERT INTO kolhoz_level VALUES("41","42","10000000000","42");
INSERT INTO kolhoz_level VALUES("42","43","15000000000","43");
INSERT INTO kolhoz_level VALUES("43","44","20000000000","44");
INSERT INTO kolhoz_level VALUES("45","45","25000000000","45");
INSERT INTO kolhoz_level VALUES("46","46","30000000000","46");
INSERT INTO kolhoz_level VALUES("47","47","35000000000","47");
INSERT INTO kolhoz_level VALUES("48","48","40000000000","48");
INSERT INTO kolhoz_level VALUES("49","49","45000000000","49");
INSERT INTO kolhoz_level VALUES("50","50","50000000000","50");
INSERT INTO kolhoz_level VALUES("56","51","60000000000","51");
INSERT INTO kolhoz_level VALUES("57","52","70000000000","52");
INSERT INTO kolhoz_level VALUES("58","53","80000000000","53");
INSERT INTO kolhoz_level VALUES("59","54","90000000000","54");
INSERT INTO kolhoz_level VALUES("60","55","100000000000","55");
INSERT INTO kolhoz_level VALUES("61","56","200000000000","56");
INSERT INTO kolhoz_level VALUES("62","57","300000000000","57");
INSERT INTO kolhoz_level VALUES("63","58","400000000000","58");
INSERT INTO kolhoz_level VALUES("64","59","500000000000","59");
INSERT INTO kolhoz_level VALUES("65","60","600000000000","60");
INSERT INTO kolhoz_level VALUES("66","61","700000000000","61");
INSERT INTO kolhoz_level VALUES("67","62","800000000000","62");
INSERT INTO kolhoz_level VALUES("68","63","900000000000","63");
INSERT INTO kolhoz_level VALUES("69","64","1000000000000","65");
INSERT INTO kolhoz_level VALUES("70","65","1100000000000","65");
INSERT INTO kolhoz_level VALUES("71","66","1200000000000","66");
INSERT INTO kolhoz_level VALUES("72","67","1300000000000","67");
INSERT INTO kolhoz_level VALUES("73","68","1400000000000","68");
INSERT INTO kolhoz_level VALUES("74","69","1500000000000","69");
INSERT INTO kolhoz_level VALUES("75","70","1600000000000","70");
INSERT INTO kolhoz_level VALUES("76","71","1700000000000","71");
INSERT INTO kolhoz_level VALUES("77","72","1800000000000","72");
INSERT INTO kolhoz_level VALUES("78","73","1900000000000","73");
INSERT INTO kolhoz_level VALUES("79","74","2000000000000","74");
INSERT INTO kolhoz_level VALUES("80","75","2100000000000","75");



DROP TABLE IF EXISTS `kolhoz_mail`;

CREATE TABLE `kolhoz_mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_kont` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `read` set('0','1') DEFAULT '0',
  `type` enum('at','to') DEFAULT 'to',
  `sistem` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kolhoz_market`;

CREATE TABLE `kolhoz_market` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant2` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `arena` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2648 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_market VALUES("1630","1024","266","5","0");
INSERT INTO kolhoz_market VALUES("1632","1206","253","1","0");
INSERT INTO kolhoz_market VALUES("1636","1200","247","5","0");
INSERT INTO kolhoz_market VALUES("1637","1011","259","1","0");
INSERT INTO kolhoz_market VALUES("1638","1229","266","4","0");
INSERT INTO kolhoz_market VALUES("1769","1352","287","240","0");
INSERT INTO kolhoz_market VALUES("1641","1338","256","21","0");
INSERT INTO kolhoz_market VALUES("1738","1381","247","208","0");
INSERT INTO kolhoz_market VALUES("1661","1319","317","1660","0");
INSERT INTO kolhoz_market VALUES("1649","1338","285","480","0");
INSERT INTO kolhoz_market VALUES("2550","1","317","90","0");
INSERT INTO kolhoz_market VALUES("1665","1351","317","1040","0");
INSERT INTO kolhoz_market VALUES("2442","1547","282","400","0");
INSERT INTO kolhoz_market VALUES("2100","1381","259","144","0");
INSERT INTO kolhoz_market VALUES("2624","1448","284","80","0");
INSERT INTO kolhoz_market VALUES("2149","1411","279","884","0");
INSERT INTO kolhoz_market VALUES("1796","1409","282","80","0");
INSERT INTO kolhoz_market VALUES("1977","1416","266","704","0");
INSERT INTO kolhoz_market VALUES("2504","1454","277","360","0");
INSERT INTO kolhoz_market VALUES("1740","1380","269","36","0");
INSERT INTO kolhoz_market VALUES("1714","1346","287","2160","0");
INSERT INTO kolhoz_market VALUES("2028","1038","259","640","0");
INSERT INTO kolhoz_market VALUES("2475","1373","282","160","0");
INSERT INTO kolhoz_market VALUES("1804","1338","287","2000","0");
INSERT INTO kolhoz_market VALUES("1803","1387","278","160","0");
INSERT INTO kolhoz_market VALUES("1879","1441","287","12","0");
INSERT INTO kolhoz_market VALUES("2480","1337","285","320","0");
INSERT INTO kolhoz_market VALUES("1829","1381","256","384","0");
INSERT INTO kolhoz_market VALUES("1853","1387","254","80","0");
INSERT INTO kolhoz_market VALUES("1870","1387","279","640","0");
INSERT INTO kolhoz_market VALUES("2418","1547","279","80","0");
INSERT INTO kolhoz_market VALUES("1908","1411","259","468","0");
INSERT INTO kolhoz_market VALUES("2448","1416","279","528","0");
INSERT INTO kolhoz_market VALUES("2503","1049","282","480","0");
INSERT INTO kolhoz_market VALUES("2641","1488","282","80","0");
INSERT INTO kolhoz_market VALUES("2498","1402","287","160","0");
INSERT INTO kolhoz_market VALUES("2006","1038","291","80","0");
INSERT INTO kolhoz_market VALUES("1996","1496","291","800","0");
INSERT INTO kolhoz_market VALUES("2191","1521","291","230","0");
INSERT INTO kolhoz_market VALUES("2114","1497","317","80","0");
INSERT INTO kolhoz_market VALUES("2268","1381","282","144","0");
INSERT INTO kolhoz_market VALUES("2630","1390","287","80","0");
INSERT INTO kolhoz_market VALUES("2177","1415","254","80","0");
INSERT INTO kolhoz_market VALUES("2578","1361","266","80","0");
INSERT INTO kolhoz_market VALUES("2408","1553","282","640","0");
INSERT INTO kolhoz_market VALUES("2334","1371","282","320","0");
INSERT INTO kolhoz_market VALUES("2117","1529","307","880","0");
INSERT INTO kolhoz_market VALUES("2350","1516","317","480","0");
INSERT INTO kolhoz_market VALUES("2182","1516","291","240","0");
INSERT INTO kolhoz_market VALUES("2359","1414","317","160","0");
INSERT INTO kolhoz_market VALUES("2233","1388","317","800","0");
INSERT INTO kolhoz_market VALUES("2628","1556","264","80","0");
INSERT INTO kolhoz_market VALUES("2626","1483","282","80","0");
INSERT INTO kolhoz_market VALUES("2441","1374","280","80","0");
INSERT INTO kolhoz_market VALUES("2513","1374","282","320","0");
INSERT INTO kolhoz_market VALUES("2481","1360","317","480","0");
INSERT INTO kolhoz_market VALUES("2642","1353","282","80","0");
INSERT INTO kolhoz_market VALUES("2459","1509","280","352","0");
INSERT INTO kolhoz_market VALUES("2511","1530","264","160","0");
INSERT INTO kolhoz_market VALUES("2521","1350","285","240","0");
INSERT INTO kolhoz_market VALUES("2647","1510","287","80","0");
INSERT INTO kolhoz_market VALUES("2625","1357","285","80","0");
INSERT INTO kolhoz_market VALUES("2608","1417","270","160","0");
INSERT INTO kolhoz_market VALUES("2577","1545","317","160","0");
INSERT INTO kolhoz_market VALUES("2633","1379","309","80","0");



DROP TABLE IF EXISTS `kolhoz_mest`;

CREATE TABLE `kolhoz_mest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant` int(11) DEFAULT '0',
  `soil` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_water` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `cultivator` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1198 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_mest VALUES("555","1004","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("556","1005","7","0","1353291234","1353273654","1353273534","1","0");
INSERT INTO kolhoz_mest VALUES("557","1006","7","0","1353340962","1353323382","1353323262","1","0");
INSERT INTO kolhoz_mest VALUES("558","1007","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("559","1008","7","0","1353324207","1353306627","1353306507","1","0");
INSERT INTO kolhoz_mest VALUES("560","1009","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("561","1010","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("562","1011","7","0","1353337544","1353319964","1353319844","1","0");
INSERT INTO kolhoz_mest VALUES("563","1012","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("564","1013","1","0","1353332082","1353330222","1353330102","1","0");
INSERT INTO kolhoz_mest VALUES("565","1014","7","0","1353342976","1353325396","1353325276","1","0");
INSERT INTO kolhoz_mest VALUES("566","1015","7","0","1353281347","1353263767","1353263647","1","0");
INSERT INTO kolhoz_mest VALUES("567","1016","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("568","1017","8","0","1353332641","1353312961","1353312841","1","0");
INSERT INTO kolhoz_mest VALUES("569","1018","6","0","1353326219","1353311939","1353311819","1","0");
INSERT INTO kolhoz_mest VALUES("570","1019","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("571","1020","7","0","1353346152","1353328572","1353328452","1","0");
INSERT INTO kolhoz_mest VALUES("572","1021","6","0","1353327463","1353313183","1353313063","1","0");
INSERT INTO kolhoz_mest VALUES("573","1022","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("574","1023","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("575","1024","7","0","1353344636","1353327056","1353326936","1","0");
INSERT INTO kolhoz_mest VALUES("576","1025","7","0","1353263025","1353245445","1353245325","1","0");
INSERT INTO kolhoz_mest VALUES("577","1026","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("578","1027","1","0","1353284776","1353282916","1353282796","1","0");
INSERT INTO kolhoz_mest VALUES("579","1028","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("580","1029","7","0","1353275943","1353258363","1353258243","1","0");
INSERT INTO kolhoz_mest VALUES("581","1030","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("582","1031","6","0","1353338580","1353324300","1353324180","1","0");
INSERT INTO kolhoz_mest VALUES("583","1032","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("584","1033","7","0","1353349063","1353331483","1353331363","1","0");
INSERT INTO kolhoz_mest VALUES("585","1034","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("586","1035","7","0","1353334477","1353316897","1353316777","1","0");
INSERT INTO kolhoz_mest VALUES("587","1036","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("588","1037","0","0","1354679508","1354643628","1354643508","1","0");
INSERT INTO kolhoz_mest VALUES("589","1038","10","0","1355166238","1355130358","1355130238","1","0");
INSERT INTO kolhoz_mest VALUES("590","1039","3","0","1353336564","1353326664","1353326604","1","0");
INSERT INTO kolhoz_mest VALUES("591","1040","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("592","1041","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("593","1042","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("594","1043","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("595","1044","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("596","1045","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("597","1046","7","0","1353341457","1353323877","1353323757","1","0");
INSERT INTO kolhoz_mest VALUES("598","1047","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("599","1048","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("600","1049","0","0","1355053587","1355051727","1355051607","0","0");
INSERT INTO kolhoz_mest VALUES("601","1050","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("602","1051","7","0","1353291875","1353274295","1353274175","1","0");
INSERT INTO kolhoz_mest VALUES("603","1052","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("604","1053","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("605","1054","3","0","1353335871","1353325971","1353325911","1","0");
INSERT INTO kolhoz_mest VALUES("606","1055","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("607","1056","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("608","1057","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("609","1058","2","0","1353335990","1353330110","1353329990","1","0");
INSERT INTO kolhoz_mest VALUES("610","1059","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("611","1060","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("612","1061","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("613","1062","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("614","1063","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("615","1064","7","0","1353313836","1353296256","1353296136","1","0");
INSERT INTO kolhoz_mest VALUES("616","1065","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("617","1066","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("618","1067","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("619","1068","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("620","1069","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("621","1070","7","0","1353316846","1353299266","1353299146","1","0");
INSERT INTO kolhoz_mest VALUES("622","1071","8","0","1355393127","1355373447","1355373327","1","0");
INSERT INTO kolhoz_mest VALUES("623","1072","6","0","1353344413","1353330133","1353330013","1","0");
INSERT INTO kolhoz_mest VALUES("624","1073","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("625","1074","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("626","1075","3","0","1353337900","1353328000","1353327940","1","0");
INSERT INTO kolhoz_mest VALUES("627","1076","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("628","1077","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("629","1078","1","0","1353301030","1353299170","1353299050","1","0");
INSERT INTO kolhoz_mest VALUES("630","1079","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("631","1080","7","0","1353348375","1353330795","1353330675","1","0");
INSERT INTO kolhoz_mest VALUES("632","1081","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("633","1082","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("634","1083","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("635","1084","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("636","1085","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("637","1086","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("638","1087","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("639","1088","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("640","1089","7","0","1353344575","1353326995","1353326875","1","0");
INSERT INTO kolhoz_mest VALUES("641","1090","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("642","1091","7","0","1355575699","1355558119","1355557999","1","0");
INSERT INTO kolhoz_mest VALUES("643","1092","7","0","1353269272","1353251692","1353251572","1","0");
INSERT INTO kolhoz_mest VALUES("644","1093","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("645","1094","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("646","1095","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("647","1096","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("648","1097","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("649","1098","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("650","1099","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("651","1100","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("652","1101","5","0","1353341641","1353330361","1353330241","1","0");
INSERT INTO kolhoz_mest VALUES("653","1102","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("654","1103","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("655","1104","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("656","1105","7","0","1353335475","1353317895","1353317775","1","0");
INSERT INTO kolhoz_mest VALUES("657","1106","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("658","1107","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("659","1108","7","0","1353347955","1353330375","1353330255","1","0");
INSERT INTO kolhoz_mest VALUES("660","1109","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("661","1110","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("662","1111","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("663","1112","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("664","1113","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("665","1114","7","0","1353324436","1353306856","1353306736","1","0");
INSERT INTO kolhoz_mest VALUES("666","1115","1","0","1353253162","1353251302","1353251182","1","0");
INSERT INTO kolhoz_mest VALUES("667","1116","6","0","1353344466","1353330186","1353330066","1","0");
INSERT INTO kolhoz_mest VALUES("668","1117","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("669","1118","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("670","1119","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("671","1120","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("672","1121","1","0","1353320749","1353318889","1353318769","1","0");
INSERT INTO kolhoz_mest VALUES("673","1122","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("674","1123","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("675","1124","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("676","1125","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("677","1126","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("678","1127","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("679","1128","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("680","1129","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("681","1130","1","0","1353255557","1353253697","1353253577","1","0");
INSERT INTO kolhoz_mest VALUES("682","1131","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("683","1132","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("684","1133","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("685","1134","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("686","1135","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("687","1136","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("688","1138","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("689","1137","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("690","1139","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("691","1140","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("692","1141","9","0","1355537539","1355507659","1355507539","1","0");
INSERT INTO kolhoz_mest VALUES("693","1142","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("694","1143","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("695","1144","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("696","1145","7","0","1353344260","1353326680","1353326560","1","0");
INSERT INTO kolhoz_mest VALUES("697","1146","6","0","1355571388","1355557108","1355556988","1","0");
INSERT INTO kolhoz_mest VALUES("698","1147","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("699","1148","7","0","1353350616","1353333036","1353332916","1","0");
INSERT INTO kolhoz_mest VALUES("700","1149","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("701","1150","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("702","1151","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("703","1152","7","0","1353350695","1353333115","1353332995","1","0");
INSERT INTO kolhoz_mest VALUES("704","1153","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("705","1154","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("706","1155","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("707","1156","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("708","1157","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("709","1158","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("710","1159","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("711","1160","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("712","1161","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("713","1162","7","0","1353322156","1353304576","1353304456","1","0");
INSERT INTO kolhoz_mest VALUES("714","1163","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("715","1164","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("716","1165","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("717","1166","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("718","1167","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("719","1168","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("720","1169","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("721","1170","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("722","1171","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("723","1172","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("724","1173","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("725","1174","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("726","1175","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("727","1176","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("728","1177","7","0","1353345460","1353327880","1353327760","1","0");
INSERT INTO kolhoz_mest VALUES("729","1178","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("730","1179","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("731","1180","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("732","1181","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("733","1182","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("734","1183","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("735","1184","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("736","1185","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("737","1186","1","0","1353270072","1353268212","1353268092","1","0");
INSERT INTO kolhoz_mest VALUES("738","1187","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("739","1188","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("740","1189","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("741","1190","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("742","1191","3","0","1353279629","1353269729","1353269669","1","0");
INSERT INTO kolhoz_mest VALUES("743","1192","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("744","1193","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("745","1194","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("746","1195","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("747","1196","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("748","1197","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("749","1198","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("750","1199","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("751","1200","7","0","1353348786","1353331206","1353331086","1","0");
INSERT INTO kolhoz_mest VALUES("752","1201","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("753","1202","7","0","1353331924","1353314344","1353314224","1","0");
INSERT INTO kolhoz_mest VALUES("754","1203","7","0","1353337404","1353319824","1353319704","1","0");
INSERT INTO kolhoz_mest VALUES("755","1204","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("756","1205","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("757","1206","7","0","1353297619","1353280039","1353279919","1","0");
INSERT INTO kolhoz_mest VALUES("758","1207","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("759","1208","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("760","1209","7","0","1353324982","1353307402","1353307282","1","0");
INSERT INTO kolhoz_mest VALUES("761","1210","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("762","1211","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("763","1212","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("764","1213","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("765","1214","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("766","1215","6","0","1353338553","1353324273","1353324153","1","0");
INSERT INTO kolhoz_mest VALUES("767","1216","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("768","1217","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("769","1218","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("770","1219","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("771","1220","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("772","1221","7","0","1353355892","1353338312","1353338192","1","0");
INSERT INTO kolhoz_mest VALUES("773","1222","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("774","1223","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("775","1224","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("776","1225","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("777","1226","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("778","1227","7","0","1353295833","1353278253","1353278133","1","0");
INSERT INTO kolhoz_mest VALUES("779","1228","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("780","1229","7","0","1353300976","1353283396","1353283276","1","0");
INSERT INTO kolhoz_mest VALUES("781","1230","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("782","1231","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("783","1232","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("784","1233","2","0","1353333481","1353327601","1353327481","1","0");
INSERT INTO kolhoz_mest VALUES("785","1234","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("786","1235","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("787","1236","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("788","1237","6","0","1353338642","1353324362","1353324242","1","0");
INSERT INTO kolhoz_mest VALUES("789","1238","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("790","1239","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("791","1240","7","0","1353297312","1353279732","1353279612","1","0");
INSERT INTO kolhoz_mest VALUES("792","1241","7","0","1353309490","1353291910","1353291790","1","0");
INSERT INTO kolhoz_mest VALUES("793","1242","7","0","1353298141","1353280561","1353280441","1","0");
INSERT INTO kolhoz_mest VALUES("794","1243","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("795","1244","7","0","1353299145","1353281565","1353281445","1","0");
INSERT INTO kolhoz_mest VALUES("796","1245","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("797","1246","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("798","1247","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("799","1248","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("800","1249","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("801","1250","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("802","1251","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("803","1252","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("804","1253","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("805","1254","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("806","1255","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("807","1256","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("808","1257","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("809","1258","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("810","1259","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("811","1260","1","0","1353302201","1353300341","1353300221","1","0");
INSERT INTO kolhoz_mest VALUES("812","1261","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("813","1262","6","0","1353328843","1353314563","1353314443","1","0");
INSERT INTO kolhoz_mest VALUES("814","1263","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("815","1264","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("816","1265","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("817","1266","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("818","1267","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("819","1268","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("820","1269","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("821","1270","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("822","1271","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("823","1272","7","0","1353350940","1353333360","1353333240","1","0");
INSERT INTO kolhoz_mest VALUES("824","1273","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("825","1274","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("826","1275","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("827","1276","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("828","1277","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("829","1278","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("830","1279","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("831","1280","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("832","1281","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("833","1282","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("834","1283","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("835","1284","3","0","1353342182","1353332282","1353332222","1","0");
INSERT INTO kolhoz_mest VALUES("836","1285","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("837","1286","6","0","1353345910","1353331630","1353331510","1","0");
INSERT INTO kolhoz_mest VALUES("838","1287","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("839","1288","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("840","1289","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("841","1290","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("842","1291","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("843","1292","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("844","1293","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("845","1294","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("846","1295","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("847","1296","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("848","1297","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("849","1298","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("850","1299","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("851","1300","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("852","1301","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("853","1302","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("854","1303","3","0","1353343197","1353333297","1353333237","1","0");
INSERT INTO kolhoz_mest VALUES("855","1304","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("856","1305","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("857","1306","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("858","1307","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("859","1308","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("860","1309","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("861","1310","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("862","1311","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("863","1","10","0","1355596857","1355560977","1355560857","1","0");
INSERT INTO kolhoz_mest VALUES("864","1312","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("865","1313","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("866","1314","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("867","1315","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("868","1316","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("869","1317","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("870","1319","6","0","1354762393","1354748113","1354747993","1","0");
INSERT INTO kolhoz_mest VALUES("871","1336","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("872","1337","10","0","1354733940","1354698060","1354697940","1","0");
INSERT INTO kolhoz_mest VALUES("873","1360","8","0","1354709930","1354690250","1354690130","1","0");
INSERT INTO kolhoz_mest VALUES("874","1346","0","0","1354685239","1354649359","1354649239","1","0");
INSERT INTO kolhoz_mest VALUES("875","1354","0","0","1354669173","1354651593","1354651473","1","0");
INSERT INTO kolhoz_mest VALUES("876","1371","0","0","1354649461","1354647601","1354647481","1","0");
INSERT INTO kolhoz_mest VALUES("877","1373","10","0","1354719480","1354683600","1354683480","1","0");
INSERT INTO kolhoz_mest VALUES("878","1357","0","0","1354714979","1354679099","1354678979","1","0");
INSERT INTO kolhoz_mest VALUES("879","1355","0","0","1354723106","1354705526","1354705406","0","0");
INSERT INTO kolhoz_mest VALUES("880","1328","0","0","1354693145","1354691285","1354691165","1","0");
INSERT INTO kolhoz_mest VALUES("881","1341","0","0","1354706833","1354676953","1354676833","1","0");
INSERT INTO kolhoz_mest VALUES("882","1338","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("883","1366","0","0","1354760188","1354724308","1354724188","0","0");
INSERT INTO kolhoz_mest VALUES("884","1377","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("885","1353","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("886","1350","7","0","1354724217","1354706637","1354706517","1","0");
INSERT INTO kolhoz_mest VALUES("887","1378","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("888","1379","0","0","1354696269","1354660389","1354660269","1","0");
INSERT INTO kolhoz_mest VALUES("889","1351","10","0","1354707251","1354671371","1354671251","1","0");
INSERT INTO kolhoz_mest VALUES("890","1327","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("891","1380","8","0","1354895604","1354875924","1354875804","1","0");
INSERT INTO kolhoz_mest VALUES("892","1381","0","0","1354874450","1354838570","1354838450","1","0");
INSERT INTO kolhoz_mest VALUES("893","1335","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("894","1382","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("895","1352","10","0","1354744558","1354708678","1354708558","1","0");
INSERT INTO kolhoz_mest VALUES("896","1359","8","0","1354719892","1354700212","1354700092","1","0");
INSERT INTO kolhoz_mest VALUES("897","1358","0","0","1355133055","1355127175","1355127055","0","0");
INSERT INTO kolhoz_mest VALUES("898","1367","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("899","1383","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("900","1374","8","0","1354723321","1354703641","1354703521","1","0");
INSERT INTO kolhoz_mest VALUES("901","1384","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("902","1385","10","0","1355376886","1355341006","1355340886","1","0");
INSERT INTO kolhoz_mest VALUES("903","1386","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("904","1387","10","0","1355110975","1355075095","1355074975","1","0");
INSERT INTO kolhoz_mest VALUES("905","1345","2","0","1354704380","1354698500","1354698380","1","0");
INSERT INTO kolhoz_mest VALUES("906","1388","10","0","1354766263","1354730383","1354730263","1","0");
INSERT INTO kolhoz_mest VALUES("907","1389","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("908","1390","0","0","1354730661","1354713081","1354712961","1","0");
INSERT INTO kolhoz_mest VALUES("909","1391","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("910","1392","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("911","1393","5","0","1355061450","1355050170","1355050050","1","0");
INSERT INTO kolhoz_mest VALUES("912","1394","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("913","1395","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("914","1396","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("915","1397","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("916","1398","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("917","1362","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("918","1399","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("919","1400","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("920","1331","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("921","1401","0","0","1354709940","1354708080","1354707960","1","0");
INSERT INTO kolhoz_mest VALUES("922","1402","0","0","1355367334","1355331454","1355331334","0","0");
INSERT INTO kolhoz_mest VALUES("923","1332","0","0","1354923709","1354906129","1354906009","1","0");
INSERT INTO kolhoz_mest VALUES("924","1403","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("925","1404","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("926","1405","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("927","1406","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("928","1407","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("929","1333","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("930","1408","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("931","1409","0","0","1354806785","1354770905","1354770785","0","0");
INSERT INTO kolhoz_mest VALUES("932","1410","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("933","1411","9","0","1354995352","1354965472","1354965352","1","0");
INSERT INTO kolhoz_mest VALUES("934","1412","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("935","1344","9","0","1355585849","1355555969","1355555849","1","0");
INSERT INTO kolhoz_mest VALUES("936","1413","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("937","1365","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("938","1414","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("939","1415","7","0","1354823355","1354805775","1354805655","1","0");
INSERT INTO kolhoz_mest VALUES("940","1342","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("941","1416","10","0","1355467717","1355431837","1355431717","1","0");
INSERT INTO kolhoz_mest VALUES("942","1347","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("943","1417","0","0","1354996141","1354976461","1354976341","0","0");
INSERT INTO kolhoz_mest VALUES("944","1418","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("945","1419","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("946","1420","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("947","1422","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("948","1421","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("949","1423","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("950","1424","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("951","1425","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("952","1326","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("953","1426","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("954","1427","7","0","1355013409","1354995829","1354995709","1","0");
INSERT INTO kolhoz_mest VALUES("955","1428","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("956","1429","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("957","1430","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("958","1431","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("959","1369","0","0","1355149987","1355130307","1355130187","0","0");
INSERT INTO kolhoz_mest VALUES("960","1432","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("961","1433","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("962","1434","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("963","1435","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("964","1436","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("965","1437","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("966","1438","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("967","1439","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("968","1440","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("969","1441","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("970","1442","10","0","1355405843","1355369963","1355369843","1","0");
INSERT INTO kolhoz_mest VALUES("971","1443","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("972","1444","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("973","1445","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("974","1446","10","0","1355422658","1355386778","1355386658","1","0");
INSERT INTO kolhoz_mest VALUES("975","1361","0","0","1355312860","1355293180","1355293060","1","0");
INSERT INTO kolhoz_mest VALUES("976","1447","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("977","1448","0","0","1355199452","1355197592","1355197472","0","0");
INSERT INTO kolhoz_mest VALUES("978","1449","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("979","1450","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("980","1451","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("981","1452","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("982","1453","0","0","1355087443","1355051563","1355051443","1","0");
INSERT INTO kolhoz_mest VALUES("983","1454","10","0","1355568784","1355532904","1355532784","1","0");
INSERT INTO kolhoz_mest VALUES("984","1455","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("985","1456","10","0","1355565092","1355529212","1355529092","1","0");
INSERT INTO kolhoz_mest VALUES("986","1457","10","0","1355346028","1355310148","1355310028","1","0");
INSERT INTO kolhoz_mest VALUES("987","1458","10","0","1355479160","1355443280","1355443160","1","0");
INSERT INTO kolhoz_mest VALUES("988","1459","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("989","1460","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("990","1461","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("991","1462","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("992","1463","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("993","1464","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("994","1465","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("995","1466","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("996","1467","8","0","1355575330","1355555650","1355555530","1","0");
INSERT INTO kolhoz_mest VALUES("997","1468","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("998","1469","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("999","1470","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1000","1471","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1001","1472","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1002","1473","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1003","1474","10","0","1355287254","1355251374","1355251254","1","0");
INSERT INTO kolhoz_mest VALUES("1004","1475","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1005","1476","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1006","1477","10","0","1355301124","1355265244","1355265124","1","0");
INSERT INTO kolhoz_mest VALUES("1007","1478","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1008","1479","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1009","1480","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1010","1481","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1011","1482","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1012","1483","10","0","1355542134","1355506254","1355506134","1","0");
INSERT INTO kolhoz_mest VALUES("1013","1484","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1014","1485","0","0","1355124479","1355106899","1355106779","1","0");
INSERT INTO kolhoz_mest VALUES("1015","1486","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1016","1487","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1017","1488","0","0","1355111489","1355109629","1355109509","1","0");
INSERT INTO kolhoz_mest VALUES("1018","1489","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1019","1490","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1020","1491","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1021","1492","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1022","1493","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1023","1494","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1024","1495","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1025","1496","10","0","1355145741","1355109861","1355109741","1","0");
INSERT INTO kolhoz_mest VALUES("1026","1497","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1027","1498","0","0","1355334385","1355298505","1355298385","0","0");
INSERT INTO kolhoz_mest VALUES("1028","1499","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1029","1500","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1030","1501","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1031","1502","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1032","1503","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1033","1504","9","0","1355092029","1355062149","1355062029","1","0");
INSERT INTO kolhoz_mest VALUES("1034","1505","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1035","1506","0","0","1355174096","1355138216","1355138096","1","0");
INSERT INTO kolhoz_mest VALUES("1036","1507","10","0","1355093708","1355057828","1355057708","1","0");
INSERT INTO kolhoz_mest VALUES("1037","1508","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1038","1509","0","0","1355244425","1355242565","1355242445","1","0");
INSERT INTO kolhoz_mest VALUES("1039","1510","0","0","1355380861","1355369581","1355369461","0","0");
INSERT INTO kolhoz_mest VALUES("1040","1511","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1041","1512","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1042","1513","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1043","1514","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1044","1515","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1045","1516","10","0","1355502251","1355466371","1355466251","1","0");
INSERT INTO kolhoz_mest VALUES("1046","1517","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1047","1518","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1048","1519","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1049","1520","10","0","1355195946","1355160066","1355159946","1","0");
INSERT INTO kolhoz_mest VALUES("1050","1521","10","0","1355514682","1355478802","1355478682","1","0");
INSERT INTO kolhoz_mest VALUES("1051","1522","7","0","1355435324","1355417744","1355417624","1","0");
INSERT INTO kolhoz_mest VALUES("1052","1523","0","0","1355087326","1355085466","1355085346","1","0");
INSERT INTO kolhoz_mest VALUES("1053","1524","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1054","1525","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1055","1526","5","0","1355568115","1355556835","1355556715","1","0");
INSERT INTO kolhoz_mest VALUES("1056","1527","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1057","1528","1","0","1355085908","1355084048","1355083928","1","0");
INSERT INTO kolhoz_mest VALUES("1058","1529","10","0","1355150225","1355114345","1355114225","1","0");
INSERT INTO kolhoz_mest VALUES("1059","1530","10","0","1355520013","1355484133","1355484013","1","0");
INSERT INTO kolhoz_mest VALUES("1060","1531","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1061","1532","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1062","1533","0","0","1355378745","1355361165","1355361045","0","0");
INSERT INTO kolhoz_mest VALUES("1063","1534","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1064","1535","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1065","1536","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1066","1537","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1067","1538","7","0","1355271884","1355254304","1355254184","1","0");
INSERT INTO kolhoz_mest VALUES("1068","1539","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1069","1540","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1070","1541","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1071","1542","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1072","1543","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1073","1544","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1074","1545","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1075","1546","10","0","1355547555","1355511675","1355511555","1","0");
INSERT INTO kolhoz_mest VALUES("1076","1547","1","0","1355556472","1355554612","1355554492","1","0");
INSERT INTO kolhoz_mest VALUES("1077","1548","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1078","1549","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1079","1550","3","0","1355240706","1355230806","1355230746","1","0");
INSERT INTO kolhoz_mest VALUES("1080","1551","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1081","1552","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1082","1553","10","0","1355555768","1355519888","1355519768","1","0");
INSERT INTO kolhoz_mest VALUES("1083","1554","7","0","1355339213","1355321633","1355321513","1","0");
INSERT INTO kolhoz_mest VALUES("1084","1555","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1085","1556","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1086","1557","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1087","1558","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1088","1363","8","0","1355444325","1355424645","1355424525","1","0");
INSERT INTO kolhoz_mest VALUES("1089","1559","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1090","1560","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1091","1561","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1092","1562","6","0","1355412848","1355398568","1355398448","1","0");
INSERT INTO kolhoz_mest VALUES("1093","1563","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1094","1564","7","0","1355560342","1355542762","1355542642","1","0");
INSERT INTO kolhoz_mest VALUES("1095","1565","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1096","1566","7","0","1355567070","1355549490","1355549370","1","0");
INSERT INTO kolhoz_mest VALUES("1097","1567","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1098","1568","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1099","1569","9","0","1355550410","1355520530","1355520410","1","0");
INSERT INTO kolhoz_mest VALUES("1100","1570","8","0","1355539981","1355520301","1355520181","1","0");
INSERT INTO kolhoz_mest VALUES("1101","1571","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1102","1572","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1103","1573","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1104","1574","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1105","1575","1","0","1355472092","1355470232","1355470112","1","0");
INSERT INTO kolhoz_mest VALUES("1106","1576","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1107","1577","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1108","1578","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1109","1579","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1110","1580","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1111","1581","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1112","1582","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1113","1583","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1114","1584","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1115","1585","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1116","1586","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1117","1587","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1118","1588","1","0","1355563098","1355561238","1355561118","1","0");
INSERT INTO kolhoz_mest VALUES("1119","1589","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1120","1590","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1121","1591","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1122","1592","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1123","1593","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1124","1594","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1125","1595","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1126","1596","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1127","1597","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1128","1598","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1129","1599","0","0","0","0","0","1","0");
INSERT INTO kolhoz_mest VALUES("1130","1600","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1131","1601","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1132","1602","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1133","1603","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1134","1604","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1135","1605","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1136","1606","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1137","1607","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1138","1608","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1139","1609","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1140","1610","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1141","1611","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1142","1612","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1143","1613","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1144","1614","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1145","1615","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1146","1616","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1147","1617","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1148","1618","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1149","1619","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1150","1620","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1151","1621","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1152","1622","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1153","1623","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1154","1624","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1155","1625","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1156","1626","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1157","1627","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1158","1628","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1159","1629","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1160","1630","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1161","1631","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1162","1632","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1163","1633","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1164","1634","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1165","1635","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1166","1636","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1167","1637","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1168","1638","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1169","1639","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1170","1640","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1171","1641","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1172","1642","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1173","1643","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1174","1644","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1175","1645","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1176","1646","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1177","1647","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1178","1648","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1179","1649","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1180","1650","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1181","1651","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1182","1652","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1183","1653","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1184","1654","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1185","1655","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1186","1656","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1187","1657","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1188","1658","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1189","1659","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1190","1660","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1191","1661","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1192","1662","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1193","1663","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1194","1664","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1195","1665","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1196","1666","0","0","0","0","0","0","0");
INSERT INTO kolhoz_mest VALUES("1197","1667","0","0","0","0","0","0","0");



DROP TABLE IF EXISTS `kolhoz_pet`;

CREATE TABLE `kolhoz_pet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `money` int(11) DEFAULT '0',
  `rating` varchar(1000) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `work` varchar(1000) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_pet VALUES("1","Шелкопряд","1000","200","300","10","Приносит шелк");
INSERT INTO kolhoz_pet VALUES("2","Курица","10000","500","3000","16","Приносит куриные яйца");
INSERT INTO kolhoz_pet VALUES("4","Гусыня","100000","700","5000","22","Приносит гусиные яйца");
INSERT INTO kolhoz_pet VALUES("5","Корова","150000","700","6000","18","Приносит молоко");
INSERT INTO kolhoz_pet VALUES("6","Овечка","175000","800","8000","20","Приносит шерсть");
INSERT INTO kolhoz_pet VALUES("7","Пчела","250000","1000","10000","24","Приносит мёд");
INSERT INTO kolhoz_pet VALUES("9","Перепелка","1000000","1500","10000","32","Приносит перепелиные яйца");
INSERT INTO kolhoz_pet VALUES("10","Шиншила","1750000","1500","20000","30","Приносит мех");
INSERT INTO kolhoz_pet VALUES("11","Крокодил","20000000","3000","50000","35","Приносит кожу");
INSERT INTO kolhoz_pet VALUES("12","Марал","25000000","5000","75000","36","Приносит рога");
INSERT INTO kolhoz_pet VALUES("13","Лебедь","30000000","6000","65000","38","Приносит пух");
INSERT INTO kolhoz_pet VALUES("14","Фламинго","32000000","10000","100000","38","Участвует в выставках");
INSERT INTO kolhoz_pet VALUES("15","Бобер","35000000","12000","85000","40","Заготавливает древесину");
INSERT INTO kolhoz_pet VALUES("16","Панда","38000000","20000","130000","40","Участвует в выставках");
INSERT INTO kolhoz_pet VALUES("17","Страус","37000000","15000","110000","41","Приносит страусиные яйца");
INSERT INTO kolhoz_pet VALUES("18","Рысь","40000000","26000","170000","41","Участвует в выставках");
INSERT INTO kolhoz_pet VALUES("19","Павлин","39000000","20000","140000","42","Участвует в выставках");
INSERT INTO kolhoz_pet VALUES("20","Лиса","45000000","34000","220000","42","Ворует яйца");
INSERT INTO kolhoz_pet VALUES("21","Сокол","34000000","26000","185000","43","Участвует в соколиной охоте");
INSERT INTO kolhoz_pet VALUES("22","Лев","50000000","44000","285000","43","Участвует в выставках");
INSERT INTO kolhoz_pet VALUES("23","Индюк","55000000","32000","200000","44","Приносит индюшачьи яйца");
INSERT INTO kolhoz_pet VALUES("24","Свинья","60000000","50000","300000","44","Приносит поросят");
INSERT INTO kolhoz_pet VALUES("25","Голубь","58000000","38000","220000","45","Работает почтальоном");
INSERT INTO kolhoz_pet VALUES("26","Лошадь","65000000","60000","320000","45","Участвует в скачках");
INSERT INTO kolhoz_pet VALUES("27","Аист","61000000","40000","230000","46","Работает почтальоном");
INSERT INTO kolhoz_pet VALUES("28","Белка","68000000","65000","340000","46","Заготовляет орешки");
INSERT INTO kolhoz_pet VALUES("29","Чайка","65000000","42000","240000","47","Ловит рыбу");
INSERT INTO kolhoz_pet VALUES("30","Ёжик","70000000","70000","360000","47","Собирает яблоки");
INSERT INTO kolhoz_pet VALUES("31","Пеликан","66000000","44000","250000","48","Ловит рыбу");
INSERT INTO kolhoz_pet VALUES("32","Кенгуру","75000000","75000","380000","48","Приносит кенгурят");
INSERT INTO kolhoz_pet VALUES("33","Попугай","67000000","46000","260000","49","Разговаривает");
INSERT INTO kolhoz_pet VALUES("34","Кролик","80000000","80000","400000","49","Приносит крольчат");
INSERT INTO kolhoz_pet VALUES("35","Сова","68000000","50000","270000","50","Ловит грызунов");
INSERT INTO kolhoz_pet VALUES("36","Верблюд","85000000","85000","420000","50","Дает шерсть");
INSERT INTO kolhoz_pet VALUES("100","Медведь","90000000","90000","440000","52","Приносит медвежью шкуру");
INSERT INTO kolhoz_pet VALUES("101","Попугай экзотический","95000000","95000","460000","54","Приносит экзотические пера");
INSERT INTO kolhoz_pet VALUES("102","Пингвин","100000000","100000","480000","56","Приносит пух");
INSERT INTO kolhoz_pet VALUES("103","Черепаха","110000000","110000","500000","58","Приносит панцири");
INSERT INTO kolhoz_pet VALUES("104","Белый Тигр","130000000","130000","550000","60","Участвует в выставках");



DROP TABLE IF EXISTS `kolhoz_petground`;

CREATE TABLE `kolhoz_petground` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_pet` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_money` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `time_money2` int(11) DEFAULT '0',
  `time_rf` int(11) DEFAULT '0',
  `last_rf` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8664 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_petground VALUES("5669","1006","7","1353529537","1353322772","20","10578","0","1353333350");
INSERT INTO kolhoz_petground VALUES("5670","1006","7","1353529606","1353322828","20","10522","0","1353333350");
INSERT INTO kolhoz_petground VALUES("5671","1006","7","1353529731","1353322842","20","10508","0","1353333350");
INSERT INTO kolhoz_petground VALUES("5672","1006","7","1353529922","1353322864","20","10486","0","1353333350");
INSERT INTO kolhoz_petground VALUES("5673","1005","7","1353567487","1353280172","20","58163","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5674","1005","7","1353567593","1353280153","20","58742","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5675","1005","7","1353567593","1353280153","20","58742","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5676","1005","7","1353567593","1353280153","20","58742","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5677","1008","1","1353587166","1353296517","20","48570","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5678","1008","2","1353587353","1353296517","20","48383","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5679","1008","6","1353588425","1353296517","20","48383","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5680","1008","7","1353578906","1353296517","20","48383","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5681","1015","1","1353544185","1353269454","20","64714","0","1353320899");
INSERT INTO kolhoz_petground VALUES("5682","1015","2","1353544276","1353269454","20","64623","0","1353320899");
INSERT INTO kolhoz_petground VALUES("5683","1015","5","1353544298","1353269454","20","64601","0","1353320899");
INSERT INTO kolhoz_petground VALUES("5684","1015","6","1353544317","1353269454","20","64582","0","1353320899");
INSERT INTO kolhoz_petground VALUES("5685","1025","7","1353530058","1353242781","20","3021","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5686","1025","7","1353530058","1353242787","20","3015","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5687","1025","7","1353530058","1353242796","20","3006","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5688","1025","7","1353530058","1353242804","20","2998","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5689","1014","2","1353532163","1353244146","20","288000","0","1355050412");
INSERT INTO kolhoz_petground VALUES("5690","1014","7","1353535451","1353247413","20","288000","0","1355050412");
INSERT INTO kolhoz_petground VALUES("5691","1014","6","1353532308","1353244213","20","288000","0","1355050412");
INSERT INTO kolhoz_petground VALUES("5692","1014","7","1353535324","1353244727","20","288000","0","1355050412");
INSERT INTO kolhoz_petground VALUES("5693","1025","7","1353530244","1353242813","20","2989","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5694","1025","7","1353530244","1353242822","20","2980","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5695","1025","7","1353530244","1353242834","20","2968","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5696","1015","7","1353544635","1353269454","20","64230","0","1353320899");
INSERT INTO kolhoz_petground VALUES("5697","1017","7","1353617287","1353329941","20","3423","0","1353333348");
INSERT INTO kolhoz_petground VALUES("5698","1017","2","1353617829","1353329941","20","3519","0","1353333348");
INSERT INTO kolhoz_petground VALUES("5699","1017","10","1353605762","1353329941","20","3519","0","1353333348");
INSERT INTO kolhoz_petground VALUES("5700","1017","6","1353607641","1353329941","20","3519","0","1353333348");
INSERT INTO kolhoz_petground VALUES("5701","1006","7","1353374000","1353322697","20","2550","0","1353333350");
INSERT INTO kolhoz_petground VALUES("5702","1025","0","1353530692","1353242845","20","486","0","1353243331");
INSERT INTO kolhoz_petground VALUES("5703","1025","7","1353531298","1353243267","20","2504","0","1353245802");
INSERT INTO kolhoz_petground VALUES("5704","1037","1","1353546101","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5705","1037","1","1353546350","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5706","1037","1","1353546441","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5707","1037","2","1353546482","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5708","1027","7","1353561535","1353273762","20","287773","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5709","1027","7","1353561535","1353273800","20","287735","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5710","1027","7","1353561535","1353274037","20","287498","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5711","1027","7","1353561535","1353274051","20","287484","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5712","1029","7","1353546326","1353263054","20","75368","0","1353338422");
INSERT INTO kolhoz_petground VALUES("5713","1029","6","1353550317","1353262512","20","76105","0","1353338422");
INSERT INTO kolhoz_petground VALUES("5714","1029","7","1353551171","1353263096","20","75251","0","1353338422");
INSERT INTO kolhoz_petground VALUES("5715","1029","7","1353551171","1353263130","20","75251","0","1353338422");
INSERT INTO kolhoz_petground VALUES("5716","1020","7","1353607318","1353321107","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("5717","1020","7","1353607318","1353321108","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("5718","1020","7","1353607318","1353321110","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("5719","1020","7","1353607318","1353321112","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("5720","1027","7","1353561535","1353274086","20","287449","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5721","1027","7","1353562179","1353274115","20","288064","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5722","1037","6","1353546585","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5723","1027","7","1353562179","1353274069","20","288110","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5724","1035","7","1353605027","1353318802","20","5887","0","1353324121");
INSERT INTO kolhoz_petground VALUES("5725","1035","7","1353605406","1353318802","20","5887","0","1353324121");
INSERT INTO kolhoz_petground VALUES("5726","1035","6","1353606101","1353318802","20","6022","0","1353324121");
INSERT INTO kolhoz_petground VALUES("5727","1035","7","1353606214","1353318802","20","5909","0","1353324121");
INSERT INTO kolhoz_petground VALUES("5728","1004","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5729","1004","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5730","1004","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5731","1004","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5732","1037","7","1353547324","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5733","1037","7","1353547324","1355526093","20","0","0","1355762109");
INSERT INTO kolhoz_petground VALUES("5734","1027","7","1353562179","1353274024","20","288155","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5735","1027","7","1353558835","1353271771","20","288000","0","1355422435");
INSERT INTO kolhoz_petground VALUES("5736","1033","7","1353616059","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5737","1033","7","1353619765","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5738","1033","7","1353619765","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5739","1033","7","1353619765","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5740","1069","1","1353591508","1353245833","20","66081","0","1353311989");
INSERT INTO kolhoz_petground VALUES("5741","1069","1","1353591703","1353246088","20","65886","0","1353311989");
INSERT INTO kolhoz_petground VALUES("5742","1069","5","1353591861","1353246247","20","65728","0","1353311989");
INSERT INTO kolhoz_petground VALUES("5743","1069","2","1353591784","1353246174","20","65805","0","1353311989");
INSERT INTO kolhoz_petground VALUES("5744","1033","7","1353619765","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5745","1033","7","1353619765","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5746","1063","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5747","1063","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5748","1063","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5749","1063","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5750","1064","5","1353584267","1353296090","20","12080","0","1353296526");
INSERT INTO kolhoz_petground VALUES("5751","1064","6","1353584093","1353296386","20","311","0","1353296526");
INSERT INTO kolhoz_petground VALUES("5752","1064","6","1353584093","1353296393","20","297","0","1353296526");
INSERT INTO kolhoz_petground VALUES("5753","1064","7","1353584093","1353296078","20","433","0","1353296526");
INSERT INTO kolhoz_petground VALUES("5754","1072","7","1353626099","1353338275","20","142","0","1353338417");
INSERT INTO kolhoz_petground VALUES("5755","1072","7","1353612069","1353338300","20","117","0","1353338417");
INSERT INTO kolhoz_petground VALUES("5756","1072","7","1353612561","1353338316","20","101","0","1353338417");
INSERT INTO kolhoz_petground VALUES("5757","1072","7","1353612745","1353324881","20","13536","0","1353338417");
INSERT INTO kolhoz_petground VALUES("5758","1014","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5759","1051","1","1353560574","1353272516","20","288000","0","1355579709");
INSERT INTO kolhoz_petground VALUES("5760","1051","1","1353560821","1353272632","20","288000","0","1355579709");
INSERT INTO kolhoz_petground VALUES("5761","1051","2","1353560821","1353273044","20","287777","0","1355579709");
INSERT INTO kolhoz_petground VALUES("5762","1051","5","1353561250","1353273123","20","288000","0","1355579709");
INSERT INTO kolhoz_petground VALUES("5763","1078","2","1353579922","1353299013","20","8143","0","1353300340");
INSERT INTO kolhoz_petground VALUES("5764","1078","2","1353580036","1353299013","20","8089","0","1353300340");
INSERT INTO kolhoz_petground VALUES("5765","1078","2","1353580036","1353299013","20","8121","0","1353300340");
INSERT INTO kolhoz_petground VALUES("5766","1078","2","1353580036","1353299013","20","8162","0","1353300340");
INSERT INTO kolhoz_petground VALUES("5767","1054","7","1353615586","1353330613","20","3747","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5768","1054","7","1353615749","1353330613","20","5268","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5769","1054","7","1353615848","1353330613","20","5232","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5770","1054","7","1353616032","1353330613","20","5214","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5771","1024","1","1353582719","1353323905","20","14669","0","1353338188");
INSERT INTO kolhoz_petground VALUES("5772","1024","1","1353582719","1353323905","20","14669","0","1353338188");
INSERT INTO kolhoz_petground VALUES("5773","1024","1","1353582719","1353323905","20","14669","0","1353338188");
INSERT INTO kolhoz_petground VALUES("5774","1024","1","1353582719","1353323905","20","14669","0","1353338188");
INSERT INTO kolhoz_petground VALUES("5775","1035","7","1353604228","1353318802","20","5909","0","1353324121");
INSERT INTO kolhoz_petground VALUES("5776","1078","2","1353580344","1353299013","20","7996","0","1353300340");
INSERT INTO kolhoz_petground VALUES("5777","1078","2","1353580344","1353299013","20","7996","0","1353300340");
INSERT INTO kolhoz_petground VALUES("5778","1054","7","1353616206","1353330613","20","5006","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5779","1054","7","1353616206","1353330613","20","5006","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5780","1054","7","1353616352","1353330613","20","4860","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5781","1089","7","1353610175","1353326357","20","5928","0","1353332285");
INSERT INTO kolhoz_petground VALUES("5782","1089","7","1353611226","1353326134","20","6151","0","1353332285");
INSERT INTO kolhoz_petground VALUES("5783","1089","7","1353611425","1353326076","20","6209","0","1353332285");
INSERT INTO kolhoz_petground VALUES("5784","1089","7","1353611938","1353326286","20","5999","0","1353332285");
INSERT INTO kolhoz_petground VALUES("5785","1092","1","1353538190","1353250160","20","7762","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5786","1092","2","1353538311","1353250705","20","7247","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5787","1092","6","1353538822","1353250811","20","7130","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5788","1092","6","1353538870","1353250859","20","7082","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5789","1092","7","1353538939","1353250884","20","7013","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5790","1092","7","1353538963","1353250893","20","6989","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5791","1092","7","1353538963","1353250899","20","6989","0","1353257952");
INSERT INTO kolhoz_petground VALUES("5792","1061","2","1353607158","1353319103","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5793","1061","2","1353607158","1353319107","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5794","1061","2","1353607158","1353319114","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5795","1061","2","1353607158","1353319121","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5796","1109","1","1353538831","1353250669","20","79251","0","1353330081");
INSERT INTO kolhoz_petground VALUES("5797","1109","1","1353539286","1353250683","20","78796","0","1353330081");
INSERT INTO kolhoz_petground VALUES("5798","1109","5","1353539595","1353251815","20","78266","0","1353330081");
INSERT INTO kolhoz_petground VALUES("5799","1109","6","1353539886","1353251940","20","78141","0","1353330081");
INSERT INTO kolhoz_petground VALUES("5800","1118","1","1353538826","1353250721","20","1491","0","1353252317");
INSERT INTO kolhoz_petground VALUES("5801","1118","1","1353538871","1353250851","20","1446","0","1353252317");
INSERT INTO kolhoz_petground VALUES("5802","1118","1","1353538918","1353250892","20","1399","0","1353252317");
INSERT INTO kolhoz_petground VALUES("5803","1118","2","1353538965","1353250940","20","1352","0","1353252317");
INSERT INTO kolhoz_petground VALUES("5804","1109","7","1353544096","1353256077","20","73985","0","1353330081");
INSERT INTO kolhoz_petground VALUES("5805","1115","1","1353539120","1353250978","20","16057","0","1353267177");
INSERT INTO kolhoz_petground VALUES("5806","1115","1","1353539120","1353250986","20","16057","0","1353267177");
INSERT INTO kolhoz_petground VALUES("5807","1115","2","1353539212","1353251347","20","15830","0","1353267177");
INSERT INTO kolhoz_petground VALUES("5808","1115","2","1353539393","1353251378","20","15784","0","1353267177");
INSERT INTO kolhoz_petground VALUES("5809","1031","6","1353611329","1355579953","20","10037","0","1355583928");
INSERT INTO kolhoz_petground VALUES("5810","1031","6","1353609694","1355579967","20","8372","0","1355583928");
INSERT INTO kolhoz_petground VALUES("5811","1031","6","1353610518","1353313393","20","297125","0","1355583928");
INSERT INTO kolhoz_petground VALUES("5812","1031","6","1353610993","1353313404","20","297589","0","1355583928");
INSERT INTO kolhoz_petground VALUES("5813","1058","7","1355991221","1355760739","20","6408","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5814","1058","7","1355991221","1355760743","20","11496","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5815","1058","7","1355991221","1355761524","20","1392","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5816","1058","7","1355991221","1355761639","20","1392","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5817","1031","6","1353601394","1353313432","20","287962","0","1355583928");
INSERT INTO kolhoz_petground VALUES("5818","1118","6","1353539074","1353251054","20","1243","0","1353252317");
INSERT INTO kolhoz_petground VALUES("5819","1024","5","1353582899","1353323905","20","14489","0","1353338188");
INSERT INTO kolhoz_petground VALUES("5820","1114","1","1353583093","1353306667","20","11691","0","1353306784");
INSERT INTO kolhoz_petground VALUES("5821","1114","1","1353583869","1353306669","20","10915","0","1353306784");
INSERT INTO kolhoz_petground VALUES("5822","1114","2","1353584039","1353306669","20","10745","0","1353306784");
INSERT INTO kolhoz_petground VALUES("5823","1114","5","1353584235","1353306672","20","10549","0","1353306784");
INSERT INTO kolhoz_petground VALUES("5824","1108","7","1353612157","1353328670","20","12914","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5825","1108","7","1353604991","1353328670","20","12884","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5826","1108","7","1353604991","1353328670","20","12868","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5827","1108","7","1353604991","1353328670","20","12794","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5828","1121","6","1353554352","1353324880","20","4212","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5829","1121","5","1353554358","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5830","1121","7","1353554629","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5831","1121","7","1353554633","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5832","1017","6","1353612105","1353329941","20","3519","0","1353333348");
INSERT INTO kolhoz_petground VALUES("5833","1074","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5834","1074","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5835","1074","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5836","1074","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5837","1121","7","1353554713","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5838","1121","7","1353554713","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5839","1064","7","1353584093","1353296087","20","433","0","1353296526");
INSERT INTO kolhoz_petground VALUES("5840","1130","1","1353541261","1353252935","20","2093","0","1353255354");
INSERT INTO kolhoz_petground VALUES("5841","1130","1","1353541261","1353253089","20","2093","0","1353255354");
INSERT INTO kolhoz_petground VALUES("5842","1130","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5843","1130","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5844","1105","7","1353601012","1353317539","20","1636","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5845","1105","7","1353601468","1353317539","20","1636","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5846","1105","7","1353604361","1353317539","20","1636","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5847","1105","7","1353604512","1353317539","20","1636","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5848","1108","7","1353612820","1353328670","20","12749","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5849","1134","7","1353540964","1353253474","20","19","0","1353253493");
INSERT INTO kolhoz_petground VALUES("5850","1134","0","1353540988","1353252976","20","131","0","1353253119");
INSERT INTO kolhoz_petground VALUES("5851","1134","0","1353541034","1353253019","20","95","0","1353253129");
INSERT INTO kolhoz_petground VALUES("5852","1134","0","1353541065","1353253052","20","69","0","1353253134");
INSERT INTO kolhoz_petground VALUES("5853","1134","6","1353541099","1353253082","20","394","0","1353253493");
INSERT INTO kolhoz_petground VALUES("5854","1134","6","1353541193","1353253178","20","300","0","1353253493");
INSERT INTO kolhoz_petground VALUES("5855","1115","4","1353540942","1353252930","20","14235","0","1353267177");
INSERT INTO kolhoz_petground VALUES("5856","1134","7","1353541427","1353253222","20","66","0","1353253493");
INSERT INTO kolhoz_petground VALUES("5857","1011","6","1353613454","1353319887","20","293567","0","1355578346");
INSERT INTO kolhoz_petground VALUES("5858","1011","6","1353617452","1353319905","20","297547","0","1355578346");
INSERT INTO kolhoz_petground VALUES("5859","1011","6","1353613314","1353319916","20","293398","0","1355578346");
INSERT INTO kolhoz_petground VALUES("5860","1011","2","1353620715","1353320019","20","302400","0","1355578346");
INSERT INTO kolhoz_petground VALUES("5861","1108","5","1353613375","1353328670","20","12749","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5862","1134","7","1353541427","1353253238","20","66","0","1353253493");
INSERT INTO kolhoz_petground VALUES("5863","1134","7","1353541427","1353253256","20","66","0","1353253493");
INSERT INTO kolhoz_petground VALUES("5864","1114","7","1353585222","1353306673","20","9562","0","1353306784");
INSERT INTO kolhoz_petground VALUES("5865","1105","7","1353605477","1353317539","20","1686","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5866","1105","7","1353591166","1353317539","20","1686","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5867","1101","2","1353373627","1353255697","3","43249","0","1353331239");
INSERT INTO kolhoz_petground VALUES("5868","1101","2","1353373627","1353255716","3","43340","0","1353331239");
INSERT INTO kolhoz_petground VALUES("5869","1101","2","1353344827","1353278476","1","812","0","1353331239");
INSERT INTO kolhoz_petground VALUES("5870","1101","2","1353344827","1353278491","1","812","0","1353331239");
INSERT INTO kolhoz_petground VALUES("5871","1116","2","1353352582","1353324823","2","6442","0","1353331134");
INSERT INTO kolhoz_petground VALUES("5872","1116","2","1353352612","1353324828","2","6404","0","1353331134");
INSERT INTO kolhoz_petground VALUES("5873","1116","2","1353352222","1353324405","2","6789","0","1353331134");
INSERT INTO kolhoz_petground VALUES("5874","1116","2","1353352647","1353324832","2","6397","0","1353331134");
INSERT INTO kolhoz_petground VALUES("5875","1108","6","1353604991","1353328670","20","12749","0","1353331521");
INSERT INTO kolhoz_petground VALUES("5876","1116","2","1353611867","1353324841","20","6365","0","1353331134");
INSERT INTO kolhoz_petground VALUES("5877","1145","1","1353601307","1353326522","20","16067","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5878","1145","6","1353601444","1353326522","20","15930","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5879","1145","2","1353601366","1353326522","20","16008","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5880","1145","7","1353601545","1353326522","20","15829","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5881","1101","2","1353344827","1353278523","1","812","0","1353331239");
INSERT INTO kolhoz_petground VALUES("5882","1114","7","1353590306","1353306675","20","4478","0","1353306784");
INSERT INTO kolhoz_petground VALUES("5883","1145","7","1353601633","1353326522","20","15741","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5884","1070","1","1353545306","1353257283","20","41947","0","1353299253");
INSERT INTO kolhoz_petground VALUES("5885","1070","1","1353545405","1353257389","20","41848","0","1353299253");
INSERT INTO kolhoz_petground VALUES("5886","1070","2","1353545447","1353257431","20","41806","0","1353299253");
INSERT INTO kolhoz_petground VALUES("5887","1070","6","1353545642","1353257628","20","41611","0","1353299253");
INSERT INTO kolhoz_petground VALUES("5888","1089","7","1353545000","1353325825","20","17685","0","1353332285");
INSERT INTO kolhoz_petground VALUES("5889","1089","7","1353617027","1353329200","20","3258","0","1353332285");
INSERT INTO kolhoz_petground VALUES("5890","1054","7","1353617471","1353330613","20","3741","0","1353333212");
INSERT INTO kolhoz_petground VALUES("5891","1145","7","1353603444","1353326522","20","13930","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5892","1145","7","1353340927","1353326522","1","16827","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5893","1145","7","1353340927","1353326522","1","16827","0","1353329374");
INSERT INTO kolhoz_petground VALUES("5894","1070","7","1353546170","1353258138","20","41083","0","1353299253");
INSERT INTO kolhoz_petground VALUES("5895","1091","7","1356033131","1355755020","20","12998","0","1355757860");
INSERT INTO kolhoz_petground VALUES("5896","1091","7","1356033131","1355755020","20","12980","0","1355757860");
INSERT INTO kolhoz_petground VALUES("5897","1091","7","1356033131","1355755020","20","13097","0","1355757860");
INSERT INTO kolhoz_petground VALUES("5898","1091","7","1356033131","1355755020","20","13413","0","1355757860");
INSERT INTO kolhoz_petground VALUES("5899","1049","12","1356040570","1355759716","20","4386","0","1355762192");
INSERT INTO kolhoz_petground VALUES("5900","1049","12","1356040570","1355759716","20","4386","0","1355762192");
INSERT INTO kolhoz_petground VALUES("5901","1049","12","1356040570","1355759716","20","4386","0","1355762192");
INSERT INTO kolhoz_petground VALUES("5902","1049","12","1356040570","1355759716","20","4386","0","1355762192");
INSERT INTO kolhoz_petground VALUES("5903","1033","7","1353619765","1353332289","20","1061","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5904","1105","7","1353591375","1353317539","20","1686","0","1353319163");
INSERT INTO kolhoz_petground VALUES("5905","1131","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5906","1131","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5907","1131","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5908","1131","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5909","1033","7","1353620245","1353332289","20","1101","0","1353333346");
INSERT INTO kolhoz_petground VALUES("5910","1165","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5911","1165","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5912","1165","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5913","1165","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5914","1080","1","1353593299","1353330091","20","10985","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5915","1080","1","1353593299","1353330092","20","10985","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5916","1080","1","1353593299","1353330094","20","10985","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5917","1080","1","1353593366","1353330094","20","10918","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5918","1080","1","1353593366","1353330095","20","10918","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5919","1080","1","1353593366","1353330096","20","10918","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5920","1080","1","1353593402","1353330097","20","10882","0","1353330684");
INSERT INTO kolhoz_petground VALUES("5921","1079","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5922","1079","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5923","1079","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5924","1079","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5925","1058","7","1355991221","1355761687","20","1392","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5926","1058","7","1355991221","1355761692","20","1392","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5927","1058","7","1355991221","1355761657","20","1392","0","1355762209");
INSERT INTO kolhoz_petground VALUES("5928","1162","4","1353586636","1353294075","20","10678","0","1353304753");
INSERT INTO kolhoz_petground VALUES("5929","1162","4","1353586636","1353294120","20","10633","0","1353304753");
INSERT INTO kolhoz_petground VALUES("5930","1162","4","1353586636","1353294140","20","10613","0","1353304753");
INSERT INTO kolhoz_petground VALUES("5931","1162","4","1353586636","1353294160","20","10593","0","1353304753");
INSERT INTO kolhoz_petground VALUES("5932","1008","7","1353580306","1353296517","20","41030","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5933","1141","10","1355791410","1355507597","20","13072","0","1355508423");
INSERT INTO kolhoz_petground VALUES("5934","1141","10","1355791457","1355507597","20","13052","0","1355508423");
INSERT INTO kolhoz_petground VALUES("5935","1141","10","1355791573","1355507597","20","12957","0","1355508423");
INSERT INTO kolhoz_petground VALUES("5936","1141","7","1355794408","1355507597","20","2015","0","1355508423");
INSERT INTO kolhoz_petground VALUES("5937","1162","4","1353586636","1353294180","20","10573","0","1353304753");
INSERT INTO kolhoz_petground VALUES("5938","1160","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5939","1160","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5940","1160","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5941","1160","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5942","1008","7","1353580306","1353296517","20","41030","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5943","1008","7","1353580306","1353296517","20","41030","0","1353333336");
INSERT INTO kolhoz_petground VALUES("5944","1121","7","1353555380","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5945","1121","7","1353555380","1353324880","20","4253","0","1353329087");
INSERT INTO kolhoz_petground VALUES("5946","1005","7","1353567593","1353280153","20","58742","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5947","1005","7","1353567593","1353280153","20","58742","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5948","1005","7","1353567593","1353280153","20","58742","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5949","1005","7","1353567724","1353280153","20","58611","0","1353338335");
INSERT INTO kolhoz_petground VALUES("5950","1029","7","1353552245","1353264182","20","74177","0","1353338422");
INSERT INTO kolhoz_petground VALUES("5951","1148","0","1353593575","1353306022","20","529","0","1353306551");
INSERT INTO kolhoz_petground VALUES("5952","1148","0","1353594481","1353306581","20","669","0","1353307250");
INSERT INTO kolhoz_petground VALUES("5953","1148","0","1353594684","1353306602","20","573","0","1353307257");
INSERT INTO kolhoz_petground VALUES("5954","1148","0","1353595229","1353307213","20","35","0","1353307264");
INSERT INTO kolhoz_petground VALUES("5955","1061","2","1353607158","1353319138","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5956","1061","2","1353607158","1353319146","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5957","1061","2","1353607158","1353319155","20","5348","0","1353324506");
INSERT INTO kolhoz_petground VALUES("5958","1186","1","1353553394","1353265326","20","2708","0","1353268102");
INSERT INTO kolhoz_petground VALUES("5959","1186","1","1353553394","1353265334","20","2708","0","1353268102");
INSERT INTO kolhoz_petground VALUES("5960","1186","1","1353553394","1353265343","20","2708","0","1353268102");
INSERT INTO kolhoz_petground VALUES("5961","1186","1","1353553394","1353265353","20","2708","0","1353268102");
INSERT INTO kolhoz_petground VALUES("5962","1177","7","1353611214","1353325485","20","7481","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5963","1177","7","1353611237","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5964","1177","7","1353611237","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5965","1177","7","1353611237","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5966","1177","7","1353611237","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5967","1177","7","1353611237","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5968","1075","7","1353611481","1353327148","20","2332","0","1353328757");
INSERT INTO kolhoz_petground VALUES("5969","1075","7","1353612071","1353327148","20","2292","0","1353328757");
INSERT INTO kolhoz_petground VALUES("5970","1075","7","1353612577","1353327148","20","3155","0","1353328757");
INSERT INTO kolhoz_petground VALUES("5971","1075","7","1353612722","1353327148","20","3097","0","1353328757");
INSERT INTO kolhoz_petground VALUES("5972","1186","5","1353553822","1353265808","20","2280","0","1353268102");
INSERT INTO kolhoz_petground VALUES("5973","1075","7","1353612840","1353327148","20","3033","0","1353328757");
INSERT INTO kolhoz_petground VALUES("5974","1036","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5975","1036","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5976","1036","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5977","1036","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5978","1075","7","1353613271","1353327148","20","3010","0","1353328757");
INSERT INTO kolhoz_petground VALUES("5979","1156","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5980","1156","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5981","1156","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5982","1156","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("5983","1177","7","1353612640","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("5984","1191","1","1353557154","1353268677","20","468","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5985","1191","1","1353557170","1353268691","20","452","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5986","1191","1","1353557170","1353268713","20","452","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5987","1191","1","1353557170","1353268745","20","452","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5988","1191","1","1353557288","1353269224","20","334","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5989","1191","1","1353557288","1353269251","20","334","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5990","1191","1","1353557288","1353269278","20","334","0","1353269622");
INSERT INTO kolhoz_petground VALUES("5991","1200","1","1353615995","1353284809","20","48552","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5992","1200","1","1353616107","1353270500","20","62840","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5993","1200","1","1353616123","1353270521","20","62824","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5994","1200","2","1353616161","1353270556","20","62786","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5995","1031","6","1353601688","1353313449","20","288239","0","1355583928");
INSERT INTO kolhoz_petground VALUES("5996","1200","7","1353616473","1353274401","20","58946","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5997","1200","6","1353616984","1353271378","20","61963","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5998","1200","7","1353617229","1353271615","20","61718","0","1353333347");
INSERT INTO kolhoz_petground VALUES("5999","1020","7","1353607318","1353321112","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("6000","1206","5","1353606029","1353310669","20","28844","0","1353332706");
INSERT INTO kolhoz_petground VALUES("6001","1206","5","1353606029","1353310669","20","28838","0","1353332706");
INSERT INTO kolhoz_petground VALUES("6002","1206","5","1353606029","1353310669","20","28832","0","1353332706");
INSERT INTO kolhoz_petground VALUES("6003","1206","5","1353606029","1353310669","20","28826","0","1353332706");
INSERT INTO kolhoz_petground VALUES("6004","1202","1","1353560905","1353318323","20","15713","0","1353331818");
INSERT INTO kolhoz_petground VALUES("6005","1202","1","1353561072","1353318326","20","15546","0","1353331818");
INSERT INTO kolhoz_petground VALUES("6006","1202","2","1353561145","1353318329","20","15473","0","1353331818");
INSERT INTO kolhoz_petground VALUES("6007","1202","6","1353561339","1353318333","20","15237","0","1353331818");
INSERT INTO kolhoz_petground VALUES("6008","1210","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6009","1210","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6010","1210","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6011","1210","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6012","1051","5","1353561250","1353273140","20","288000","0","1355579709");
INSERT INTO kolhoz_petground VALUES("6013","1051","5","1353561250","1353273160","20","288000","0","1355579709");
INSERT INTO kolhoz_petground VALUES("6014","1208","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6015","1208","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6016","1208","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6017","1208","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6018","1114","7","1353590358","1353306677","20","4426","0","1353306784");
INSERT INTO kolhoz_petground VALUES("6019","1202","4","1353561615","1353318349","20","15003","0","1353331818");
INSERT INTO kolhoz_petground VALUES("6020","1202","4","1353561672","1353318338","20","14946","0","1353331818");
INSERT INTO kolhoz_petground VALUES("6021","1114","7","1353590466","1353306679","20","4318","0","1353306784");
INSERT INTO kolhoz_petground VALUES("6022","1211","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6023","1211","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6024","1211","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6025","1211","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6026","1209","7","1353605687","1353316248","20","17099","0","1353333347");
INSERT INTO kolhoz_petground VALUES("6027","1209","0","1353591367","1353309400","20","12637","0","1353316004");
INSERT INTO kolhoz_petground VALUES("6028","1209","0","1353591440","1353309402","20","12627","0","1353316067");
INSERT INTO kolhoz_petground VALUES("6029","1209","0","1353591552","1353309404","20","12542","0","1353316094");
INSERT INTO kolhoz_petground VALUES("6030","1209","0","1353591708","1353309406","20","12404","0","1353316112");
INSERT INTO kolhoz_petground VALUES("6031","1209","7","1353606562","1353309410","20","29185","0","1353333347");
INSERT INTO kolhoz_petground VALUES("6032","1209","7","1353606646","1353309417","20","29101","0","1353333347");
INSERT INTO kolhoz_petground VALUES("6033","1209","7","1353606646","1353309419","20","29101","0","1353333347");
INSERT INTO kolhoz_petground VALUES("6034","1206","5","1353606315","1353310669","20","28791","0","1353332706");
INSERT INTO kolhoz_petground VALUES("6035","1206","5","1353606367","1353310669","20","28739","0","1353332706");
INSERT INTO kolhoz_petground VALUES("6036","1227","1","1353608619","1353277404","20","54695","0","1353332114");
INSERT INTO kolhoz_petground VALUES("6037","1227","1","1353608718","1353277507","20","54596","0","1353332114");
INSERT INTO kolhoz_petground VALUES("6038","1227","2","1353608803","1353277627","20","54487","0","1353332114");
INSERT INTO kolhoz_petground VALUES("6039","1227","2","1353608896","1353277632","20","54418","0","1353332114");
INSERT INTO kolhoz_petground VALUES("6040","1229","1","1353564329","1353276228","20","56839","0","1353333168");
INSERT INTO kolhoz_petground VALUES("6041","1229","1","1353564346","1353276341","20","56822","0","1353333168");
INSERT INTO kolhoz_petground VALUES("6042","1229","1","1353564366","1353276359","20","56802","0","1353333168");
INSERT INTO kolhoz_petground VALUES("6043","1229","2","1353564402","1353276385","20","56766","0","1353333168");
INSERT INTO kolhoz_petground VALUES("6044","1229","2","1353564402","1353276390","20","56766","0","1353333168");
INSERT INTO kolhoz_petground VALUES("6045","1203","7","1353608054","1353302366","20","43691","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6046","1203","7","1353608088","1353302372","20","43643","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6047","1203","7","1353595579","1353319986","20","18435","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6048","1203","7","1353608418","1353320007","20","18003","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6049","1203","7","1353608418","1353320031","20","18003","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6050","1203","7","1353608418","1353320108","20","18003","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6051","1221","5","1353623323","1353338039","20","2903","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6052","1221","5","1353623391","1353338039","20","2894","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6053","1221","5","1353623391","1353338039","20","2884","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6054","1221","5","1353623472","1353338039","20","2876","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6055","1230","1","1353565953","1353277545","20","1361","0","1353279314");
INSERT INTO kolhoz_petground VALUES("6056","1230","1","1353565986","1353277558","20","1328","0","1353279314");
INSERT INTO kolhoz_petground VALUES("6057","1230","5","1353566048","1353278238","20","1076","0","1353279314");
INSERT INTO kolhoz_petground VALUES("6058","1230","6","1353566300","1353278292","20","1014","0","1353279314");
INSERT INTO kolhoz_petground VALUES("6059","1221","5","1353623588","1353338039","20","2836","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6060","1024","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6061","1227","7","1353609285","1353278069","20","54029","0","1353332114");
INSERT INTO kolhoz_petground VALUES("6062","1200","7","1353609467","1353278251","20","55080","0","1353333347");
INSERT INTO kolhoz_petground VALUES("6063","1240","1","1353567385","1353279355","20","53137","0","1353332522");
INSERT INTO kolhoz_petground VALUES("6064","1240","1","1353567403","1353279398","20","53119","0","1353332522");
INSERT INTO kolhoz_petground VALUES("6065","1240","2","1353567424","1353279442","20","53080","0","1353332522");
INSERT INTO kolhoz_petground VALUES("6066","1240","5","1353567463","1353279458","20","53059","0","1353332522");
INSERT INTO kolhoz_petground VALUES("6067","1240","6","1353567527","1353279523","20","52995","0","1353332522");
INSERT INTO kolhoz_petground VALUES("6068","1242","1","1353568093","1353280059","20","398","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6069","1242","1","1353568118","1353280105","20","373","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6070","1242","2","1353568137","1353280154","20","337","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6071","1242","5","1353568186","1353280180","20","305","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6072","1242","6","1353568206","1353280199","20","285","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6073","1242","4","1353568247","1353280242","20","244","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6074","1221","7","1353625916","1353338039","20","2836","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6075","1242","6","1353568277","1353280267","20","214","0","1353280491");
INSERT INTO kolhoz_petground VALUES("6076","1244","1","1353569162","1353281177","20","353","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6077","1244","2","1353569269","1353281263","20","261","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6078","1244","6","1353569301","1353281294","20","229","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6079","1244","7","1353569388","1353281322","20","142","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6080","1244","7","1353569388","1353281342","20","142","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6081","1244","7","1353569388","1353281351","20","142","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6082","1244","7","1353569388","1353281375","20","142","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6083","1244","7","1353569388","1353281368","20","142","0","1353281530");
INSERT INTO kolhoz_petground VALUES("6084","1233","6","1353615386","1353328420","20","3887","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6085","1233","6","1353615393","1353328420","20","3887","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6086","1233","6","1353615398","1353328420","20","3887","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6087","1233","6","1353615403","1353328420","20","3887","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6088","1233","7","1353615426","1353328420","20","3887","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6089","1241","7","1353589459","1353303534","20","13966","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6090","1241","7","1353589496","1353303534","20","13995","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6091","1241","7","1353589523","1353303534","20","13976","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6092","1241","7","1353589561","1353303534","20","13976","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6093","1215","5","1353616565","1353328716","20","2908","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6094","1215","6","1353616587","1353328716","20","2908","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6095","1215","7","1353616599","1353328716","20","2908","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6096","1215","6","1353616615","1353328716","20","2908","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6097","1215","7","1353617041","1353328716","20","2908","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6098","1233","6","1353617609","1353328420","20","3895","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6099","1215","6","1353617773","1353328716","20","2908","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6100","1233","6","1353617828","1353328420","20","3895","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6101","1237","5","1353613172","1353318534","20","14832","0","1353333366");
INSERT INTO kolhoz_petground VALUES("6102","1237","5","1353615288","1353318632","20","14734","0","1353333366");
INSERT INTO kolhoz_petground VALUES("6103","1237","5","1353619172","1353318687","20","14679","0","1353333366");
INSERT INTO kolhoz_petground VALUES("6104","1237","5","1353608232","1353318085","20","13134","0","1353333366");
INSERT INTO kolhoz_petground VALUES("6105","1233","7","1353618017","1353328420","20","3895","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6106","1241","7","1353589594","1353303534","20","13976","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6107","1241","7","1353589622","1353303534","20","13976","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6108","1250","1","1353575617","1353287410","20","1333","0","1353288950");
INSERT INTO kolhoz_petground VALUES("6109","1250","1","1353575617","1353287519","20","1333","0","1353288950");
INSERT INTO kolhoz_petground VALUES("6110","1250","2","1353575682","1353287732","20","1218","0","1353288950");
INSERT INTO kolhoz_petground VALUES("6111","1250","2","1353575682","1353287664","20","1268","0","1353288950");
INSERT INTO kolhoz_petground VALUES("6112","1241","7","1353590485","1353303534","20","13976","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6113","1108","7","1353606895","1353328670","20","12626","0","1353331521");
INSERT INTO kolhoz_petground VALUES("6114","1241","7","1353578994","1353303534","20","13976","0","1353317493");
INSERT INTO kolhoz_petground VALUES("6115","1006","7","1353388501","1353322697","20","2478","0","1353333350");
INSERT INTO kolhoz_petground VALUES("6116","1162","4","1353582283","1353294198","20","10470","0","1353304753");
INSERT INTO kolhoz_petground VALUES("6117","1162","4","1353582283","1353294219","20","10470","0","1353304753");
INSERT INTO kolhoz_petground VALUES("6118","1162","4","1353582641","1353294614","20","10112","0","1353304753");
INSERT INTO kolhoz_petground VALUES("6119","1215","5","1353614505","1353328716","20","3002","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6120","1260","1","1353587554","1353299440","20","815","0","1353300369");
INSERT INTO kolhoz_petground VALUES("6121","1260","1","1353587567","1353299498","20","802","0","1353300369");
INSERT INTO kolhoz_petground VALUES("6122","1260","1","1353313985","1353299512","1","784","0","1353300369");
INSERT INTO kolhoz_petground VALUES("6123","1260","1","1353313996","1353299525","1","773","0","1353300369");
INSERT INTO kolhoz_petground VALUES("6124","1046","2","1353616696","1353329217","20","4486","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6125","1046","2","1353616743","1353329217","20","4477","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6126","1046","2","1353617038","1353329217","20","4313","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6127","1046","6","1353617038","1353329217","20","4313","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6128","1046","6","1353602941","1353329217","20","4313","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6129","1046","6","1353603559","1353329217","20","4313","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6130","1046","6","1353603559","1353329217","20","4313","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6131","1039","1","1353598354","1353302825","20","20536","0","1353330890");
INSERT INTO kolhoz_petground VALUES("6132","1039","1","1353599845","1353303024","20","19045","0","1353330890");
INSERT INTO kolhoz_petground VALUES("6133","1039","1","1353606344","1353303074","20","12546","0","1353330890");
INSERT INTO kolhoz_petground VALUES("6134","1039","1","1353611643","1353303130","20","7247","0","1353330890");
INSERT INTO kolhoz_petground VALUES("6135","1071","1","1355852950","1353309833","20","489340","0","1355751890");
INSERT INTO kolhoz_petground VALUES("6136","1071","1","1355852950","1353309859","20","489340","0","1355751890");
INSERT INTO kolhoz_petground VALUES("6137","1071","6","1355852950","1353311849","20","489172","0","1355751890");
INSERT INTO kolhoz_petground VALUES("6138","1071","6","1355737750","1353311867","20","475200","0","1355751890");
INSERT INTO kolhoz_petground VALUES("6139","1046","7","1353603956","1353329217","20","4313","0","1353333351");
INSERT INTO kolhoz_petground VALUES("6140","1152","6","1353619308","1353332473","20","732","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6141","1152","6","1353619452","1353332473","20","717","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6142","1152","6","1353619750","1353332473","20","701","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6143","1152","6","1353619887","1353332473","20","683","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6144","1215","6","1353335157","1353328716","1","3002","0","1353331617");
INSERT INTO kolhoz_petground VALUES("6145","1039","1","1353357251","1353303232","20","2439","0","1353330890");
INSERT INTO kolhoz_petground VALUES("6146","1152","6","1353620291","1353332473","20","793","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6147","1152","6","1353620291","1353332473","20","793","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6148","1152","6","1353606111","1353332473","20","793","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6149","1152","6","1353606215","1353332473","20","793","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6150","1020","7","1353607318","1353321113","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("6151","1020","7","1353607318","1353321120","20","11982","0","1353331300");
INSERT INTO kolhoz_petground VALUES("6152","1020","7","1353607464","1353321122","20","11836","0","1353331300");
INSERT INTO kolhoz_petground VALUES("6153","1177","7","1353608024","1353325485","20","7461","0","1353332652");
INSERT INTO kolhoz_petground VALUES("6154","1272","4","1353608822","1353325322","20","8033","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6155","1272","4","1353608822","1353325322","20","8021","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6156","1272","4","1353608822","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6157","1272","4","1353609440","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6158","1272","4","1353609493","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6159","1272","4","1353609493","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6160","1272","4","1353609493","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6161","1262","4","1353601917","1353314075","20","4382","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6162","1262","4","1353601947","1353314087","20","4370","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6163","1262","4","1353601996","1353314114","20","4343","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6164","1262","4","1353602269","1353314130","20","4188","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6165","1152","7","1353611498","1353332473","20","793","0","1353333084");
INSERT INTO kolhoz_petground VALUES("6166","1148","7","1353625518","1353337971","20","906","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6167","1148","7","1353625518","1353337972","20","906","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6168","1148","7","1353613473","1353332467","20","12951","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6169","1049","12","1356040570","1355759716","20","4386","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6170","1085","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6171","1085","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6172","1085","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6173","1085","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6174","1013","2","1353597997","1353329501","20","7211","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6175","1013","2","1353597997","1353329501","20","7222","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6176","1013","2","1353597997","1353329501","20","7233","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6177","1013","2","1353598261","1353329501","20","7089","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6178","1013","2","1353598261","1353329501","20","7089","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6179","1071","6","1353615168","1353312739","20","302400","0","1355751890");
INSERT INTO kolhoz_petground VALUES("6180","1071","6","1353352621","1353312764","1","28800","0","1355751890");
INSERT INTO kolhoz_petground VALUES("6181","1049","12","1356040570","1355759716","20","6062","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6182","1049","10","1356040570","1355759716","20","6062","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6183","1018","7","1353613473","1353326436","20","287037","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6184","1018","7","1353613672","1353326468","20","287204","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6185","1018","7","1353613773","1353326498","20","287275","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6186","1018","7","1353613773","1353326517","20","287256","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6187","1049","10","1356040570","1355759716","20","6062","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6188","1262","4","1353602269","1353314158","20","4188","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6189","1066","1","1353390675","1353318575","20","72000","0","1355579012");
INSERT INTO kolhoz_petground VALUES("6190","1066","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6191","1066","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6192","1066","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6193","1018","7","1353613844","1353326605","20","287239","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6194","1021","1","1353614467","1353326640","20","760","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6195","1021","1","1353614467","1353326640","20","760","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6196","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6197","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6198","1018","7","1353613989","1353326632","20","287357","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6199","1018","7","1353614066","1353326657","20","287409","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6200","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6201","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6202","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6203","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6204","1021","1","1353614564","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6205","1018","7","1353614146","1353326309","20","288000","0","1355583001");
INSERT INTO kolhoz_petground VALUES("6206","1233","7","1353614413","1353328420","20","3895","0","1353332304");
INSERT INTO kolhoz_petground VALUES("6207","1013","6","1353600313","1353329501","20","5037","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6208","1013","6","1353600313","1353329501","20","5037","0","1353331750");
INSERT INTO kolhoz_petground VALUES("6209","1021","5","1353600473","1353326640","20","663","0","1353327227");
INSERT INTO kolhoz_petground VALUES("6210","1006","7","1353374070","1353322718","20","2480","0","1353333350");
INSERT INTO kolhoz_petground VALUES("6211","1262","4","1353602327","1353314186","20","4130","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6212","1262","4","1353602971","1353314209","20","3486","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6213","1285","1","1353603520","1353315460","20","1019","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6214","1285","2","1353603629","1353315684","20","855","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6215","1285","6","1353603738","1353315726","20","801","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6216","1285","6","1353603804","1353315791","20","735","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6217","1262","4","1353329618","1353315026","1","3239","0","1353318457");
INSERT INTO kolhoz_petground VALUES("6218","1272","4","1353603062","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6219","1285","7","1353603841","1353315829","20","698","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6220","1285","7","1353603922","1353315903","20","617","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6221","1285","7","1353604041","1353315957","20","498","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6222","1285","7","1353604166","1353316138","20","373","0","1353316539");
INSERT INTO kolhoz_petground VALUES("6223","1284","2","1353605046","1353324902","20","7260","0","1353332162");
INSERT INTO kolhoz_petground VALUES("6224","1284","2","1353606089","1353325124","20","7038","0","1353332162");
INSERT INTO kolhoz_petground VALUES("6225","1284","2","1353606089","1353325160","20","7002","0","1353332162");
INSERT INTO kolhoz_petground VALUES("6226","1284","2","1353606089","1353325201","20","6961","0","1353332162");
INSERT INTO kolhoz_petground VALUES("6227","1284","2","1353606089","1353325235","20","6927","0","1353332162");
INSERT INTO kolhoz_petground VALUES("6228","1284","2","1353606089","1353325266","20","6896","0","1353332162");
INSERT INTO kolhoz_petground VALUES("6229","1286","2","1353605348","1353328075","20","3564","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6230","1286","6","1353614778","1353328232","20","3407","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6231","1286","4","1353615115","1353328347","20","3292","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6232","1286","1","1353370315","1353327055","3","4524","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6233","1286","1","1353370315","1353327072","3","4524","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6234","1286","1","1353370315","1353327085","3","4524","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6235","1286","1","1353370315","1353327106","3","4524","0","1353331639");
INSERT INTO kolhoz_petground VALUES("6236","1221","7","1353620346","1353338039","20","2836","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6237","1239","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6238","1239","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6239","1239","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6240","1239","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6241","1272","4","1353606141","1353325322","20","8011","0","1353333319");
INSERT INTO kolhoz_petground VALUES("6242","1061","2","1353607198","1353319197","20","5308","0","1353324506");
INSERT INTO kolhoz_petground VALUES("6243","1075","7","1353607507","1353327148","20","3010","0","1353328757");
INSERT INTO kolhoz_petground VALUES("6244","1031","6","1353607509","1353319717","20","287792","0","1355583928");
INSERT INTO kolhoz_petground VALUES("6245","1237","6","1353610004","1353321692","20","11362","0","1353333366");
INSERT INTO kolhoz_petground VALUES("6246","1288","1","1353508890","1353321646","20","11589","0","1353333279");
INSERT INTO kolhoz_petground VALUES("6247","1288","2","1353337046","1353322633","20","10633","0","1353333279");
INSERT INTO kolhoz_petground VALUES("6248","1288","5","1353347604","1353332930","1","75","0","1353333279");
INSERT INTO kolhoz_petground VALUES("6249","1288","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6250","1288","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6251","1221","7","1353624571","1353338039","20","1853","0","1353338424");
INSERT INTO kolhoz_petground VALUES("6252","1072","7","1353613101","1353325034","20","13316","0","1353338417");
INSERT INTO kolhoz_petground VALUES("6253","1072","7","1353613293","1353325195","20","13124","0","1353338417");
INSERT INTO kolhoz_petground VALUES("6254","1072","7","1353613350","1353325334","20","13067","0","1353338417");
INSERT INTO kolhoz_petground VALUES("6255","1058","10","1355976821","1355761553","19","1029","0","1355762209");
INSERT INTO kolhoz_petground VALUES("6256","1017","10","1353616326","1353329941","20","3519","0","1353333348");
INSERT INTO kolhoz_petground VALUES("6257","1308","2","1353618318","1353330761","20","1733","0","1353332494");
INSERT INTO kolhoz_petground VALUES("6258","1308","5","1353618833","1353330899","20","1595","0","1353332494");
INSERT INTO kolhoz_petground VALUES("6259","1308","4","1353618986","1353330977","20","1508","0","1353332494");
INSERT INTO kolhoz_petground VALUES("6260","1308","7","1353619067","1353331138","20","1356","0","1353332494");
INSERT INTO kolhoz_petground VALUES("6261","1303","5","1353347609","1353332284","20","5208","0","1353338417");
INSERT INTO kolhoz_petground VALUES("6262","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6263","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6264","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6265","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6266","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6267","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6268","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6269","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6270","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6271","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6272","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6273","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6274","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6275","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6276","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6277","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6278","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6279","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6280","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6281","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6282","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6283","1303","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6284","1","104","1355737715","1355723312","1","14400","0","1356175955");
INSERT INTO kolhoz_petground VALUES("6285","1","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6286","1","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6287","1","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6288","1308","7","1353619236","1353331173","20","1258","0","1353332494");
INSERT INTO kolhoz_petground VALUES("6289","1308","0","1353619322","1353331289","20","1078","0","1353332400");
INSERT INTO kolhoz_petground VALUES("6290","1308","0","1353619322","1353331301","20","1069","0","1353332391");
INSERT INTO kolhoz_petground VALUES("6291","1305","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6292","1305","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6293","1305","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6294","1305","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6295","1312","1","1353347470","1353332940","1","229","0","1353333299");
INSERT INTO kolhoz_petground VALUES("6296","1312","1","1353347483","1353333038","1","216","0","1353333299");
INSERT INTO kolhoz_petground VALUES("6297","1312","1","1353347503","1353333054","1","196","0","1353333299");
INSERT INTO kolhoz_petground VALUES("6298","1312","1","1353347510","1353333060","1","189","0","1353333299");
INSERT INTO kolhoz_petground VALUES("6299","1299","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6300","1299","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6301","1299","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6302","1299","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6303","1011","7","1353621319","1353333288","20","288000","0","1355578346");
INSERT INTO kolhoz_petground VALUES("6304","1011","7","1353621319","1353333301","20","288000","0","1355578346");
INSERT INTO kolhoz_petground VALUES("6305","1011","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6306","1011","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6307","1203","7","0","1353338395","1","0","0","1353338421");
INSERT INTO kolhoz_petground VALUES("6660","1381","12","1355708798","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("6659","1381","12","1355709043","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("6658","1381","12","1355709384","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("6657","1381","12","1355710222","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("6312","1321","36","1354531567","1354517172","1","14400","0","1354547881");
INSERT INTO kolhoz_petground VALUES("6313","1321","36","1354531567","1354517172","1","14400","0","1354547881");
INSERT INTO kolhoz_petground VALUES("6314","1321","36","1354531567","1354517172","1","14400","0","1354547881");
INSERT INTO kolhoz_petground VALUES("6315","1321","36","1354531567","1354517172","1","14400","0","1354547881");
INSERT INTO kolhoz_petground VALUES("6316","1325","1","0","1354621232","1","0","0","1354622220");
INSERT INTO kolhoz_petground VALUES("6317","1325","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6318","1325","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6319","1325","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6320","1327","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6321","1327","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6322","1327","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6323","1327","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6324","1328","12","1356012594","1355723267","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6325","1328","12","1356012594","1355723267","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6326","1328","12","1356012594","1355723267","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6327","1328","12","1356012594","1355723267","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6328","1332","4","1355188559","1354905699","20","54112","0","1354959811");
INSERT INTO kolhoz_petground VALUES("6329","1332","4","1355188559","1354905776","20","54035","0","1354959811");
INSERT INTO kolhoz_petground VALUES("6330","1332","2","1355188559","1354708364","20","260654","0","1354959811");
INSERT INTO kolhoz_petground VALUES("6331","1332","2","1355188559","1354708369","20","260645","0","1354959811");
INSERT INTO kolhoz_petground VALUES("6332","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6333","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6334","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6335","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6336","1337","14","1355987942","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6337","1337","14","1355988029","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6338","1337","14","1355988416","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6339","1337","14","1355988416","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6340","1326","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6341","1326","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6342","1326","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6343","1326","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6344","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6345","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6346","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6347","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6348","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6349","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6350","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6351","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6352","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6353","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6354","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6355","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6356","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6357","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6358","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6359","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6360","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6361","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6362","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6363","1336","104","1356022668","1355745512","20","9969","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6364","1336","104","1356022668","1355750446","20","5031","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6365","1336","104","1356022668","1355750466","20","5011","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6366","1336","104","1356022668","1355750495","20","4982","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6367","1336","104","1356022668","1355750518","20","4959","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6368","1336","104","1356022668","1355750544","20","4933","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6369","1336","104","1356022668","1355750583","20","4894","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6370","1336","104","1356022668","1355750603","20","4874","0","1355755477");
INSERT INTO kolhoz_petground VALUES("6371","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6372","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6373","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6374","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6375","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6376","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6377","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6378","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6379","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6380","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6381","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6382","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6383","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6384","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6385","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6386","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6387","1337","14","1355988416","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6388","1337","14","1355988416","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6389","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6390","1337","14","1355988416","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6391","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6392","1337","14","1355988416","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6393","1338","16","1356034572","1355757604","20","628","0","1355757615");
INSERT INTO kolhoz_petground VALUES("6394","1348","6","1354923860","1354636430","20","3925","0","1354640355");
INSERT INTO kolhoz_petground VALUES("6395","1348","7","1354924532","1354636586","20","3769","0","1354640355");
INSERT INTO kolhoz_petground VALUES("6396","1348","7","1354924617","1354636603","20","3738","0","1354640355");
INSERT INTO kolhoz_petground VALUES("6397","1348","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6398","1351","104","1355415572","1355137074","20","279226","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6399","1351","104","1355423676","1355137074","20","287330","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6400","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6401","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6402","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6403","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6404","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6405","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6406","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6407","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6408","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6409","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6410","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6411","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6412","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6413","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6414","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6415","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6416","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6417","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6418","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6419","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6420","1351","104","1355423676","1355137074","20","288010","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6421","1351","104","1355416179","1355137074","20","280513","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6422","1351","104","1355415694","1355137074","20","280028","0","1355586688");
INSERT INTO kolhoz_petground VALUES("6423","1344","7","1355786694","1355762019","20","7383","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6424","1344","7","1355786694","1355762019","20","7425","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6425","1344","7","1355786694","1355762019","20","7407","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6426","1344","7","1355786694","1355762019","20","7387","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6427","1345","1","1354986074","1354698076","20","610","0","1354698684");
INSERT INTO kolhoz_petground VALUES("6428","1345","1","1354986074","1354698076","20","610","0","1354698684");
INSERT INTO kolhoz_petground VALUES("6429","1345","1","1354986074","1354698076","20","610","0","1354698684");
INSERT INTO kolhoz_petground VALUES("6430","1345","1","1354986074","1354698076","20","610","0","1354698684");
INSERT INTO kolhoz_petground VALUES("6431","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6432","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6433","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6434","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6435","1346","18","1356035580","1355758289","20","8187","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6436","1346","18","1356035580","1355758289","20","8187","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6437","1346","18","1356035804","1355758289","20","8187","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6438","1346","18","1356035804","1355758289","20","8187","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6439","1344","7","1355786694","1355762019","20","4208","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6440","1367","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6441","1367","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6442","1367","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6443","1367","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6444","1359","104","1356039911","1355758094","20","13979","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6445","1359","104","1356039911","1355758094","20","14049","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6446","1359","104","1356039911","1355758094","20","14179","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6447","1359","104","1356039911","1355758094","20","14198","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6448","1344","7","1355786694","1355762019","20","4208","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6449","1344","7","1355786694","1355762019","20","4208","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6450","1344","10","1355786694","1355762019","20","5083","0","1355762102");
INSERT INTO kolhoz_petground VALUES("6451","1360","104","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6452","1360","100","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6453","1360","12","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6454","1360","5","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6455","1350","14","1355979136","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6456","1350","14","1355965919","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6457","1350","14","1355966792","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6458","1350","14","1355966792","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6459","1037","104","1355504795","1355526093","1","1","0","1355762109");
INSERT INTO kolhoz_petground VALUES("6460","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6461","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6462","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6463","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6464","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6465","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6466","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6467","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6468","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6469","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6470","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6471","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6472","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6473","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6474","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6475","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6476","1037","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6477","1360","14","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6478","1360","16","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6479","1360","34","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6655","1380","7","1355159259","1354875747","20","8054","0","1354879313");
INSERT INTO kolhoz_petground VALUES("6481","1355","14","1355856805","1355579129","20","185915","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6482","1355","14","1355856805","1355579129","20","185856","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6483","1355","14","1355856805","1355579129","20","185800","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6484","1355","14","1355856805","1355579129","20","185698","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6654","1380","7","1355159520","1354875747","20","8054","0","1354879313");
INSERT INTO kolhoz_petground VALUES("6653","1380","7","1355159520","1354875747","20","8054","0","1354879313");
INSERT INTO kolhoz_petground VALUES("6652","1380","7","1355159520","1354875747","20","8054","0","1354879313");
INSERT INTO kolhoz_petground VALUES("6656","1381","12","1355710222","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("6649","1380","7","1355159520","1354875747","20","8054","0","1354879313");
INSERT INTO kolhoz_petground VALUES("6490","1355","14","1355856805","1355579129","20","185638","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6491","1371","12","1355794805","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6492","1371","12","1355794805","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6493","1371","12","1355794783","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6494","1371","12","1355797691","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6495","1350","14","1355967456","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6496","1371","12","1355807796","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6497","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6498","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6499","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6500","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6501","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6502","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6503","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6504","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6505","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6506","1337","14","1355999663","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6507","1337","14","1355999881","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6508","1337","14","1355999881","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6509","1337","14","1355999881","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6510","1337","14","1356000187","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6511","1337","14","1356000187","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6512","1337","14","1356000187","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6513","1337","14","1356000187","1355712279","20","41639","0","1355753917");
INSERT INTO kolhoz_petground VALUES("6646","1319","104","1356027842","1355741219","20","19604","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6645","1319","104","1356027842","1355741219","20","19604","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6516","1355","14","1355856805","1355579129","20","185836","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6644","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6518","1355","14","1355856805","1355579129","20","185777","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6519","1346","18","1356041411","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6520","1346","18","1356044702","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6521","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6522","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6523","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6524","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6525","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6526","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6527","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6528","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6529","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6530","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6531","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6532","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6533","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6534","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6535","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6536","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6537","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6538","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6539","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6540","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6541","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6542","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6543","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6544","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6545","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6546","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6547","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6548","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6549","1346","18","1356044818","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6550","1346","18","1356044894","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6551","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6552","1346","18","1356044894","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6553","1346","18","1356046138","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6554","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6555","1346","18","1356046138","1355758289","20","8266","0","1355761677");
INSERT INTO kolhoz_petground VALUES("6556","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6557","1357","14","1355835914","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("6558","1341","16","1355393607","1355116960","20","116943","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6559","1341","16","1355393734","1355116960","20","116907","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6560","1341","16","1355395271","1355116960","20","116877","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6561","1341","16","1355395271","1355116960","20","116839","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6562","1359","104","1356039911","1355758094","20","1544","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6643","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6648","1380","7","1355159520","1354875747","20","8054","0","1354879313");
INSERT INTO kolhoz_petground VALUES("6647","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6566","1328","12","1356012594","1355723267","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6567","1328","12","1356012594","1355723267","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6568","1328","12","1356012594","1355724535","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6569","1328","12","1356012594","1355724558","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6570","1328","12","1356012594","1355724589","20","19937","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6571","1328","12","1356012594","1355738518","20","6013","0","1355744531");
INSERT INTO kolhoz_petground VALUES("6572","1354","7","1355612565","1355324691","20","182088","0","1355506678");
INSERT INTO kolhoz_petground VALUES("6573","1354","7","1355598466","1355324691","20","182088","0","1355506678");
INSERT INTO kolhoz_petground VALUES("6574","1354","2","1355598529","1355324691","20","182113","0","1355506678");
INSERT INTO kolhoz_petground VALUES("6575","1354","5","1355598606","1355324691","20","182113","0","1355506678");
INSERT INTO kolhoz_petground VALUES("6576","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6577","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6578","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6579","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6580","1366","12","1355786940","1355414156","20","336080","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6581","1366","12","1355787034","1355414156","20","336061","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6582","1366","12","1355787034","1355414156","20","336033","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6583","1366","12","1355786787","1355414156","20","336015","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6584","1366","12","1355787323","1355414156","20","335993","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6585","1366","12","1355787323","1355414156","20","335972","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6586","1366","12","1355787323","1355414156","20","335950","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6587","1378","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6588","1378","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6589","1378","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6590","1378","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6591","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6592","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6593","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6594","1373","103","1355971359","1355692293","20","69900","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6595","1354","7","1355602201","1355324691","20","182113","0","1355506678");
INSERT INTO kolhoz_petground VALUES("6596","1366","12","1355776131","1355414156","20","335920","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6597","1341","16","1355403979","1355116960","20","116801","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6598","1341","16","1355403979","1355116960","20","116774","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6599","1341","16","1355403979","1355116960","20","116738","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6600","1341","16","1355399039","1355116960","20","116693","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6601","1341","16","1355399039","1355116960","20","116664","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6602","1341","16","1355399039","1355116960","20","116624","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6603","1341","16","1355399039","1355116960","20","116598","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6604","1341","16","1355399039","1355116960","20","116562","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6605","1341","16","1355399039","1355116960","20","116531","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6606","1341","16","1355399039","1355116960","20","116499","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6607","1341","16","1355399039","1355116960","20","116433","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6608","1341","16","1355399039","1355116960","20","116388","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6609","1341","16","1355399039","1355116960","20","116360","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6610","1341","16","1355399039","1355116960","20","116304","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6611","1341","16","1355399039","1355116960","20","116274","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6612","1341","16","1355399039","1355116960","20","116247","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6613","1341","16","1355399039","1355116960","20","116214","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6614","1341","16","1355399039","1355116960","20","116166","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6615","1341","16","1355399039","1355116960","20","116126","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6616","1341","16","1355399039","1355116960","20","116089","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6617","1341","16","1355399039","1355116960","20","116459","0","1355230173");
INSERT INTO kolhoz_petground VALUES("6618","1379","36","1356022799","1355746336","20","17632","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6619","1379","36","1356022914","1355746336","20","17602","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6620","1379","36","1356023642","1355746336","20","17578","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6621","1379","36","1356023642","1355746336","20","17549","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6622","1379","36","1356029528","1355746336","20","27991","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6623","1379","36","1356029528","1355746336","20","27971","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6624","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6625","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6626","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6627","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6628","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6629","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6630","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6631","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6632","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6633","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6634","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6635","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6636","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6637","1379","36","1356022596","1355746336","20","27596","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6638","1379","36","1356022645","1355746336","20","27547","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6639","1379","36","1356022645","1355746336","20","27547","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6640","1379","36","1356022645","1355746336","20","27547","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6641","1379","36","1356022645","1355746336","20","27547","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6642","1379","36","1356022645","1355746336","20","27547","0","1355762192");
INSERT INTO kolhoz_petground VALUES("6661","1381","12","1355712107","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("6662","1352","16","1355653356","1355373689","20","8366","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6663","1352","16","1355653356","1355373689","20","8366","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6664","1352","16","1355653356","1355373689","20","8366","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6665","1352","16","1355653356","1355373689","20","8366","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6666","1359","104","1356039911","1355758094","20","7122","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6667","1359","104","1356039911","1355758094","20","6952","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6668","1366","12","1355783069","1355414156","20","335898","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6669","1366","12","1355783069","1355414156","20","335880","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6670","1366","12","1355783069","1355414156","20","335848","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6671","1366","12","1355783069","1355414156","20","335814","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6672","1366","12","1355783069","1355414156","20","335791","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6673","1366","12","1355783069","1355414156","20","335769","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6674","1366","12","1355783069","1355414156","20","335739","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6675","1366","12","1355783069","1355414156","20","335701","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6676","1366","12","1355783069","1355414156","20","335672","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6677","1366","12","1355783069","1355414156","20","335652","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6678","1366","12","1355783069","1355414156","20","335593","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6679","1366","12","1355783069","1355414156","20","335557","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6680","1366","12","1355783069","1355414156","20","335525","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6681","1366","12","1355783069","1355414156","20","335505","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6682","1366","12","1355783069","1355414156","20","335486","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6683","1366","12","1355783069","1355414156","20","335200","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6684","1366","12","1355783069","1355414156","20","335088","0","1355745820");
INSERT INTO kolhoz_petground VALUES("6685","1374","11","1355994429","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("6686","1374","11","1355994682","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("6687","1374","11","1355995352","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("6688","1374","12","1355995392","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("6689","1374","12","1355995929","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("6690","1384","14","1356000542","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6691","1384","14","1356000555","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6692","1384","14","1356000571","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6693","1384","14","1356000586","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6694","1384","14","1355993000","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6695","1384","14","1355994105","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6696","1345","1","1354986289","1354698283","20","395","0","1354698684");
INSERT INTO kolhoz_petground VALUES("6697","1345","1","1354986358","1354698351","20","326","0","1354698684");
INSERT INTO kolhoz_petground VALUES("6698","1360","32","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6699","1360","102","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6700","1360","33","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6701","1360","23","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6702","1360","7","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6703","1387","10","1355794873","1355506861","20","7911","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6704","1387","10","1355794873","1355506861","20","13144","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6705","1387","10","1355794873","1355506861","20","16831","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6706","1387","10","1355794873","1355506861","20","9319","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6707","1388","104","1355968964","1355752392","20","14091","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6708","1388","104","1355968949","1355752392","20","14003","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6709","1388","104","1355970269","1355752392","20","14025","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6710","1388","104","1355970261","1355752392","20","14048","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6711","1371","12","1355807796","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6712","1371","12","1355807796","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6713","1371","12","1355804585","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6714","1371","12","1355804585","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6715","1388","104","1355970294","1355752392","20","13724","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6716","1388","104","1355970372","1355752392","20","13701","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6717","1388","104","1355970405","1355752392","20","13675","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6718","1388","104","1355970936","1355752392","20","13617","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6719","1388","104","1355970952","1355752392","20","13647","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6720","1388","104","1355971069","1355752392","20","13588","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6721","1388","104","1355971129","1355752392","20","13546","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6722","1388","104","1355970470","1355752392","20","13515","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6723","1388","104","1355970440","1355752392","20","13488","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6724","1388","104","1355970245","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6725","1359","104","1356039911","1355758094","20","3025","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6726","1359","104","1356039911","1355758094","20","3784","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6727","1359","104","1356039911","1355758094","20","3769","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6728","1359","104","1356039911","1355758094","20","3694","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6729","1359","104","1356039911","1355758094","20","3632","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6730","1359","104","1356039911","1355758094","20","3617","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6731","1359","104","1356039911","1355758094","20","3521","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6732","1359","104","1356039911","1355758094","20","3485","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6733","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6734","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6735","1393","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6736","1393","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6737","1393","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6738","1393","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6739","1359","104","1356039911","1355758094","20","4598","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6740","1359","104","1356039911","1355758094","20","4634","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6741","1359","104","1356039911","1355758094","20","4649","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6742","1359","104","1356039911","1355758094","20","4668","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6743","1359","104","1356039911","1355758094","20","5772","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6744","1359","104","1356039911","1355758094","20","5830","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6745","1359","104","1356039911","1355758094","20","5850","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6746","1359","104","1356039911","1355758094","20","5888","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6747","1359","104","1356039911","1355758094","20","5907","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6748","1359","104","1356039911","1355758094","20","5925","0","1355758925");
INSERT INTO kolhoz_petground VALUES("6749","1384","14","1356003105","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("6750","1390","18","1356024380","1355319973","20","439228","0","1355745362");
INSERT INTO kolhoz_petground VALUES("6751","1390","18","1356024380","1355319973","20","439292","0","1355745362");
INSERT INTO kolhoz_petground VALUES("6752","1390","18","1356024380","1355319973","20","439363","0","1355745362");
INSERT INTO kolhoz_petground VALUES("6753","1390","18","1356024459","1355319973","20","439429","0","1355745362");
INSERT INTO kolhoz_petground VALUES("6754","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6755","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6756","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6757","1401","16","1356003842","1355752480","20","8891","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6758","1401","16","1356003851","1355752480","20","8881","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6759","1401","16","1356003859","1355752480","20","8868","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6760","1401","16","1356003868","1355752480","20","8829","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6761","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6762","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6763","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6764","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6765","1401","16","1356003888","1355752480","20","8823","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6766","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6767","1401","16","1356003891","1355752480","20","8817","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6768","1401","16","1356003906","1355752480","20","8811","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6769","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6770","1352","16","1355653472","1355373689","20","8250","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6771","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6772","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6773","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6774","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6775","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6776","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6777","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6778","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6779","1352","16","1355653581","1355373689","20","8141","0","1355373722");
INSERT INTO kolhoz_petground VALUES("6780","1331","18","1355702434","1355720695","20","6490","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6781","1331","18","1355702434","1355720695","20","6467","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6782","1331","18","1355702434","1355720695","20","6444","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6783","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6784","1389","10","1355787625","1355507714","20","31","0","1355507731");
INSERT INTO kolhoz_petground VALUES("6785","1389","10","1355787625","1355507714","20","31","0","1355507731");
INSERT INTO kolhoz_petground VALUES("6786","1389","10","1355787625","1355507714","20","31","0","1355507731");
INSERT INTO kolhoz_petground VALUES("6787","1389","9","1355509922","1355507714","1","3031","0","1355507731");
INSERT INTO kolhoz_petground VALUES("6788","1360","21","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6789","1360","6","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6790","1360","18","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6791","1360","19","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6792","1401","16","1356006869","1355752480","20","8805","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6793","1401","16","1356006869","1355752480","20","8800","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6794","1401","16","1356006869","1355752480","20","8795","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6795","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6796","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6797","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6798","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6799","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6800","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6801","1360","22","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6802","1360","26","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6803","1401","16","1356006869","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6804","1360","24","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6805","1360","101","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6806","1360","30","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6807","1360","28","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6808","1360","29","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6809","1360","35","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6810","1360","36","1355958551","1355754175","20","9277","0","1355759428");
INSERT INTO kolhoz_petground VALUES("6811","1353","11","1356010848","1355757292","20","1285","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6812","1353","11","1356010848","1355757292","20","1275","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6813","1353","11","1356010848","1355757292","20","1256","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6814","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6815","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6816","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6817","1401","16","1356007586","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6818","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6819","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6820","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6821","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6822","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6823","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6824","1401","16","1355993817","1355752480","20","8789","0","1355757976");
INSERT INTO kolhoz_petground VALUES("6825","1388","104","1355965446","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6826","1388","104","1355965524","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6827","1388","104","1355965446","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6828","1388","104","1355965524","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6829","1388","104","1355965524","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6830","1388","104","1355965607","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6831","1388","104","1355967061","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6832","1388","104","1355967061","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6833","1388","104","1355965787","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6834","1388","104","1355967061","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6835","1388","104","1355967061","1355752392","20","13445","0","1355757267");
INSERT INTO kolhoz_petground VALUES("6836","1394","7","1355714390","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("6837","1394","7","1355714417","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("6838","1394","7","1355717993","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("6839","1394","4","1355718008","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("6840","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("6841","1403","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6842","1403","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6843","1403","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6844","1403","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6845","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6846","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6847","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6848","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6849","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6850","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6851","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6852","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6853","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6854","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6855","1397","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6856","1397","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6857","1397","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6858","1397","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6859","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6860","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6861","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6862","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6863","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6864","1350","14","1355969937","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6865","1350","14","1355978342","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6866","1350","14","1355978200","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6867","1350","14","1355978200","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6868","1350","14","1355978200","1355691441","20","72862","0","1355762157");
INSERT INTO kolhoz_petground VALUES("6869","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6870","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6871","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6872","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6873","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6874","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6875","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6876","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6877","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6878","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6879","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6880","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6881","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6882","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6883","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6884","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6885","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6886","1373","103","1355971359","1355692293","20","72129","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6887","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6888","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6889","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6890","1331","16","1355702434","1355720695","20","0","0","1355762143");
INSERT INTO kolhoz_petground VALUES("6891","1373","103","1355971359","1355692293","20","72097","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6892","1373","103","1355971359","1355692293","20","72057","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6893","1373","103","1355971359","1355692293","20","72000","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6894","1373","103","1355971359","1355692293","20","71827","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6895","1373","103","1355971359","1355692293","20","71827","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6896","1373","103","1355971359","1355692293","20","71827","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6897","1373","103","1355971359","1355692293","20","71827","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6898","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6899","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6900","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6901","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6902","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6903","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6904","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6905","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6906","1373","103","1355971359","1355692293","20","71407","0","1355762188");
INSERT INTO kolhoz_petground VALUES("6907","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6908","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6909","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6910","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6911","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6912","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6913","1402","18","1355839028","1355554323","20","7845","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6914","1402","18","1355839028","1355554323","20","7875","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6915","1402","18","1355839028","1355554323","20","7926","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6916","1402","18","1355839028","1355554323","20","7983","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6917","1354","7","1355612267","1355324691","20","182113","0","1355506678");
INSERT INTO kolhoz_petground VALUES("6918","1402","18","1355839028","1355554323","20","8024","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6919","1402","18","1355839028","1355554323","20","8064","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6920","1402","18","1355839028","1355554323","20","8110","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6921","1402","18","1355839028","1355554323","20","8140","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6922","1402","18","1355839028","1355554323","20","8196","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6923","1402","18","1355839028","1355554323","20","8237","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6924","1402","18","1355839028","1355554323","20","8282","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6925","1402","18","1355839028","1355554323","20","8309","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6926","1402","18","1355839028","1355554323","20","8336","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6927","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6928","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6929","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6930","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6931","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6932","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6933","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6934","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6935","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6936","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6937","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6938","1402","18","1355839028","1355554323","20","8372","0","1355554641");
INSERT INTO kolhoz_petground VALUES("6939","1371","12","1355804585","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("6940","1387","10","1355794873","1355506861","20","9319","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6941","1387","10","1355794873","1355506861","20","9319","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6942","1387","10","1355794873","1355506861","20","17509","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6943","1387","10","1355794873","1355506861","20","17509","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6944","1387","10","1355794873","1355506861","20","17509","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6945","1387","10","1355794873","1355506861","20","17509","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6946","1387","10","1355794873","1355506861","20","17509","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6947","1387","10","1355794873","1355506861","20","17509","0","1355514784");
INSERT INTO kolhoz_petground VALUES("6948","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6949","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6950","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6951","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6952","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6953","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6954","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6955","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6956","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6957","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6958","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6959","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6960","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6961","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6962","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6963","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6964","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6965","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6966","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6967","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6968","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6969","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6970","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6971","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6972","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6973","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6974","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6975","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6976","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6977","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6978","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6979","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6980","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6981","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6982","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6983","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6984","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6985","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6986","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6987","1355","14","1355856805","1355579129","20","192069","0","1355760530");
INSERT INTO kolhoz_petground VALUES("6988","1409","14","1355155700","1354878824","20","11351","0","1354879051");
INSERT INTO kolhoz_petground VALUES("6989","1410","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6990","1410","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6991","1410","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6992","1410","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6993","1410","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("6994","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6995","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6996","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6997","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6998","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("6999","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7000","1319","104","1356027842","1355741219","20","23607","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7001","1390","18","1356024459","1355319973","20","439528","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7002","1390","18","1356024893","1355319973","20","439610","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7003","1390","18","1356024893","1355319973","20","439689","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7004","1390","18","1356024893","1355319973","20","439735","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7005","1390","18","1356024893","1355319973","20","425424","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7006","1390","18","1356024893","1355319973","20","425488","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7007","1390","18","1356024893","1355319973","20","425614","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7008","1390","18","1356024893","1355319973","20","425672","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7009","1390","18","1356024893","1355319973","20","425722","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7010","1390","18","1356024893","1355319973","20","425794","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7011","1390","18","1356024893","1355319973","20","425858","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7012","1390","18","1356024893","1355319973","20","425904","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7013","1390","18","1356025218","1355319973","20","425958","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7014","1390","18","1356025218","1355319973","20","426006","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7015","1390","18","1356025218","1355319973","20","426059","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7016","1390","18","1356025218","1355319973","20","426108","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7017","1390","18","1356025218","1355319973","20","426145","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7018","1390","18","1356025218","1355319973","20","426216","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7019","1390","18","1356025218","1355319973","20","426269","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7020","1390","18","1356025218","1355319973","20","426336","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7021","1390","18","1356025218","1355319973","20","426434","0","1355745362");
INSERT INTO kolhoz_petground VALUES("7022","1385","2","1355456059","1355340348","8","129085","0","1355748121");
INSERT INTO kolhoz_petground VALUES("7023","1385","1","1355427259","1355340349","6","86400","0","1355748121");
INSERT INTO kolhoz_petground VALUES("7024","1385","5","1355484859","1355340350","10","144000","0","1355748121");
INSERT INTO kolhoz_petground VALUES("7025","1385","10","1355628859","1355340336","20","288000","0","1355748121");
INSERT INTO kolhoz_petground VALUES("7026","1412","1","1355774597","1355760204","1","1991","0","1355762188");
INSERT INTO kolhoz_petground VALUES("7027","1412","2","1355774597","1355760204","1","1991","0","1355762188");
INSERT INTO kolhoz_petground VALUES("7028","1412","5","1355774597","1355760204","1","1991","0","1355762188");
INSERT INTO kolhoz_petground VALUES("7029","1412","5","1355774597","1355760204","1","1991","0","1355762188");
INSERT INTO kolhoz_petground VALUES("7030","1409","14","1355155820","1354878824","20","11231","0","1354879051");
INSERT INTO kolhoz_petground VALUES("7031","1409","14","1355155820","1354878824","20","11231","0","1354879051");
INSERT INTO kolhoz_petground VALUES("7032","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7033","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7034","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7035","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7036","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("7037","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("7038","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7039","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7040","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7041","1384","14","1355995811","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7042","1384","14","1355995811","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7043","1381","12","1355708035","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7136","1358","9","1355823688","1355541853","20","8798","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7045","1384","14","1355996340","1355717106","20","12053","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7046","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7047","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7048","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7049","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7050","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7051","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7052","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7053","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7054","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7055","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7056","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7057","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7058","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7059","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7060","1415","16","1355527019","1355239001","20","14257","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7061","1415","16","1355527019","1355239001","20","8964","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7062","1415","16","1355527019","1355239001","20","9133","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7063","1415","16","1355527019","1355239001","20","14165","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7064","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7065","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7066","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7067","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7068","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7069","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7070","1414","104","1356020185","1355732225","20","20070","0","1355752236");
INSERT INTO kolhoz_petground VALUES("7071","1387","11","1355794873","1355506861","20","18150","0","1355514784");
INSERT INTO kolhoz_petground VALUES("7072","1387","12","1355794873","1355506861","20","14313","0","1355514784");
INSERT INTO kolhoz_petground VALUES("7073","1387","12","1355794873","1355506861","20","10650","0","1355514784");
INSERT INTO kolhoz_petground VALUES("7074","1387","12","1355795190","1355507144","20","7594","0","1355514784");
INSERT INTO kolhoz_petground VALUES("7075","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7076","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7077","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7078","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7079","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7080","1411","14","1356041165","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7081","1411","14","1356041703","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7082","1411","14","1356041740","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7083","1411","14","1356041827","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7084","1358","9","1355829140","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7085","1358","9","1355817401","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7086","1358","9","1355817401","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7087","1358","9","1355817401","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7088","1358","9","1355817401","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7089","1347","14","1356019849","1355757184","20","1491","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7090","1347","14","1356019849","1355757184","20","1491","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7091","1347","14","1356019849","1355757184","20","1491","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7092","1347","14","1356019849","1355757184","20","1491","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7093","1416","12","1356038822","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7094","1416","12","1356038822","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7095","1416","12","1356038822","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7096","1416","12","1356038871","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7097","1416","12","1356038871","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7098","1416","12","1356038871","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7099","1384","14","1355996499","1355717106","20","7978","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7100","1362","12","1356042922","1355755378","20","2007","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7101","1362","12","1356042922","1355755378","20","2007","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7102","1362","14","1356042922","1355755378","20","2007","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7103","1362","14","1356042922","1355755378","20","2007","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7104","1417","26","1356038304","1355756628","20","4184","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7105","1417","26","1356038344","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7106","1417","26","1356038344","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7107","1417","26","1356038344","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7108","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7109","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7110","1394","4","1355713996","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("7111","1419","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7112","1419","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7113","1419","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7114","1419","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7115","1415","16","1355527019","1355239001","20","14209","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7116","1415","16","1355527019","1355239001","20","1016","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7117","1415","16","1355527019","1355239001","20","855","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7118","1415","16","1355527019","1355239001","20","737","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7119","1415","16","1355527019","1355239001","20","695","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7120","1415","16","1355527019","1355239001","20","581","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7121","1415","16","1355527019","1355239001","20","504","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7122","1415","16","1355527019","1355239001","20","522","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7123","1415","16","1355527019","1355239001","20","600","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7124","1415","16","1355527019","1355239001","20","632","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7125","1415","16","1355527019","1355239001","20","658","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7126","1415","16","1355527019","1355239001","20","680","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7127","1415","16","1355527019","1355239001","20","713","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7128","1415","16","1355527019","1355239001","20","751","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7129","1415","16","1355527019","1355239001","20","821","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7130","1415","16","1355527019","1355239001","20","840","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7131","1415","16","1355527019","1355239001","20","877","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7132","1415","16","1355527019","1355239001","20","928","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7133","1415","16","1355527019","1355239001","20","950","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7134","1415","16","1355527019","1355239001","20","967","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7135","1415","16","1355527019","1355239001","20","979","0","1355239099");
INSERT INTO kolhoz_petground VALUES("7137","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7138","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7139","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7140","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7141","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7142","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7143","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7144","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7145","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7146","1319","104","1356027842","1355741219","20","19602","0","1355759444");
INSERT INTO kolhoz_petground VALUES("7147","1374","10","1355985956","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7148","1374","10","1355985956","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7149","1374","10","1355985956","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7150","1374","10","1355985956","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7151","1374","10","1355985956","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7152","1374","10","1355986442","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7153","1374","10","1355986442","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7154","1374","10","1355986442","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7155","1374","10","1355986442","1355745559","20","5544","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7156","1374","10","1355986442","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7157","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7158","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7159","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7160","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7161","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7162","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7163","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7164","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7165","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7166","1374","10","1355987050","1355745559","20","5558","0","1355747200");
INSERT INTO kolhoz_petground VALUES("7167","1358","9","1355828142","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7168","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7169","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7170","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7171","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7172","1427","7","1355843295","1355555368","20","130635","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7173","1427","7","1355843358","1355555368","20","130635","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7174","1427","7","1355843273","1355555368","20","130635","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7175","1427","7","1355843286","1355555368","20","130635","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7176","1369","12","1356037991","1355762147","20","8688","0","1355762186");
INSERT INTO kolhoz_petground VALUES("7177","1369","12","1356037991","1355762147","20","8688","0","1355762186");
INSERT INTO kolhoz_petground VALUES("7178","1369","12","1356037991","1355762147","20","8688","0","1355762186");
INSERT INTO kolhoz_petground VALUES("7179","1369","12","1356037991","1355762147","20","8688","0","1355762186");
INSERT INTO kolhoz_petground VALUES("7180","1433","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7181","1433","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7182","1433","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7183","1433","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7184","1381","12","1355711987","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7185","1381","12","1355711987","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7186","1381","12","1355711987","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7187","1381","12","1355711987","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7188","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7189","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7190","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7191","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7192","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7193","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7194","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7195","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7196","1381","0","1355640406","1355363401","20","11653","0","1355363640");
INSERT INTO kolhoz_petground VALUES("7197","1381","0","1355640406","1355363401","20","11663","0","1355363650");
INSERT INTO kolhoz_petground VALUES("7198","1381","0","1355640406","1355363401","20","11673","0","1355363660");
INSERT INTO kolhoz_petground VALUES("7199","1381","0","1355640406","1355363401","20","11684","0","1355363671");
INSERT INTO kolhoz_petground VALUES("7200","1381","0","1355640406","1355363401","20","11699","0","1355363686");
INSERT INTO kolhoz_petground VALUES("7201","1381","12","1355712406","1355431934","20","54572","0","1355486484");
INSERT INTO kolhoz_petground VALUES("7202","1347","14","1356019849","1355757184","20","2579","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7203","1347","14","1356019849","1355757184","20","2579","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7204","1347","14","1356019849","1355757184","20","2461","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7205","1347","14","1356019849","1355757184","20","2652","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7206","1347","14","1356019849","1355757184","20","2652","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7207","1347","14","1356019849","1355757184","20","2652","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7208","1347","14","1356019849","1355757184","20","2652","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7209","1347","14","1356019849","1355757184","20","2652","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7210","1347","14","1356019849","1355757184","20","2822","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7211","1347","14","1356019849","1355757184","20","2822","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7212","1347","14","1356019849","1355757184","20","2822","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7213","1347","14","1356019849","1355757184","20","2822","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7214","1347","14","1356019849","1355757184","20","3037","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7215","1347","14","1356019849","1355757184","20","3037","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7216","1347","14","1356019849","1355757184","20","3037","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7217","1347","14","1356019849","1355757184","20","3037","0","1355758656");
INSERT INTO kolhoz_petground VALUES("7218","1358","10","1355822001","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7219","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7220","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7221","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7222","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7223","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7224","1387","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7225","1394","7","1355726992","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("7226","1441","16","1355255273","1354980215","20","13047","0","1354980320");
INSERT INTO kolhoz_petground VALUES("7227","1441","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7228","1441","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7229","1441","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7230","1442","24","1356046002","1355758000","20","14994","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7231","1442","24","1356046002","1355758000","20","14994","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7232","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7233","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7234","1394","7","1355714325","1355440238","20","13186","0","1355441048");
INSERT INTO kolhoz_petground VALUES("7235","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7236","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7237","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7238","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7239","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7240","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7241","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7242","1442","16","1356046002","1355758000","20","654","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7243","1442","16","1356046002","1355758000","20","1015","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7244","1442","16","1356046002","1355758000","20","1015","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7245","1442","16","1356046002","1355758000","20","1015","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7246","1442","16","1356046002","1355758000","20","1015","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7247","1442","16","1356046002","1355758000","20","1015","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7248","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7249","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7250","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7251","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7252","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7253","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7254","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7255","1442","16","1356046002","1355758000","20","1106","0","1355758654");
INSERT INTO kolhoz_petground VALUES("7256","1443","14","0","1355040589","1","0","0","1355074819");
INSERT INTO kolhoz_petground VALUES("7257","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7258","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7259","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7260","1384","14","1355994055","1355717106","20","7952","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7261","1446","11","1356037900","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7262","1446","11","1356037909","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7263","1446","11","1356037916","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7264","1446","11","1356037924","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7265","1446","11","1356037936","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7266","1446","11","1356037945","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7267","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("7268","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("7269","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("7270","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("7271","1446","11","1356024470","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7272","1446","12","1356024470","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7273","1446","12","1356024504","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7274","1446","10","1356024504","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7275","1446","10","1356024504","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7276","1446","10","1356024537","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7277","1446","10","1356024537","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7278","1446","12","1356024584","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7279","1446","12","1356024584","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7280","1445","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7281","1445","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7282","1445","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7283","1445","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7284","1446","12","1356027770","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7285","1446","10","1356026341","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7286","1446","10","1356025136","1355750778","20","4554","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7287","1446","10","1356036176","1355750778","20","4665","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7288","1446","10","1356036214","1355750778","20","4627","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7289","1446","10","1356036214","1355750778","20","4627","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7290","1446","11","1356032739","1355750778","20","4627","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7291","1446","10","1356025136","1355750778","20","4627","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7292","1446","10","1356029048","1355750778","20","4627","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7293","1446","10","1356024950","1355750778","20","4627","0","1355752836");
INSERT INTO kolhoz_petground VALUES("7294","1361","10","1355974719","1355686696","20","1525","0","1355686905");
INSERT INTO kolhoz_petground VALUES("7295","1361","0","1355569259","1355290154","20","9978","0","1355291237");
INSERT INTO kolhoz_petground VALUES("7296","1361","0","1355569259","1355290154","20","9984","0","1355291243");
INSERT INTO kolhoz_petground VALUES("7297","1371","12","1355804217","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7298","1416","12","1356039074","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7299","1447","2","1355351867","1355323053","2","13014","0","1355324802");
INSERT INTO kolhoz_petground VALUES("7300","1447","1","1355337467","1355323053","1","13014","0","1355324802");
INSERT INTO kolhoz_petground VALUES("7301","1447","1","1355337467","1355323053","1","13014","0","1355324802");
INSERT INTO kolhoz_petground VALUES("7302","1447","2","1355337467","1355323053","1","13014","0","1355324802");
INSERT INTO kolhoz_petground VALUES("7303","1332","4","1355193948","1354905930","20","53863","0","1354959811");
INSERT INTO kolhoz_petground VALUES("7304","1447","1","1355337467","1355323053","1","13014","0","1355324802");
INSERT INTO kolhoz_petground VALUES("7305","1417","26","1356035654","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7306","1411","14","1356034341","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7307","1411","14","1356034341","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7308","1371","12","1355804217","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7309","1371","12","1355804217","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7310","1448","14","1356037331","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7311","1448","14","1356035819","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7312","1448","14","1356035935","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7313","1448","14","1356035935","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7314","1448","14","1356036381","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7315","1448","14","1356036381","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("8534","1586","1","1355534550","1355520130","1","429","0","1355520579");
INSERT INTO kolhoz_petground VALUES("7317","1453","6","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7318","1453","10","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7319","1453","10","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7320","1454","5","1356033844","1355758587","20","13031","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7321","1454","5","1356033844","1355758587","20","13031","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7322","1454","5","1356033844","1355758587","20","13031","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7323","1454","5","1356033844","1355758587","20","13031","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7324","1454","7","1356033844","1355758587","20","13557","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7325","1454","7","1356033844","1355758587","20","13592","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7326","1454","10","1356033844","1355758587","20","14026","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7327","1454","10","1356033844","1355758587","20","14026","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7328","1454","10","1356033844","1355758587","20","14026","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7329","1448","14","1356036381","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7330","1455","12","1355997575","1355718384","20","2792","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7331","1455","12","1355997575","1355718401","20","2775","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7332","1455","12","1355997575","1355718419","20","2757","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7333","1455","12","1355997575","1355718441","20","2735","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7334","1455","12","1355998695","1355718458","20","2718","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7335","1455","12","1355999480","1355718589","20","2587","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7336","1457","16","1356018086","1355731861","20","13240","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7337","1457","16","1356018086","1355731861","20","13227","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7338","1457","16","1356018086","1355731861","20","13218","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7339","1457","16","1356006888","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7340","1456","10","1356041007","1355761082","20","7658","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7341","1456","10","1356041998","1355761082","20","7658","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7342","1456","7","1356042126","1355761082","20","7658","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7343","1456","10","1356044634","1355761082","20","7658","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7344","1449","10","1356024809","1355741885","20","4967","0","1355742303");
INSERT INTO kolhoz_petground VALUES("7345","1449","10","1356016943","1355741885","20","4997","0","1355742303");
INSERT INTO kolhoz_petground VALUES("7346","1449","10","1356018243","1355741885","20","4997","0","1355742303");
INSERT INTO kolhoz_petground VALUES("7347","1449","10","1356018243","1355741885","20","4997","0","1355742303");
INSERT INTO kolhoz_petground VALUES("7348","1417","26","1356037744","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7349","1417","26","1356037744","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7350","1417","26","1356037744","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7351","1412","6","1355774597","1355760204","1","2069","0","1355762188");
INSERT INTO kolhoz_petground VALUES("7352","1416","12","1356046692","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7353","1416","12","1356046692","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7354","1416","12","1356046692","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7355","1416","12","1356046692","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7356","1416","12","1356046692","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7357","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7358","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7359","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7360","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7361","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7362","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7363","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7364","1416","12","1356048032","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7365","1448","14","1356036381","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7366","1333","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7367","1333","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7368","1333","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7369","1333","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7370","1394","7","1355715842","1355440238","20","13206","0","1355441048");
INSERT INTO kolhoz_petground VALUES("7371","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7372","1448","14","1356036381","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7373","1448","14","1356037631","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7374","1448","14","1356037631","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7375","1448","14","1356038186","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7376","1448","14","1356038186","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7377","1448","14","1356026611","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7378","1448","14","1356033417","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7379","1448","14","1356035655","1355750631","20","3105","0","1355751686");
INSERT INTO kolhoz_petground VALUES("7380","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7381","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7382","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7383","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7384","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7385","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7386","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7387","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7388","1448","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7389","1358","10","1355820746","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7390","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7391","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7392","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7393","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7394","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7395","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7396","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7397","1417","26","1356044623","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7398","1416","12","1356045210","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7399","1416","12","1356045210","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7400","1416","12","1356045210","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7401","1416","12","1356045210","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7402","1416","12","1356045210","1355760170","20","12386","0","1355760287");
INSERT INTO kolhoz_petground VALUES("7403","1411","14","1356032223","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7404","1411","14","1356032223","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7405","1411","14","1356032223","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7406","1411","14","1356032223","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7407","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7408","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7409","1411","14","1356033484","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7410","1411","14","1356033484","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7411","1411","14","1356033484","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7412","1411","14","1356033484","1355754571","20","1180","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7413","1411","14","1356033484","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7414","1411","14","1356033484","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7415","1411","14","1356033484","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7416","1411","14","1356033484","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7417","1427","7","1355845975","1355555368","20","130645","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7418","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7419","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7420","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7421","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7422","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7423","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7424","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7425","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7426","1417","26","1356033560","1355756628","20","4169","0","1355757362");
INSERT INTO kolhoz_petground VALUES("7427","1353","11","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("7428","1353","0","1356010848","1355757292","20","893","0","1355757366");
INSERT INTO kolhoz_petground VALUES("7429","1353","14","1356010848","1355757420","20","293","0","1355757713");
INSERT INTO kolhoz_petground VALUES("7430","1371","12","1355795455","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7431","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7432","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7433","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7434","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7435","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7436","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7437","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7438","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7439","1411","14","1356028818","1355754571","20","1186","0","1355754796");
INSERT INTO kolhoz_petground VALUES("7440","1453","9","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7441","1474","12","1356007058","1355726740","20","28270","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7442","1474","0","1355978335","1355698547","20","9127","0","1355699041");
INSERT INTO kolhoz_petground VALUES("7443","1474","10","1356007135","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7444","1474","10","1356009311","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7445","1474","10","1356009401","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7446","1453","9","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7447","1474","10","1356009401","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7448","1453","9","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7449","1474","10","1356009401","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7450","1474","10","1356009587","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7451","1453","9","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7452","1474","10","1356009625","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7453","1474","10","1356009625","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7454","1474","10","1356009625","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7455","1474","10","1356009625","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("7456","1453","9","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7457","1453","9","1355997206","1355358046","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("7458","1456","7","1356046096","1355761082","20","7717","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7459","1456","7","1356041308","1355761082","20","7684","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7460","1456","7","1356041366","1355761082","20","7653","0","1355761319");
INSERT INTO kolhoz_petground VALUES("7461","1455","12","1356001949","1355718606","20","2570","0","1355721176");
INSERT INTO kolhoz_petground VALUES("7462","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7463","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7464","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7465","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7466","1457","16","1356006767","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7467","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7468","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7469","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7470","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7471","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7472","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7473","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7474","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7475","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7476","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7477","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7478","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7479","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7480","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7481","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7482","1443","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7483","1485","9","1355775144","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7484","1485","9","1355775194","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7485","1485","9","1355777097","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7486","1485","9","1355777142","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7487","1492","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7488","1492","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7489","1492","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7490","1492","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7491","1504","9","1355467625","1355180577","20","264053","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7492","1504","9","1355467625","1355180577","20","264053","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7493","1504","9","1355458787","1355180577","20","264053","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7494","1504","9","1355468578","1355180577","20","264052","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7495","1505","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7496","1505","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7497","1505","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7498","1505","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7499","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7500","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7501","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7502","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7503","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7504","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7505","1497","104","1356010959","1355729922","20","25824","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7506","1497","104","1356010959","1355729922","20","25824","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7507","1497","104","1356010959","1355729922","20","25824","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7508","1497","104","1356010959","1355729922","20","25824","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7509","1498","11","1355993547","1355714403","20","12238","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7510","1498","11","1355993742","1355714475","20","65","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7511","1498","7","1355993761","1355714403","20","6991","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7512","1498","7","1355993829","1355714403","20","6980","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7513","1501","12","1355840170","1355564687","20","13521","0","1355565691");
INSERT INTO kolhoz_petground VALUES("7514","1501","0","1355377449","1355171409","20","12720","0","1355171442");
INSERT INTO kolhoz_petground VALUES("7515","1501","0","1355377449","1355171409","20","12752","0","1355171451");
INSERT INTO kolhoz_petground VALUES("7516","1501","0","1355377608","1355171409","20","12704","0","1355171459");
INSERT INTO kolhoz_petground VALUES("7517","1504","9","1355194978","1355180577","1","15352","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7518","1504","9","1355194978","1355180577","1","15352","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7519","1504","9","1355195105","1355180690","1","14400","0","1355443678");
INSERT INTO kolhoz_petground VALUES("7520","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7521","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7522","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7523","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7524","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7525","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7526","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7527","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7528","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7529","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7530","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7531","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7532","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7533","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7534","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7535","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7536","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7537","1507","26","1355406997","1355058984","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7538","1507","26","1355406997","1355059027","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7539","1507","26","1355406997","1355060687","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7540","1507","26","1355406997","1355060777","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7541","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7542","1485","9","1355777197","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7543","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7544","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7545","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7546","1504","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7547","1510","16","1356050047","1355762159","20","11781","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7548","1510","16","1356050047","1355762159","20","11761","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7549","1510","16","1356050047","1355762159","20","11735","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7550","1510","16","1356050047","1355762159","20","11639","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7551","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7552","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7553","1428","20","1355848792","1355564194","20","3789","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7554","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7555","1506","12","1356026079","1355744113","20","7644","0","1355745723");
INSERT INTO kolhoz_petground VALUES("7556","1506","12","1356026079","1355744113","20","7644","0","1355745723");
INSERT INTO kolhoz_petground VALUES("7557","1506","12","1356017724","1355744113","20","7644","0","1355745723");
INSERT INTO kolhoz_petground VALUES("7558","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7559","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7560","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7561","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7562","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7563","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7564","1498","7","1355993995","1355714403","20","6964","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7565","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7566","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7567","1510","16","1356050047","1355762159","20","11616","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7568","1510","16","1356050047","1355762159","20","11584","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7569","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7570","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7571","1498","7","1355994089","1355714403","20","6949","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7572","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7573","1498","7","1355994126","1355714403","20","6939","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7574","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7575","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7576","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7577","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7578","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7579","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7580","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7581","1428","20","1355852476","1355564194","20","105","0","1355564581");
INSERT INTO kolhoz_petground VALUES("7582","1497","104","1356010959","1355729922","20","25824","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7583","1497","104","1356010959","1355729922","20","25824","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7584","1497","104","1356011002","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7585","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7586","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7587","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7588","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7589","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7590","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7591","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7592","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7593","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7594","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7595","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7596","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7597","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7598","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7599","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7600","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7601","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7602","1497","104","1356013728","1355729922","20","25781","0","1355748783");
INSERT INTO kolhoz_petground VALUES("7603","1503","11","1356010324","1355727985","20","5984","0","1355730935");
INSERT INTO kolhoz_petground VALUES("7604","1503","11","1356010854","1355727985","20","5984","0","1355730935");
INSERT INTO kolhoz_petground VALUES("7605","1503","11","1356002191","1355727985","20","5984","0","1355730935");
INSERT INTO kolhoz_petground VALUES("7606","1503","11","1356004454","1355727985","20","5984","0","1355730935");
INSERT INTO kolhoz_petground VALUES("7607","1501","0","1355377449","1355171409","20","12644","0","1355171468");
INSERT INTO kolhoz_petground VALUES("7608","1501","0","1355377608","1355171409","20","12394","0","1355171477");
INSERT INTO kolhoz_petground VALUES("7609","1501","0","1355377608","1355171409","20","12390","0","1355171500");
INSERT INTO kolhoz_petground VALUES("7610","1501","0","1355378602","1355171409","20","8911","0","1355171513");
INSERT INTO kolhoz_petground VALUES("7611","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("7612","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("7613","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("7614","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("7615","1498","7","1355997196","1355714403","20","6926","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7616","1498","7","1355997196","1355714403","20","6915","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7617","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7618","1507","26","1355406997","1355061473","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7619","1507","26","1355406997","1355061752","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7620","1507","26","1355406997","1355061794","20","302400","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7621","1507","26","1355407091","1355119035","20","288000","0","1355760586");
INSERT INTO kolhoz_petground VALUES("7622","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7623","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7624","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7625","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7626","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7627","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7628","1501","0","1355378602","1355171409","20","8925","0","1355171527");
INSERT INTO kolhoz_petground VALUES("7629","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7630","1501","0","1355378602","1355171409","20","8945","0","1355171547");
INSERT INTO kolhoz_petground VALUES("7631","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7632","1509","11","1355998067","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7633","1509","11","1355998169","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7634","1509","11","1355998342","1355716316","20","28772","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7635","1509","10","1355998342","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7636","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7637","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7638","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7639","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7640","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7641","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7642","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7643","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7644","1507","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7645","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7646","1501","0","1355378602","1355171409","20","8968","0","1355171570");
INSERT INTO kolhoz_petground VALUES("7647","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7648","1501","0","1355378602","1355171409","20","8984","0","1355171586");
INSERT INTO kolhoz_petground VALUES("7649","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7650","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7651","1501","0","1355378824","1355171409","20","8776","0","1355171600");
INSERT INTO kolhoz_petground VALUES("7652","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7653","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7654","1501","0","1355378824","1355171409","20","8789","0","1355171613");
INSERT INTO kolhoz_petground VALUES("7655","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7656","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7657","1501","0","1355378824","1355171409","20","8801","0","1355171625");
INSERT INTO kolhoz_petground VALUES("7658","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7659","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7660","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7661","1501","0","1355378824","1355171409","20","8837","0","1355171661");
INSERT INTO kolhoz_petground VALUES("7662","1501","0","1355378824","1355171409","20","8856","0","1355171680");
INSERT INTO kolhoz_petground VALUES("7663","1501","0","0","1355171409","20","8585","0","1355171793");
INSERT INTO kolhoz_petground VALUES("7664","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7665","1501","0","0","1355171409","20","8585","0","1355171877");
INSERT INTO kolhoz_petground VALUES("7666","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7667","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7668","1501","0","0","1355171409","20","8585","0","1355171864");
INSERT INTO kolhoz_petground VALUES("7669","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7670","1501","11","1355840170","1355564687","20","13521","0","1355565691");
INSERT INTO kolhoz_petground VALUES("7671","1501","11","1355840170","1355564687","20","13521","0","1355565691");
INSERT INTO kolhoz_petground VALUES("7672","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7673","1501","11","1355840170","1355564687","20","13521","0","1355565691");
INSERT INTO kolhoz_petground VALUES("7674","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7675","1501","11","1355840170","1355564687","20","13521","0","1355565691");
INSERT INTO kolhoz_petground VALUES("7676","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7677","1501","11","1355840170","1355564687","20","13521","0","1355565691");
INSERT INTO kolhoz_petground VALUES("7678","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7679","1496","22","1355845997","1355560954","20","2957","0","1355560954");
INSERT INTO kolhoz_petground VALUES("7680","1509","10","1355998565","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7681","1509","10","1355998565","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7682","1509","10","1355998565","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7683","1498","7","1355998632","1355714403","20","6905","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7684","1498","7","1355998632","1355714403","20","6874","0","1355714540");
INSERT INTO kolhoz_petground VALUES("7685","1522","7","1355699604","1355417527","20","273014","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7686","1522","7","1355699604","1355417527","20","273002","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7687","1522","7","1355699604","1355417527","20","272989","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7688","1522","7","1355699604","1355417527","20","272962","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7689","1520","10","1356028492","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7690","1520","10","1356030141","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7691","1520","10","1356030141","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7692","1520","10","1356030234","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7693","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7694","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7695","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7696","1488","10","1356038853","1355752678","20","3688","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7697","1522","7","1355699604","1355417527","20","272874","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7698","1522","7","1355699604","1355417527","20","272831","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7699","1522","7","1355699604","1355417527","20","272767","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7700","1522","7","1355699604","1355417527","20","272741","0","1355686990");
INSERT INTO kolhoz_petground VALUES("7701","1521","1","1355839616","1355308662","20","257466","0","1355564282");
INSERT INTO kolhoz_petground VALUES("7702","1521","11","1355839616","1355308662","20","256934","0","1355564282");
INSERT INTO kolhoz_petground VALUES("7703","1521","11","1355839616","1355308662","20","256864","0","1355564282");
INSERT INTO kolhoz_petground VALUES("7704","1521","11","1355841429","1355308662","20","256864","0","1355564282");
INSERT INTO kolhoz_petground VALUES("7705","1521","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7706","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7707","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7708","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7709","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7710","1477","0","1355670496","1355386640","20","1400","0","1355386679");
INSERT INTO kolhoz_petground VALUES("7711","1477","0","1355670496","1355386640","20","1324","0","1355386683");
INSERT INTO kolhoz_petground VALUES("7712","1477","0","1355670496","1355386640","20","1303","0","1355386692");
INSERT INTO kolhoz_petground VALUES("7713","1477","0","1355670496","1355386640","20","1208","0","1355386688");
INSERT INTO kolhoz_petground VALUES("7714","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7715","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7716","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7717","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7718","1477","0","1355670496","1355386640","20","1215","0","1355386695");
INSERT INTO kolhoz_petground VALUES("7719","1477","0","1355670496","1355386640","20","1220","0","1355386700");
INSERT INTO kolhoz_petground VALUES("7720","1521","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7721","1477","0","1355670496","1355386640","20","1226","0","1355386706");
INSERT INTO kolhoz_petground VALUES("7722","1477","0","1355670496","1355386640","20","1229","0","1355386709");
INSERT INTO kolhoz_petground VALUES("7723","1477","0","1355670897","1355386640","20","1233","0","1355386713");
INSERT INTO kolhoz_petground VALUES("7724","1477","0","1355670897","1355386640","20","1259","0","1355386739");
INSERT INTO kolhoz_petground VALUES("7725","1477","0","1355670897","1355386640","20","1263","0","1355386743");
INSERT INTO kolhoz_petground VALUES("7726","1477","0","1355670897","1355386640","20","1266","0","1355386746");
INSERT INTO kolhoz_petground VALUES("7727","1483","10","1356030579","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7728","1483","10","1356031692","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7729","1483","14","1356031949","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7730","1483","12","1356032057","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7731","1520","10","1356030234","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7732","1520","10","1356030234","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7733","1509","10","1356001639","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7734","1520","10","1356030478","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7735","1520","10","1356030478","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7736","1520","10","1356030478","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7737","1520","10","1356031699","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7738","1520","10","1356031699","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7739","1485","9","1355773845","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7740","1520","10","1356031699","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7741","1485","9","1355773859","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7742","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7743","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7744","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7745","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7746","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7747","1485","9","1355773859","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7748","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7749","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7750","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7751","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7752","1510","16","1356050047","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7753","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7754","1485","9","1355773859","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7755","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7756","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7757","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7758","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7759","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7760","1520","10","1356031699","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7761","1520","10","1356031699","1355744256","20","14750","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7762","1520","10","1356032985","1355744256","20","14817","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7763","1520","10","1356032985","1355744256","20","14817","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7764","1520","10","1356032985","1355744256","20","14817","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7765","1520","10","1356032985","1355744256","20","14817","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7766","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7767","1520","10","1356032985","1355744256","20","14817","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7768","1510","16","1356037302","1355762159","20","11554","0","1355762205");
INSERT INTO kolhoz_petground VALUES("7769","1520","10","1356032985","1355744256","20","14817","0","1355745402");
INSERT INTO kolhoz_petground VALUES("7770","1427","7","1355845593","1355555368","20","130645","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7771","1427","7","1355845593","1355555368","20","130645","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7772","1427","7","1355845593","1355555368","20","130645","0","1355685931");
INSERT INTO kolhoz_petground VALUES("7773","1483","12","1356032890","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7774","1483","12","1356033037","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7775","1483","12","1356033118","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7776","1483","12","1356033235","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7777","1483","12","1356033396","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7778","1483","12","1356033479","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7779","1528","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7780","1528","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7781","1528","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7782","1528","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7783","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7784","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7785","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7786","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7787","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7788","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7789","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7790","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7791","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7792","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7793","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7794","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7795","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7796","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7797","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7798","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7799","1049","10","1356040570","1355759716","20","7106","0","1355762192");
INSERT INTO kolhoz_petground VALUES("7800","1529","36","1356035667","1355751954","20","19292","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7801","1529","36","1356035667","1355751954","20","19292","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7802","1529","36","1356035667","1355751954","20","19292","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7803","1529","36","1356035667","1355751954","20","19292","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7804","1532","12","0","1355151230","1","0","0","1355152206");
INSERT INTO kolhoz_petground VALUES("7805","1532","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7806","1532","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7807","1532","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7808","1523","10","1356026242","1355742664","20","10480","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7809","1523","10","1356026242","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7810","1523","10","1356026242","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7811","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7812","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7813","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7814","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7815","1141","7","1355794648","1355507597","20","1775","0","1355508423");
INSERT INTO kolhoz_petground VALUES("7816","1141","7","1355794740","1355507597","20","1683","0","1355508423");
INSERT INTO kolhoz_petground VALUES("7817","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7818","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7819","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7820","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7821","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7822","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7823","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7824","1523","10","1356030084","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7825","1531","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7826","1531","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7827","1531","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7828","1531","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7829","1488","10","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7830","1488","10","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("7831","1467","10","1355782196","1355725309","20","43799","0","1355759001");
INSERT INTO kolhoz_petground VALUES("7832","1467","10","1355782202","1355725309","20","36309","0","1355759001");
INSERT INTO kolhoz_petground VALUES("7833","1467","10","1355782206","1355725309","20","40402","0","1355759001");
INSERT INTO kolhoz_petground VALUES("7834","1467","10","1355782211","1355725309","20","34189","0","1355759001");
INSERT INTO kolhoz_petground VALUES("7835","1467","10","1355782250","1355725309","20","37124","0","1355759001");
INSERT INTO kolhoz_petground VALUES("7836","1353","12","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("7837","1485","9","1355774626","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7838","1485","9","1355774626","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7839","1485","9","1355774626","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("7840","1530","10","1355857845","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7841","1530","10","1355845598","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7842","1530","10","1355847085","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7843","1530","10","1355845706","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7844","1523","10","1356017391","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7845","1523","10","1356017391","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7846","1523","10","1356017391","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7847","1523","10","1356017391","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7848","1523","10","1356017391","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("7849","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7850","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7851","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7852","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7853","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7854","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7855","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7856","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7857","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7858","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7859","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7860","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7861","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7862","1038","26","1356035003","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7863","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7864","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7865","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7866","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7867","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7868","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7869","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7870","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7871","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7872","1038","26","1356035118","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7873","1038","26","1356035141","1355748608","20","7896","0","1355754893");
INSERT INTO kolhoz_petground VALUES("7874","1509","10","1356003135","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7875","1509","10","1356003135","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7876","1509","10","1356003135","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7877","1509","10","1356003135","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7878","1509","10","1355995751","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7879","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7880","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7881","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7882","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("7883","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7884","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7885","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7886","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7887","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7888","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7889","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7890","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7891","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7892","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7893","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7894","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7895","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7896","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7897","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7898","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7899","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7900","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7901","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7902","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7903","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7904","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7905","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7906","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7907","1537","16","1355442987","1355376725","20","72000","0","1355696085");
INSERT INTO kolhoz_petground VALUES("7908","1454","10","1356033844","1355758587","20","1083","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7909","1454","10","1356034356","1355758587","20","1394","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7910","1521","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7911","1521","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("7912","1529","36","1356035705","1355751954","20","19292","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7913","1529","36","1356035778","1355751954","20","19292","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7914","1530","10","1355849776","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7915","1530","10","1355849776","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7916","1530","10","1355849970","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7917","1530","10","1355849970","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7918","1530","10","1355849970","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7919","1530","10","1355849970","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7920","1529","36","1356029230","1355751954","20","19730","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7921","1529","36","1356029230","1355751954","20","19730","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7922","1529","36","1356029230","1355751954","20","19730","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7923","1529","36","1356029230","1355751954","20","19730","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7924","1529","36","1356029230","1355751954","20","19730","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7925","1529","36","1356029512","1355751954","20","19448","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7926","1529","36","1356029512","1355751954","20","19448","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7927","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7928","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7929","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7930","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7931","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7932","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7933","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7934","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7935","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7936","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7937","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7938","1529","36","1356034563","1355751954","20","19445","0","1355760959");
INSERT INTO kolhoz_petground VALUES("7939","1384","14","1355996563","1355717106","20","7930","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7940","1384","14","1355996563","1355717106","20","7857","0","1355718121");
INSERT INTO kolhoz_petground VALUES("7941","1530","10","1355853059","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7942","1509","10","1356001270","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7943","1509","10","1356002628","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7944","1509","10","1355991550","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7945","1509","10","1355992570","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("7946","1530","10","1355854380","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7947","1530","10","1355854380","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7948","1530","10","1355854380","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7949","1530","10","1355854380","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7950","1530","10","1355854380","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7951","1353","12","1356010848","1355757292","20","2031","0","1355757713");
INSERT INTO kolhoz_petground VALUES("7952","1358","10","1355826029","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("7953","1467","10","1355781033","1355725309","20","36432","0","1355759001");
INSERT INTO kolhoz_petground VALUES("7954","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7955","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7956","1457","16","1356006959","1355731861","20","13204","0","1355732092");
INSERT INTO kolhoz_petground VALUES("7957","1412","4","1355774597","1355760204","1","1991","0","1355762188");
INSERT INTO kolhoz_petground VALUES("7958","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7959","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7960","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7961","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7962","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7963","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7964","1518","6","1355684753","1355584472","7","19","0","1355584472");
INSERT INTO kolhoz_petground VALUES("7965","1518","5","1355684753","1355584472","7","19","0","1355584472");
INSERT INTO kolhoz_petground VALUES("7966","1518","5","1355684753","1355584472","7","19","0","1355584472");
INSERT INTO kolhoz_petground VALUES("7967","1518","7","1355684753","1355584472","7","81","0","1355584472");
INSERT INTO kolhoz_petground VALUES("7968","1518","6","1355684753","1355584472","7","53","0","1355584472");
INSERT INTO kolhoz_petground VALUES("7969","1518","7","1355684753","1355584472","7","53","0","1355584472");
INSERT INTO kolhoz_petground VALUES("7970","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7971","1454","10","1356033844","1355758587","20","1390","0","1355758875");
INSERT INTO kolhoz_petground VALUES("7972","1530","10","1355850573","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("7973","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7974","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7975","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7976","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7977","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("7978","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7979","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7980","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7981","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7982","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7983","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7984","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7985","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7986","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7987","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("7988","1483","12","1356026905","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("7989","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7990","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7991","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7992","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7993","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7994","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7995","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7996","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7997","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7998","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("7999","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8000","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8001","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8002","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8003","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8004","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8005","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8006","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8007","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8008","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8009","1545","101","1355973510","1355326196","20","308487","0","1355720397");
INSERT INTO kolhoz_petground VALUES("8010","1483","12","1356027715","1355742425","20","9183","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8011","1538","2","1355426706","1355401219","20","28800","0","1355577169");
INSERT INTO kolhoz_petground VALUES("8012","1530","10","1355853546","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8013","1530","10","1355853546","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8014","1474","10","1356008775","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8015","1474","10","1356009059","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8016","1474","10","1356009059","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8017","1474","10","1356009059","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8018","1353","12","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8019","1533","7","1355612624","1355581120","3","11740","0","1355581164");
INSERT INTO kolhoz_petground VALUES("8020","1533","7","1355612645","1355581126","3","11719","0","1355581164");
INSERT INTO kolhoz_petground VALUES("8021","1533","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8022","1533","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8023","1474","10","1356003896","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8024","1394","7","1355727784","1355440238","20","13206","0","1355441048");
INSERT INTO kolhoz_petground VALUES("8025","1547","11","1355706397","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8026","1547","11","1355706397","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8027","1547","11","1355706428","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8028","1547","11","1355706445","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8029","1547","11","1355706459","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8030","1547","11","1355706470","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8031","1547","11","1355706490","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8032","1546","14","1356036274","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8033","1546","10","1356036389","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8034","1546","10","1356036548","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8035","1546","10","1356036575","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8036","1547","11","1355706501","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8037","1547","11","1355706509","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8038","1547","11","1355692729","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8039","1498","7","1355988688","1355714403","20","6863","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8040","1498","7","1355988688","1355714403","20","6851","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8041","1498","7","1355994571","1355714403","20","6837","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8042","1498","7","1355989776","1355714403","20","6823","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8043","1498","7","1355989776","1355714403","20","6811","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8044","1498","7","1355989776","1355714403","20","6795","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8045","1498","7","1355989776","1355714403","20","6781","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8046","1547","12","1355693056","1355576778","20","11279","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8047","1547","12","1355693665","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8048","1530","10","1355853546","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8049","1530","10","1355853546","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8050","1547","12","1355696338","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8051","1353","12","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8052","1547","12","1355696957","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8053","1547","12","1355696957","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8054","1483","11","1356028251","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8055","1547","12","1355697880","1355576778","20","12319","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8056","1547","12","1355698150","1355576778","20","11677","0","1355586700");
INSERT INTO kolhoz_petground VALUES("8057","1547","0","1355698624","1355576778","20","2568","0","1355576794");
INSERT INTO kolhoz_petground VALUES("8058","1547","0","1355698624","1355576778","20","2573","0","1355576799");
INSERT INTO kolhoz_petground VALUES("8059","1547","0","1355698624","1355576778","20","2581","0","1355576807");
INSERT INTO kolhoz_petground VALUES("8060","1546","10","1356045989","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8061","1546","10","1356045989","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8062","1546","10","1356045989","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8063","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8064","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8065","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8066","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8067","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8068","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8069","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8070","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8071","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8072","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8073","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8074","1546","10","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8075","1546","14","1356047646","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8076","1389","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8077","1518","6","1355684753","1355584472","7","53","0","1355584472");
INSERT INTO kolhoz_petground VALUES("8078","1474","10","1356010302","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8079","1474","10","1356010302","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8080","1474","10","1356010302","1355726740","20","33896","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8081","1494","1","1355181888","1355167469","1","14400","0","1355586708");
INSERT INTO kolhoz_petground VALUES("8082","1494","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8083","1494","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8084","1494","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8085","1509","10","1355992570","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("8086","1509","10","1355999785","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("8087","1509","10","1356002060","1355716316","20","29379","0","1355743582");
INSERT INTO kolhoz_petground VALUES("8088","1547","0","1355698728","1355576778","20","2587","0","1355576813");
INSERT INTO kolhoz_petground VALUES("8089","1546","14","1356044279","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8090","1546","14","1356044279","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8091","1546","14","1356044279","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8092","1546","14","1356044279","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8093","1546","14","1356044279","1355761169","20","1173","0","1355761931");
INSERT INTO kolhoz_petground VALUES("8094","1458","10","1356013404","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8095","1458","10","1356013404","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8096","1458","10","1356013404","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8097","1458","10","1356013404","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8098","1488","10","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("8099","1488","12","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("8100","1362","12","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8101","1362","12","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8102","1362","12","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8103","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8104","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8105","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8106","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8107","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8108","1456","7","1356038056","1355761082","20","7653","0","1355761319");
INSERT INTO kolhoz_petground VALUES("8109","1357","14","1355836866","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("8110","1357","14","1355836866","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("8111","1357","14","1355836866","1355757558","20","2867","0","1355757645");
INSERT INTO kolhoz_petground VALUES("8112","1503","10","1356010451","1355727985","20","8484","0","1355730935");
INSERT INTO kolhoz_petground VALUES("8113","1530","10","1355853244","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8114","1530","0","1355594044","1355311361","20","1748","0","1355311501");
INSERT INTO kolhoz_petground VALUES("8115","1530","11","1355853244","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8116","1498","7","1355989776","1355714403","20","6768","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8117","1498","7","1355995968","1355714403","20","6572","0","1355714540");
INSERT INTO kolhoz_petground VALUES("8118","1488","12","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("8119","1488","12","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("8120","1488","12","1356038853","1355752678","20","3834","0","1355755119");
INSERT INTO kolhoz_petground VALUES("8121","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8122","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8123","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8124","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8125","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8126","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8127","1550","7","1356021707","1355741073","20","4450","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8128","1550","7","1356021707","1355741073","20","4461","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8129","1550","7","1356021707","1355741073","20","4473","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8130","1550","7","1356021707","1355741073","20","4485","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8131","1547","0","1355703935","1355576778","20","2592","0","1355576818");
INSERT INTO kolhoz_petground VALUES("8132","1449","10","1356017616","1355741885","20","12383","0","1355742303");
INSERT INTO kolhoz_petground VALUES("8133","1550","7","1356021707","1355741073","20","4549","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8134","1550","7","1356021707","1355741073","20","4536","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8135","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8136","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8137","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8138","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8139","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8140","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8141","1550","7","1356024811","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8142","1550","7","1356024811","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8143","1550","7","1356024811","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8144","1550","7","1356024811","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8145","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8146","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8147","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8148","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8149","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8150","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8151","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8152","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8153","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8154","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8155","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8156","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8157","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8158","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8159","1548","18","1356018504","1355735717","20","25379","0","1355760510");
INSERT INTO kolhoz_petground VALUES("8160","1547","0","1355695441","1355576778","20","2599","0","1355576825");
INSERT INTO kolhoz_petground VALUES("8161","1547","0","1355695441","1355576778","20","2606","0","1355576832");
INSERT INTO kolhoz_petground VALUES("8162","1547","0","1355695509","1355576778","20","2611","0","1355576837");
INSERT INTO kolhoz_petground VALUES("8163","1550","7","1356027284","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8164","1550","7","1356027284","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8165","1550","7","1356028440","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8166","1550","7","1356028440","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8167","1550","7","1356028440","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8168","1371","12","1355806239","1355520674","20","12098","0","1355520691");
INSERT INTO kolhoz_petground VALUES("8169","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8170","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8171","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8172","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8173","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8174","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8175","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8176","1369","12","1356044555","1355762147","20","8688","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8177","1369","12","1356044555","1355762147","20","8688","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8178","1369","12","1356044555","1355762147","20","8745","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8179","1369","12","1356044555","1355762147","20","8812","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8180","1369","12","1356044555","1355762147","20","8858","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8181","1369","12","1356044555","1355762147","20","8933","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8182","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8183","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8184","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8185","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8186","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8187","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8188","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8189","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8190","1361","10","1355974719","1355686696","20","186","0","1355686905");
INSERT INTO kolhoz_petground VALUES("8191","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8192","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8193","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8194","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8195","1556","10","1356022002","1355742777","20","12184","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8196","1530","11","1355847542","1355571842","20","2939","0","1355571892");
INSERT INTO kolhoz_petground VALUES("8197","1474","10","1356007834","1355726740","20","32776","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8198","1474","10","1356007834","1355726740","20","32776","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8199","1474","10","1356007834","1355726740","20","32776","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8200","1474","10","1356007834","1355726740","20","32776","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8201","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8202","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8203","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8204","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8205","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8206","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8207","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8208","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8209","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8210","1369","12","1356037727","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8211","1369","12","1356037940","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8212","1369","10","1356039354","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8213","1369","10","1356039354","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8214","1369","11","1356039354","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8215","1369","11","1356039354","1355762147","20","9006","0","1355762186");
INSERT INTO kolhoz_petground VALUES("8216","1554","7","1355551712","1355322191","20","1107","0","1355323298");
INSERT INTO kolhoz_petground VALUES("8217","1554","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8218","1554","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8219","1554","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8220","1483","12","1356033705","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8221","1389","10","1355783821","1355507714","20","3031","0","1355507731");
INSERT INTO kolhoz_petground VALUES("8222","1523","10","1356019686","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("8223","1353","12","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8224","1353","12","1356010848","1355757292","20","1240","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8225","1474","10","1356007834","1355726740","20","32776","0","1355752610");
INSERT INTO kolhoz_petground VALUES("8226","1458","5","1356014034","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8227","1458","5","1356014034","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8228","1458","10","1356014932","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8229","1458","10","1356014992","1355728026","20","43664","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8230","1358","10","1355820447","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8231","1358","10","1355820447","1355541853","20","8838","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8232","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8233","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8234","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8235","1549","10","1355969086","1355690882","20","763","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8236","1549","10","1355969181","1355690882","20","734","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8237","1549","10","1355969200","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8238","1549","5","1355969218","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8239","1483","12","1356028512","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8240","1483","12","1356028633","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8241","1483","11","1356028771","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8242","1483","12","1356028771","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8243","1483","12","1356028881","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8244","1483","12","1356028926","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8245","1483","12","1356029164","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8246","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8247","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8248","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8249","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8250","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8251","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8252","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8253","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8254","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8255","1516","104","1355838487","1355486850","20","259792","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8256","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8257","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8258","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8259","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8260","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8261","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8262","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8263","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8264","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8265","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8266","1516","104","1355838620","1355486850","20","259659","0","1355738277");
INSERT INTO kolhoz_petground VALUES("8267","1455","12","1355997655","1355718622","20","2554","0","1355721176");
INSERT INTO kolhoz_petground VALUES("8268","1353","12","1356010848","1355757292","20","2195","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8269","1353","12","1356010848","1355757292","20","2201","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8270","1549","5","1355969416","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8271","1549","5","1355969432","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8272","1456","10","1356047539","1355761082","20","7653","0","1355761319");
INSERT INTO kolhoz_petground VALUES("8273","1483","12","1356029226","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8274","1483","12","1356029428","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8275","1483","12","1356029428","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8276","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8277","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8278","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8279","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8280","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8281","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8282","1488","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8283","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8284","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8285","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8286","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8287","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8288","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8289","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8290","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8291","1027","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8292","1027","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8293","1027","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8294","1027","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8295","1485","9","1355767922","1355752372","20","7942","0","1355759961");
INSERT INTO kolhoz_petground VALUES("8296","1483","12","1356029428","1355742425","20","9264","0","1355749515");
INSERT INTO kolhoz_petground VALUES("8297","1353","12","1356010848","1355757292","20","2201","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8298","1353","12","1356010848","1355757292","20","2201","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8299","1353","12","1356010848","1355757292","20","2201","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8300","1455","12","1356007728","1355718639","20","2537","0","1355721176");
INSERT INTO kolhoz_petground VALUES("8301","1455","12","1356007827","1355718657","20","2519","0","1355721176");
INSERT INTO kolhoz_petground VALUES("8302","1455","12","1356008482","1355718674","20","2502","0","1355721176");
INSERT INTO kolhoz_petground VALUES("8303","1556","11","1356022002","1355742777","20","12576","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8304","1549","5","1355970258","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8305","1549","5","1355970258","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8306","1562","1","1355774580","1355760700","1","1522","0","1355762185");
INSERT INTO kolhoz_petground VALUES("8307","1562","1","1355774607","1355511126","1","11527","0","1355762185");
INSERT INTO kolhoz_petground VALUES("8308","1562","1","1355774841","1355760215","1","1744","0","1355762185");
INSERT INTO kolhoz_petground VALUES("8309","1562","1","1355774854","1355760446","1","1731","0","1355762185");
INSERT INTO kolhoz_petground VALUES("8310","1562","1","1355774889","1355760463","1","1696","0","1355762185");
INSERT INTO kolhoz_petground VALUES("8311","1384","14","1356005102","1355717106","20","7835","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8312","1384","14","1356005161","1355717106","20","7813","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8313","1353","12","1356010848","1355757292","20","2201","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8314","1353","12","1356010848","1355757292","20","2201","0","1355757713");
INSERT INTO kolhoz_petground VALUES("8315","1566","7","1355785866","1355749860","3","2959","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8316","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8317","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8318","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8319","1562","2","1355774898","1355760469","1","1687","0","1355762185");
INSERT INTO kolhoz_petground VALUES("8320","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8321","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8322","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8323","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8324","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8325","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8326","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8327","1553","14","1356008467","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8328","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8329","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8330","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8331","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8332","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8333","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8334","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8335","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8336","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8337","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8338","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8339","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8340","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8341","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8342","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8343","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8344","1553","14","1356008158","1355726172","20","20732","0","1355741199");
INSERT INTO kolhoz_petground VALUES("8345","1453","11","1355997206","1355358316","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8346","1453","12","1355997206","1355358424","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8347","1453","12","1355997206","1355358449","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8348","1453","12","1355997206","1355358477","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8349","1453","12","1355997206","1355358503","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8350","1453","12","1355997206","1355358534","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8351","1453","12","1355997206","1355358553","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8352","1453","12","1355997206","1355358572","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8353","1453","12","1355997206","1355358596","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8354","1453","12","1355997206","1355358619","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8355","1453","12","1355997206","1355358637","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8356","1453","12","1355997206","1355358661","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8357","1453","12","1355997206","1355358687","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8358","1453","12","1355997206","1355358708","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8359","1453","12","1355997206","1355358732","20","316724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8360","1477","0","1355669050","1355386640","20","1270","0","1355386750");
INSERT INTO kolhoz_petground VALUES("8361","1477","0","1355669050","1355386640","20","1273","0","1355386753");
INSERT INTO kolhoz_petground VALUES("8362","1477","0","1355669050","1355386640","20","1281","0","1355386761");
INSERT INTO kolhoz_petground VALUES("8363","1477","0","1355669050","1355386640","20","1277","0","1355386757");
INSERT INTO kolhoz_petground VALUES("8364","1477","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8365","1477","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8366","1477","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8367","1477","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8368","1477","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8369","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8370","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8371","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8372","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8373","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8374","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8375","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8376","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8377","1361","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8378","1564","7","1356031605","1355745727","20","15594","0","1355760552");
INSERT INTO kolhoz_petground VALUES("8379","1564","7","1356031679","1355745727","20","15594","0","1355760552");
INSERT INTO kolhoz_petground VALUES("8380","1564","5","1356031605","1355745727","20","15594","0","1355760552");
INSERT INTO kolhoz_petground VALUES("8381","1564","7","1356031755","1355745727","20","15594","0","1355760552");
INSERT INTO kolhoz_petground VALUES("8382","1564","7","1356031755","1355745727","20","15594","0","1355760552");
INSERT INTO kolhoz_petground VALUES("8383","1568","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8384","1568","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8385","1568","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8386","1568","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8387","1569","10","1355982566","1355737775","20","5500","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8388","1569","10","1355982574","1355737775","20","5477","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8389","1569","10","1355982583","1355737775","20","5455","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8390","1569","10","1355982591","1355737775","20","5437","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8391","1523","10","1356029054","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("8392","1523","10","1356029054","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("8393","1523","10","1356029054","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("8394","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8395","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8396","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8397","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8398","1506","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8399","1454","10","1356033844","1355758587","20","1390","0","1355758875");
INSERT INTO kolhoz_petground VALUES("8400","1454","11","1356033844","1355758587","20","1390","0","1355758875");
INSERT INTO kolhoz_petground VALUES("8401","1454","0","0","1355703488","20","0","0","1355703506");
INSERT INTO kolhoz_petground VALUES("8402","1564","7","1356034861","1355745727","20","15594","0","1355760552");
INSERT INTO kolhoz_petground VALUES("8403","1569","10","1355979873","1355737775","20","5417","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8404","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8405","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8406","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8407","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8408","1362","10","1356042922","1355755378","20","2053","0","1355756983");
INSERT INTO kolhoz_petground VALUES("8409","1503","10","1356008499","1355727985","20","8484","0","1355730935");
INSERT INTO kolhoz_petground VALUES("8410","1570","5","1355471830","1355471919","20","254","0","1355757657");
INSERT INTO kolhoz_petground VALUES("8411","1570","10","1355428660","1355494131","20","0","0","1355757657");
INSERT INTO kolhoz_petground VALUES("8412","1570","10","1355428682","1355520011","20","0","0","1355757657");
INSERT INTO kolhoz_petground VALUES("8413","1570","10","1355428702","1355526277","20","0","0","1355757657");
INSERT INTO kolhoz_petground VALUES("8414","1570","10","1355428729","1355735642","20","0","0","1355757657");
INSERT INTO kolhoz_petground VALUES("8415","1569","10","1355976766","1355737775","20","5402","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8416","1569","10","1355976766","1355737775","20","5378","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8417","1569","10","1355976766","1355737775","20","5344","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8418","1569","10","1355976766","1355737775","20","5313","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8419","1572","1","0","1355414261","3","0","0","1355429525");
INSERT INTO kolhoz_petground VALUES("8420","1572","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8421","1572","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8422","1572","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8423","1523","10","1356021410","1355742664","20","10423","0","1355753000");
INSERT INTO kolhoz_petground VALUES("8424","1549","10","1355966504","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8425","1549","10","1355966504","1355690882","20","702","0","1355690989");
INSERT INTO kolhoz_petground VALUES("8426","1363","2","1356050004","1355422084","20","302588","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8427","1363","7","1356050004","1355422450","20","302588","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8428","1363","7","1355920404","1355422623","20","302588","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8429","1363","7","1355725366","1355422650","20","302400","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8430","1575","1","1355484875","1355470385","1","14400","0","1355566423");
INSERT INTO kolhoz_petground VALUES("8431","1575","1","1355484888","1355470406","1","14400","0","1355566423");
INSERT INTO kolhoz_petground VALUES("8432","1575","1","1355484901","1355470424","1","14400","0","1355566423");
INSERT INTO kolhoz_petground VALUES("8433","1575","1","1355484918","1355470460","1","14400","0","1355566423");
INSERT INTO kolhoz_petground VALUES("8434","1363","7","1355725366","1355422745","20","302400","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8435","1363","7","1355725366","1355422776","20","302400","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8436","1363","7","1355725366","1355422800","20","302400","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8437","1363","7","1355725366","1355422828","20","302400","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8438","1141","10","1355787235","1355507597","20","9188","0","1355508423");
INSERT INTO kolhoz_petground VALUES("8439","1458","11","1356005359","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8440","1458","11","1356005359","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8441","1458","11","1356005359","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8442","1458","11","1356005359","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8443","1458","11","1356005359","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8444","1458","11","1356005359","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8445","1458","11","1356005936","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8446","1458","11","1356005936","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8447","1577","16","1355485948","1355470289","1","14400","0","1355491881");
INSERT INTO kolhoz_petground VALUES("8448","1577","13","1355485948","1355470400","1","14400","0","1355491881");
INSERT INTO kolhoz_petground VALUES("8449","1577","1","1355485948","1355470424","1","14400","0","1355491881");
INSERT INTO kolhoz_petground VALUES("8450","1577","2","1355485948","1355470445","1","14400","0","1355491881");
INSERT INTO kolhoz_petground VALUES("8451","1458","11","1356007205","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8452","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8453","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8454","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8455","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8456","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8457","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8458","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8459","1458","11","1356007487","1355728026","20","43697","0","1355761056");
INSERT INTO kolhoz_petground VALUES("8460","1363","10","1355723501","1355435465","20","288000","0","1355762192");
INSERT INTO kolhoz_petground VALUES("8461","1578","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8462","1578","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8463","1578","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8464","1578","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8465","1579","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8466","1579","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8467","1579","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8468","1579","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8469","1384","14","1355998391","1355717106","20","7730","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8470","1580","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8471","1580","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8472","1580","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8473","1580","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8474","1358","10","1355823596","1355541853","20","6463","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8475","1358","10","1355823596","1355541853","20","6463","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8476","1358","10","1355823596","1355541853","20","6463","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8477","1358","10","1355823596","1355541853","20","6463","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8478","1503","10","1356013050","1355727985","20","5885","0","1355730935");
INSERT INTO kolhoz_petground VALUES("8479","1503","10","1356013460","1355727985","20","5475","0","1355730935");
INSERT INTO kolhoz_petground VALUES("8480","1358","10","1355556258","1355541853","1","201","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8481","1358","10","1355556258","1355541853","1","201","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8482","1358","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8483","1358","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8484","1358","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8485","1358","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8486","1358","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8487","1358","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8488","1358","10","1355827617","1355541853","20","6463","0","1355542059");
INSERT INTO kolhoz_petground VALUES("8489","1565","1","1355699886","1355685473","1","5335","0","1355690821");
INSERT INTO kolhoz_petground VALUES("8490","1565","1","1355699901","1355685492","1","5320","0","1355690821");
INSERT INTO kolhoz_petground VALUES("8491","1565","1","1355699982","1355685566","1","5239","0","1355690821");
INSERT INTO kolhoz_petground VALUES("8492","1565","1","1355700018","1355685591","1","5203","0","1355690821");
INSERT INTO kolhoz_petground VALUES("8493","1565","1","1355700247","1355685599","1","4974","0","1355690821");
INSERT INTO kolhoz_petground VALUES("8494","1565","1","1355700258","1355685606","1","4963","0","1355690821");
INSERT INTO kolhoz_petground VALUES("8495","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8496","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8497","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8498","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8499","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8500","1566","7","1355754949","1355749860","1","2954","0","1355752759");
INSERT INTO kolhoz_petground VALUES("8501","1583","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8502","1583","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8503","1583","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8504","1583","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8505","1571","1","1355748293","1355733632","1","5464","0","1355739357");
INSERT INTO kolhoz_petground VALUES("8506","1571","2","1355748293","1355733632","1","5464","0","1355739357");
INSERT INTO kolhoz_petground VALUES("8507","1571","2","1355748293","1355733632","1","5464","0","1355739357");
INSERT INTO kolhoz_petground VALUES("8508","1571","2","1355748293","1355733632","1","5464","0","1355739357");
INSERT INTO kolhoz_petground VALUES("8509","1467","10","1355787297","1355725309","20","43719","0","1355759001");
INSERT INTO kolhoz_petground VALUES("8510","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8511","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8512","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8513","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8514","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8515","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8516","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8517","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8518","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8519","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8520","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8521","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8522","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8523","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8524","1467","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8525","1584","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8526","1584","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8527","1584","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8528","1584","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8529","1141","10","1355795708","1355507662","20","715","0","1355508423");
INSERT INTO kolhoz_petground VALUES("8530","1585","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8531","1585","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8532","1585","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8533","1585","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8535","1586","1","1355534553","1355520134","1","426","0","1355520579");
INSERT INTO kolhoz_petground VALUES("8536","1586","1","1355534557","1355520139","1","422","0","1355520579");
INSERT INTO kolhoz_petground VALUES("8537","1586","1","1355534563","1355520144","1","416","0","1355520579");
INSERT INTO kolhoz_petground VALUES("8538","1586","1","1355534575","1355520172","1","404","0","1355520579");
INSERT INTO kolhoz_petground VALUES("8539","1569","10","1355982468","1355737775","20","167","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8540","1569","10","1355982468","1355737775","20","167","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8541","1569","10","1355982468","1355737775","20","167","0","1355737835");
INSERT INTO kolhoz_petground VALUES("8542","1558","0","1355710722","1355696312","3","276","0","1355696598");
INSERT INTO kolhoz_petground VALUES("8543","1558","0","1355725346","1355696535","3","42","0","1355696588");
INSERT INTO kolhoz_petground VALUES("8544","1558","0","1355783121","1355696711","6","1720","0","1355698441");
INSERT INTO kolhoz_petground VALUES("8545","1558","0","1355614314","1355695659","2","0","0","1355696105");
INSERT INTO kolhoz_petground VALUES("8546","1526","2","1355853887","1355760480","7","3942","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8547","1526","2","1355854174","1355760482","7","3642","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8548","1526","2","1355782352","1355760483","2","3451","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8549","1526","2","1355782540","1355760486","2","3219","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8550","1526","2","1355774870","1355760487","1","6886","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8551","1526","2","1355774870","1355760490","1","5786","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8552","1526","2","1355774870","1355760499","1","6694","0","1355762105");
INSERT INTO kolhoz_petground VALUES("8553","1456","10","1356042661","1355761082","20","6658","0","1355761319");
INSERT INTO kolhoz_petground VALUES("8554","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8555","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8556","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8557","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8558","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8559","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8560","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8561","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8562","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8563","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8564","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8565","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8566","1588","1","1355747283","1355703916","3","43200","0","1355751461");
INSERT INTO kolhoz_petground VALUES("8567","1588","1","1355747318","1355703917","3","43200","0","1355751461");
INSERT INTO kolhoz_petground VALUES("8568","1588","1","1355747367","1355703918","3","43200","0","1355751461");
INSERT INTO kolhoz_petground VALUES("8569","1588","1","1355747421","1355703919","3","43200","0","1355751461");
INSERT INTO kolhoz_petground VALUES("8570","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8571","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8572","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8573","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8574","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8575","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8576","1588","2","1355747449","1355703939","3","43200","0","1355751461");
INSERT INTO kolhoz_petground VALUES("8577","1429","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8578","1429","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8579","1429","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8580","1429","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8581","1455","12","1356000497","1355718691","20","2485","0","1355721176");
INSERT INTO kolhoz_petground VALUES("8582","1607","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8583","1607","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8584","1607","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8585","1607","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8586","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8587","1609","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8588","1609","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8589","1609","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8590","1609","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8591","1146","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8592","1053","10","1355860687","1355752887","20","9714","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8593","1053","10","1355860687","1355752887","20","9623","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8594","1053","10","1355860687","1355752887","20","9574","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8595","1053","10","1355860687","1355752887","20","9521","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8596","1053","10","1355860687","1355752887","20","9482","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8597","1053","10","1355860687","1355752887","20","9418","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8598","1053","10","1355860687","1355752887","20","9361","0","1355762042");
INSERT INTO kolhoz_petground VALUES("8599","1614","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8600","1614","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8601","1614","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8602","1614","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8603","1620","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8604","1620","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8605","1620","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8606","1620","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8607","1613","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8608","1613","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8609","1613","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8610","1613","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8611","1091","7","1355812615","1355755020","4","13413","0","1355757860");
INSERT INTO kolhoz_petground VALUES("8612","1091","7","1356043015","1355755020","20","13413","0","1355757860");
INSERT INTO kolhoz_petground VALUES("8613","1622","2","1355593753","1355583788","1","258","0","1355584046");
INSERT INTO kolhoz_petground VALUES("8614","1622","2","1355593894","1355583840","1","206","0","1355584046");
INSERT INTO kolhoz_petground VALUES("8615","1622","2","1355593954","1355583866","1","180","0","1355584046");
INSERT INTO kolhoz_petground VALUES("8616","1622","2","1355593986","1355583891","1","155","0","1355584046");
INSERT INTO kolhoz_petground VALUES("8617","1622","2","1355594012","1355583936","1","110","0","1355584046");
INSERT INTO kolhoz_petground VALUES("8618","1622","0","1355594039","1355578596","1","4328","0","1355583967");
INSERT INTO kolhoz_petground VALUES("8619","1622","2","1355594121","1355579690","6","4325","0","1355584046");
INSERT INTO kolhoz_petground VALUES("8620","1265","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8621","1265","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8622","1265","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8623","1265","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8624","1630","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8625","1630","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8626","1630","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8627","1630","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8628","1647","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8629","1647","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8630","1647","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8631","1647","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8632","1558","7","1355784949","1355698537","6","56680","0","1355755229");
INSERT INTO kolhoz_petground VALUES("8633","1558","0","1355600327","1355695661","1","0","0","1355696130");
INSERT INTO kolhoz_petground VALUES("8634","1659","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8635","1659","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8636","1659","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8637","1659","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8638","1412","10","1355774597","1355760204","1","1991","0","1355762188");
INSERT INTO kolhoz_petground VALUES("8639","1550","10","1356023607","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8640","1550","10","1356023607","1355741073","20","4443","0","1355741254");
INSERT INTO kolhoz_petground VALUES("8641","1556","11","1356030074","1355742777","20","12573","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8642","1556","11","1356030074","1355742777","20","12573","0","1355754255");
INSERT INTO kolhoz_petground VALUES("8643","1453","12","1355997206","1355694683","20","28724","0","1355723530");
INSERT INTO kolhoz_petground VALUES("8644","1384","14","1356005370","1355717275","20","751","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8645","1384","14","1356005370","1355717297","20","751","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8646","1384","14","1356005370","1355717333","20","751","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8647","1384","14","1356006063","1355717886","20","58","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8648","1384","14","1356006063","1355717910","20","58","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8649","1384","14","1356006063","1355717932","20","58","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8650","1384","14","1356006063","1355717964","20","58","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8651","1384","14","1356006063","1355717987","20","58","0","1355718121");
INSERT INTO kolhoz_petground VALUES("8652","1482","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8653","1482","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8654","1482","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8655","1482","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8656","1456","10","1356038595","1355761082","20","6658","0","1355761319");
INSERT INTO kolhoz_petground VALUES("8657","1570","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8658","1570","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8659","1570","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8660","1621","7","1356039442","1355754652","20","7517","0","1355762169");
INSERT INTO kolhoz_petground VALUES("8661","1621","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8662","1621","0","0","0","1","0","0","0");
INSERT INTO kolhoz_petground VALUES("8663","1621","0","0","0","1","0","0","0");



DROP TABLE IF EXISTS `kolhoz_plant`;

CREATE TABLE `kolhoz_plant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `money` int(11) DEFAULT '0',
  `time_soil` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_plant VALUES("5","Укроп","10","30","1","2700","12","120","1");
INSERT INTO kolhoz_plant VALUES("6","Петрушка","10","40","1","2700","13","120","1");
INSERT INTO kolhoz_plant VALUES("7","Лук","20","20","1","6480","27","120","2");
INSERT INTO kolhoz_plant VALUES("8","Хрен","20","80","1","23520","50","120","2");
INSERT INTO kolhoz_plant VALUES("9","Мята","30","30","1","9360","42","120","3");
INSERT INTO kolhoz_plant VALUES("10","Редис","30","120","1","34920","82","120","3");
INSERT INTO kolhoz_plant VALUES("11","Капуста","40","40","3","12240","58","120","4");
INSERT INTO kolhoz_plant VALUES("12","Базилик","40","160","3","46320","120","120","4");
INSERT INTO kolhoz_plant VALUES("13","Морковь","50","50","3","15120","74","120","5");
INSERT INTO kolhoz_plant VALUES("14","Свекла","50","200","3","57720","162","120","5");
INSERT INTO kolhoz_plant VALUES("15","Щавель","60","60","4","18000","92","120","6");
INSERT INTO kolhoz_plant VALUES("16","Картофель","60","240","4","69120","208","120","6");
INSERT INTO kolhoz_plant VALUES("17","Горох","70","70","4","20880","111","120","7");
INSERT INTO kolhoz_plant VALUES("18","Перец","70","280","4","80520","258","120","7");
INSERT INTO kolhoz_plant VALUES("19","Томат","80","80","6","23760","130","120","8");
INSERT INTO kolhoz_plant VALUES("20","Сельдерей","80","320","6","93600","312","120","8");
INSERT INTO kolhoz_plant VALUES("21","Брокколи","90","90","6","26640","150","120","9");
INSERT INTO kolhoz_plant VALUES("22","Огурец","90","360","6","105600","370","120","9");
INSERT INTO kolhoz_plant VALUES("23","Кабачок","100","100","8","29520","171","180","10");
INSERT INTO kolhoz_plant VALUES("24","Клубника","100","400","8","115200","432","180","10");
INSERT INTO kolhoz_plant VALUES("25","Фасоль","110","110","8","32400","193","180","11");
INSERT INTO kolhoz_plant VALUES("26","Баклажан","110","440","8","126000","498","180","11");
INSERT INTO kolhoz_plant VALUES("27","Тыква","120","120","6","35280","216","180","12");
INSERT INTO kolhoz_plant VALUES("28","Арбуз","120","480","6","136800","567","180","12");
INSERT INTO kolhoz_plant VALUES("29","Чеснок","130","130","10","38160","239","180","13");
INSERT INTO kolhoz_plant VALUES("31","Спаржа","130","520","10","147600","639","180","13");
INSERT INTO kolhoz_plant VALUES("32","Кукуруза","140","140","7","38880","263","180","14");
INSERT INTO kolhoz_plant VALUES("33","Патиссон","140","560","7","162000","716","180","14");
INSERT INTO kolhoz_plant VALUES("34","Чили","150","150","7","43920","288","180","15");
INSERT INTO kolhoz_plant VALUES("35","Дыня","150","600","7","172800","795","180","15");
INSERT INTO kolhoz_plant VALUES("36","Ежевика","160","160","13","46800","313","180","16");
INSERT INTO kolhoz_plant VALUES("37","Яблоко","160","640","13","183600","878","180","16");
INSERT INTO kolhoz_plant VALUES("38","Крыжовник","170","170","13","49680","339","180","17");
INSERT INTO kolhoz_plant VALUES("39","Груша","170","680","13","194400","965","180","17");
INSERT INTO kolhoz_plant VALUES("40","Виноград","180","180","14","52560","366","180","18");
INSERT INTO kolhoz_plant VALUES("41","Бананы","180","720","14","205200","1054","180","18");
INSERT INTO kolhoz_plant VALUES("42","Малина","190","190","14","55440","393","180","19");
INSERT INTO kolhoz_plant VALUES("43","Грибы","190","760","14","216000","1149","180","19");
INSERT INTO kolhoz_plant VALUES("44","Вишня","200","200","13","58320","422","240","20");
INSERT INTO kolhoz_plant VALUES("45","Подсолнух","200","800","13","230400","1243","240","20");
INSERT INTO kolhoz_plant VALUES("46","Анютины Глазки","210","210","18","61200","451","240","21");
INSERT INTO kolhoz_plant VALUES("47","Гибискусы","220","880","13","252000","1446","240","22");
INSERT INTO kolhoz_plant VALUES("48","Ландыши","230","230","17","66960","510","240","23");
INSERT INTO kolhoz_plant VALUES("49","Колокольчики","240","960","19","273600","1660","240","24");
INSERT INTO kolhoz_plant VALUES("50","Тьюльпаны","250","250","17","94320","573","240","25");
INSERT INTO kolhoz_plant VALUES("51","Лилии","260","1040","22","298800","1888","240","26");
INSERT INTO kolhoz_plant VALUES("52","Гвоздики","270","270","22","78480","638","240","27");
INSERT INTO kolhoz_plant VALUES("53","Ромашки","280","1120","27","320400","2127","240","28");
INSERT INTO kolhoz_plant VALUES("54","Маки","290","290","27","84240","706","240","29");
INSERT INTO kolhoz_plant VALUES("55","Розы","300","1200","26","342000","2379","300","30");
INSERT INTO kolhoz_plant VALUES("56","Арахис","310","310","27","90000","776","300","31");
INSERT INTO kolhoz_plant VALUES("57","Миндаль","320","1280","27","367200","2643","300","32");
INSERT INTO kolhoz_plant VALUES("58","Фундук","330","330","27","97200","849","300","33");
INSERT INTO kolhoz_plant VALUES("59","Кедровый орех","340","1360","29","388800","2919","300","34");
INSERT INTO kolhoz_plant VALUES("60","Кокос","350","350","27","100800","924","300","35");
INSERT INTO kolhoz_plant VALUES("61","Лимон","500","2000","30","435600","2600","300","36");
INSERT INTO kolhoz_plant VALUES("62","Смородина","500","1500","30","165600","1125","300","37");
INSERT INTO kolhoz_plant VALUES("63","Слива","600","2500","30","464400","2700","300","37");
INSERT INTO kolhoz_plant VALUES("64","Облепиха","600","2000","30","176400","1000","300","38");
INSERT INTO kolhoz_plant VALUES("65","Персик","400","3500","30","507600","2800","300","38");
INSERT INTO kolhoz_plant VALUES("66","Черника","480","2500","30","198000","870","300","38");
INSERT INTO kolhoz_plant VALUES("67","Абрикос","39","5000","30","554400","2900","300","39");
INSERT INTO kolhoz_plant VALUES("68","Брусника","450","3500","30","219600","850","300","39");
INSERT INTO kolhoz_plant VALUES("69","Апельсин","460","7000","30","615600","3500","1200","40");
INSERT INTO kolhoz_plant VALUES("70","Гранат","470","5000","30","248400","950","1200","40");
INSERT INTO kolhoz_plant VALUES("72","Финики","510","10000","30","835200","3000","1260","41");
INSERT INTO kolhoz_plant VALUES("73","Хурма","520","8000","30","338400","2000","1260","42");
INSERT INTO kolhoz_plant VALUES("74","Киви","530","15000","30","928800","6000","1320","43");
INSERT INTO kolhoz_plant VALUES("75","Манго","540","12000","30","399600","3000","1320","44");
INSERT INTO kolhoz_plant VALUES("76","Айва","550","25000","30","1044000","10000","1380","45");
INSERT INTO kolhoz_plant VALUES("77","Барбарис","560","15000","30","432000","4000","1380","46");
INSERT INTO kolhoz_plant VALUES("78","Ирис","570","28000","30","1080000","11000","1380","46");
INSERT INTO kolhoz_plant VALUES("79","Календула","580","18000","30","468000","5000","1440","47");
INSERT INTO kolhoz_plant VALUES("80","Крапива","590","31000","30","1116000","12000","1440","47");
INSERT INTO kolhoz_plant VALUES("81","Кувшинка","600","21000","30","504000","6000","1440","48");
INSERT INTO kolhoz_plant VALUES("82","Одуванчик","610","33000","30","1152000","13000","1440","48");
INSERT INTO kolhoz_plant VALUES("83","Подорожник","620","24000","30","540000","7000","1500","49");
INSERT INTO kolhoz_plant VALUES("84","Сирень","630","36000","30","1188000","14000","1500","49");
INSERT INTO kolhoz_plant VALUES("85","Василёк","640","27000","30","576000","8000","1500","50");
INSERT INTO kolhoz_plant VALUES("86","Женьшень","650","40000","30","1224000","15000","1500","50");



DROP TABLE IF EXISTS `kolhoz_plant2`;

CREATE TABLE `kolhoz_plant2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `cena` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `rubies` int(11) DEFAULT '0',
  `time_soil2` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=318 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_plant2 VALUES("247","Мятная настойка","60","2450","1","8000","60","0","16");
INSERT INTO kolhoz_plant2 VALUES("248","Грибы маринованные","62","2550","1","8300","62","0","16");
INSERT INTO kolhoz_plant2 VALUES("249","Арбузы маринованные","64","2650","1","8600","64","0","16");
INSERT INTO kolhoz_plant2 VALUES("250","Мусс ягодный","66","2750","1","8900","66","0","16");
INSERT INTO kolhoz_plant2 VALUES("251","Чесночная настойка","68","2850","1","9200","68","0","18");
INSERT INTO kolhoz_plant2 VALUES("252","Варенье из крыжовника","70","2950","1","9500","71","0","18");
INSERT INTO kolhoz_plant2 VALUES("253","Настойка любительская ","72","3050","1","9800","74","0","18");
INSERT INTO kolhoz_plant2 VALUES("254","Варенье из винограда ","74","3150","1","10100","77","0","19");
INSERT INTO kolhoz_plant2 VALUES("255","Томатное пюре ","76","3250","1","10400","77","0","21");
INSERT INTO kolhoz_plant2 VALUES("256","Брокколи маринованные","78","9999","1","10700","73","0","21");
INSERT INTO kolhoz_plant2 VALUES("257","Яблоки с хреном ","80","3450","1","11000","82","0","22");
INSERT INTO kolhoz_plant2 VALUES("258","Томаты в розовом рассоле","82","3999","1","11300","83","0","22");
INSERT INTO kolhoz_plant2 VALUES("259","Крестьянский салат","84","10999","1","11600","87","0","23");
INSERT INTO kolhoz_plant2 VALUES("260","Огурцы маринованные","86","3750","1","11900","87","0","23");
INSERT INTO kolhoz_plant2 VALUES("261","Клубничная наливка ","88","3850","1","12200","90","0","23");
INSERT INTO kolhoz_plant2 VALUES("262","Дедов спотыкач","90","3950","1","12500","91","0","23");
INSERT INTO kolhoz_plant2 VALUES("263","Джем из дыни","92","4050","1","12800","94","0","23");
INSERT INTO kolhoz_plant2 VALUES("264","Банановое варенье","94","4150","1","13100","100","0","25");
INSERT INTO kolhoz_plant2 VALUES("265","Клубничный компот","96","4250","1","13400","98","0","25");
INSERT INTO kolhoz_plant2 VALUES("266","Грушевый компот","98","4350","1","13700","103","0","25");
INSERT INTO kolhoz_plant2 VALUES("267","Варенье из груши ","60","4450","1","1400000","200","0","28");
INSERT INTO kolhoz_plant2 VALUES("268","Груши в собственном соку","102","4550","1","14300","104","0","28");
INSERT INTO kolhoz_plant2 VALUES("269","Варенье из арбузов","104","4650","1","14600","106","0","28");
INSERT INTO kolhoz_plant2 VALUES("270","Ромашковая настойка","106","4750","1","14900","110","0","32");
INSERT INTO kolhoz_plant2 VALUES("271","Квашеные томаты","108","4850","1","15200","111","0","32");
INSERT INTO kolhoz_plant2 VALUES("272","Варенье из роз","110","4950","1","15500","112","0","32");
INSERT INTO kolhoz_plant2 VALUES("273","Желе клубничное","112","5050","1","15800","115","0","33");
INSERT INTO kolhoz_plant2 VALUES("274","Редис в сладко-кислой заливке","114","5150","1","16100","119","0","33");
INSERT INTO kolhoz_plant2 VALUES("275","Розовая настойка ","116","5250","1","16400","117","0","33");
INSERT INTO kolhoz_plant2 VALUES("276","Желейный салат","118","5350","1","16700","120","0","34");
INSERT INTO kolhoz_plant2 VALUES("277","Кукуруза в маринаде","120","5450","1","17000","125","0","35");
INSERT INTO kolhoz_plant2 VALUES("278","Ореховая настойка","122","5550","1","17300","127","0","35");
INSERT INTO kolhoz_plant2 VALUES("279","Капусты с травами","124","5650","1","17600","130","0","35");
INSERT INTO kolhoz_plant2 VALUES("280","Пикантные кабачки","126","5750","1","17900","129","0","35");
INSERT INTO kolhoz_plant2 VALUES("281","Варенье из моркови ","128","5850","1","18200","131","0","36");
INSERT INTO kolhoz_plant2 VALUES("282","Ликёр из гвоздик","130","5950","1","18500","135","0","36");
INSERT INTO kolhoz_plant2 VALUES("283","Салат с фасолью","132","6050","1","18800","136","0","39");
INSERT INTO kolhoz_plant2 VALUES("284","Арбузно-вишнёвый напиток ","134","6150","1","19100","138","0","39");
INSERT INTO kolhoz_plant2 VALUES("285","Вишнёвый ликёр ","136","6250","1","29400","147","0","39");
INSERT INTO kolhoz_plant2 VALUES("286","Тыквенное пюре","138","6350","1","197000","150","0","40");
INSERT INTO kolhoz_plant2 VALUES("287","Маринованная капуста ","140","6450","1","20000","155","0","40");
INSERT INTO kolhoz_plant2 VALUES("288","Ликёр из ежевики","142","6550","1","20300","149","0","42");
INSERT INTO kolhoz_plant2 VALUES("289","Кокосовый джем","144","6650","1","20600","151","0","42");
INSERT INTO kolhoz_plant2 VALUES("290","Варенье из смородины","146","6750","1","30900","155","0","42");
INSERT INTO kolhoz_plant2 VALUES("291","Настойка от Михалыча","148","6850","1","31200","160","0","42");
INSERT INTO kolhoz_plant2 VALUES("292","Салат из тыквы и яблок","150","6950","1","2150000","190","0","44");
INSERT INTO kolhoz_plant2 VALUES("293","Морс облепиховый","152","70500","1","3180000","224","0","44");
INSERT INTO kolhoz_plant2 VALUES("294","Цукаты из слив ","154","71500","1","22100","170","0","46");
INSERT INTO kolhoz_plant2 VALUES("295","Сливянка ","156","7250","1","22400","171","0","46");
INSERT INTO kolhoz_plant2 VALUES("296","Черничная наливка ","158","7350","1","227000","181","0","46");
INSERT INTO kolhoz_plant2 VALUES("297","Повидло персиковое","160","7450","1","33000","180","0","46");
INSERT INTO kolhoz_plant2 VALUES("298","Ликёр из персиков","162","700550","1","23300","139","0","47");
INSERT INTO kolhoz_plant2 VALUES("299","Варенье из брусники ","164","7650","1","23600","176","0","47");
INSERT INTO kolhoz_plant2 VALUES("300","Абрикосовый ликёр ","166","7750","1","23900","180","0","47");
INSERT INTO kolhoz_plant2 VALUES("301","Повидло бруснично- черничное","168","7850","1","24200","181","0","49");
INSERT INTO kolhoz_plant2 VALUES("302","Настойка фруктовая ","170","7950","1","745000","200","0","49");
INSERT INTO kolhoz_plant2 VALUES("303","Ликер на гранатах ","172","8050","1","24800","180","0","49");
INSERT INTO kolhoz_plant2 VALUES("304","Апельсиновое варенье ","174","900150","1","75100","174","0","49");
INSERT INTO kolhoz_plant2 VALUES("305","Салат Тропикана ","176","8250","1","25400","190","0","50");
INSERT INTO kolhoz_plant2 VALUES("306","Коктейль Мартини оранж","178","8350","1","25700","190","0","50");
INSERT INTO kolhoz_plant2 VALUES("307","Салат Черная роза","180","8450","1","26000","200","0","50");
INSERT INTO kolhoz_plant2 VALUES("308","Желе из хурмы","182","8550","1","26300","196","0","50");
INSERT INTO kolhoz_plant2 VALUES("309","Щербет из хурмы","184","8650000","1","266000","190","0","50");
INSERT INTO kolhoz_plant2 VALUES("310","Парфе из киви","186","8750","1","26900","275","0","51");
INSERT INTO kolhoz_plant2 VALUES("311","Джем из киви","188","8850","1","27200","278","0","51");
INSERT INTO kolhoz_plant2 VALUES("312","Зелёненькое варенье","190","8950","1","27500","281","0","51");
INSERT INTO kolhoz_plant2 VALUES("313","Мартини из киви","192","9050","1","27800","284","0","51");
INSERT INTO kolhoz_plant2 VALUES("314","Крюшон из дыни","194","9150","1","28100","287","0","53");
INSERT INTO kolhoz_plant2 VALUES("315","Салат из манго и дыни","196","9250","1","28400","290","0","53");
INSERT INTO kolhoz_plant2 VALUES("316","Варенье из айвы","198","9350","1","28700","293","0","54");
INSERT INTO kolhoz_plant2 VALUES("317","Повидло из перца по-венгерски","200","9450","1","29000","296","0","55");



DROP TABLE IF EXISTS `kolhoz_polka2`;

CREATE TABLE `kolhoz_polka2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_plant2` int(11) DEFAULT '0',
  `soil2` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `time_water2` int(11) DEFAULT '0',
  `time_soil2` int(11) DEFAULT '0',
  `cultivator2` enum('0','1') DEFAULT '0',
  `first` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5830 DEFAULT CHARSET=utf8;

INSERT INTO kolhoz_polka2 VALUES("39","0","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("40","0","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("41","0","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("42","0","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("43","46","231","0","1348512880","1348509800","1348509680","1","0");
INSERT INTO kolhoz_polka2 VALUES("44","46","231","0","1348509534","1348506454","1348506334","1","0");
INSERT INTO kolhoz_polka2 VALUES("45","46","231","0","1348509538","1348506458","1348506338","1","0");
INSERT INTO kolhoz_polka2 VALUES("46","46","231","0","1348509540","1348506460","1348506340","1","0");
INSERT INTO kolhoz_polka2 VALUES("47","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("48","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("49","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("50","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("51","9","0","0","1349966998","1349937718","1349937598","1","0");
INSERT INTO kolhoz_polka2 VALUES("52","9","0","0","1349967006","1349937726","1349937606","0","0");
INSERT INTO kolhoz_polka2 VALUES("53","9","0","0","1349967015","1349937735","1349937615","0","0");
INSERT INTO kolhoz_polka2 VALUES("54","9","0","0","1349967023","1349937743","1349937623","0","0");
INSERT INTO kolhoz_polka2 VALUES("55","2","0","0","1350506519","1350498639","1350498519","0","0");
INSERT INTO kolhoz_polka2 VALUES("56","2","0","0","1351112153","1351104273","1351104153","0","0");
INSERT INTO kolhoz_polka2 VALUES("57","2","222","0","1349724940","1349724560","1349724440","1","0");
INSERT INTO kolhoz_polka2 VALUES("58","2","0","0","1349724939","1349724559","1349724439","0","0");
INSERT INTO kolhoz_polka2 VALUES("59","19","0","0","1349710322","1349690442","1349690322","1","0");
INSERT INTO kolhoz_polka2 VALUES("60","19","287","0","1349710322","1349690442","1349690322","1","0");
INSERT INTO kolhoz_polka2 VALUES("61","19","287","0","1349710323","1349690443","1349690323","1","0");
INSERT INTO kolhoz_polka2 VALUES("62","19","287","0","1349710323","1349690443","1349690323","1","0");
INSERT INTO kolhoz_polka2 VALUES("63","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("64","9","0","0","1349967032","1349937752","1349937632","0","0");
INSERT INTO kolhoz_polka2 VALUES("65","9","0","0","1349967041","1349937761","1349937641","0","0");
INSERT INTO kolhoz_polka2 VALUES("66","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("67","9","0","0","1349967055","1349937775","1349937655","0","0");
INSERT INTO kolhoz_polka2 VALUES("68","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("69","9","0","0","1349967066","1349937786","1349937666","0","0");
INSERT INTO kolhoz_polka2 VALUES("70","9","0","0","1349967078","1349937798","1349937678","0","0");
INSERT INTO kolhoz_polka2 VALUES("71","46","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("72","46","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("73","9","0","0","1349967088","1349937808","1349937688","0","0");
INSERT INTO kolhoz_polka2 VALUES("74","46","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("75","9","0","0","1349967097","1349937817","1349937697","0","0");
INSERT INTO kolhoz_polka2 VALUES("76","9","0","0","1349967107","1349937827","1349937707","0","0");
INSERT INTO kolhoz_polka2 VALUES("77","9","0","0","1349967119","1349937839","1349937719","0","0");
INSERT INTO kolhoz_polka2 VALUES("78","9","0","0","1349967129","1349937849","1349937729","0","0");
INSERT INTO kolhoz_polka2 VALUES("79","9","0","0","1349967138","1349937858","1349937738","0","0");
INSERT INTO kolhoz_polka2 VALUES("80","9","0","0","1349967183","1349937903","1349937783","0","0");
INSERT INTO kolhoz_polka2 VALUES("81","9","0","0","1349967192","1349937912","1349937792","0","0");
INSERT INTO kolhoz_polka2 VALUES("82","9","0","0","1349967204","1349937924","1349937804","0","0");
INSERT INTO kolhoz_polka2 VALUES("83","9","0","0","1349967216","1349937936","1349937816","0","0");
INSERT INTO kolhoz_polka2 VALUES("84","46","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("85","9","0","0","1349967253","1349937973","1349937853","0","0");
INSERT INTO kolhoz_polka2 VALUES("86","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("87","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("88","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("89","19","287","0","1349710324","1349690444","1349690324","1","0");
INSERT INTO kolhoz_polka2 VALUES("90","19","287","0","1349710325","1349690445","1349690325","1","0");
INSERT INTO kolhoz_polka2 VALUES("91","19","287","0","1349710325","1349690445","1349690325","1","0");
INSERT INTO kolhoz_polka2 VALUES("92","19","287","0","1349710330","1349690450","1349690330","1","0");
INSERT INTO kolhoz_polka2 VALUES("93","19","287","0","1349710326","1349690446","1349690326","1","0");
INSERT INTO kolhoz_polka2 VALUES("94","19","287","0","1349710333","1349690453","1349690333","1","0");
INSERT INTO kolhoz_polka2 VALUES("95","19","287","0","1349710335","1349690455","1349690335","1","0");
INSERT INTO kolhoz_polka2 VALUES("96","19","287","0","1349710338","1349690458","1349690338","1","0");
INSERT INTO kolhoz_polka2 VALUES("97","19","287","0","1349710341","1349690461","1349690341","1","0");
INSERT INTO kolhoz_polka2 VALUES("98","8","267","0","1351433846","1350033966","1350033846","1","0");
INSERT INTO kolhoz_polka2 VALUES("99","8","267","0","1351433851","1350033971","1350033851","1","0");
INSERT INTO kolhoz_polka2 VALUES("100","8","267","0","1351433855","1350033975","1350033855","1","0");
INSERT INTO kolhoz_polka2 VALUES("101","8","267","0","1351433855","1350033975","1350033855","1","0");
INSERT INTO kolhoz_polka2 VALUES("102","8","267","0","1351433860","1350033980","1350033860","1","0");
INSERT INTO kolhoz_polka2 VALUES("103","12","0","0","1350276152","1349878628","1349878508","0","0");
INSERT INTO kolhoz_polka2 VALUES("104","12","0","0","1350276152","1349878628","1349878508","0","0");
INSERT INTO kolhoz_polka2 VALUES("105","12","0","0","1350276152","1349878678","1349878558","0","0");
INSERT INTO kolhoz_polka2 VALUES("106","12","0","0","1350276152","1349878626","1349878506","0","0");
INSERT INTO kolhoz_polka2 VALUES("107","5","282","0","1349690338","1349671958","1349671838","1","0");
INSERT INTO kolhoz_polka2 VALUES("108","5","282","0","1349690339","1349671959","1349671839","1","0");
INSERT INTO kolhoz_polka2 VALUES("109","5","282","0","1349690334","1349671954","1349671834","1","0");
INSERT INTO kolhoz_polka2 VALUES("110","5","282","0","1349690332","1349671952","1349671832","1","0");
INSERT INTO kolhoz_polka2 VALUES("111","5","282","0","1349690331","1349671951","1349671831","1","0");
INSERT INTO kolhoz_polka2 VALUES("112","5","282","0","1349690330","1349671950","1349671830","1","0");
INSERT INTO kolhoz_polka2 VALUES("113","5","282","0","1349690329","1349671949","1349671829","1","0");
INSERT INTO kolhoz_polka2 VALUES("114","6","282","0","1349627995","1349609615","1349609495","1","0");
INSERT INTO kolhoz_polka2 VALUES("115","6","282","0","1349627997","1349609617","1349609497","1","0");
INSERT INTO kolhoz_polka2 VALUES("116","6","282","0","1349627999","1349609619","1349609499","1","0");
INSERT INTO kolhoz_polka2 VALUES("117","6","282","0","1349628002","1349609622","1349609502","1","0");
INSERT INTO kolhoz_polka2 VALUES("118","6","282","0","1349628004","1349609624","1349609504","1","0");
INSERT INTO kolhoz_polka2 VALUES("119","24","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("120","24","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("121","24","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("122","24","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("123","5","282","0","1349690328","1349671948","1349671828","1","0");
INSERT INTO kolhoz_polka2 VALUES("124","51","282","0","1351502681","1351484301","1351484181","1","0");
INSERT INTO kolhoz_polka2 VALUES("125","51","282","0","1351502682","1351484302","1351484182","1","0");
INSERT INTO kolhoz_polka2 VALUES("126","51","282","0","1351502683","1351484303","1351484183","1","0");
INSERT INTO kolhoz_polka2 VALUES("127","51","282","0","1351502657","1351484277","1351484157","1","0");
INSERT INTO kolhoz_polka2 VALUES("128","19","287","0","1349710364","1349690484","1349690364","1","0");
INSERT INTO kolhoz_polka2 VALUES("129","19","287","0","1349710365","1349690485","1349690365","1","0");
INSERT INTO kolhoz_polka2 VALUES("130","19","287","0","1349710366","1349690486","1349690366","1","0");
INSERT INTO kolhoz_polka2 VALUES("131","19","287","0","1349710366","1349690486","1349690366","1","0");
INSERT INTO kolhoz_polka2 VALUES("132","19","287","0","1349710366","1349690486","1349690366","1","0");
INSERT INTO kolhoz_polka2 VALUES("133","19","287","0","1349710371","1349690491","1349690371","1","0");
INSERT INTO kolhoz_polka2 VALUES("134","19","287","0","1349710371","1349690491","1349690371","1","0");
INSERT INTO kolhoz_polka2 VALUES("135","53","246","0","1348931036","1348923456","1348923336","1","0");
INSERT INTO kolhoz_polka2 VALUES("136","53","246","0","1348931043","1348923463","1348923343","1","0");
INSERT INTO kolhoz_polka2 VALUES("137","53","246","0","1348931044","1348923464","1348923344","1","0");
INSERT INTO kolhoz_polka2 VALUES("138","53","246","0","1348931045","1348923465","1348923345","1","0");
INSERT INTO kolhoz_polka2 VALUES("139","51","282","0","1351502685","1351484305","1351484185","1","0");
INSERT INTO kolhoz_polka2 VALUES("140","51","282","0","1351502686","1351484306","1351484186","1","0");
INSERT INTO kolhoz_polka2 VALUES("141","51","282","0","1351502687","1351484307","1351484187","1","0");
INSERT INTO kolhoz_polka2 VALUES("142","51","282","0","1351502663","1351484283","1351484163","1","0");
INSERT INTO kolhoz_polka2 VALUES("143","51","282","0","1351502630","1351484250","1351484130","1","0");
INSERT INTO kolhoz_polka2 VALUES("144","51","282","0","1351502674","1351484294","1351484174","1","0");
INSERT INTO kolhoz_polka2 VALUES("145","51","282","0","1351502673","1351484293","1351484173","1","0");
INSERT INTO kolhoz_polka2 VALUES("146","51","282","0","1351502676","1351484296","1351484176","1","0");
INSERT INTO kolhoz_polka2 VALUES("147","58","276","0","1349004186","1348987606","1348987486","1","0");
INSERT INTO kolhoz_polka2 VALUES("148","58","276","0","1349004218","1348987638","1348987518","1","0");
INSERT INTO kolhoz_polka2 VALUES("149","58","276","0","1349004590","1348988010","1348987890","1","0");
INSERT INTO kolhoz_polka2 VALUES("150","58","276","0","1349004643","1348988063","1348987943","1","0");
INSERT INTO kolhoz_polka2 VALUES("151","3","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("152","3","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("153","3","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("154","3","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("155","58","276","0","1349004675","1348988095","1348987975","1","0");
INSERT INTO kolhoz_polka2 VALUES("156","58","276","0","1349004722","1348988142","1348988022","1","0");
INSERT INTO kolhoz_polka2 VALUES("157","58","276","0","1349004747","1348988167","1348988047","1","0");
INSERT INTO kolhoz_polka2 VALUES("158","58","276","0","1349004798","1348988218","1348988098","1","0");
INSERT INTO kolhoz_polka2 VALUES("159","58","276","0","1349004849","1348988269","1348988149","1","0");
INSERT INTO kolhoz_polka2 VALUES("160","58","276","0","1349004918","1348988338","1348988218","1","0");
INSERT INTO kolhoz_polka2 VALUES("161","58","276","0","1349004988","1348988408","1348988288","1","0");
INSERT INTO kolhoz_polka2 VALUES("162","58","276","0","1349005023","1348988443","1348988323","1","0");
INSERT INTO kolhoz_polka2 VALUES("163","58","276","0","1349005065","1348988485","1348988365","1","0");
INSERT INTO kolhoz_polka2 VALUES("164","58","276","0","1349005109","1348988529","1348988409","1","0");
INSERT INTO kolhoz_polka2 VALUES("165","65","222","0","1348656631","1348656251","1348656131","1","0");
INSERT INTO kolhoz_polka2 VALUES("166","65","222","0","1348656635","1348656255","1348656135","1","0");
INSERT INTO kolhoz_polka2 VALUES("167","65","222","0","1348656637","1348656257","1348656137","1","0");
INSERT INTO kolhoz_polka2 VALUES("168","65","222","0","1348656639","1348656259","1348656139","1","0");
INSERT INTO kolhoz_polka2 VALUES("169","8","267","0","1351433865","1350033985","1350033865","1","0");
INSERT INTO kolhoz_polka2 VALUES("170","8","267","0","1351433865","1350033985","1350033865","1","0");
INSERT INTO kolhoz_polka2 VALUES("171","8","267","0","1351433884","1350034004","1350033884","1","0");
INSERT INTO kolhoz_polka2 VALUES("172","29","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("173","29","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("174","29","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("175","29","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("176","8","267","0","1351433884","1350034004","1350033884","1","0");
INSERT INTO kolhoz_polka2 VALUES("177","8","267","0","1351433874","1350033994","1350033874","1","0");
INSERT INTO kolhoz_polka2 VALUES("178","8","267","0","1351433874","1350033994","1350033874","1","0");
INSERT INTO kolhoz_polka2 VALUES("179","8","267","0","1351433875","1350033995","1350033875","1","0");
INSERT INTO kolhoz_polka2 VALUES("180","8","267","0","1351433890","1350034010","1350033890","1","0");
INSERT INTO kolhoz_polka2 VALUES("181","8","267","0","1351433894","1350034014","1350033894","1","0");
INSERT INTO kolhoz_polka2 VALUES("182","8","267","0","1351433903","1350034023","1350033903","1","0");
INSERT INTO kolhoz_polka2 VALUES("183","8","267","0","1351433904","1350034024","1350033904","1","0");
INSERT INTO kolhoz_polka2 VALUES("184","8","267","0","1351433906","1350034026","1350033906","1","0");
INSERT INTO kolhoz_polka2 VALUES("185","8","267","0","1351433920","1350034040","1350033920","1","0");
INSERT INTO kolhoz_polka2 VALUES("186","8","267","0","1351433928","1350034048","1350033928","1","0");
INSERT INTO kolhoz_polka2 VALUES("187","8","267","0","1351433918","1350034038","1350033918","1","0");
INSERT INTO kolhoz_polka2 VALUES("188","68","0","0","1348799774","1348781394","1348781274","0","0");
INSERT INTO kolhoz_polka2 VALUES("189","68","0","0","1348799781","1348781401","1348781281","0","0");
INSERT INTO kolhoz_polka2 VALUES("190","68","0","0","1348799784","1348781404","1348781284","0","0");
INSERT INTO kolhoz_polka2 VALUES("191","68","0","0","1348799785","1348781405","1348781285","0","0");
INSERT INTO kolhoz_polka2 VALUES("192","68","0","0","1348799788","1348781408","1348781288","0","0");
INSERT INTO kolhoz_polka2 VALUES("193","68","0","0","1348799790","1348781410","1348781290","0","0");
INSERT INTO kolhoz_polka2 VALUES("194","68","0","0","1348799793","1348781413","1348781293","0","0");
INSERT INTO kolhoz_polka2 VALUES("195","68","0","0","1348799795","1348781415","1348781295","0","0");
INSERT INTO kolhoz_polka2 VALUES("196","68","0","0","1348799798","1348781418","1348781298","0","0");
INSERT INTO kolhoz_polka2 VALUES("197","68","0","0","1348799800","1348781420","1348781300","0","0");
INSERT INTO kolhoz_polka2 VALUES("198","68","0","0","1348799803","1348781423","1348781303","0","0");
INSERT INTO kolhoz_polka2 VALUES("199","68","0","0","1348799805","1348781425","1348781305","0","0");
INSERT INTO kolhoz_polka2 VALUES("200","68","0","0","1348799808","1348781428","1348781308","0","0");
INSERT INTO kolhoz_polka2 VALUES("201","68","0","0","1348799809","1348781429","1348781309","0","0");
INSERT INTO kolhoz_polka2 VALUES("202","68","0","0","1348799811","1348781431","1348781311","0","0");
INSERT INTO kolhoz_polka2 VALUES("203","68","0","0","1348799812","1348781432","1348781312","0","0");
INSERT INTO kolhoz_polka2 VALUES("204","68","0","0","1348799814","1348781434","1348781314","0","0");
INSERT INTO kolhoz_polka2 VALUES("205","68","0","0","1348799815","1348781435","1348781315","0","0");
INSERT INTO kolhoz_polka2 VALUES("206","68","0","0","1348799818","1348781438","1348781318","0","0");
INSERT INTO kolhoz_polka2 VALUES("207","68","0","0","1348799819","1348781439","1348781319","0","0");
INSERT INTO kolhoz_polka2 VALUES("208","43","227","0","1349673695","1349671815","1349671695","1","0");
INSERT INTO kolhoz_polka2 VALUES("209","43","227","0","1349673702","1349671822","1349671702","1","0");
INSERT INTO kolhoz_polka2 VALUES("210","43","227","0","1349673749","1349671869","1349671749","1","0");
INSERT INTO kolhoz_polka2 VALUES("211","43","227","0","1349673704","1349671824","1349671704","1","0");
INSERT INTO kolhoz_polka2 VALUES("212","64","222","0","1349670686","1349670306","1349670186","1","0");
INSERT INTO kolhoz_polka2 VALUES("213","64","222","0","1349670706","1349670326","1349670206","1","0");
INSERT INTO kolhoz_polka2 VALUES("214","64","222","0","1349670713","1349670333","1349670213","1","0");
INSERT INTO kolhoz_polka2 VALUES("215","64","222","0","1349670730","1349670350","1349670230","1","0");
INSERT INTO kolhoz_polka2 VALUES("216","80","222","0","1348837185","1348836805","1348836685","1","0");
INSERT INTO kolhoz_polka2 VALUES("217","80","222","0","1348837196","1348836816","1348836696","1","0");
INSERT INTO kolhoz_polka2 VALUES("218","80","222","0","1348837207","1348836827","1348836707","1","0");
INSERT INTO kolhoz_polka2 VALUES("219","70","279","0","1351419538","1351402058","1351401938","1","0");
INSERT INTO kolhoz_polka2 VALUES("220","70","279","0","1351419538","1351402058","1351401938","1","0");
INSERT INTO kolhoz_polka2 VALUES("221","70","279","0","1351419539","1351402059","1351401939","1","0");
INSERT INTO kolhoz_polka2 VALUES("222","70","279","0","1351419540","1351402060","1351401940","1","0");
INSERT INTO kolhoz_polka2 VALUES("223","70","279","0","1351419540","1351402060","1351401940","1","0");
INSERT INTO kolhoz_polka2 VALUES("224","70","279","0","1351419541","1351402061","1351401941","1","0");
INSERT INTO kolhoz_polka2 VALUES("225","70","279","0","1351419542","1351402062","1351401942","1","0");
INSERT INTO kolhoz_polka2 VALUES("226","70","279","0","1351419543","1351402063","1351401943","1","0");
INSERT INTO kolhoz_polka2 VALUES("227","70","279","0","1351419548","1351402068","1351401948","1","0");
INSERT INTO kolhoz_polka2 VALUES("228","70","279","0","1351419548","1351402068","1351401948","1","0");
INSERT INTO kolhoz_polka2 VALUES("229","70","279","0","1351419549","1351402069","1351401949","1","0");
INSERT INTO kolhoz_polka2 VALUES("230","51","282","0","1351502666","1351484286","1351484166","1","0");
INSERT INTO kolhoz_polka2 VALUES("231","51","282","0","1351502670","1351484290","1351484170","1","0");
INSERT INTO kolhoz_polka2 VALUES("232","12","0","0","1350276152","1349878625","1349878505","0","0");
INSERT INTO kolhoz_polka2 VALUES("233","51","282","0","1351502662","1351484282","1351484162","1","0");
INSERT INTO kolhoz_polka2 VALUES("234","53","246","0","1348931046","1348923466","1348923346","1","0");
INSERT INTO kolhoz_polka2 VALUES("235","12","0","0","1350276152","1349878687","1349878567","0","0");
INSERT INTO kolhoz_polka2 VALUES("236","58","276","0","1349005144","1348988564","1348988444","1","0");
INSERT INTO kolhoz_polka2 VALUES("237","70","279","0","1351419549","1351402069","1351401949","1","0");
INSERT INTO kolhoz_polka2 VALUES("238","70","279","0","1351419550","1351402070","1351401950","1","0");
INSERT INTO kolhoz_polka2 VALUES("239","46","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("240","5","282","0","1349690327","1349671947","1349671827","1","0");
INSERT INTO kolhoz_polka2 VALUES("241","114","254","0","1349114161","1349104181","1349104061","1","0");
INSERT INTO kolhoz_polka2 VALUES("242","114","254","0","1349114175","1349104195","1349104075","1","0");
INSERT INTO kolhoz_polka2 VALUES("243","114","254","0","1349114179","1349104199","1349104079","1","0");
INSERT INTO kolhoz_polka2 VALUES("244","114","254","0","1349114183","1349104203","1349104083","1","0");
INSERT INTO kolhoz_polka2 VALUES("245","114","254","0","1349114191","1349104211","1349104091","1","0");
INSERT INTO kolhoz_polka2 VALUES("246","114","254","0","1349114227","1349104247","1349104127","1","0");
INSERT INTO kolhoz_polka2 VALUES("247","103","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("248","103","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("249","103","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("250","103","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("251","102","0","0","1350942758","1350926178","1350926058","0","0");
INSERT INTO kolhoz_polka2 VALUES("252","102","0","0","1349947350","1349930770","1349930650","0","0");
INSERT INTO kolhoz_polka2 VALUES("253","102","0","0","1349947351","1349930771","1349930651","0","0");
INSERT INTO kolhoz_polka2 VALUES("254","102","0","0","1349947355","1349930775","1349930655","0","0");
INSERT INTO kolhoz_polka2 VALUES("255","23","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("256","23","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("257","23","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("258","23","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("259","12","0","0","1350276152","1349878601","1349878481","0","0");
INSERT INTO kolhoz_polka2 VALUES("260","5","282","0","1349690326","1349671946","1349671826","1","0");
INSERT INTO kolhoz_polka2 VALUES("261","102","0","0","1349947353","1349930773","1349930653","0","0");
INSERT INTO kolhoz_polka2 VALUES("262","102","0","0","1349947354","1349930774","1349930654","0","0");
INSERT INTO kolhoz_polka2 VALUES("263","102","0","0","1349947356","1349930776","1349930656","0","0");
INSERT INTO kolhoz_polka2 VALUES("264","102","0","0","1349947357","1349930777","1349930657","0","0");
INSERT INTO kolhoz_polka2 VALUES("265","102","0","0","1349947362","1349930782","1349930662","0","0");
INSERT INTO kolhoz_polka2 VALUES("266","102","0","0","1349947369","1349930789","1349930669","0","0");
INSERT INTO kolhoz_polka2 VALUES("267","109","246","0","1349761953","1349754373","1349754253","1","0");
INSERT INTO kolhoz_polka2 VALUES("268","109","246","0","1349761955","1349754375","1349754255","1","0");
INSERT INTO kolhoz_polka2 VALUES("269","109","246","0","1349761963","1349754383","1349754263","1","0");
INSERT INTO kolhoz_polka2 VALUES("270","109","246","0","1349761957","1349754377","1349754257","1","0");
INSERT INTO kolhoz_polka2 VALUES("271","102","0","0","1349947384","1349930804","1349930684","0","0");
INSERT INTO kolhoz_polka2 VALUES("272","102","0","0","1349947398","1349930818","1349930698","0","0");
INSERT INTO kolhoz_polka2 VALUES("273","102","0","0","1349947403","1349930823","1349930703","0","0");
INSERT INTO kolhoz_polka2 VALUES("274","102","0","0","1349947411","1349930831","1349930711","0","0");
INSERT INTO kolhoz_polka2 VALUES("275","118","231","0","1349878822","1349875742","1349875622","1","0");
INSERT INTO kolhoz_polka2 VALUES("276","118","231","0","1349878824","1349875744","1349875624","1","0");
INSERT INTO kolhoz_polka2 VALUES("277","118","231","0","1349878827","1349875747","1349875627","1","0");
INSERT INTO kolhoz_polka2 VALUES("278","118","231","0","1349878829","1349875749","1349875629","1","0");
INSERT INTO kolhoz_polka2 VALUES("279","129","267","0","1352813171","1351413291","1351413171","1","0");
INSERT INTO kolhoz_polka2 VALUES("280","129","267","0","1352813177","1351413297","1351413177","1","0");
INSERT INTO kolhoz_polka2 VALUES("281","129","267","0","1352813178","1351413298","1351413178","1","0");
INSERT INTO kolhoz_polka2 VALUES("282","129","267","0","1352813179","1351413299","1351413179","1","0");
INSERT INTO kolhoz_polka2 VALUES("283","51","282","0","1351502660","1351484280","1351484160","1","0");
INSERT INTO kolhoz_polka2 VALUES("284","51","282","0","1351502656","1351484276","1351484156","1","0");
INSERT INTO kolhoz_polka2 VALUES("285","143","222","0","1349788686","1349788306","1349788186","1","0");
INSERT INTO kolhoz_polka2 VALUES("286","143","222","0","1349788691","1349788311","1349788191","1","0");
INSERT INTO kolhoz_polka2 VALUES("287","143","222","0","1349788693","1349788313","1349788193","1","0");
INSERT INTO kolhoz_polka2 VALUES("288","143","222","0","1349788700","1349788320","1349788200","1","0");
INSERT INTO kolhoz_polka2 VALUES("289","149","264","0","1351518437","1351505457","1351505337","1","0");
INSERT INTO kolhoz_polka2 VALUES("290","149","264","0","1351518443","1351505463","1351505343","1","0");
INSERT INTO kolhoz_polka2 VALUES("291","149","264","0","1351518449","1351505469","1351505349","1","0");
INSERT INTO kolhoz_polka2 VALUES("292","149","264","0","1351518455","1351505475","1351505355","1","0");
INSERT INTO kolhoz_polka2 VALUES("293","102","0","0","1349947416","1349930836","1349930716","0","0");
INSERT INTO kolhoz_polka2 VALUES("294","102","0","0","1349947422","1349930842","1349930722","0","0");
INSERT INTO kolhoz_polka2 VALUES("295","161","267","0","1352462160","1351062280","1351062160","1","0");
INSERT INTO kolhoz_polka2 VALUES("296","161","267","0","1352462164","1351062284","1351062164","1","0");
INSERT INTO kolhoz_polka2 VALUES("297","161","267","0","1352462168","1351062288","1351062168","1","0");
INSERT INTO kolhoz_polka2 VALUES("298","161","267","0","1352462170","1351062290","1351062170","1","0");
INSERT INTO kolhoz_polka2 VALUES("299","94","0","0","1349787669","1349669868","1349669748","1","0");
INSERT INTO kolhoz_polka2 VALUES("300","94","0","0","1349787669","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("301","94","0","0","1349787669","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("302","94","0","0","1349787669","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("303","169","235","0","1350475514","1350411634","1350411514","1","0");
INSERT INTO kolhoz_polka2 VALUES("304","169","235","0","1350475528","1350411648","1350411528","1","0");
INSERT INTO kolhoz_polka2 VALUES("305","169","235","0","1350475514","1350411634","1350411514","1","0");
INSERT INTO kolhoz_polka2 VALUES("306","169","235","0","1350475514","1350411634","1350411514","1","0");
INSERT INTO kolhoz_polka2 VALUES("307","169","235","0","1350475529","1350411649","1350411529","1","0");
INSERT INTO kolhoz_polka2 VALUES("308","149","264","0","1351518462","1351505482","1351505362","1","0");
INSERT INTO kolhoz_polka2 VALUES("309","129","267","0","1352813180","1351413300","1351413180","1","0");
INSERT INTO kolhoz_polka2 VALUES("310","129","267","0","1352813181","1351413301","1351413181","1","0");
INSERT INTO kolhoz_polka2 VALUES("311","129","267","0","1352813183","1351413303","1351413183","1","0");
INSERT INTO kolhoz_polka2 VALUES("312","129","267","0","1352813184","1351413304","1351413184","1","0");
INSERT INTO kolhoz_polka2 VALUES("313","129","267","0","1352813185","1351413305","1351413185","1","0");
INSERT INTO kolhoz_polka2 VALUES("314","129","267","0","1352813186","1351413306","1351413186","1","0");
INSERT INTO kolhoz_polka2 VALUES("315","129","267","0","1352813187","1351413307","1351413187","1","0");
INSERT INTO kolhoz_polka2 VALUES("316","28","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("317","28","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("318","28","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("319","28","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("320","169","235","0","1350475516","1350411636","1350411516","1","0");
INSERT INTO kolhoz_polka2 VALUES("321","169","235","0","1350475530","1350411650","1350411530","1","0");
INSERT INTO kolhoz_polka2 VALUES("322","169","235","0","1350475519","1350411639","1350411519","1","0");
INSERT INTO kolhoz_polka2 VALUES("323","169","235","0","1350475531","1350411651","1350411531","1","0");
INSERT INTO kolhoz_polka2 VALUES("324","169","235","0","1350475520","1350411640","1350411520","1","0");
INSERT INTO kolhoz_polka2 VALUES("325","169","235","0","1350475523","1350411643","1350411523","1","0");
INSERT INTO kolhoz_polka2 VALUES("326","70","279","0","1351419551","1351402071","1351401951","1","0");
INSERT INTO kolhoz_polka2 VALUES("327","149","264","0","1351518470","1351505490","1351505370","1","0");
INSERT INTO kolhoz_polka2 VALUES("328","189","267","0","1352813889","1351414009","1351413889","1","0");
INSERT INTO kolhoz_polka2 VALUES("329","189","267","0","1352813890","1351414010","1351413890","1","0");
INSERT INTO kolhoz_polka2 VALUES("330","189","267","0","1352813892","1351414012","1351413892","1","0");
INSERT INTO kolhoz_polka2 VALUES("331","189","267","0","1352813893","1351414013","1351413893","1","0");
INSERT INTO kolhoz_polka2 VALUES("332","189","267","0","1352813894","1351414014","1351413894","1","0");
INSERT INTO kolhoz_polka2 VALUES("333","189","267","0","1352813895","1351414015","1351413895","1","0");
INSERT INTO kolhoz_polka2 VALUES("334","189","267","0","1352813896","1351414016","1351413896","1","0");
INSERT INTO kolhoz_polka2 VALUES("335","190","267","0","1352814289","1351414409","1351414289","1","0");
INSERT INTO kolhoz_polka2 VALUES("336","190","267","0","1352814290","1351414410","1351414290","1","0");
INSERT INTO kolhoz_polka2 VALUES("337","190","267","0","1352814291","1351414411","1351414291","1","0");
INSERT INTO kolhoz_polka2 VALUES("338","190","267","0","1352814292","1351414412","1351414292","1","0");
INSERT INTO kolhoz_polka2 VALUES("339","146","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("340","146","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("341","146","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("342","146","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("343","70","279","0","1351419552","1351402072","1351401952","1","0");
INSERT INTO kolhoz_polka2 VALUES("344","193","222","0","1350458836","1350458456","1350458336","1","0");
INSERT INTO kolhoz_polka2 VALUES("345","193","222","0","1350445544","1350445164","1350445044","1","0");
INSERT INTO kolhoz_polka2 VALUES("346","193","0","0","1350512407","1350502727","1350502607","1","0");
INSERT INTO kolhoz_polka2 VALUES("347","193","222","0","1350445561","1350445181","1350445061","1","0");
INSERT INTO kolhoz_polka2 VALUES("348","190","267","0","1352814293","1351414413","1351414293","1","0");
INSERT INTO kolhoz_polka2 VALUES("349","190","267","0","1352814294","1351414414","1351414294","1","0");
INSERT INTO kolhoz_polka2 VALUES("350","190","267","0","1352814295","1351414415","1351414295","1","0");
INSERT INTO kolhoz_polka2 VALUES("351","129","267","0","1352813188","1351413308","1351413188","1","0");
INSERT INTO kolhoz_polka2 VALUES("352","129","267","0","1352813189","1351413309","1351413189","1","0");
INSERT INTO kolhoz_polka2 VALUES("353","189","267","0","1352813898","1351414018","1351413898","1","0");
INSERT INTO kolhoz_polka2 VALUES("354","199","247","0","1351380932","1351373052","1351372932","1","0");
INSERT INTO kolhoz_polka2 VALUES("355","199","247","0","1351380935","1351373055","1351372935","1","0");
INSERT INTO kolhoz_polka2 VALUES("356","199","247","0","1351380942","1351373062","1351372942","1","0");
INSERT INTO kolhoz_polka2 VALUES("357","199","247","0","1351380946","1351373066","1351372946","1","0");
INSERT INTO kolhoz_polka2 VALUES("358","199","0","0","1350309408","1350297928","1350297808","1","0");
INSERT INTO kolhoz_polka2 VALUES("359","199","0","0","1350309422","1350297942","1350297822","1","0");
INSERT INTO kolhoz_polka2 VALUES("360","193","222","0","1350445581","1350445201","1350445081","1","0");
INSERT INTO kolhoz_polka2 VALUES("361","193","253","0","1351025179","1351015499","1351015379","1","0");
INSERT INTO kolhoz_polka2 VALUES("362","193","222","0","1350444966","1350444586","1350444466","1","0");
INSERT INTO kolhoz_polka2 VALUES("363","193","222","0","1350444879","1350444499","1350444379","1","0");
INSERT INTO kolhoz_polka2 VALUES("364","193","222","0","1350444931","1350444551","1350444431","1","0");
INSERT INTO kolhoz_polka2 VALUES("365","202","0","0","1349812659","1349812279","1349812159","0","0");
INSERT INTO kolhoz_polka2 VALUES("366","202","0","0","1349812808","1349812428","1349812308","0","0");
INSERT INTO kolhoz_polka2 VALUES("367","202","0","0","1349812825","1349812445","1349812325","0","0");
INSERT INTO kolhoz_polka2 VALUES("368","202","0","0","1349812839","1349812459","1349812339","0","0");
INSERT INTO kolhoz_polka2 VALUES("369","219","282","0","1351504389","1351486009","1351485889","1","0");
INSERT INTO kolhoz_polka2 VALUES("370","219","282","0","1351504390","1351486010","1351485890","1","0");
INSERT INTO kolhoz_polka2 VALUES("371","219","282","0","1351504390","1351486010","1351485890","1","0");
INSERT INTO kolhoz_polka2 VALUES("372","219","282","0","1351504391","1351486011","1351485891","1","0");
INSERT INTO kolhoz_polka2 VALUES("373","220","0","0","1349843559","1349842579","1349842459","1","0");
INSERT INTO kolhoz_polka2 VALUES("374","220","0","0","1349843270","1349842590","1349842470","1","0");
INSERT INTO kolhoz_polka2 VALUES("375","220","0","0","1349843271","1349842591","1349842471","1","0");
INSERT INTO kolhoz_polka2 VALUES("376","220","0","0","1349843272","1349842592","1349842472","1","0");
INSERT INTO kolhoz_polka2 VALUES("377","219","282","0","1351504392","1351486012","1351485892","1","0");
INSERT INTO kolhoz_polka2 VALUES("378","219","282","0","1351504393","1351486013","1351485893","1","0");
INSERT INTO kolhoz_polka2 VALUES("379","220","0","0","1349843273","1349842593","1349842473","1","0");
INSERT INTO kolhoz_polka2 VALUES("380","129","267","0","1352813191","1351413311","1351413191","1","0");
INSERT INTO kolhoz_polka2 VALUES("381","129","267","0","1352813192","1351413312","1351413192","1","0");
INSERT INTO kolhoz_polka2 VALUES("382","129","267","0","1352813193","1351413313","1351413193","1","0");
INSERT INTO kolhoz_polka2 VALUES("383","129","267","0","1352813195","1351413315","1351413195","1","0");
INSERT INTO kolhoz_polka2 VALUES("384","129","267","0","1352813196","1351413316","1351413196","1","0");
INSERT INTO kolhoz_polka2 VALUES("385","227","263","0","1349870292","1349857612","1349857492","1","0");
INSERT INTO kolhoz_polka2 VALUES("386","227","263","0","1349870297","1349857617","1349857497","1","0");
INSERT INTO kolhoz_polka2 VALUES("387","227","263","0","1349870301","1349857621","1349857501","1","0");
INSERT INTO kolhoz_polka2 VALUES("388","227","263","0","1349870304","1349857624","1349857504","1","0");
INSERT INTO kolhoz_polka2 VALUES("389","227","263","0","1349870308","1349857628","1349857508","1","0");
INSERT INTO kolhoz_polka2 VALUES("390","227","263","0","1349870311","1349857631","1349857511","1","0");
INSERT INTO kolhoz_polka2 VALUES("391","227","263","0","1349870315","1349857635","1349857515","1","0");
INSERT INTO kolhoz_polka2 VALUES("392","129","267","0","1352813197","1351413317","1351413197","1","0");
INSERT INTO kolhoz_polka2 VALUES("393","226","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("394","226","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("395","226","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("396","226","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("397","193","0","0","1350443064","1350442684","1350442564","1","0");
INSERT INTO kolhoz_polka2 VALUES("398","193","222","0","1350458369","1350457989","1350457869","1","0");
INSERT INTO kolhoz_polka2 VALUES("399","149","264","0","1351518478","1351505498","1351505378","1","0");
INSERT INTO kolhoz_polka2 VALUES("400","211","267","0","1351553868","1350153988","1350153868","1","0");
INSERT INTO kolhoz_polka2 VALUES("401","211","267","0","1351553886","1350154006","1350153886","1","0");
INSERT INTO kolhoz_polka2 VALUES("402","211","230","0","1350486611","1350483831","1350483711","1","0");
INSERT INTO kolhoz_polka2 VALUES("403","211","230","0","1350486660","1350483880","1350483760","1","0");
INSERT INTO kolhoz_polka2 VALUES("404","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("405","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("406","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("407","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("408","1","317","0","1355752370","1355723490","1355723370","1","0");
INSERT INTO kolhoz_polka2 VALUES("409","219","282","0","1351504403","1351486023","1351485903","1","0");
INSERT INTO kolhoz_polka2 VALUES("410","219","282","0","1351504404","1351486024","1351485904","1","0");
INSERT INTO kolhoz_polka2 VALUES("411","193","222","0","1350458395","1350458015","1350457895","1","0");
INSERT INTO kolhoz_polka2 VALUES("412","219","282","0","1351504399","1351486019","1351485899","1","0");
INSERT INTO kolhoz_polka2 VALUES("413","219","282","0","1351504422","1351486042","1351485922","1","0");
INSERT INTO kolhoz_polka2 VALUES("414","84","230","0","1350495068","1350492288","1350492168","1","0");
INSERT INTO kolhoz_polka2 VALUES("415","84","230","0","1350495071","1350492291","1350492171","1","0");
INSERT INTO kolhoz_polka2 VALUES("416","84","230","0","1350495074","1350492294","1350492174","1","0");
INSERT INTO kolhoz_polka2 VALUES("417","84","230","0","1350495078","1350492298","1350492178","1","0");
INSERT INTO kolhoz_polka2 VALUES("418","193","222","0","1350458660","1350458280","1350458160","1","0");
INSERT INTO kolhoz_polka2 VALUES("419","219","282","0","1351504406","1351486026","1351485906","1","0");
INSERT INTO kolhoz_polka2 VALUES("420","211","230","0","1350486668","1350483888","1350483768","1","0");
INSERT INTO kolhoz_polka2 VALUES("421","219","282","0","1351504407","1351486027","1351485907","1","0");
INSERT INTO kolhoz_polka2 VALUES("422","193","222","0","1350458683","1350458303","1350458183","1","0");
INSERT INTO kolhoz_polka2 VALUES("423","219","282","0","1351504408","1351486028","1351485908","1","0");
INSERT INTO kolhoz_polka2 VALUES("424","70","279","0","1351419552","1351402072","1351401952","1","0");
INSERT INTO kolhoz_polka2 VALUES("425","70","279","0","1351419553","1351402073","1351401953","1","0");
INSERT INTO kolhoz_polka2 VALUES("426","70","279","0","1351419553","1351402073","1351401953","1","0");
INSERT INTO kolhoz_polka2 VALUES("427","129","267","0","1352813198","1351413318","1351413198","1","0");
INSERT INTO kolhoz_polka2 VALUES("428","219","282","0","1351504409","1351486029","1351485909","1","0");
INSERT INTO kolhoz_polka2 VALUES("429","219","282","0","1351504410","1351486030","1351485910","1","0");
INSERT INTO kolhoz_polka2 VALUES("430","219","282","0","1351504411","1351486031","1351485911","1","0");
INSERT INTO kolhoz_polka2 VALUES("431","149","264","0","1351518487","1351505507","1351505387","1","0");
INSERT INTO kolhoz_polka2 VALUES("432","149","264","0","1351518495","1351505515","1351505395","1","0");
INSERT INTO kolhoz_polka2 VALUES("433","219","282","0","1351504411","1351486031","1351485911","1","0");
INSERT INTO kolhoz_polka2 VALUES("434","219","282","0","1351504412","1351486032","1351485912","1","0");
INSERT INTO kolhoz_polka2 VALUES("435","219","282","0","1351504413","1351486033","1351485913","1","0");
INSERT INTO kolhoz_polka2 VALUES("436","211","230","0","1350486675","1350483895","1350483775","1","0");
INSERT INTO kolhoz_polka2 VALUES("437","70","279","0","1351419554","1351402074","1351401954","1","0");
INSERT INTO kolhoz_polka2 VALUES("438","70","279","0","1351419555","1351402075","1351401955","1","0");
INSERT INTO kolhoz_polka2 VALUES("439","219","282","0","1351504414","1351486034","1351485914","1","0");
INSERT INTO kolhoz_polka2 VALUES("440","260","282","0","1350515491","1350497111","1350496991","1","0");
INSERT INTO kolhoz_polka2 VALUES("441","260","282","0","1350515491","1350497111","1350496991","1","0");
INSERT INTO kolhoz_polka2 VALUES("442","260","282","0","1350515489","1350497109","1350496989","1","0");
INSERT INTO kolhoz_polka2 VALUES("443","260","282","0","1350515512","1350497132","1350497012","1","0");
INSERT INTO kolhoz_polka2 VALUES("444","261","242","0","1350142964","1350136584","1350136464","1","0");
INSERT INTO kolhoz_polka2 VALUES("445","261","242","0","1350142970","1350136590","1350136470","1","0");
INSERT INTO kolhoz_polka2 VALUES("446","261","242","0","1350142966","1350136586","1350136466","1","0");
INSERT INTO kolhoz_polka2 VALUES("447","261","242","0","1350142967","1350136587","1350136467","1","0");
INSERT INTO kolhoz_polka2 VALUES("448","260","282","0","1350515516","1350497136","1350497016","1","0");
INSERT INTO kolhoz_polka2 VALUES("449","260","282","0","1350515517","1350497137","1350497017","1","0");
INSERT INTO kolhoz_polka2 VALUES("450","260","282","0","1350515519","1350497139","1350497019","1","0");
INSERT INTO kolhoz_polka2 VALUES("451","260","282","0","1350515520","1350497140","1350497020","1","0");
INSERT INTO kolhoz_polka2 VALUES("452","329","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("453","329","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("454","329","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("455","329","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("456","193","222","0","1350458711","1350458331","1350458211","1","0");
INSERT INTO kolhoz_polka2 VALUES("457","193","222","0","1350458720","1350458340","1350458220","1","0");
INSERT INTO kolhoz_polka2 VALUES("458","238","264","0","1351521089","1351508109","1351507989","1","0");
INSERT INTO kolhoz_polka2 VALUES("459","238","264","0","1351521107","1351508127","1351508007","1","0");
INSERT INTO kolhoz_polka2 VALUES("460","238","264","0","1351521118","1351508138","1351508018","1","0");
INSERT INTO kolhoz_polka2 VALUES("461","238","264","0","1351521130","1351508150","1351508030","1","0");
INSERT INTO kolhoz_polka2 VALUES("462","260","282","0","1350515523","1350497143","1350497023","1","0");
INSERT INTO kolhoz_polka2 VALUES("463","260","282","0","1350515523","1350497143","1350497023","1","0");
INSERT INTO kolhoz_polka2 VALUES("464","193","222","0","1350458763","1350458383","1350458263","1","0");
INSERT INTO kolhoz_polka2 VALUES("465","84","230","0","1350495085","1350492305","1350492185","1","0");
INSERT INTO kolhoz_polka2 VALUES("466","338","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("467","338","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("468","338","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("469","338","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("470","260","282","0","1350515526","1350497146","1350497026","1","0");
INSERT INTO kolhoz_polka2 VALUES("471","260","282","0","1350515528","1350497148","1350497028","1","0");
INSERT INTO kolhoz_polka2 VALUES("472","260","282","0","1350515528","1350497148","1350497028","1","0");
INSERT INTO kolhoz_polka2 VALUES("473","172","237","0","1350493995","1350489115","1350488995","1","0");
INSERT INTO kolhoz_polka2 VALUES("474","172","237","0","1350494011","1350489131","1350489011","1","0");
INSERT INTO kolhoz_polka2 VALUES("475","172","237","0","1350494026","1350489146","1350489026","1","0");
INSERT INTO kolhoz_polka2 VALUES("476","172","237","0","1350494049","1350489169","1350489049","1","0");
INSERT INTO kolhoz_polka2 VALUES("477","260","282","0","1350515528","1350497148","1350497028","1","0");
INSERT INTO kolhoz_polka2 VALUES("478","260","282","0","1350515530","1350497150","1350497030","1","0");
INSERT INTO kolhoz_polka2 VALUES("479","260","282","0","1350515530","1350497150","1350497030","1","0");
INSERT INTO kolhoz_polka2 VALUES("480","260","282","0","1350515533","1350497153","1350497033","1","0");
INSERT INTO kolhoz_polka2 VALUES("481","199","0","0","1350309427","1350297947","1350297827","1","0");
INSERT INTO kolhoz_polka2 VALUES("482","211","230","0","1350486685","1350483905","1350483785","1","0");
INSERT INTO kolhoz_polka2 VALUES("483","347","282","0","1351513425","1351495045","1351494925","1","0");
INSERT INTO kolhoz_polka2 VALUES("484","347","282","0","1351513425","1351495045","1351494925","1","0");
INSERT INTO kolhoz_polka2 VALUES("485","347","282","0","1351513427","1351495047","1351494927","1","0");
INSERT INTO kolhoz_polka2 VALUES("486","347","282","0","1351513428","1351495048","1351494928","1","0");
INSERT INTO kolhoz_polka2 VALUES("487","347","282","0","1351513429","1351495049","1351494929","1","0");
INSERT INTO kolhoz_polka2 VALUES("488","347","282","0","1351513431","1351495051","1351494931","1","0");
INSERT INTO kolhoz_polka2 VALUES("489","347","282","0","1351513432","1351495052","1351494932","1","0");
INSERT INTO kolhoz_polka2 VALUES("490","347","282","0","1351513433","1351495053","1351494933","1","0");
INSERT INTO kolhoz_polka2 VALUES("491","347","282","0","1351513435","1351495055","1351494935","1","0");
INSERT INTO kolhoz_polka2 VALUES("492","347","282","0","1351513436","1351495056","1351494936","1","0");
INSERT INTO kolhoz_polka2 VALUES("493","347","282","0","1351513437","1351495057","1351494937","1","0");
INSERT INTO kolhoz_polka2 VALUES("494","347","282","0","1351513439","1351495059","1351494939","1","0");
INSERT INTO kolhoz_polka2 VALUES("495","347","282","0","1351513514","1351495134","1351495014","1","0");
INSERT INTO kolhoz_polka2 VALUES("496","347","282","0","1351513441","1351495061","1351494941","1","0");
INSERT INTO kolhoz_polka2 VALUES("497","347","282","0","1351513443","1351495063","1351494943","1","0");
INSERT INTO kolhoz_polka2 VALUES("498","347","282","0","1351513444","1351495064","1351494944","1","0");
INSERT INTO kolhoz_polka2 VALUES("499","84","230","0","1350495080","1350492300","1350492180","1","0");
INSERT INTO kolhoz_polka2 VALUES("500","193","222","0","1350458803","1350458423","1350458303","1","0");
INSERT INTO kolhoz_polka2 VALUES("501","172","237","0","1350494108","1350489228","1350489108","1","0");
INSERT INTO kolhoz_polka2 VALUES("502","190","267","0","1352814296","1351414416","1351414296","1","0");
INSERT INTO kolhoz_polka2 VALUES("503","190","267","0","1352814317","1351414437","1351414317","1","0");
INSERT INTO kolhoz_polka2 VALUES("504","190","267","0","1352814299","1351414419","1351414299","1","0");
INSERT INTO kolhoz_polka2 VALUES("505","190","267","0","1352814300","1351414420","1351414300","1","0");
INSERT INTO kolhoz_polka2 VALUES("506","172","237","0","1350494119","1350489239","1350489119","1","0");
INSERT INTO kolhoz_polka2 VALUES("507","184","0","0","1350914222","1350906342","1350906222","1","0");
INSERT INTO kolhoz_polka2 VALUES("508","184","0","0","1350914265","1350906385","1350906265","1","0");
INSERT INTO kolhoz_polka2 VALUES("509","184","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("510","184","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("511","172","237","0","1350494130","1350489250","1350489130","1","0");
INSERT INTO kolhoz_polka2 VALUES("512","172","237","0","1350494145","1350489265","1350489145","1","0");
INSERT INTO kolhoz_polka2 VALUES("513","347","282","0","1351513445","1351495065","1351494945","1","0");
INSERT INTO kolhoz_polka2 VALUES("514","347","282","0","1351513448","1351495068","1351494948","1","0");
INSERT INTO kolhoz_polka2 VALUES("515","347","282","0","1351513515","1351495135","1351495015","1","0");
INSERT INTO kolhoz_polka2 VALUES("516","347","282","0","1351513457","1351495077","1351494957","1","0");
INSERT INTO kolhoz_polka2 VALUES("517","250","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("518","250","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("519","250","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("520","250","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("521","172","237","0","1350494096","1350489216","1350489096","1","0");
INSERT INTO kolhoz_polka2 VALUES("522","172","237","0","1350494081","1350489201","1350489081","1","0");
INSERT INTO kolhoz_polka2 VALUES("523","260","282","0","1350515533","1350497153","1350497033","1","0");
INSERT INTO kolhoz_polka2 VALUES("524","260","282","0","1350515539","1350497159","1350497039","1","0");
INSERT INTO kolhoz_polka2 VALUES("525","260","282","0","1350515537","1350497157","1350497037","1","0");
INSERT INTO kolhoz_polka2 VALUES("526","183","0","0","1351247032","1351239152","1351239032","1","0");
INSERT INTO kolhoz_polka2 VALUES("527","183","0","0","1351247046","1351239166","1351239046","1","0");
INSERT INTO kolhoz_polka2 VALUES("528","183","0","0","1351247053","1351239173","1351239053","1","0");
INSERT INTO kolhoz_polka2 VALUES("529","183","0","0","1351247059","1351239179","1351239059","1","0");
INSERT INTO kolhoz_polka2 VALUES("530","362","0","0","1351336709","1351327029","1351326909","1","0");
INSERT INTO kolhoz_polka2 VALUES("531","362","0","0","1351321589","1351311909","1351311789","1","0");
INSERT INTO kolhoz_polka2 VALUES("532","362","0","0","1351321549","1351311869","1351311749","1","0");
INSERT INTO kolhoz_polka2 VALUES("533","362","0","0","1351321591","1351311911","1351311791","1","0");
INSERT INTO kolhoz_polka2 VALUES("534","364","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("535","364","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("536","364","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("537","364","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("538","367","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("539","367","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("540","367","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("541","367","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("542","356","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("543","356","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("544","356","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("545","356","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("546","362","0","0","1351321552","1351311872","1351311752","1","0");
INSERT INTO kolhoz_polka2 VALUES("547","362","0","0","1351321593","1351311913","1351311793","1","0");
INSERT INTO kolhoz_polka2 VALUES("548","362","0","0","1351321555","1351311875","1351311755","1","0");
INSERT INTO kolhoz_polka2 VALUES("549","362","0","0","1351321558","1351311878","1351311758","1","0");
INSERT INTO kolhoz_polka2 VALUES("550","362","0","0","1351321595","1351311915","1351311795","1","0");
INSERT INTO kolhoz_polka2 VALUES("551","362","0","0","1351321597","1351311917","1351311797","1","0");
INSERT INTO kolhoz_polka2 VALUES("552","362","0","0","1351321564","1351311884","1351311764","1","0");
INSERT INTO kolhoz_polka2 VALUES("553","362","0","0","1351321600","1351311920","1351311800","1","0");
INSERT INTO kolhoz_polka2 VALUES("554","362","0","0","1351321604","1351311924","1351311804","1","0");
INSERT INTO kolhoz_polka2 VALUES("555","362","0","0","1351321603","1351311923","1351311803","1","0");
INSERT INTO kolhoz_polka2 VALUES("556","362","0","0","1351321606","1351311926","1351311806","1","0");
INSERT INTO kolhoz_polka2 VALUES("557","362","0","0","1351321567","1351311887","1351311767","1","0");
INSERT INTO kolhoz_polka2 VALUES("558","362","0","0","1351321570","1351311890","1351311770","1","0");
INSERT INTO kolhoz_polka2 VALUES("559","362","0","0","1351321608","1351311928","1351311808","1","0");
INSERT INTO kolhoz_polka2 VALUES("560","362","0","0","1351321573","1351311893","1351311773","1","0");
INSERT INTO kolhoz_polka2 VALUES("561","362","0","0","1351321576","1351311896","1351311776","1","0");
INSERT INTO kolhoz_polka2 VALUES("562","368","247","0","1351239790","1351231910","1351231790","1","0");
INSERT INTO kolhoz_polka2 VALUES("563","368","247","0","1351239804","1351231924","1351231804","1","0");
INSERT INTO kolhoz_polka2 VALUES("564","368","247","0","1351239815","1351231935","1351231815","1","0");
INSERT INTO kolhoz_polka2 VALUES("565","368","247","0","1351239819","1351231939","1351231819","1","0");
INSERT INTO kolhoz_polka2 VALUES("566","2","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("567","399","0","0","1351152503","1351144623","1351144503","1","0");
INSERT INTO kolhoz_polka2 VALUES("568","399","0","0","1351152512","1351144632","1351144512","1","0");
INSERT INTO kolhoz_polka2 VALUES("569","399","247","0","1351152521","1351144641","1351144521","1","0");
INSERT INTO kolhoz_polka2 VALUES("570","399","247","0","1351152538","1351144658","1351144538","1","0");
INSERT INTO kolhoz_polka2 VALUES("571","402","0","0","1351116193","1351108313","1351108193","1","0");
INSERT INTO kolhoz_polka2 VALUES("572","402","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("573","402","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("574","402","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("575","386","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("576","386","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("577","386","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("578","386","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("579","408","272","0","1351514077","1351498697","1351498577","1","0");
INSERT INTO kolhoz_polka2 VALUES("580","408","272","0","1351514078","1351498698","1351498578","1","0");
INSERT INTO kolhoz_polka2 VALUES("581","408","272","0","1351514078","1351498698","1351498578","1","0");
INSERT INTO kolhoz_polka2 VALUES("582","408","272","0","1351514079","1351498699","1351498579","1","0");
INSERT INTO kolhoz_polka2 VALUES("583","408","272","0","1351514080","1351498700","1351498580","1","0");
INSERT INTO kolhoz_polka2 VALUES("584","408","272","0","1351514081","1351498701","1351498581","1","0");
INSERT INTO kolhoz_polka2 VALUES("585","408","272","0","1351514082","1351498702","1351498582","1","0");
INSERT INTO kolhoz_polka2 VALUES("586","408","272","0","1351514084","1351498704","1351498584","1","0");
INSERT INTO kolhoz_polka2 VALUES("587","408","272","0","1351514084","1351498704","1351498584","1","0");
INSERT INTO kolhoz_polka2 VALUES("588","408","272","0","1351514086","1351498706","1351498586","1","0");
INSERT INTO kolhoz_polka2 VALUES("589","408","272","0","1351514086","1351498706","1351498586","1","0");
INSERT INTO kolhoz_polka2 VALUES("590","408","272","0","1351514088","1351498708","1351498588","1","0");
INSERT INTO kolhoz_polka2 VALUES("591","404","267","0","1352743518","1351343638","1351343518","1","0");
INSERT INTO kolhoz_polka2 VALUES("592","404","267","0","1352743562","1351343682","1351343562","1","0");
INSERT INTO kolhoz_polka2 VALUES("593","404","267","0","1352743579","1351343699","1351343579","1","0");
INSERT INTO kolhoz_polka2 VALUES("594","404","267","0","1352743562","1351343682","1351343562","1","0");
INSERT INTO kolhoz_polka2 VALUES("595","408","272","0","1351514088","1351498708","1351498588","1","0");
INSERT INTO kolhoz_polka2 VALUES("596","408","272","0","1351514089","1351498709","1351498589","1","0");
INSERT INTO kolhoz_polka2 VALUES("597","408","272","0","1351514090","1351498710","1351498590","1","0");
INSERT INTO kolhoz_polka2 VALUES("598","430","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("599","430","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("600","430","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("601","430","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("602","404","267","0","1352743564","1351343684","1351343564","1","0");
INSERT INTO kolhoz_polka2 VALUES("603","404","267","0","1352743581","1351343701","1351343581","1","0");
INSERT INTO kolhoz_polka2 VALUES("604","404","267","0","1352743566","1351343686","1351343566","1","0");
INSERT INTO kolhoz_polka2 VALUES("605","395","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("606","395","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("607","395","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("608","395","0","0","0","0","0","0","0");
INSERT INTO kolhoz_polka2 VALUES("609","199","0","0","0","0","0","1","0");
INSERT INTO kolhoz_polka2 VALUES("610","408","272","0","1351514092","1351498712","1351498592","1","0");
INSERT INTO kolhoz_polka2 VALUES("611","149","264","0","1351518502","1351505522","1351505402","1","0");
INSERT INTO kolhoz_polka2 VALUES("612","149","264","0","1351518510","1351505530","1351505410","1","0");
INSERT INTO kolhoz_polka2 VALUES("613","149","264","0","1351518521","1351505541","1351505421","1","0");
INSERT INTO kolhoz_polka2 VALUES("614","189","267","0","1352813976","1351414096","1351413976","1","0");
INSERT INTO kolhoz_polka2 VALUES("615","189","267","0","1352813977","1351414097","1351413977","1","0");
INSERT INTO kolhoz_polka2 VALUES("616","189","267","0","1352813980","1351414100","1351413980","1","0");
INSERT INTO kolhoz_polka2 VALUES("617","189","267","0","1352813981","1351414101","1351413981","1","0");
INSERT INTO kolhoz_polka2 VALUES("618","189","267","0","1352813981","1351414101","1351413981","1","0");
INSERT INTO kolhoz_polka2 VALUES("619","189","267","0","1352814017","1351414137","1351414017","1","0");
INSERT INTO kolhoz_polka2 VALUES("620","190","267","0","1352814320","1351414440","1351414320","1","0");
INSERT INTO kolhoz_polka2 VALUES("621","190","267","0","1352814320","1351414440","1351414320","1","0");
INSERT INTO kolhoz_polka2 VALUES("622","190","267","0","1352814321","1351414441","1351414321","1","0");
INSERT INTO kolhoz_polka2 VALUES("623","190","267","0","1352814322","1351414442","1351414322","1","0");
INSERT INTO kolhoz_polka2 VALUES("624","190","267","0","1352814323","1351414443","1351414323","1","0");
INSERT INTO kolhoz_polka2 VALUES("625","238","264","0","1351521141","1351508161","1351508041","1","0");
INSERT INTO kolhoz_polka2 VALUES("626","408","272","0","1351514092","1351498712","1351498592","1","0");
INSERT INTO kolhoz_polka2 VALUES("627","408","272","0","1351514094","1351498714","1351498594","1","0");
INSERT INTO kolhoz_polka2 VALUES("628","408","272","0","1351514094","1351498714","1351498594","1","0");
INSERT INTO kolhoz_polka2 VALUES("629","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("630","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("631","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("632","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("633","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("634","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("635","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("636","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("637","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("638","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("639","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("640","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("641","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("642","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("643","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("644","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("645","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("646","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("647","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("648","466","317","0","1353260359","1353231479","1353231359","1","0");
INSERT INTO kolhoz_polka2 VALUES("649","477","282","0","1353241176","1353222796","1353222676","1","0");
INSERT INTO kolhoz_polka2 VALUES("650","477","282","0","1353241176","1353222796","1353222676","1","0");
INSERT INTO kolhoz_polka2 VALUES("651","477","282","0","1353241176","1353222796","1353222676","1","0");
INSERT INTO kolhoz_polka2 VALUES("652","477","282","0","1353241176","1353222796","1353222676","1","0");
INSERT INTO kolhoz_polka2 VALUES("653","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("654","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("655","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("656","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("657","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("658","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("659","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("660","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("661","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("662","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("663","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("664","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("665","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("666","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("667","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("668","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("669","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("670","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("671","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("672","467","259","0","1353222175","1353210695","1353210575","1","0");
INSERT INTO kolhoz_polka2 VALUES("760","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("759","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("675","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("676","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("677","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("678","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("679","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("680","495","0","0","1353040706","1353011826","1353011706","0","0");
INSERT INTO kolhoz_polka2 VALUES("681","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("682","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("683","480","282","0","1353228724","1353210344","1353210224","1","0");
INSERT INTO kolhoz_polka2 VALUES("684","486","259","0","1353062926","1353051446","1353051326","1","0");
INSERT INTO kolhoz_polka2 VALUES("685","486","259","0","1353062926","1353051446","1353051326","1","0");
INSERT INTO kolhoz_polka2 VALUES("686","486","259","0","1353062926","1353051446","1353051326","1","0");
INSERT INTO kolhoz_polka2 VALUES("687","486","259","0","1353062926","1353051446","1353051326","1","0");
INSERT INTO kolhoz_polka2 VALUES("688","486","259","0","1353062926","1353051446","1353051326","1","0");
INSERT INTO kolhoz_polka2 VALUES("689","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("690","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("691","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("692","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("693","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("694","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("695","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("696","498","279","0","1353249895","1353232415","1353232295","1","0");
INSERT INTO kolhoz_polka2 VALUES("697","505","282","0","1353253917","1353235537","1353235417","1","0");
INSERT INTO kolhoz_polka2 V